package com.fleaphpnet.Service;

import android.content.Context;
import android.os.AsyncTask;

import com.fleaphpnet.XinTiJson;
import com.fleaphpnet.XinTiPostQuery;
import com.fleaphpnet.XinTiRequestcode;
import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.dialog.XintiTouzhuDialogExit;
import com.fleaphpnet.entity.XinTiDaigouContentEntity;

import org.apache.http.NameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class CTZQNormalBet extends AsyncTask<JSONObject, String, JSONObject> {
    Context mconn;
    private XinTiDaigouContentEntity daigouentity;
    private Loadingprogressdialog progressDialog = null;
    private XintiTouzhuDialogExit touzhuexit;

    public CTZQNormalBet(Context mconn, XinTiDaigouContentEntity daigouentity, Loadingprogressdialog progressDialog) {
        super();
        this.mconn = mconn;
        this.daigouentity = daigouentity;
        this.progressDialog = progressDialog;
    }

    private void startProgressDialog() {
        if (progressDialog == null) {
            progressDialog = Loadingprogressdialog.createDialog(mconn);
            progressDialog.setCancelable(false);
            progressDialog.setMessage("正在提交数据...");
        }
        progressDialog.show();
    }

    private void stopProgressDialog() {
        if (progressDialog != null) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }

    @Override
    protected void onCancelled() {
        stopProgressDialog();
        super.onCancelled();
    }

    @Override
    protected void onPreExecute() {
        startProgressDialog();
    }

    @Override
    protected void onPostExecute(JSONObject result) {
        System.out.println("-------代购----->" + result);
        try {
            String touzhucode = result.getString("Code");
            String messagecode = result.getString("Value");
            String putumessage = result.getString("Message");
            if (touzhucode.equals("101")) {
                touzhuexit.ExitDialog(mconn.getResources().getString(R.string.touzhusuccess));
            } else {
                touzhuexit.ExitDialog(putumessage);
            }
        } catch (JSONException e) {
            e.printStackTrace();
            System.out.println("----登陆失败----->");
            stopProgressDialog();
        } catch (NullPointerException n) {
            n.printStackTrace();
            System.out.println("----服务器连接超时----->");
            touzhuexit.ExitDialog("服务器连接超时");
            stopProgressDialog();
        }
        stopProgressDialog();
        super.onPostExecute(result);
    }

    @Override
    protected JSONObject doInBackground(JSONObject... params) {
        touzhuexit = new XintiTouzhuDialogExit(mconn);
        String msgid = "putongtouzhu";
        //UserToken	用户效验值
        String parameters1 = "UserToken";
        //BalancePassword	资金密码
        String parameters2 = "BalancePassword";
        //GameCode 	彩种
        String parameters3 = "GameCode";
        //GameType	玩法
        String parameters4 = "GameType";
        //Security	保密度 参见附录E
        String parameters5 = "Security";
        //TotalMoney	总投注金额double
        String parameters6 = "TotalMoney";
        //StopAfterBonus	中奖后停止
        String parameters7 = "StopAfterBonus";
        //TotalMatchCount 	比赛场次数
        String parameters8 = "TotalMatchCount";
        //IssuseList	是一个json字符串，见下表
        String parameters9 = "IssuseList";
        //CodeList	是一个json字符串，见下表
        String parameters10 = "CodeList";
        //PlayType	几串几 例如（4*1）null
        String parameters11 = "PlayType";
        String values1 = daigouentity.getUsertoken();
        String values2 = daigouentity.getBalancePassword();
        String values3 = daigouentity.getGameCode();
        String values4 = daigouentity.getGameType();
        Integer values5 = daigouentity.getSecurity();
        Double values6 = daigouentity.getTotalMoney();
        Boolean values7 = daigouentity.getStopAfterBonus();
        Integer values8 = daigouentity.getTotalMatchCount();
        JSONArray values9 = new JSONArray();
        JSONObject obj1 = new JSONObject();
        int value1 = daigouentity.getAmount();
        String value2 = daigouentity.getIssuseNumber();
        int value3 = daigouentity.getIssuseTotalMoney();
        try {
            // Amount倍数
            obj1.put("Amount", value1);
            // IssuseNumber 期号
            obj1.put("IssuseNumber", value2);
            // IssuseTotalMoney 本期金额
            obj1.put("IssuseTotalMoney", value3);
            obj1.put("betNumber", value3/2/value1);
            values9.put(obj1);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        JSONArray values10 = new JSONArray();

        List<String> val1 = daigouentity.getAnteCodearr();
        List<Boolean> val2 = daigouentity.getIsDanarr();
        List<String> val3 = daigouentity.getMatchIdarr();
        List<String> val4 = daigouentity.getGametypearr();
        try {
            for (int j = 0; j < val1.size(); j++) {
                JSONObject obj2 = new JSONObject();
                // AnteCode 投足号码
                obj2.put("AnteCode", val1.get(j));
                // IsDan 是否设胆true
                obj2.put("IsDan", val2.get(j));
                // MatchId 方案号(雾, 是比赛编号吧)
                obj2.put("MatchId", val3.get(j));
                //玩法
                obj2.put("GameType", daigouentity.getGameType());
                values10.put(obj2);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        String values11 = daigouentity.getPlayType();
        List<NameValuePair> namevalue = XinTiJson.Elvenparameter11(XinTiRequestcode.Ordinary_betting_Code, msgid, parameters1, values1, parameters2, values2, parameters3, values3, parameters4, values4, parameters5, values5, parameters6, values6, parameters7, values7, parameters8, values8, parameters9, values9, parameters10, values10, parameters11, values11);
        JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
        return jsonobj;
    }
}
