package com.fleaphpnet.Service;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;

import com.fleaphpnet.XinTiJson;
import com.fleaphpnet.XinTiPostQuery;
import com.fleaphpnet.XinTiRequestcode;
import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.Application;

import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class XinTijointouzhuTask extends AsyncTask<JSONObject, String, JSONObject> {
    private Loadingprogressdialog progressDialog = null;
    public ArrayList<String> arrjointouzhu;
    public Context conn;
    private XinTijointouzhuTask jointouzhu = null;
    private String resulttouzhu;

    public XinTijointouzhuTask(Loadingprogressdialog progressDialog,
                               ArrayList<String> arrjointouzhu, Context conn,
                               XinTijointouzhuTask jointouzhu) {
        super();
        this.progressDialog = progressDialog;
        this.arrjointouzhu = arrjointouzhu;
        this.conn = conn;
        this.jointouzhu = jointouzhu;
    }

    private void startProgressDialog() {

        if (progressDialog == null) {
            progressDialog = Loadingprogressdialog.createDialog(conn);
            progressDialog.setCancelable(false);
            progressDialog.setMessage("正在加载中...");

        }

        progressDialog.show();

    }

    private void stopProgressDialog() {

        if (progressDialog != null) {

            progressDialog.dismiss();

            progressDialog = null;

        }

    }

    @Override
    protected void onCancelled() {

        stopProgressDialog();

        super.onCancelled();
    }

    @Override
    protected void onPreExecute() {

        startProgressDialog();

    }

    @Override
    protected void onPostExecute(JSONObject result) {// 可以与UI控件交互
        System.out.println("-------result----->" + result);
        resulttouzhu = result.toString();
        try {
            String logincode = result.getString("Code");
            String value = result.getString("Value");
            if (logincode.equals("101")) {
                AlertTishi(conn.getResources().getString(R.string.joinhemaisuccess));
            } else {
                //AlertTishi(conn.getResources().getString(R.string.joinhemaishibai));
                AlertTishi(value);
            }
        } catch (JSONException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            System.out.println("----登陆失败----->");
            stopProgressDialog();
        } catch (NullPointerException n) {
            n.printStackTrace();
            System.out.println("----服务器连接超时----->");
            AlertTishi("服务器连接超时");
            stopProgressDialog();
        }
        stopProgressDialog();
    }

    @Override
    protected JSONObject doInBackground(JSONObject... params) {
        String msgid = "joinhemaitouzhu";
        // UserToken 用户效验值
        String parameters1 = "UserToken";
        // BalancePassword 资金密码
        String parameters2 = "BalancePassword";
        // SchemeId 方案号
        String parameters3 = "SchemeId";
        // BuyCount 参与份数int
        String parameters4 = "BuyCount";
        // JoinPwd 参与密码
        String parameters5 = "JoinPwd";
        String values1 = Application.hashuser.get("UserToken").toString().trim();
        String values2 = arrjointouzhu.get(0).trim().toString();
        String values3 = arrjointouzhu.get(1).trim().toString();
        Integer values4 = Integer.parseInt(arrjointouzhu.get(2).trim().toString());
        String values5 = arrjointouzhu.get(3).trim().toString();
        List<NameValuePair> namevalue = XinTiJson.Fiveparameter(XinTiRequestcode.join_Buy_Code, msgid, parameters1, values1, parameters2, values2, parameters3, values3, parameters4, values4, parameters5, values5);
        JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
        return jsonobj;
    }

    @Override
    protected void onProgressUpdate(String... values) { // 可以与UI控件交互

        // TODO Auto-generated method stub
        super.onProgressUpdate(values);
    }

    //弹框
    public void AlertTishi(String shiticontent) {
        // 创建一个对话框
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(conn);
        alertDialog.setTitle("提示");
        alertDialog.setMessage(shiticontent);
        alertDialog.setPositiveButton(
                conn.getResources().getString(R.string.isok),
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int which) {
                    }
                }
        );
        alertDialog.setNegativeButton(
                conn.getResources().getString(R.string.isno),
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog,
                                        int which) {

                    }
                }
        );
        alertDialog.show();
    }


}
