package com.fleaphpnet;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.msg.xinTiUserMessage;
import com.fleaphpnet.view.BaseActivity;
import com.fleaphpnet.view.XinTiActivity;

import org.apache.http.NameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * 登陆
 */
public class SignInActivity extends BaseActivity {
    private Loadingprogressdialog progressDialog = null;
    private MainFrameTask mMainFrameTask = null;
    private SharedPreferences mshared;
    private Button mbuttonshake, zucedenglu;
    private EditText mEdittextzhanghao, mEditextmima;
    private CheckBox mcheckzhanghao, mcheckmima;
    private int mconnect;
    private TextView mtishi, telnumber;
    Intent intent = new Intent();


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);

        mtishi = (TextView) findViewById(R.id.toasttishiid);
        mbuttonshake = (Button) findViewById(R.id.loginshakeid);
        mEdittextzhanghao = (EditText) findViewById(R.id.loginyonghuid);
        mEditextmima = (EditText) findViewById(R.id.loginmimaid);
        mcheckzhanghao = (CheckBox) findViewById(R.id.jizhuzhanghaoid);
        mcheckmima = (CheckBox) findViewById(R.id.jizhumimaid);
        zucedenglu = (Button) findViewById(R.id.zucedenglu);
        telnumber = (TextView) findViewById(R.id.telnumber);
        telnumber.setText(Application.telnumber);

        //isOrEmpty
        mbuttonshake.setOnClickListener(new MyshakebuttonLogin());
        mshared = getSharedPreferences("userbutton", 0);
        mEdittextzhanghao.setText(mshared.getString("username", null));
        mEditextmima.setText(mshared.getString("userpwd", null));
        if (mEdittextzhanghao.length() != 0) {
            mcheckzhanghao.setChecked(mshared.getBoolean("mcheckmima", true));
        }
        if (mEditextmima.length() != 0) {
            mcheckmima.setChecked(mshared.getBoolean("mcheckmima", true));
            mcheckzhanghao.setChecked(mshared.getBoolean("mcheckzhanghao", true));
        }
        if (mEdittextzhanghao.length() == 0 && mEditextmima.length() == 0) {
            mcheckmima.setChecked(mshared.getBoolean("mcheckmima", false));
            mcheckzhanghao.setChecked(mshared.getBoolean("mcheckzhanghao", false));
        }

        //isOrchick
        mcheckmima.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    mcheckzhanghao.setChecked(true);
                }
                mshared = getSharedPreferences("userlogin", 0);
                mshared.edit().putBoolean("mcheckmima", isChecked).commit();
            }
        });
        mcheckzhanghao.setOnCheckedChangeListener(new OnCheckedChangeListener() {
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (!isChecked) {
                    mcheckmima.setChecked(false);
                }
                mshared = getSharedPreferences("userlogin", 0);
                mshared.edit().putBoolean("mcheckzhanghao", isChecked).commit();
            }
        });
    }

    // 转到电话
    public void onAction(View v) {
        Intent intent = new Intent();
        switch (v.getId()) {
            case R.id.kehurexianid:
                Application.Tel(SignInActivity.this);
                break;
            case R.id.register_back:
                //SignInActivity.this.finish();
                intent.setClass(SignInActivity.this, XinTiActivity.class);
                startActivity(intent);
                SignInActivity.this.finish();
                break;
            case R.id.zucedenglu:
                zucedenglu.setOnClickListener(new MyshakebuttonLogin());
                //SignInActivity.this.finish();
                break;
            case R.id.register_zhuce:
                intent.setClass(SignInActivity.this, SignUpActivity.class);
                startActivity(intent);
                SignInActivity.this.finish();
                break;
            default:
                break;
        }
    }

    // 账户密码为空时摇晃
    class MyshakebuttonLogin implements android.view.View.OnClickListener {
        public void onClick(View v) {
            String zhanghao = mEdittextzhanghao.getText().toString().trim();
            String mima = mEditextmima.getText().toString().trim();
            if (zhanghao.length() == 0) {
                Animation shake1 = AnimationUtils.loadAnimation(SignInActivity.this, R.anim.shake);
                findViewById(R.id.loginyonghuid).startAnimation(shake1);
                Animation shake = AnimationUtils.loadAnimation(SignInActivity.this, R.anim.shake);
                findViewById(R.id.zhanghaomingid).startAnimation(shake);
                Toast.makeText(SignInActivity.this, "请输入用户名 ", Toast.LENGTH_SHORT).show();
            } else if (mima.length() == 0) {
                Animation shake1 = AnimationUtils.loadAnimation(SignInActivity.this, R.anim.shake);
                findViewById(R.id.loginmimaid).startAnimation(shake1);
                Animation shake = AnimationUtils.loadAnimation(SignInActivity.this, R.anim.shake);
                findViewById(R.id.mimaid).startAnimation(shake);
                Toast.makeText(SignInActivity.this, "请输入密码 ", Toast.LENGTH_SHORT).show();
            } else {
                // new Thread(new MythreadLogin()).start();
                if (mcheckzhanghao.isChecked()) {
                    mshared = getSharedPreferences("userbutton", Context.MODE_WORLD_READABLE | Context.MODE_WORLD_WRITEABLE);
                    mshared.edit().putString("username", zhanghao).commit();
                    mcheckzhanghao.setChecked(mshared.getBoolean("mcheckzhanghao", true));
                }
                if (mcheckmima.isChecked()) {
                    mshared = getSharedPreferences("userbutton", Context.MODE_WORLD_READABLE | Context.MODE_WORLD_WRITEABLE);
                    mshared.edit().putString("username", zhanghao).commit();
                    mshared.edit().putString("userpwd", mima).commit();
                }
                Application.hashuser.put("username", zhanghao);
                Application.hashuser.put("userpwd", mima);
                //mMainFrameTask = new MainFrameTask(progressDialog, SignInActivity.this, zhanghao, mima, mMainFrameTask);
                mMainFrameTask = new MainFrameTask(progressDialog, SignInActivity.this, zhanghao, mima, mMainFrameTask);
                mMainFrameTask.execute();
            }
        }
    }

    public class MainFrameTask extends AsyncTask<JSONObject, String, JSONObject> {
        private Loadingprogressdialog progressDialog = null;
        Context mconn;
        private String values1, values2;
        private MainFrameTask mainFrame = null;

        public MainFrameTask(Loadingprogressdialog progressDialog, Context mconn, String values1, String values2) {
            super();
            this.progressDialog = progressDialog;
            this.mconn = mconn;
            this.values1 = values1;
            this.values2 = values2;
        }

        public MainFrameTask(Loadingprogressdialog progressDialog, Context mconn, String values1, String values2, MainFrameTask mainFrame) {
            super();
            this.progressDialog = progressDialog;
            this.mconn = mconn;
            this.values1 = values1;
            this.values2 = values2;
            this.mainFrame = mainFrame;
        }

        private void startProgressDialog() {
            if (progressDialog == null) {
                progressDialog = Loadingprogressdialog.createDialog(mconn);
                progressDialog.setCancelable(false);
                progressDialog.setMessage("登录中...");
            }
            progressDialog.show();
        }

        private void stopProgressDialog() {
            if (progressDialog != null) {
                progressDialog.dismiss();
                progressDialog = null;
            }
        }

        @Override
        protected void onCancelled() {
            stopProgressDialog();
            super.onCancelled();
        }

        @Override
        protected void onPreExecute() {
            startProgressDialog();
        }

        @Override
        protected void onPostExecute(JSONObject result) {
            // 可以与UI控件交互
            System.out.println("-------result----->" + result);
            try {
                String logincode = result.getString("Code");
                String value = result.getString("Value");
                JSONObject jsoncontent = new JSONObject(value);
                if (logincode.equals("101")) {
                    mtishi.setText("提示：登陆成功！！！");
                    new xinTiUserMessage().UserMsg(jsoncontent);
                    Application.Isonline = 1;
                    Intent intent = new Intent();
                    intent.setClass(mconn, XinTiActivity.class);
                    mconn.startActivity(intent);
                    SignInActivity.this.finish();
                } else {
                    mtishi.setText("提示：账户或密码登陆失败！！！");
                }
            } catch (JSONException e) {
                e.printStackTrace();
                System.out.println("----登陆失败----->");
                mtishi.setText("提示：账户或密码登陆失败！！！");
                stopProgressDialog();
            } catch (NullPointerException n) {
                n.printStackTrace();
                System.out.println("----服务器连接超时----->");
                mtishi.setText("提示：服务器连接超时！！！");
                stopProgressDialog();
            }
            stopProgressDialog();
        }

        @Override
        protected JSONObject doInBackground(JSONObject... params) {
            String msgid = "denglu";
            String parameters1 = "LoginName";
            String parameters2 = "Password";
            List<NameValuePair> namevalue = XinTiJson.Twoparameter2(XinTiRequestcode.Login_Code, msgid, parameters1, values1, parameters2, values2);
            JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
            Log.e("test", "---ddd---");
            return jsonobj;
        }

        @Override
        protected void onProgressUpdate(String... values) {
            // 可以与UI控件交互
            super.onProgressUpdate(values);
        }
    }

    @Override
    protected void onDestroy() {
        if (mcheckmima.isChecked() == false) {
            mshared.edit().putString("userpwd", null).commit();
        }
        if (mcheckzhanghao.isChecked() == false) {
            mshared.edit().putString("username", null).commit();
        }
        if (mMainFrameTask != null && !mMainFrameTask.isCancelled()) {
            mMainFrameTask.cancel(true);
        }
        super.onDestroy();
    }
}
