package com.fleaphpnet;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.Toast;

import com.fleaphpnet.adapter.MianxinTiadapter;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.view.XinTiActivity;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/**
 * @author way
 */
public class SplashActivity extends Activity {
    private static final int ISNEW = 0x001;// 是否为
    private static final int COMPLETE = 0x002;// 新特性显示完毕
    private Context mContext = this;
    private ImageView ivLeftImage, ivRightImage;
    private SharedPreferences msharedlist;
    private Handler handler = new Handler() {
        public void handleMessage(android.os.Message msg) {
            switch (msg.what) {
                case ISNEW:
                    init();
                    WhatIsNewUtils.saveFirstUseFlag(SplashActivity.this);
                    break;
                case COMPLETE:
                    Intent intent = new Intent();
                    intent.setClass(SplashActivity.this, XinTiActivity.class);
                    startActivity(intent);
                    SplashActivity.this.finish();
                    break;
                default:
                    break;
            }
        }
    };

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_splash);
        boolean isfist = WhatIsNewUtils.isFirstUse(SplashActivity.this);
        System.out.println("------第一次------>" + isfist);
        msharedlist = getSharedPreferences("test2", 0);

        if (isfist) {
            WhatIsNewUtils.saveFirstUseFlag(SplashActivity.this);
            new Timer().schedule(new TimerTask() {

                @Override
                public void run() {
                    Message msg = Message.obtain();
                    msg.what = ISNEW;
                    handler.sendMessage(msg);
                }
            }, 2000);
        } else {
            new Timer().schedule(new TimerTask() {

                @Override
                public void run() {
                    Intent intent = new Intent();
                    intent.setClass(SplashActivity.this, XinTiActivity.class);
                    startActivity(intent);
                    SplashActivity.this.finish();
                }
            }, 2000);

        }

    }

    /**
     * 初始化新特性界面
     */
    private void init() {
        LayoutInflater layoutInflater = LayoutInflater.from(mContext);
        View what_is_new = layoutInflater.inflate(R.layout.what_is_new, null);

        View pageOne = layoutInflater.inflate(R.layout.layout1, null);
        View pageTwo = layoutInflater.inflate(R.layout.layout2, null);
        View pageFour = layoutInflater.inflate(R.layout.layout4, null);
        View pageFive = layoutInflater.inflate(R.layout.layout5, null);
        View pageSix = layoutInflater.inflate(R.layout.layout6, null);
        View pageSeven = layoutInflater.inflate(R.layout.layout7, null);
        final View pageThree = layoutInflater.inflate(R.layout.layout3, null);
        ivLeftImage = (ImageView) pageThree.findViewById(R.id.iv_left_image01);
        ivRightImage = (ImageView) pageThree.findViewById(R.id.iv_left_image02);

        ViewPager viewPager = (ViewPager) what_is_new
                .findViewById(R.id.view_pager);
        final ImageView progressimage = (ImageView) what_is_new.findViewById(R.id.progressid);
        List<View> viewItems = new ArrayList<View>();
        viewItems.add(pageOne);
        viewItems.add(pageTwo);
        viewItems.add(pageFour);
        viewItems.add(pageFive);
        viewItems.add(pageSix);
        viewItems.add(pageSeven);
        viewItems.add(pageThree);
        viewPager.setAdapter(new MianxinTiadapter(viewItems));
        //mDotMarks = (DotMarks) what_is_new.findViewById(R.id.dot_marks);
        /**
         * 翻页监听事件，用于更新索引小图片
         */
        viewPager.setOnPageChangeListener(new OnPageChangeListener() {
            /**
             * 根据ViewPager的页面的变化来实时更新索引小图标
             * */
            public void onPageSelected(int arg0) {
                //mDotMarks.updateMark(arg0);// 更新
                if (arg0 == 0) {
                    progressimage.setImageResource(R.drawable.lottery_progress01);
                }
                if (arg0 == 1) {
                    progressimage.setImageResource(R.drawable.lottery_progress02);
                }
                if (arg0 == 2) {
                    progressimage.setImageResource(R.drawable.lottery_progress03);
                }
                if (arg0 == 3) {
                    progressimage.setImageResource(R.drawable.lottery_progress04);
                }
                if (arg0 == 4) {
                    progressimage.setImageResource(R.drawable.lottery_progress05);
                }
                if (arg0 == 5) {
                    progressimage.setImageResource(R.drawable.lottery_progress06);
                }
                if (arg0 == 6) {
                    progressimage.setImageResource(R.drawable.lottery_progress07);
                }
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
                // TODO Auto-generated method stub
            }

            public void onPageScrollStateChanged(int arg0) {
                // TODO Auto-generated method stub
            }
        });
        /**
         * 最后一个View添加点击事件，用于切换视图
         */
        pageThree.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                startAnimation();//开始动画
                //是否有网络
                boolean isflag = IsorInInternet.checkNet(mContext);
                if (!isflag) {
                    Toast.makeText(SplashActivity.this, "检查网络连接！！", Toast.LENGTH_SHORT).show();
                }
                //判断wifi
                boolean isfagwi = IsorInInternet.isWifi(mContext);
                if (!isfagwi) {
                    Toast.makeText(SplashActivity.this, "检查wifi是否打开！！", Toast.LENGTH_SHORT).show();
                }
                pageThree.setEnabled(false);

            }
        });
        this.setContentView(what_is_new);
    }

    /**
     * 动画
     */
    private void startAnimation() {
        Animation leftAnim = AnimationUtils.loadAnimation(mContext, R.anim.slide_left_anim);
        Animation rightAnim = AnimationUtils.loadAnimation(mContext, R.anim.slide_right_anim);
        //		final Animation fadeAnim = AnimationUtils.loadAnimation(mContext, R.anim.fade_anim);
        leftAnim.setFillAfter(true);
        rightAnim.setFillAfter(true);
        rightAnim.setAnimationListener(new AnimationListener() {

            public void onAnimationStart(Animation animation) {
                //					mDotMarks.startAnimation(fadeAnim);

            }

            public void onAnimationRepeat(Animation animation) {

            }

            public void onAnimationEnd(Animation animation) {
                //动画结束
                //				Message msg = handler.obtainMessage();
                //				msg.what = COMPLETE;
                //				handler.sendMessage(msg);
                Intent intent = new Intent();
                intent.setClass(SplashActivity.this, XinTiActivity.class);
                startActivity(intent);
                SplashActivity.this.finish();
            }
        });
        ivLeftImage.startAnimation(leftAnim);
        ivRightImage.startAnimation(rightAnim);
    }


}
