package com.fleaphpnet;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XinTiJsonjiexi {
    /**
     * 开奖和开奖历史记录 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArray(String path) throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 彩种
            String GameCode = item.getString("GameCode");
            // 玩法
            String GameType = item.getString("GameType");
            // 期号
            String IssuseNumber = item.getString("IssuseNumber");
            // 开奖号
            String WinNumber = item.getString("WinNumber");
            map = new HashMap<String, String>();
            map.put("GameCode", GameCode);
            map.put("GameType", GameType);
            map.put("IssuseNumber", IssuseNumber);
            map.put("WinNumber", WinNumber);
            list.add(map);
        }

        return list;
    }

    /**
     * 获取期号，截止时间
     * 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayDate(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 截止时间
            String StopBettingTime = item.getString("StopBettingTime");
            // 期号
            String IssuseNumber = item.getString("IssuseNumber");
            map = new HashMap<String, String>();
            map.put("StopBettingTime", StopBettingTime);
            map.put("IssuseNumber", IssuseNumber);
            list.add(map);
        }

        return list;
    }

    /**
     * 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayHistory(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成

            // GameCode 彩种
            String GameCode = item.getString("GameCode");
            // GameType 玩法
            String GameType = item.getString("GameType");
            // IssuseNumber 期号
            String IssuseNumber = item.getString("IssuseNumber");
            // WinNumber 开奖号
            String WinNumber = item.getString("WinNumber");
            map = new HashMap<String, String>();
            map.put("GameCode", GameCode);
            map.put("GameType", GameType);
            map.put("IssuseNumber", IssuseNumber);
            map.put("WinNumber", WinNumber);
            list.add(map);
        }

        return list;
    }

    /**
     * 公告 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayGonggao(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 名称
            String Title = item.getString("Title");
            // 文章编号
            String Id = item.getString("Id");
            // 创建时间
            String CreateTime = item.getString("CreateTime");
            // 创建者
            String CreateBy = item.getString("CreateBy");
            map = new HashMap<String, String>();
            map.put("Title", Title);
            map.put("Id", Id);
            map.put("CreateTime", CreateTime);
            map.put("CreateBy", CreateBy);
            list.add(map);
        }
        return list;
    }

    /**
     * 账户金额 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayzhanghu(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 账户类型
            String AccountType = item.getString("AccountType");
            // 创建时间
            String CreateTime = item.getString("CreateTime");
            // 类别
            String Category = item.getString("Category");
            // 消费前金额
            String BeforeBalance = item.getString("BeforeBalance");
            // AfterBalance 消费后金额
            String AfterBalance = item.getString("AfterBalance");
            // OrderId 订单号
            String OrderId = item.getString("OrderId");
            // PayMoney 购彩金额
            String PayMoney = item.getString("PayMoney");
            // PayType 支付类型
            // 10 ：支出
            // 20 ：收入
            String PayType = item.getString("PayType");
            // Summary 字符串描述
            String Summary = item.getString("Summary");
            map = new HashMap<String, String>();
            map.put("AccountType", AccountType);
            map.put("CreateTime", CreateTime);
            map.put("Category", Category);
            map.put("BeforeBalance", BeforeBalance);
            map.put("AfterBalance", AfterBalance);
            map.put("OrderId", OrderId);
            map.put("PayMoney", PayMoney);
            map.put("PayType", PayType);
            map.put("Summary", Summary);
            list.add(map);
        }
        return list;
    }

    /**
     * 投注记录 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayTouzhu(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成

            // SchemeId 方案号
            String SchemeId = item.getString("SchemeId");
            // GameCode 彩种
            String GameCode = item.getString("GameCode");
            // GameTypeName 玩法（中文）
            String GameTypeName = item.getString("GameTypeName");
            // BuyMoney 投注金额
            String BuyMoney = item.getString("BuyMoney");
            // BonusMoney 奖金
            String BonusMoney = item.getString("BonusMoney");
            // SchemeType 投注类型
            String SchemeType = item.getString("SchemeType");
            // BuyTime 购买时间
            String BuyTime = item.getString("BuyTime");
            map = new HashMap<String, String>();
            map.put("SchemeId", SchemeId);
            map.put("GameCode", GameCode);
            map.put("GameTypeName", GameTypeName);
            map.put("BuyMoney", BuyMoney);
            map.put("BonusMoney", BonusMoney);
            map.put("SchemeType", SchemeType);
            map.put("BuyTime", BuyTime);
            list.add(map);
        }
        System.out.println("---------list--------->" + list);
        return list;
    }

    /**
     * 银行卡查询 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static HashMap<String, String> getJSONArrayBankcard(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        JSONObject jsonArray = new JSONObject(json);
        // BankCardNumber 银行账号
        String BankCardNumber = jsonArray.getString("BankCardNumber");
        // BankCode 银行编码 如：ICBC
        String BankCode = jsonArray.getString("BankCode");
        // BankName 银行全称 如：中国工商银行
        String BankName = jsonArray.getString("BankName");
        // BankSubName 银行全称 如：中国工商银行
        String BankSubName = jsonArray.getString("BankSubName");
        // CityName 城市
        String CityName = jsonArray.getString("CityName");
        // ProvinceName 省
        String ProvinceName = jsonArray.getString("ProvinceName");
        // RealName 真实姓名
        String RealName = jsonArray.getString("RealName");
        // UserId 用户编号
        String UserId = jsonArray.getString("UserId");
        map = new HashMap<String, String>();
        map.put("BankCardNumber", BankCardNumber);
        map.put("BankCode", BankCode);
        map.put("BankName", BankName);
        map.put("BankSubName", BankSubName);
        map.put("CityName", CityName);
        map.put("ProvinceName", ProvinceName);
        map.put("RealName", RealName);
        map.put("UserId", UserId);
        list.add(map);
        return map;
    }

    /**
     * 中奖纪录查询 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayZhongjiang(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成

            // SchemeId 方案号
            String SchemeId = item.getString("SchemeId");
            // BonusMoney 中奖金额
            String BonusMoney = item.getString("BonusMoney");
            // DisplayName 真实姓名
            String DisplayName = item.getString("DisplayName");
            // UserId 用户编号
            String UserId = item.getString("UserId");
            // SchemeType 方案类型（1：普通投注，2：追号，3：合买）
            //String SchemeType = item.getString("SchemeType");
            // BetCount 柱数
            String BetCount = item.getString("BetCount");
            // TotalMoney 投注金额
            String TotalMoney = item.getString("TotalMoney");
            map = new HashMap<String, String>();
            map.put("SchemeId", SchemeId);
            map.put("BonusMoney", BonusMoney);
            map.put("DisplayName", DisplayName);
            map.put("UserId", UserId);
            //map.put("SchemeType", SchemeType);
            map.put("BetCount", BetCount);
            map.put("TotalMoney", TotalMoney);
            list.add(map);
        }
        System.out.println("---------list--------->" + list);
        return list;
    }

    /**
     * 合买列表查询 获取"数组形式"的JSON数据， 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArrayHeMai(String path) throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成

            // GameCode 彩种
            String GameCode = item.getString("GameCode");
            // GameDisplayName 彩种显示名
            String GameDisplayName = item.getString("GameDisplayName");
            // GameType 玩法
            String GameType = item.getString("GameType");
            // GameTypeDisplayName 玩法显示名
            String GameTypeDisplayName = item.getString("GameTypeDisplayName");
            // CreateUserId 创建合买用户编号
            String CreateUserId = item.getString("CreateUserId");
            // CreaterDisplayName 创建合买用户名
            String CreaterDisplayName = item.getString("CreaterDisplayName");
            // CreaterHideDisplayNameCount 创建合买用户名隐藏位数
            String CreaterHideDisplayNameCount = item.getString("CreaterHideDisplayNameCount");
            // CreateTime 创建时间
            String CreateTime = item.getString("CreateTime");
            /**
             * 这里服务端没有返回,先注释掉
             * @author lizf
             */
            // SuccessGainMoney 成功方案盈利金额（用于计算战绩）
            //String SuccessGainMoney = item.getString("SuccessGainMoney");
            // FailGainMoney 失败方案盈利金额（用于计算流产战绩）
            //String FailGainMoney = item.getString("FailGainMoney");
            // SchemeId 方案号
            String SchemeId = item.getString("SchemeId");
            // TotalMoney 总金额
            String TotalMoney = item.getString("TotalMoney");
            // Subscription 认购
            String Subscription = item.getString("Subscription");
            // Guarantees 保底
            String Guarantees = item.getString("Guarantees");
            // StopTime 停止时间
            String StopTime = item.getString("StopTime");
            // TotalCount 总份数
            String TotalCount = item.getString("TotalCount");
            // SoldCount 已售出份数
            String SoldCount = item.getString("SoldCount");
            // Price 单价
            String Price = item.getString("Price");
            // Progress 进度
            String Progress = item.getString("Progress");
            // JoinPwd 参与密码
            String JoinPwd = item.getString("JoinPwd");
            // BetCount 投注注数
            //String BetCount = item.getString("BetCount");
            // BonusDeduct 中奖提成
            //String BonusDeduct = item.getString("BonusDeduct");
            // IssuseNumber 期号
            String IssuseNumber = item.getString("IssuseNumber");
            map = new HashMap<String, String>();

            map.put("GameCode", GameCode);
            map.put("GameDisplayName", GameDisplayName);
            map.put("GameType", GameType);
            map.put("GameTypeDisplayName", GameTypeDisplayName);
            map.put("CreateUserId", CreateUserId);
            map.put("CreaterDisplayName", CreaterDisplayName);
            map.put("CreaterHideDisplayNameCount", CreaterHideDisplayNameCount);
            map.put("CreateTime", CreateTime);
            //map.put("SuccessGainMoney", SuccessGainMoney);
            //map.put("FailGainMoney", FailGainMoney);
            map.put("SchemeId", SchemeId);
            map.put("TotalMoney", TotalMoney);
            map.put("Subscription", Subscription);
            map.put("Guarantees", Guarantees);
            map.put("StopTime", StopTime);
            map.put("TotalCount", TotalCount);
            map.put("SoldCount", SoldCount);
            map.put("Price", Price);
            map.put("Progress", Progress);
            map.put("JoinPwd", JoinPwd);
            //map.put("BetCount", BetCount);
            //map.put("BonusDeduct", BonusDeduct);
            map.put("IssuseNumber", IssuseNumber);

            list.add(map);
        }
        System.out.println("---------list--------->" + list);
        return list;
    }

    /**
     * 保持用户订单查询 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArraybaochidingdan(
            String path) throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成

            // 用户ID
            String UserId = item.getString("UserId");
            // 倍数
            String Amount = item.getString("Amount");
            // 注数
            String BetCount = item.getString("BetCount");
            // 创建时间
            String CreateTime = item.getString("CreateTime");
            // 真实姓名
            String DisplayName = item.getString("DisplayName");
            // 彩种编码
            String GameCode = item.getString("GameCode");
            // 玩法编码
            String GameType = item.getString("GameType");
            // 期号
            String IssuseNumber = item.getString("IssuseNumber");
            // 几串几
            String PlayType = item.getString("PlayType");
            // 进行状态
            // 0：等待中
            // 10：进行中
            // 20：自动停止
            // 80：被中断
            // 90：已完成
            String ProgressStatus = item.getString("ProgressStatus");
            // 方案投注类别
            // 0：普通投注
            // 1：单式上传
            // 2：过滤投注
            String SchemeBettingCategory = item
                    .getString("SchemeBettingCategory");
            // 方案号
            String SchemeId = item.getString("SchemeId");
            // 方案来源
            // 0：网站投注
            // 101：iPhone客户端投注
            // 102：Android客户端投注
            // 103：WAP网站投注
            // 104：触屏版投注
            String SchemeSource = item.getString("SchemeSource");
            // 方案类型（1：普通投注，2：追号，3：合买）
            String SchemeType = item.getString("SchemeType");
            // 停止时间
            String StopTime = item.getString("StopTime");
            // 停止时间（字符串）
            String StrStopTime = item.getString("StrStopTime");
            // 投注总金额
            String TotalMoney = item.getString("TotalMoney");

            map = new HashMap<String, String>();

            map.put("UserId", UserId);
            map.put("Amount", Amount);
            map.put("BetCount", BetCount);
            map.put("CreateTime", CreateTime);
            map.put("DisplayName", DisplayName);
            map.put("GameCode", GameCode);
            map.put("GameType", GameType);
            map.put("IssuseNumber", IssuseNumber);
            map.put("PlayType", PlayType);
            map.put("ProgressStatus", ProgressStatus);
            map.put("SchemeBettingCategory", SchemeBettingCategory);
            map.put("SchemeId", SchemeId);
            map.put("SchemeSource", SchemeSource);
            map.put("SchemeType", SchemeType);
            map.put("StopTime", StopTime);
            map.put("StrStopTime", StrStopTime);
            map.put("TotalMoney", TotalMoney);
            list.add(map);
        }
        System.out.println("---------list--------->" + list);
        return list;
    }

    /**
     * 传统足球队伍信息查询 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArraylistmapCTZQ(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> listmapCTZQ = new ArrayList<Map<String, String>>();
        Map<String, String> mapCTZQ = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 颜色
            String Color = item.getString("Color");
            // 彩种
            String GameCode = item.getString("GameCode");
            // 玩法
            String GameType = item.getString("GameType");
            // 客队名称
            String GuestTeamName = item.getString("GuestTeamName");
            // 客队排名
            String GuestTeamStanding = item.getString("GuestTeamStanding");
            // 主队名称
            String HomeTeamName = item.getString("HomeTeamName");
            // 主队排名
            String HomeTeamStanding = item.getString("HomeTeamStanding");
            // 编号
            String Id = item.getString("Id");
            // 期号
            String IssuseNumber = item.getString("IssuseNumber");
            // 联赛名称
            String MatchName = item.getString("MatchName");
            // 比赛开始时间
            String MatchStartTime = item.getString("MatchStartTime");
            //
            // 赛事状态：
            // 0：未开售
            // 10：销售中
            // 20：已结束
            //
            String MatchState = item.getString("MatchState");
            // 赛事编号
            String OrderNumber = item.getString("OrderNumber");
            // SP
            String AverageOdds = item.getString("AverageOdds");
            // 点击一场比赛时，链接到m.xinti.com/buy/zqdetail/FXId本地址（不能用浏览器打开，只能用内置浏览器打开）
            String FXId = item.getString("FXId");

            mapCTZQ = new HashMap<String, String>();
            mapCTZQ.put("Color", Color);
            mapCTZQ.put("GameCode", GameCode);
            mapCTZQ.put("GameType", GameType);
            mapCTZQ.put("GuestTeamName", GuestTeamName);
            mapCTZQ.put("GuestTeamStanding", GuestTeamStanding);
            mapCTZQ.put("HomeTeamName", HomeTeamName);
            mapCTZQ.put("HomeTeamStanding", HomeTeamStanding);
            mapCTZQ.put("Id", Id);
            mapCTZQ.put("IssuseNumber", IssuseNumber);
            mapCTZQ.put("MatchName", MatchName);
            mapCTZQ.put("MatchStartTime", MatchStartTime);
            mapCTZQ.put("MatchState", MatchState);
            mapCTZQ.put("OrderNumber", OrderNumber);
            mapCTZQ.put("AverageOdds", AverageOdds);
            mapCTZQ.put("FXId", FXId);
            listmapCTZQ.add(mapCTZQ);
        }
        System.out.println("---------list--------->" + listmapCTZQ);
        return listmapCTZQ;
    }

    /**
     * 北京单场队伍信息查询 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArraylistmapBJDC(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 客队名称
            String GuestTeamName = item.getString("GuestTeamName");
            // 主队名称
            String HomeTeamName = item.getString("HomeTeamName");
            // 编号
            String Id = item.getString("Id");
            // 期号
            String IssuseNumber = item.getString("IssuseNumber");
            // 让球
            String LetBall = item.getString("LetBall");
            // 停止投注时间
            String LocalStopTime = item.getString("LocalStopTime");
            // 联赛颜色
            String MatchColor = item.getString("MatchColor");
            // 联赛名称
            String MatchName = item.getString("MatchName");
            // 比赛编号
            String MatchOrderId = item.getString("MatchOrderId");
            // 比赛开始时间
            String MatchStartTime = item.getString("MatchStartTime");
            // 状态
            // 0：销售中
            // 1：停止销售
            String MatchState = item.getString("MatchState");
            // 平SP
            String SP_Flat_Odds = item.getString("SP_Flat_Odds");
            // 负SP
            String SP_Lose_Odds = item.getString("SP_Lose_Odds");
            // 胜SP
            String SP_Win_Odds = item.getString("SP_Win_Odds");
            // 进球0SP
            String JinQiu_0_Odds = item.getString("JinQiu_0_Odds");
            // 进球1SP
            String JinQiu_1_Odds = item.getString("JinQiu_1_Odds");
            // 进球2SP
            String JinQiu_2_Odds = item.getString("JinQiu_2_Odds");
            // 进球3SP
            String JinQiu_3_Odds = item.getString("JinQiu_3_Odds");
            // 进球4SP
            String JinQiu_4_Odds = item.getString("JinQiu_4_Odds");
            // 进球5SP
            String JinQiu_5_Odds = item.getString("JinQiu_5_Odds");
            // 进球6SP
            String JinQiu_6_Odds = item.getString("JinQiu_6_Odds");
            // 进球7SP
            String JinQiu_7_Odds = item.getString("JinQiu_7_Odds");
            // 上单SP
            String SH_D_Odds = item.getString("SH_D_Odds");
            // 上双SP
            String SH_S_Odds = item.getString("SH_S_Odds");
            // 下单SP
            String X_D_Odds = item.getString("X_D_Odds");
            // 下双SP
            String X_S_Odds = item.getString("X_S_Odds");
            // 负0：1 SP
            String F_01 = item.getString("F_01");
            // 负0：2 SP
            String F_02 = item.getString("F_02");
            // 负0：3 SP
            String F_03 = item.getString("F_03");
            // 负0：4 SP
            String F_04 = item.getString("F_04");
            // 负1：2 SP
            String F_12 = item.getString("F_12");
            // 负1：3 SP
            String F_13 = item.getString("F_13");
            // 负1：4 SP
            String F_14 = item.getString("F_14");
            // 负2：3 SP
            String F_23 = item.getString("F_23");
            // 负2：4 SP
            String F_24 = item.getString("F_24");
            // 负其它SP
            String F_QT = item.getString("F_QT");
            // 平0: 0 SP
            String P_00 = item.getString("P_00");
            // 平1: 1 SP
            String P_11 = item.getString("P_11");
            // 平2: 2 SP
            String P_22 = item.getString("P_22");
            // 平3: 3 SP
            String P_33 = item.getString("P_33");
            // 平其它SP
            String P_QT = item.getString("P_QT");
            // 胜 1: 0 SP
            String S_10 = item.getString("S_10");
            // 胜 2: 0 SP
            String S_20 = item.getString("S_20");
            // 胜 2: 1 SP
            String S_21 = item.getString("S_21");
            // 胜 3: 0 SP
            String S_30 = item.getString("S_30");
            // 胜 3: 1 SP
            String S_31 = item.getString("S_31");
            // 胜 3: 2 SP
            String S_32 = item.getString("S_32");
            // 胜 4: 0 SP
            String S_40 = item.getString("S_40");
            // 胜 4: 1 SP
            String S_41 = item.getString("S_41");
            // 胜 4: 2 SP
            String S_42 = item.getString("S_42");
            // 胜 其它SP
            String S_QT = item.getString("S_QT");


            // 负负SP
            String F_F_Odds = item.getString("F_F_Odds");
            // 负平SP
            String F_P_Odds = item.getString("F_P_Odds");
            // 负胜SP
            String F_SH_Odds = item.getString("F_SH_Odds");
            // 平负SP
            String P_F_Odds = item.getString("P_F_Odds");
            // 平平SP
            String P_P_Odds = item.getString("P_P_Odds");
            // 平胜SP
            String P_SH_Odds = item.getString("P_SH_Odds");
            // 胜负SP
            String SH_F_Odds = item.getString("SH_F_Odds");
            // 胜平SP
            String SH_P_Odds = item.getString("SH_P_Odds");
            // 胜胜SP
            String SH_SH_Odds = item.getString("SH_SH_Odds");
            // 点击一场比赛时，链接到m.xinti.com/buy/zqdetail/FXId本地址（不能用浏览器打开，只能用内置浏览器打开）
            String FXId = item.getString("FXId");

            map = new HashMap<String, String>();
            map.put("GuestTeamName", GuestTeamName);
            map.put("HomeTeamName", HomeTeamName);
            map.put("Id", Id);
            map.put("IssuseNumber", IssuseNumber);
            map.put("LetBall", LetBall);
            map.put("LocalStopTime", LocalStopTime);
            map.put("MatchColor", MatchColor);
            map.put("MatchName", MatchName);
            map.put("MatchOrderId", MatchOrderId);
            map.put("MatchStartTime", MatchStartTime);
            map.put("MatchState", MatchState);
            map.put("SP_Flat_Odds", SP_Flat_Odds);
            map.put("SP_Lose_Odds", SP_Lose_Odds);
            map.put("SP_Win_Odds", SP_Win_Odds);
            map.put("JinQiu_0_Odds", JinQiu_0_Odds);
            map.put("JinQiu_1_Odds", JinQiu_1_Odds);
            map.put("JinQiu_2_Odds", JinQiu_2_Odds);
            map.put("JinQiu_3_Odds", JinQiu_3_Odds);
            map.put("JinQiu_4_Odds", JinQiu_4_Odds);
            map.put("JinQiu_5_Odds", JinQiu_5_Odds);
            map.put("JinQiu_6_Odds", JinQiu_6_Odds);
            map.put("JinQiu_7_Odds", JinQiu_7_Odds);
            map.put("SH_D_Odds", SH_D_Odds);
            map.put("SH_S_Odds", SH_S_Odds);
            map.put("X_D_Odds", X_D_Odds);
            map.put("X_S_Odds", X_S_Odds);
            map.put("F_01", F_01);
            map.put("F_02", F_02);
            map.put("F_03", F_03);
            map.put("F_04", F_04);
            map.put("F_12", F_12);
            map.put("F_13", F_13);
            map.put("F_14", F_14);
            map.put("F_23", F_23);
            map.put("F_24", F_24);
            map.put("F_QT", F_QT);
            map.put("P_00", P_00);
            map.put("P_11", P_11);
            map.put("P_22", P_22);
            map.put("P_33", P_33);
            map.put("P_QT", P_QT);
            map.put("S_10", S_10);
            map.put("S_20", S_20);
            map.put("S_21", S_21);
            map.put("S_30", S_30);
            map.put("S_31", S_31);
            map.put("S_32", S_32);
            map.put("S_40", S_40);
            map.put("S_41", S_41);
            map.put("S_42", S_42);
            map.put("S_QT", S_QT);
            map.put("F_F_Odds", F_F_Odds);
            map.put("F_P_Odds", F_P_Odds);
            map.put("F_SH_Odds", F_SH_Odds);
            map.put("P_F_Odds", P_F_Odds);
            map.put("P_P_Odds", P_P_Odds);
            map.put("P_SH_Odds", P_SH_Odds);
            map.put("SH_F_Odds", SH_F_Odds);
            map.put("SH_P_Odds", SH_P_Odds);
            map.put("SH_SH_Odds", SH_SH_Odds);
            map.put("FXId", FXId);
            list.add(map);
        }
        System.out.println("---------list--------->" + list);
        return list;
    }

    /**
     * 竞彩足球队伍信息查询 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArraylistmapJCZQ(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> listmapJCZQ = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            String MatchData = item.getString("MatchData");
            // 比赛日期
            String MatchId = item.getString("MatchId");
            // 比赛ID
            String MatchNumber = item.getString("MatchNumber");
            // 比赛编号
            String FSStopBettingTime = item.getString("FSStopBettingTime");
            // 投注截止时间
            String GuestTeamName = item.getString("GuestTeamName");
            // 客队名称
            String HomeTeamName = item.getString("HomeTeamName");
            // 主队名称
            String LeagueColor = item.getString("LeagueColor");
            // 联赛颜色
            String LeagueName = item.getString("LeagueName");
            // 联赛名称


            String LetBall = item.getString("LetBall");
            // 让球数
            String MatchIdName = item.getString("MatchIdName");
            // 比赛编号名称
            String StartDateTime = item.getString("StartDateTime");
            // 开始时间


            String SP_Flat_Odds = item.getString("SP_Flat_Odds");
            // 让球平SP
            String SP_Lose_Odds = item.getString("SP_Lose_Odds");
            // 让球负SP
            String SP_Win_Odds = item.getString("SP_Win_Odds");
            // 让球胜SP

            String SP_Flat_Odds_BRQ = item.getString("SP_Flat_Odds_BRQ");
            // 平SP
            String SP_Lose_Odds_BRQ = item.getString("SP_Lose_Odds_BRQ");
            // 负SP
            String SP_Win_Odds_BRQ = item.getString("SP_Win_Odds_BRQ");
            // 胜SP


            String JinQiu_0_Odds = item.getString("JinQiu_0_Odds");
            // 进球0 SP
            String JinQiu_1_Odds = item.getString("JinQiu_1_Odds");
            // 进球1 SP
            String JinQiu_2_Odds = item.getString("JinQiu_2_Odds");
            // 进球2 SP
            String JinQiu_3_Odds = item.getString("JinQiu_3_Odds");
            // 进球3 SP
            String JinQiu_4_Odds = item.getString("JinQiu_4_Odds");
            // 进球4 SP
            String JinQiu_5_Odds = item.getString("JinQiu_5_Odds");
            // 进球5 SP
            String JinQiu_6_Odds = item.getString("JinQiu_6_Odds");
            // 进球6 SP
            String JinQiu_7_Odds = item.getString("JinQiu_7_Odds");
            // 进球7 SP


            String F_01 = item.getString("F_01");
            // 负0:1 SP
            String F_02 = item.getString("F_02");
            // 负0:2 SP
            String F_03 = item.getString("F_03");
            // 负0:3 SP
            String F_04 = item.getString("F_04");
            // 负0:4 SP
            String F_05 = item.getString("F_05");
            // 负0:5 SP
            String F_12 = item.getString("F_12");
            // 负1:2 SP
            String F_13 = item.getString("F_13");
            // 负1:3 SP
            String F_14 = item.getString("F_14");
            // 负1:4 SP
            String F_15 = item.getString("F_15");
            // 负1:5 SP
            String F_23 = item.getString("F_23");
            // 负2:3 SP
            String F_24 = item.getString("F_24");
            // 负2:4 SP
            String F_25 = item.getString("F_25");
            // 负2:5 SP
            String F_QT = item.getString("F_QT");
            // 负其它SP
            String P_00 = item.getString("P_00");
            // 平0：0 SP
            String P_11 = item.getString("P_11");
            // 平 1：1SP
            String P_22 = item.getString("P_22");
            // 平 2：2SP
            String P_33 = item.getString("P_33");
            // 平 3：3SP
            String P_QT = item.getString("P_QT");
            // 平其它SP
            String S_10 = item.getString("S_10");
            // 胜1:0 SP
            String S_20 = item.getString("S_20");
            // 胜2:0 SP
            String S_21 = item.getString("S_21");
            // 胜2:1 SP
            String S_30 = item.getString("S_30");
            // 胜3:0 SP
            String S_31 = item.getString("S_31");
            // 胜3:1 SP
            String S_32 = item.getString("S_32");
            // 胜3:2 SP
            // 胜4:0 SP
            String S_40 = item.getString("S_40");
            // 胜4:1 SP
            String S_41 = item.getString("S_41");
            // 胜4:2 SP
            String S_42 = item.getString("S_42");
            // 胜5:0 SP
            String S_50 = item.getString("S_50");
            // 胜5:1 SP
            String S_51 = item.getString("S_51");
            // 胜5:2 SP
            String S_52 = item.getString("S_52");
            // 胜其它 SP
            String S_QT = item.getString("S_QT");


            // 负负SP
            String F_F_Odds = item.getString("F_F_Odds");
            // 负平SP
            String F_P_Odds = item.getString("F_P_Odds");
            // 负胜SP
            String F_SH_Odds = item.getString("F_SH_Odds");
            // 平负SP
            String P_F_Odds = item.getString("P_F_Odds");
            // 平平SP
            String P_P_Odds = item.getString("P_P_Odds");
            // 平胜SP
            String P_SH_Odds = item.getString("P_SH_Odds");
            // 胜平SP
            String SH_F_Odds = item.getString("SH_F_Odds");
            // 胜平SP
            String SH_P_Odds = item.getString("SH_P_Odds");
            // 胜胜SP
            String SH_SH_Odds = item.getString("SH_SH_Odds");
            // 点击一场比赛时，链接到m.xinti.com/buy/zqdetail/FXId本地址（不能用浏览器打开，只能用内置浏览器打开）
            String FXId = item.getString("FXId");

            map = new HashMap<String, String>();
            map.put("MatchData", MatchData);
            map.put("MatchId", MatchId);
            map.put("MatchNumber", MatchNumber);
            map.put("FSStopBettingTime", FSStopBettingTime);
            map.put("GuestTeamName", GuestTeamName);
            map.put("HomeTeamName", HomeTeamName);
            map.put("LeagueColor", LeagueColor);
            map.put("LeagueName", LeagueName);
            map.put("LetBall", LetBall);
            map.put("MatchIdName", MatchIdName);
            map.put("StartDateTime", StartDateTime);
            map.put("SP_Flat_Odds", SP_Flat_Odds);
            map.put("SP_Lose_Odds", SP_Lose_Odds);
            map.put("SP_Win_Odds", SP_Win_Odds);
            map.put("SP_Flat_Odds_BRQ", SP_Flat_Odds_BRQ);
            map.put("SP_Lose_Odds_BRQ", SP_Lose_Odds_BRQ);
            map.put("SP_Win_Odds_BRQ", SP_Win_Odds_BRQ);
            map.put("JinQiu_0_Odds", JinQiu_0_Odds);
            map.put("JinQiu_1_Odds", JinQiu_1_Odds);
            map.put("JinQiu_2_Odds", JinQiu_2_Odds);
            map.put("JinQiu_3_Odds", JinQiu_3_Odds);
            map.put("JinQiu_4_Odds", JinQiu_4_Odds);
            map.put("JinQiu_5_Odds", JinQiu_5_Odds);
            map.put("JinQiu_6_Odds", JinQiu_6_Odds);
            map.put("JinQiu_7_Odds", JinQiu_7_Odds);
            map.put("F_01", F_01);
            map.put("F_02", F_02);
            map.put("F_03", F_03);
            map.put("F_04", F_04);
            map.put("F_05", F_05);
            map.put("F_12", F_12);
            map.put("F_13", F_13);
            map.put("F_14", F_14);
            map.put("F_15", F_15);
            map.put("F_23", F_23);
            map.put("F_24", F_24);
            map.put("F_25", F_25);
            map.put("F_QT", F_QT);
            map.put("P_00", P_00);
            map.put("P_11", P_11);
            map.put("P_22", P_22);
            map.put("P_33", P_33);
            map.put("P_QT", P_QT);
            map.put("S_10", S_10);
            map.put("S_20", S_20);
            map.put("S_21", S_21);
            map.put("S_30", S_30);
            map.put("S_31", S_31);
            map.put("S_32", S_32);
            map.put("S_40", S_40);
            map.put("S_41", S_41);
            map.put("S_42", S_42);
            map.put("S_50", S_50);
            map.put("S_51", S_51);
            map.put("S_52", S_52);
            map.put("S_QT", S_QT);
            map.put("F_F_Odds", F_F_Odds);
            map.put("F_P_Odds", F_P_Odds);
            map.put("F_SH_Odds", F_SH_Odds);
            map.put("P_F_Odds", P_F_Odds);
            map.put("P_P_Odds", P_P_Odds);
            map.put("P_SH_Odds", P_SH_Odds);
            map.put("SH_F_Odds", SH_F_Odds);
            map.put("SH_P_Odds", SH_P_Odds);
            map.put("SH_SH_Odds", SH_SH_Odds);
            map.put("FXId", FXId);
            listmapJCZQ.add(map);
        }
        System.out.println("---------list--------->" + listmapJCZQ);
        return listmapJCZQ;
    }

    /**
     * 竞彩篮球队伍信息查询 获取"数组形式"的JSON数据，
     * 数据形式：[{"id":1,"name":"小猪"},{"id":2,"name":"小猫"}]
     *
     * @param path 网页路径
     * @return 返回List
     * @throws Exception
     */
    public static List<Map<String, String>> getJSONArraylistmapJCLQ(String path)
            throws Exception {
        String json = path;
        List<Map<String, String>> listmapJCLQ = new ArrayList<Map<String, String>>();
        Map<String, String> map = null;
        JSONArray jsonArray = new JSONArray(json); // 数据直接为一个数组形式，所以可以直接
        // 用android提供的框架JSONArray读取JSON数据，转换成Array
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject item = jsonArray.getJSONObject(i); // 每条记录又由几个Object对象组成
            // 停止投注时间
            String FSStopBettingTime = item.getString("FSStopBettingTime");

            // 客队名称
            String GuestTeamName = item.getString("GuestTeamName");

            // 主队名称
            String HomeTeamName = item.getString("HomeTeamName");

            // 联盟颜色
            String LeagueColor = item.getString("LeagueColor");

            // 联赛名称
            String LeagueName = item.getString("LeagueName");

            // 比赛编号名称
            String MatchIdName = item.getString("MatchIdName");

            // 开始时间
            String StartDateTime = item.getString("StartDateTime");

            // 比赛日期
            String MatchData = item.getString("MatchData");

            // 方案号
            String MatchId = item.getString("MatchId");

            // 比赛编号
            String MatchNumber = item.getString("MatchNumber");


            String FXId = item.getString("FXId");
            // 点击一场比赛时，链接到m.xinti.com/buy/zqdetail/FXId本地址（不能用浏览器打开，只能用内置浏览器打开）

            String SF_LoseSP = item.getString("SF_LoseSP");
            // 胜负——负SP

            String SF_WinSP = item.getString("SF_WinSP");
            // 胜负 胜SP

            String RF_LoseSP = item.getString("RF_LoseSP");
            // 让分 胜负——负SP
            String RF = item.getString("RF");
            // 让分数
            String RF_WinSP = item.getString("RF_WinSP");
            // 让分 ——胜SP

            String GuestWin1_5 = item.getString("GuestWin1_5");
            // 客胜1-5
            String GuestWin6_10 = item.getString("GuestWin6_10");
            // 客胜6-10
            String GuestWin11_15 = item.getString("GuestWin11_15");
            // 客胜11-5
            String GuestWin16_20 = item.getString("GuestWin16_20");
            // 客胜16-20
            String GuestWin21_25 = item.getString("GuestWin21_25");
            // 客胜21-25
            String GuestWin26 = item.getString("GuestWin26");
            // 客胜26
            String HomeWin1_5 = item.getString("HomeWin1_5");
            // 主胜1-5
            String HomeWin6_10 = item.getString("HomeWin6_10");
            // 主胜6-10
            String HomeWin11_15 = item.getString("HomeWin11_15");
            // 主胜11-15
            String HomeWin16_20 = item.getString("HomeWin16_20");
            // 主胜16-20
            String HomeWin21_25 = item.getString("HomeWin21_25");
            // 主胜21-25
            String HomeWin26 = item.getString("HomeWin26");
            // 主胜26


            String DF = item.getString("DF");
            // 大小分——大分SP
            String XF = item.getString("XF");
            // 小分SP
            String YSZF = item.getString("YSZF");
            // 预设总分

            map = new HashMap<String, String>();
            map.put("FSStopBettingTime", FSStopBettingTime);
            map.put("GuestTeamName", GuestTeamName);
            map.put("HomeTeamName", HomeTeamName);
            map.put("LeagueColor", LeagueColor);
            map.put("LeagueName", LeagueName);
            map.put("MatchIdName", MatchIdName);
            map.put("StartDateTime", StartDateTime);
            map.put("MatchData", MatchData);
            map.put("MatchId", MatchId);
            map.put("MatchNumber", MatchNumber);
            map.put("FXId", FXId);
            map.put("SF_LoseSP", SF_LoseSP);
            map.put("SF_WinSP", SF_WinSP);
            map.put("RF_LoseSP", RF_LoseSP);
            map.put("RF", RF);
            map.put("RF_WinSP", RF_WinSP);

            map.put("GuestWin1_5", GuestWin1_5);
            map.put("GuestWin6_10", GuestWin6_10);
            map.put("GuestWin11_15", GuestWin11_15);
            map.put("GuestWin16_20", GuestWin16_20);
            map.put("GuestWin21_25", GuestWin21_25);
            map.put("GuestWin26", GuestWin26);
            map.put("HomeWin1_5", HomeWin1_5);
            map.put("HomeWin6_10", HomeWin6_10);
            map.put("HomeWin11_15", HomeWin11_15);
            map.put("HomeWin16_20", HomeWin16_20);
            map.put("HomeWin21_25", HomeWin21_25);
            map.put("HomeWin26", HomeWin26);

            map.put("DF", DF);
            map.put("XF", XF);
            map.put("YSZF", YSZF);

            listmapJCLQ.add(map);
        }
        System.out.println("---------list--------->" + listmapJCLQ);
        return listmapJCLQ;
    }
}
