package com.fleaphpnet;

/**
 * POST方法向服务器发送数据 请求数据
 */

import com.fleaphpnet.caiyuntong.BuildConfig;
import com.fleaphpnet.caiyuntong.component.StringUtils;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class XinTiPostQuery {
    // 请求地址
    private static String url = XinTiRequestcode.Request_internet;

    // 用于一个参数的查询
    public static JSONObject UserRegister(List<NameValuePair> nameValuePair) {

        //getCaller();
        /** 建立HTTP Post联机 请求数据 */
        HttpPost httpRequest = new HttpPost(url);
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, 10000);//请求超时10秒
        HttpConnectionParams.setSoTimeout(httpParams, 10000);//请求数据超时10秒

        httpRequest.setParams(httpParams);
        try {
            //发送数据到服务器
            httpRequest.setEntity(new UrlEncodedFormEntity(nameValuePair, HTTP.UTF_8));//设置编码，防止中午乱码
            System.out.println("Get参数:-----> " + httpParams.toString());
            System.out.println("Post参数:-----> " + nameValuePair.toString());
            /** 取得HTTP response 服务器回复数据 */
            HttpResponse httpResponse = new DefaultHttpClient().execute(httpRequest);
            /** 若状态码为200 ok */
            System.out.println("状态码:-----> " + httpResponse.getStatusLine().toString());
            int code = httpResponse.getStatusLine().getStatusCode();
            if (code == 200) {
                /* 取出响应字符串 */
                //String htmlCharset = "GBK";
                //String strResult = EntityUtils.toString(httpResponse.getEntity(), htmlCharset);
                //logToFile
                String strResult = EntityUtils.toString(httpResponse.getEntity());
                if (BuildConfig.DEBUG) System.out.println("直接返回:-----> " + strResult);
                String hexString = StringUtils.toHexString(strResult);
                if (BuildConfig.DEBUG) System.out.println("直接返回Hex:-----> " + StringUtils.toHexString(strResult));
                // System.err.println("返回-------------> " + strResult);
                JSONObject jsonobj = new JSONObject(strResult);
                return jsonobj;
            } else {
                System.out.println("Error Response:-----> " + httpResponse.getStatusLine().toString());
            }
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (JSONException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCaller() {
        int i;
        StackTraceElement stack[] = (new Throwable()).getStackTrace();
        for (i = 0; i < stack.length; i++) {
            StackTraceElement ste = stack[i];
            System.out.println(ste.getClassName() + "." + ste.getMethodName() + "(...);");
            System.out.println(i + "--" + ste.getMethodName());
            System.out.println(i + "--" + ste.getFileName());
            System.out.println(i + "--" + ste.getLineNumber());
        }
        return "";
    }
}
