package com.fleaphpnet.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager.LayoutParams;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.fleaphpnet.Dao.CutDateQuery;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.dialog.ZJQDialog;
import com.fleaphpnet.entity.XinTiBJDCEntity;
import com.fleaphpnet.entity.XinTiSPFDentity;
import com.fleaphpnet.holder.BJDC_HHholderView;

import java.util.ArrayList;
import java.util.List;

public class bjdcBflistAdapter extends BaseAdapter {
    private Context mconn;
    private List<XinTiBJDCEntity> zjqlisttest;
    //设置胆
    private List<Drawable> listdd, listcontentd;
    //content
    private List<Boolean> listcontent;
    //胆
    private List<Boolean> listd;
    //判断胆是否可选
    private List<Boolean> isdaneable;

    public List<Boolean> getDan() {
        return this.listd;
    }

    public bjdcBflistAdapter(Context mconn, List<XinTiBJDCEntity> zjqlisttest) {
        super();
        this.mconn = mconn;
        this.zjqlisttest = zjqlisttest;
        listcontent = new ArrayList<Boolean>(zjqlisttest.size());
        listd = new ArrayList<Boolean>(zjqlisttest.size());
        isdaneable = new ArrayList<Boolean>(zjqlisttest.size());
        listdd = new ArrayList<Drawable>(zjqlisttest.size());
        listcontentd = new ArrayList<Drawable>(zjqlisttest.size());

        for (int i = 0; i < zjqlisttest.size(); i++) {
            listcontent.add(false);
            listd.add(false);
            isdaneable.add(false);
            listdd.add(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
            listcontentd.add(mconn.getResources().getDrawable(R.drawable.dialog_bg_sliver));

            //初始化用户选择数据
            Teamarrs.add("");
            TeamShowarrs.add("");
        }
    }

    public int getCount() {
        // TODO Auto-generated method stub
        return zjqlisttest.size();
    }

    public Object getItem(int position) {
        // TODO Auto-generated method stub
        return zjqlisttest.get(position);
    }

    public long getItemId(int position) {
        // TODO Auto-generated method stub
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        LinearLayout mli1, mli2, mli3;
        final ViewHolder holder;

        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(mconn).inflate(R.layout.update_ball_layout_dialog_item_qq, null);
            holder.mbtncontent = (Button) convertView.findViewById(R.id.userchoice_content);
            holder.mlidan = (LinearLayout) convertView.findViewById(R.id.mliqq4);

            holder.mtxtteamhome = (TextView) convertView.findViewById(R.id.all_hometeamid);
            holder.mtxtteamguest = (TextView) convertView.findViewById(R.id.all_guestteamid);
            holder.mtxtteamstoptime = (TextView) convertView.findViewById(R.id.all_timestopid);
            holder.mtxtmatch = (TextView) convertView.findViewById(R.id.all_matchnameid);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        holder.mtxtmatch.setText(zjqlisttest.get(position).getMatchName());
        holder.mtxtteamhome.setText(zjqlisttest.get(position).getHomeTeamName());
        holder.mtxtteamguest.setText(zjqlisttest.get(position).getGuestTeamName());
        holder.mtxtteamstoptime.setText(CutDateQuery.CutDateTimeShow(zjqlisttest.get(position).getLocalStopTime()) + "截止");


        datestr = zjqlisttest.get(0).getLocalStopTime();
        holder.mlidan.setId(position);
        holder.mbtncontent.setId(position);
        holder.mbtncontent.setBackgroundDrawable(listcontentd.get(position));
        holder.mbtncontent.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                TeamDialog(holder.mbtncontent, holder.mlidan, zjqlisttest.get(position));

            }
        });

        holder.mlidan.setBackgroundDrawable(listdd.get(position));
        holder.mlidan.setEnabled(isdaneable.get(position));
        holder.mlidan.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                if (listd.get(position)) {
                    listd.set(v.getId(), false);
                    listdd.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    holder.mlidan.setBackgroundDrawable(listdd.get(position));
                } else {
                    listdd.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_red_trans));
                    holder.mlidan.setBackgroundDrawable(listdd.get(position));
                    listd.set(v.getId(), true);
                }
            }
        });
        return convertView;
    }

    class ViewHolder {
        TextView mtxtteamhome, mtxtteamguest, mtxtteamstoptime, mtxtmatch;
        Button mbtncontent;
        LinearLayout mlidan;
    }

    private Boolean[] usercheckboolean;

    public void TeamDialog(final Button btncontent, final LinearLayout mlidan, final XinTiBJDCEntity zjqquery) {
        final BJDC_HHholderView ZJQVIEW = new BJDC_HHholderView();
        final ZJQDialog dialog2 = new ZJQDialog(mconn, R.style.Theme_dialog,
                R.layout.update_ball_dialog_item_bjdc_bf, LayoutParams.FILL_PARENT,
                LayoutParams.FILL_PARENT);
        usercheckboolean = new Boolean[25];
        str = "";
/*		for (int i = 0; i < usercheckboolean.length; i++) {
            usercheckboolean[i]=false;
		}*/
        ZJQVIEW.mlibf_1b0 = (LinearLayout) dialog2.findViewById(R.id.mlibf_1b0);
        ZJQVIEW.mlibf_2b0 = (LinearLayout) dialog2.findViewById(R.id.mlibf_2b0);
        ZJQVIEW.mlibf_2b1 = (LinearLayout) dialog2.findViewById(R.id.mlibf_2b1);
        ZJQVIEW.mlibf_3b0 = (LinearLayout) dialog2.findViewById(R.id.mlibf_3b0);
        ZJQVIEW.mlibf_3b1 = (LinearLayout) dialog2.findViewById(R.id.mlibf_3b1);
        ZJQVIEW.mlibf_3b2 = (LinearLayout) dialog2.findViewById(R.id.mlibf_3b2);
        ZJQVIEW.mlibf_4b0 = (LinearLayout) dialog2.findViewById(R.id.mlibf_4b0);
        ZJQVIEW.mlibf_4b1 = (LinearLayout) dialog2.findViewById(R.id.mlibf_4b1);
        ZJQVIEW.mlibf_4b2 = (LinearLayout) dialog2.findViewById(R.id.mlibf_4b2);
        ZJQVIEW.mlibf_sqt = (LinearLayout) dialog2.findViewById(R.id.mlibf_sqt);


        ZJQVIEW.mlibf_0b0 = (LinearLayout) dialog2.findViewById(R.id.mlibf_0b0);
        ZJQVIEW.mlibf_1b1 = (LinearLayout) dialog2.findViewById(R.id.mlibf_1b1);
        ZJQVIEW.mlibf_2b2 = (LinearLayout) dialog2.findViewById(R.id.mlibf_2b2);
        ZJQVIEW.mlibf_3b3 = (LinearLayout) dialog2.findViewById(R.id.mlibf_3b3);
        ZJQVIEW.mlibf_pqt = (LinearLayout) dialog2.findViewById(R.id.mlibf_pqt);

        ZJQVIEW.mlibf_0b1 = (LinearLayout) dialog2.findViewById(R.id.mlibf_0b1);
        ZJQVIEW.mlibf_0b2 = (LinearLayout) dialog2.findViewById(R.id.mlibf_0b2);
        ZJQVIEW.mlibf_0b3 = (LinearLayout) dialog2.findViewById(R.id.mlibf_0b3);
        ZJQVIEW.mlibf_0b4 = (LinearLayout) dialog2.findViewById(R.id.mlibf_0b4);
        ZJQVIEW.mlibf_1b2 = (LinearLayout) dialog2.findViewById(R.id.mlibf_1b2);
        ZJQVIEW.mlibf_1b3 = (LinearLayout) dialog2.findViewById(R.id.mlibf_1b3);
        ZJQVIEW.mlibf_1b4 = (LinearLayout) dialog2.findViewById(R.id.mlibf_1b4);
        ZJQVIEW.mlibf_2b3 = (LinearLayout) dialog2.findViewById(R.id.mlibf_2b3);
        ZJQVIEW.mlibf_2b4 = (LinearLayout) dialog2.findViewById(R.id.mlibf_2b4);
        ZJQVIEW.mlibf_fqt = (LinearLayout) dialog2.findViewById(R.id.mlibf_fqt);

        //内容
        ZJQVIEW.mlibf_1b0_txt = (TextView) dialog2.findViewById(R.id.mtextbf_1b0);
        ZJQVIEW.mlibf_2b0_txt = (TextView) dialog2.findViewById(R.id.mtextbf_2b0);
        ZJQVIEW.mlibf_2b1_txt = (TextView) dialog2.findViewById(R.id.mtextbf_2b1);
        ZJQVIEW.mlibf_3b0_txt = (TextView) dialog2.findViewById(R.id.mtextbf_3b0);
        ZJQVIEW.mlibf_3b1_txt = (TextView) dialog2.findViewById(R.id.mtextbf_3b1);
        ZJQVIEW.mlibf_3b2_txt = (TextView) dialog2.findViewById(R.id.mtextbf_3b2);
        ZJQVIEW.mlibf_4b0_txt = (TextView) dialog2.findViewById(R.id.mtextbf_4b0);
        ZJQVIEW.mlibf_4b1_txt = (TextView) dialog2.findViewById(R.id.mtextbf_4b1);
        ZJQVIEW.mlibf_4b2_txt = (TextView) dialog2.findViewById(R.id.mtextbf_4b2);
        ZJQVIEW.mlibf_sqt_txt = (TextView) dialog2.findViewById(R.id.mtextbf_sqt);


        ZJQVIEW.mlibf_0b0_txt = (TextView) dialog2.findViewById(R.id.mtextbf_0b0);
        ZJQVIEW.mlibf_1b1_txt = (TextView) dialog2.findViewById(R.id.mtextbf_1b1);
        ZJQVIEW.mlibf_2b2_txt = (TextView) dialog2.findViewById(R.id.mtextbf_2b2);
        ZJQVIEW.mlibf_3b3_txt = (TextView) dialog2.findViewById(R.id.mtextbf_3b3);
        ZJQVIEW.mlibf_pqt_txt = (TextView) dialog2.findViewById(R.id.mtextbf_pqt);

        ZJQVIEW.mlibf_0b1_txt = (TextView) dialog2.findViewById(R.id.mtextbf_0b1);
        ZJQVIEW.mlibf_0b2_txt = (TextView) dialog2.findViewById(R.id.mtextbf_0b2);
        ZJQVIEW.mlibf_0b3_txt = (TextView) dialog2.findViewById(R.id.mtextbf_0b3);
        ZJQVIEW.mlibf_0b4_txt = (TextView) dialog2.findViewById(R.id.mtextbf_0b4);
        ZJQVIEW.mlibf_1b2_txt = (TextView) dialog2.findViewById(R.id.mtextbf_1b2);
        ZJQVIEW.mlibf_1b3_txt = (TextView) dialog2.findViewById(R.id.mtextbf_1b3);
        ZJQVIEW.mlibf_1b4_txt = (TextView) dialog2.findViewById(R.id.mtextbf_1b4);
        ZJQVIEW.mlibf_2b3_txt = (TextView) dialog2.findViewById(R.id.mtextbf_2b3);
        ZJQVIEW.mlibf_2b4_txt = (TextView) dialog2.findViewById(R.id.mtextbf_2b4);
        ZJQVIEW.mlibf_fqt_txt = (TextView) dialog2.findViewById(R.id.mtextbf_fqt);

        //sp值
        ZJQVIEW.mlibf_1b0_sp = (TextView) dialog2.findViewById(R.id.mtextbf_1b0_sp);
        ZJQVIEW.mlibf_2b0_sp = (TextView) dialog2.findViewById(R.id.mtextbf_2b0_sp);
        ZJQVIEW.mlibf_2b1_sp = (TextView) dialog2.findViewById(R.id.mtextbf_2b1_sp);
        ZJQVIEW.mlibf_3b0_sp = (TextView) dialog2.findViewById(R.id.mtextbf_3b0_sp);
        ZJQVIEW.mlibf_3b1_sp = (TextView) dialog2.findViewById(R.id.mtextbf_3b1_sp);
        ZJQVIEW.mlibf_3b2_sp = (TextView) dialog2.findViewById(R.id.mtextbf_3b2_sp);
        ZJQVIEW.mlibf_4b0_sp = (TextView) dialog2.findViewById(R.id.mtextbf_4b0_sp);
        ZJQVIEW.mlibf_4b1_sp = (TextView) dialog2.findViewById(R.id.mtextbf_4b1_sp);
        ZJQVIEW.mlibf_4b2_sp = (TextView) dialog2.findViewById(R.id.mtextbf_4b2_sp);
        ZJQVIEW.mlibf_sqt_sp = (TextView) dialog2.findViewById(R.id.mtextbf_sqt_sp);


        ZJQVIEW.mlibf_0b0_sp = (TextView) dialog2.findViewById(R.id.mtextbf_0b0_sp);
        ZJQVIEW.mlibf_1b1_sp = (TextView) dialog2.findViewById(R.id.mtextbf_1b1_sp);
        ZJQVIEW.mlibf_2b2_sp = (TextView) dialog2.findViewById(R.id.mtextbf_2b2_sp);
        ZJQVIEW.mlibf_3b3_sp = (TextView) dialog2.findViewById(R.id.mtextbf_3b3_sp);
        ZJQVIEW.mlibf_pqt_sp = (TextView) dialog2.findViewById(R.id.mtextbf_pqt_sp);

        ZJQVIEW.mlibf_0b1_sp = (TextView) dialog2.findViewById(R.id.mtextbf_0b1_sp);
        ZJQVIEW.mlibf_0b2_sp = (TextView) dialog2.findViewById(R.id.mtextbf_0b2_sp);
        ZJQVIEW.mlibf_0b3_sp = (TextView) dialog2.findViewById(R.id.mtextbf_0b3_sp);
        ZJQVIEW.mlibf_0b4_sp = (TextView) dialog2.findViewById(R.id.mtextbf_0b4_sp);
        ZJQVIEW.mlibf_1b2_sp = (TextView) dialog2.findViewById(R.id.mtextbf_1b2_sp);
        ZJQVIEW.mlibf_1b3_sp = (TextView) dialog2.findViewById(R.id.mtextbf_1b3_sp);
        ZJQVIEW.mlibf_1b4_sp = (TextView) dialog2.findViewById(R.id.mtextbf_1b4_sp);
        ZJQVIEW.mlibf_2b3_sp = (TextView) dialog2.findViewById(R.id.mtextbf_2b3_sp);
        ZJQVIEW.mlibf_2b4_sp = (TextView) dialog2.findViewById(R.id.mtextbf_2b4_sp);
        ZJQVIEW.mlibf_fqt_sp = (TextView) dialog2.findViewById(R.id.mtextbf_fqt_sp);


        ZJQVIEW.buttonok = (Button) dialog2.findViewById(R.id.dialog_button_ok);
        ZJQVIEW.buttoncancel = (Button) dialog2.findViewById(R.id.dialog_button_cancel);
        usercheckboolean[0] = zjqquery.isBjdc_bf_1b0();
        usercheckboolean[1] = zjqquery.isBjdc_bf_2b0();
        usercheckboolean[2] = zjqquery.isBjdc_bf_2b1();
        usercheckboolean[3] = zjqquery.isBjdc_bf_3b0();
        usercheckboolean[4] = zjqquery.isBjdc_bf_3b1();
        usercheckboolean[5] = zjqquery.isBjdc_bf_3b2();
        usercheckboolean[6] = zjqquery.isBjdc_bf_4b0();
        usercheckboolean[7] = zjqquery.isBjdc_bf_4b1();
        usercheckboolean[8] = zjqquery.isBjdc_bf_4b2();
        usercheckboolean[9] = zjqquery.isBjdc_bf_sqt();

        usercheckboolean[10] = zjqquery.isBjdc_bf_0b0();
        usercheckboolean[11] = zjqquery.isBjdc_bf_1b1();
        usercheckboolean[12] = zjqquery.isBjdc_bf_2b2();
        usercheckboolean[13] = zjqquery.isBjdc_bf_3b3();
        usercheckboolean[14] = zjqquery.isBjdc_bf_pqt();


        usercheckboolean[15] = zjqquery.isBjdc_bf_0b1();
        usercheckboolean[16] = zjqquery.isBjdc_bf_0b2();
        usercheckboolean[17] = zjqquery.isBjdc_bf_0b3();
        usercheckboolean[18] = zjqquery.isBjdc_bf_0b4();

        usercheckboolean[19] = zjqquery.isBjdc_bf_1b2();
        usercheckboolean[20] = zjqquery.isBjdc_bf_1b3();
        usercheckboolean[21] = zjqquery.isBjdc_bf_1b4();
        usercheckboolean[22] = zjqquery.isBjdc_bf_2b3();
        usercheckboolean[23] = zjqquery.isBjdc_bf_2b4();
        usercheckboolean[24] = zjqquery.isBjdc_bf_fqt();

        //比分
        btnPress(zjqquery.isBjdc_bf_1b0(), ZJQVIEW.mlibf_1b0, ZJQVIEW.mlibf_1b0_txt, ZJQVIEW.mlibf_1b0_sp);
        btnPress(zjqquery.isBjdc_bf_2b0(), ZJQVIEW.mlibf_2b0, ZJQVIEW.mlibf_2b0_txt, ZJQVIEW.mlibf_2b0_sp);
        btnPress(zjqquery.isBjdc_bf_2b1(), ZJQVIEW.mlibf_2b1, ZJQVIEW.mlibf_2b1_txt, ZJQVIEW.mlibf_2b1_sp);
        btnPress(zjqquery.isBjdc_bf_3b0(), ZJQVIEW.mlibf_3b0, ZJQVIEW.mlibf_3b0_txt, ZJQVIEW.mlibf_3b0_sp);
        btnPress(zjqquery.isBjdc_bf_3b1(), ZJQVIEW.mlibf_3b1, ZJQVIEW.mlibf_3b1_txt, ZJQVIEW.mlibf_3b1_sp);
        btnPress(zjqquery.isBjdc_bf_3b2(), ZJQVIEW.mlibf_3b2, ZJQVIEW.mlibf_3b2_txt, ZJQVIEW.mlibf_3b2_sp);
        btnPress(zjqquery.isBjdc_bf_4b0(), ZJQVIEW.mlibf_4b0, ZJQVIEW.mlibf_4b0_txt, ZJQVIEW.mlibf_4b0_sp);
        btnPress(zjqquery.isBjdc_bf_4b1(), ZJQVIEW.mlibf_4b1, ZJQVIEW.mlibf_4b1_txt, ZJQVIEW.mlibf_4b1_sp);
        btnPress(zjqquery.isBjdc_bf_4b2(), ZJQVIEW.mlibf_4b2, ZJQVIEW.mlibf_4b2_txt, ZJQVIEW.mlibf_4b2_sp);
        btnPress(zjqquery.isBjdc_bf_sqt(), ZJQVIEW.mlibf_sqt, ZJQVIEW.mlibf_sqt_txt, ZJQVIEW.mlibf_sqt_sp);

        ZJQVIEW.mlibf_1b0_sp.setText("" + zjqquery.getS_10());
        ZJQVIEW.mlibf_2b0_sp.setText("" + zjqquery.getS_20());
        ZJQVIEW.mlibf_2b1_sp.setText("" + zjqquery.getS_21());
        ZJQVIEW.mlibf_3b0_sp.setText("" + zjqquery.getS_30());
        ZJQVIEW.mlibf_3b1_sp.setText("" + zjqquery.getS_31());
        ZJQVIEW.mlibf_3b2_sp.setText("" + zjqquery.getS_32());
        ZJQVIEW.mlibf_4b0_sp.setText("" + zjqquery.getS_40());
        ZJQVIEW.mlibf_4b1_sp.setText("" + zjqquery.getS_41());
        ZJQVIEW.mlibf_4b2_sp.setText("" + zjqquery.getS_42());
        ZJQVIEW.mlibf_sqt_sp.setText("" + zjqquery.getS_QT());


        btnPress(zjqquery.isBjdc_bf_0b0(), ZJQVIEW.mlibf_0b0, ZJQVIEW.mlibf_0b0_txt, ZJQVIEW.mlibf_0b0_sp);
        btnPress(zjqquery.isBjdc_bf_1b1(), ZJQVIEW.mlibf_1b1, ZJQVIEW.mlibf_1b1_txt, ZJQVIEW.mlibf_1b1_sp);
        btnPress(zjqquery.isBjdc_bf_2b2(), ZJQVIEW.mlibf_2b2, ZJQVIEW.mlibf_2b2_txt, ZJQVIEW.mlibf_2b2_sp);
        btnPress(zjqquery.isBjdc_bf_3b3(), ZJQVIEW.mlibf_3b3, ZJQVIEW.mlibf_3b3_txt, ZJQVIEW.mlibf_3b3_sp);
        btnPress(zjqquery.isBjdc_bf_pqt(), ZJQVIEW.mlibf_pqt, ZJQVIEW.mlibf_pqt_txt, ZJQVIEW.mlibf_pqt_sp);
        ZJQVIEW.mlibf_0b0_sp.setText("" + zjqquery.getP_00());
        ZJQVIEW.mlibf_1b1_sp.setText("" + zjqquery.getP_11());
        ZJQVIEW.mlibf_2b2_sp.setText("" + zjqquery.getP_22());
        ZJQVIEW.mlibf_3b3_sp.setText("" + zjqquery.getP_33());
        ZJQVIEW.mlibf_pqt_sp.setText("" + zjqquery.getP_QT());

        btnPress(zjqquery.isBjdc_bf_0b1(), ZJQVIEW.mlibf_0b1, ZJQVIEW.mlibf_0b1_txt, ZJQVIEW.mlibf_0b1_sp);
        btnPress(zjqquery.isBjdc_bf_0b2(), ZJQVIEW.mlibf_0b2, ZJQVIEW.mlibf_0b2_txt, ZJQVIEW.mlibf_0b2_sp);
        btnPress(zjqquery.isBjdc_bf_0b3(), ZJQVIEW.mlibf_0b3, ZJQVIEW.mlibf_0b3_txt, ZJQVIEW.mlibf_0b3_sp);
        btnPress(zjqquery.isBjdc_bf_0b4(), ZJQVIEW.mlibf_0b4, ZJQVIEW.mlibf_0b4_txt, ZJQVIEW.mlibf_0b4_sp);
        btnPress(zjqquery.isBjdc_bf_1b2(), ZJQVIEW.mlibf_1b2, ZJQVIEW.mlibf_1b2_txt, ZJQVIEW.mlibf_1b2_sp);
        btnPress(zjqquery.isBjdc_bf_1b3(), ZJQVIEW.mlibf_1b3, ZJQVIEW.mlibf_1b3_txt, ZJQVIEW.mlibf_1b3_sp);
        btnPress(zjqquery.isBjdc_bf_1b4(), ZJQVIEW.mlibf_1b4, ZJQVIEW.mlibf_1b4_txt, ZJQVIEW.mlibf_1b4_sp);
        btnPress(zjqquery.isBjdc_bf_2b3(), ZJQVIEW.mlibf_2b3, ZJQVIEW.mlibf_2b3_txt, ZJQVIEW.mlibf_2b3_sp);
        btnPress(zjqquery.isBjdc_bf_2b4(), ZJQVIEW.mlibf_2b4, ZJQVIEW.mlibf_2b4_txt, ZJQVIEW.mlibf_2b4_sp);
        btnPress(zjqquery.isBjdc_bf_fqt(), ZJQVIEW.mlibf_fqt, ZJQVIEW.mlibf_fqt_txt, ZJQVIEW.mlibf_fqt_sp);

        ZJQVIEW.mlibf_0b1_sp.setText("" + zjqquery.getF_01());
        ZJQVIEW.mlibf_0b2_sp.setText("" + zjqquery.getF_02());
        ZJQVIEW.mlibf_0b3_sp.setText("" + zjqquery.getF_03());
        ZJQVIEW.mlibf_0b4_sp.setText("" + zjqquery.getF_04());
        ZJQVIEW.mlibf_1b2_sp.setText("" + zjqquery.getF_12());
        ZJQVIEW.mlibf_1b3_sp.setText("" + zjqquery.getF_13());
        ZJQVIEW.mlibf_1b4_sp.setText("" + zjqquery.getF_14());
        ZJQVIEW.mlibf_2b3_sp.setText("" + zjqquery.getF_23());
        ZJQVIEW.mlibf_2b4_sp.setText("" + zjqquery.getF_24());
        ZJQVIEW.mlibf_fqt_sp.setText("" + zjqquery.getF_QT());


        ZJQVIEW.mlibf_1b0.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[0]) {

                    usercheckboolean[0] = false;
                } else {
                    usercheckboolean[0] = true;
                }
                btnPress(usercheckboolean[0], ZJQVIEW.mlibf_1b0, ZJQVIEW.mlibf_1b0_txt, ZJQVIEW.mlibf_1b0_sp);
            }
        });
        ZJQVIEW.mlibf_2b0.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[1]) {

                    usercheckboolean[1] = false;
                } else {

                    usercheckboolean[1] = true;
                }
                btnPress(usercheckboolean[1], ZJQVIEW.mlibf_2b0, ZJQVIEW.mlibf_2b0_txt, ZJQVIEW.mlibf_2b0_sp);
            }
        });
        ZJQVIEW.mlibf_2b1.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[2]) {

                    usercheckboolean[2] = false;
                } else {

                    usercheckboolean[2] = true;
                }
                btnPress(usercheckboolean[2], ZJQVIEW.mlibf_2b1, ZJQVIEW.mlibf_2b1_txt, ZJQVIEW.mlibf_2b1_sp);
            }
        });


        ZJQVIEW.mlibf_3b0.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[3]) {

                    usercheckboolean[3] = false;
                } else {

                    usercheckboolean[3] = true;
                }
                btnPress(usercheckboolean[3], ZJQVIEW.mlibf_3b0, ZJQVIEW.mlibf_3b0_txt, ZJQVIEW.mlibf_3b0_sp);
            }
        });
        ZJQVIEW.mlibf_3b1.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[4]) {


                    usercheckboolean[4] = false;
                } else {

                    usercheckboolean[4] = true;
                }
                btnPress(usercheckboolean[4], ZJQVIEW.mlibf_3b1, ZJQVIEW.mlibf_3b1_txt, ZJQVIEW.mlibf_3b1_sp);
            }
        });
        ZJQVIEW.mlibf_3b2.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[5]) {


                    usercheckboolean[5] = false;
                } else {

                    usercheckboolean[5] = true;
                }
                btnPress(usercheckboolean[5], ZJQVIEW.mlibf_3b2, ZJQVIEW.mlibf_3b2_txt, ZJQVIEW.mlibf_3b2_sp);
            }
        });

        ZJQVIEW.mlibf_4b0.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[6]) {

                    usercheckboolean[6] = false;
                } else {

                    usercheckboolean[6] = true;
                }
                btnPress(usercheckboolean[6], ZJQVIEW.mlibf_4b0, ZJQVIEW.mlibf_4b0_txt, ZJQVIEW.mlibf_4b0_sp);
            }
        });
        ZJQVIEW.mlibf_4b1.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[7]) {


                    usercheckboolean[7] = false;
                } else {

                    usercheckboolean[7] = true;
                }
                btnPress(usercheckboolean[7], ZJQVIEW.mlibf_4b1, ZJQVIEW.mlibf_4b1_txt, ZJQVIEW.mlibf_4b1_sp);
            }
        });
        ZJQVIEW.mlibf_4b2.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[8]) {


                    usercheckboolean[8] = false;
                } else {

                    usercheckboolean[8] = true;
                }
                btnPress(usercheckboolean[8], ZJQVIEW.mlibf_4b2, ZJQVIEW.mlibf_4b2_txt, ZJQVIEW.mlibf_4b2_sp);
            }
        });


        ZJQVIEW.mlibf_sqt.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[9]) {


                    usercheckboolean[9] = false;
                } else {

                    usercheckboolean[9] = true;
                }
                btnPress(usercheckboolean[9], ZJQVIEW.mlibf_sqt, ZJQVIEW.mlibf_sqt_txt, ZJQVIEW.mlibf_sqt_sp);
            }
        });

        ZJQVIEW.mlibf_0b0.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[10]) {


                    usercheckboolean[10] = false;
                } else {

                    usercheckboolean[10] = true;
                }
                btnPress(usercheckboolean[10], ZJQVIEW.mlibf_0b0, ZJQVIEW.mlibf_0b0_txt, ZJQVIEW.mlibf_0b0_sp);
            }
        });

        ZJQVIEW.mlibf_1b1.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[11]) {


                    usercheckboolean[11] = false;
                } else {

                    usercheckboolean[11] = true;
                }
                btnPress(usercheckboolean[11], ZJQVIEW.mlibf_1b1, ZJQVIEW.mlibf_1b1_txt, ZJQVIEW.mlibf_1b1_sp);
            }
        });
        ZJQVIEW.mlibf_2b2.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[12]) {


                    usercheckboolean[12] = false;
                } else {

                    usercheckboolean[12] = true;
                }
                btnPress(usercheckboolean[12], ZJQVIEW.mlibf_2b2, ZJQVIEW.mlibf_2b2_txt, ZJQVIEW.mlibf_2b2_sp);
            }
        });

        ZJQVIEW.mlibf_3b3.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[13]) {


                    usercheckboolean[13] = false;
                } else {

                    usercheckboolean[13] = true;
                }
                btnPress(usercheckboolean[13], ZJQVIEW.mlibf_3b3, ZJQVIEW.mlibf_3b3_txt, ZJQVIEW.mlibf_3b3_sp);
            }
        });
        ZJQVIEW.mlibf_pqt.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[14]) {


                    usercheckboolean[14] = false;
                } else {

                    usercheckboolean[14] = true;
                }
                btnPress(usercheckboolean[14], ZJQVIEW.mlibf_pqt, ZJQVIEW.mlibf_pqt_txt, ZJQVIEW.mlibf_pqt_sp);
            }
        });
        ZJQVIEW.mlibf_0b1.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[15]) {


                    usercheckboolean[15] = false;
                } else {

                    usercheckboolean[15] = true;
                }
                btnPress(usercheckboolean[15], ZJQVIEW.mlibf_0b1, ZJQVIEW.mlibf_0b1_txt, ZJQVIEW.mlibf_0b1_sp);
            }
        });

        ZJQVIEW.mlibf_0b2.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[16]) {


                    usercheckboolean[16] = false;
                } else {

                    usercheckboolean[16] = true;
                }
                btnPress(usercheckboolean[16], ZJQVIEW.mlibf_0b2, ZJQVIEW.mlibf_0b2_txt, ZJQVIEW.mlibf_0b2_sp);
            }
        });
        ZJQVIEW.mlibf_0b3.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[17]) {


                    usercheckboolean[17] = false;
                } else {

                    usercheckboolean[17] = true;
                }
                btnPress(usercheckboolean[17], ZJQVIEW.mlibf_0b3, ZJQVIEW.mlibf_0b3_txt, ZJQVIEW.mlibf_0b3_sp);
            }
        });
        ZJQVIEW.mlibf_0b4.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[18]) {


                    usercheckboolean[18] = false;
                } else {

                    usercheckboolean[18] = true;
                }
                btnPress(usercheckboolean[18], ZJQVIEW.mlibf_0b4, ZJQVIEW.mlibf_0b4_txt, ZJQVIEW.mlibf_0b4_sp);
            }
        });


        ZJQVIEW.mlibf_1b2.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[19]) {


                    usercheckboolean[19] = false;
                } else {

                    usercheckboolean[19] = true;
                }
                btnPress(usercheckboolean[19], ZJQVIEW.mlibf_1b2, ZJQVIEW.mlibf_1b2_txt, ZJQVIEW.mlibf_1b2_sp);
            }
        });

        ZJQVIEW.mlibf_1b3.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[20]) {


                    usercheckboolean[20] = false;
                } else {

                    usercheckboolean[20] = true;
                }
                btnPress(usercheckboolean[20], ZJQVIEW.mlibf_1b3, ZJQVIEW.mlibf_1b3_txt, ZJQVIEW.mlibf_1b3_sp);
            }
        });

        ZJQVIEW.mlibf_1b4.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[21]) {


                    usercheckboolean[21] = false;
                } else {

                    usercheckboolean[21] = true;
                }
                btnPress(usercheckboolean[21], ZJQVIEW.mlibf_1b4, ZJQVIEW.mlibf_1b4_txt, ZJQVIEW.mlibf_1b4_sp);
            }
        });


        ZJQVIEW.mlibf_2b3.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[22]) {


                    usercheckboolean[22] = false;
                } else {

                    usercheckboolean[22] = true;
                }
                btnPress(usercheckboolean[22], ZJQVIEW.mlibf_2b3, ZJQVIEW.mlibf_2b3_txt, ZJQVIEW.mlibf_2b3_sp);
            }
        });
        ZJQVIEW.mlibf_2b4.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[23]) {


                    usercheckboolean[23] = false;
                } else {

                    usercheckboolean[23] = true;
                }
                btnPress(usercheckboolean[23], ZJQVIEW.mlibf_2b4, ZJQVIEW.mlibf_2b4_txt, ZJQVIEW.mlibf_2b4_sp);
            }
        });


        ZJQVIEW.mlibf_fqt.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[24]) {


                    usercheckboolean[24] = false;
                } else {

                    usercheckboolean[24] = true;
                }
                btnPress(usercheckboolean[24], ZJQVIEW.mlibf_fqt, ZJQVIEW.mlibf_fqt_txt, ZJQVIEW.mlibf_fqt_sp);
            }
        });
        ZJQVIEW.buttonok.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                boolean flag = isTure2(usercheckboolean);
                SubmitUserchioce(zjqquery, usercheckboolean);
                if (flag) {
                    showContent(zjqquery);
                    isdaneable.set(mlidan.getId(), true);
                    mlidan.setEnabled(true);
                    listcontent.set(btncontent.getId(), true);
                    listcontentd.set(btncontent.getId(), mconn.getResources().getDrawable(R.drawable.dialog_item_red));
                    btncontent.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_item_red));
                    btncontent.setTextColor(mconn.getResources().getColor(R.color.white));

                    btncontent.setText(strshow.substring(1));
                    Teamarrs.set(btncontent.getId(), str);
                    TeamShowarrs.set(btncontent.getId(), strshow);
                } else {
                    isdaneable.set(mlidan.getId(), false);
                    mlidan.setEnabled(false);
                    listdd.set(mlidan.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    mlidan.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    listcontentd.set(btncontent.getId(), mconn.getResources().getDrawable(R.drawable.dialog_bg_sliver));
                    btncontent.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_bg_sliver));
                    btncontent.setTextColor(mconn.getResources().getColor(R.color.silver));
                    btncontent.setText("选择投注内容");
                    Teamarrs.set(btncontent.getId(), "");
                    TeamShowarrs.set(btncontent.getId(), "");
                }
                dialog2.dismiss();
            }
        });
        ZJQVIEW.buttoncancel.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                dialog2.dismiss();
            }
        });
        dialog2.show();// 显示Dialog
    }

    //自定义按钮
    public void btnPress(Boolean isflag, LinearLayout mliner, TextView texttitle, TextView textsp) {
        if (isflag) {
            texttitle.setTextColor(mconn.getResources().getColor(R.color.white));
            textsp.setTextColor(mconn.getResources().getColor(R.color.white));
            mliner.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_top_left_bottom_right_red));
        } else {
            texttitle.setTextColor(mconn.getResources().getColor(R.color.black));
            mliner.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_top_left_bottom));
            textsp.setTextColor(mconn.getResources().getColor(R.color.silver));
        }

    }

    //判断用户是否选择数据
    public Boolean isTure(XinTiBJDCEntity zjqquery) {
        if (zjqquery.isBjdc_bf_1b0() || zjqquery.isBjdc_bf_2b0()
                || zjqquery.isBjdc_bf_2b1() || zjqquery.isBjdc_bf_3b0()
                || zjqquery.isBjdc_bf_3b1() || zjqquery.isBjdc_bf_3b2()

                || zjqquery.isBjdc_bf_4b0() || zjqquery.isBjdc_bf_4b1()
                || zjqquery.isBjdc_bf_4b2()
                || zjqquery.isBjdc_bf_sqt() || zjqquery.isBjdc_bf_0b0()

                || zjqquery.isBjdc_bf_1b1() || zjqquery.isBjdc_bf_2b2()
                || zjqquery.isBjdc_bf_3b3() || zjqquery.isBjdc_bf_pqt()

                || zjqquery.isBjdc_bf_0b1() || zjqquery.isBjdc_bf_0b2()
                || zjqquery.isBjdc_bf_0b3() || zjqquery.isBjdc_bf_0b4()
                || zjqquery.isBjdc_bf_1b2()
                || zjqquery.isBjdc_bf_1b3() || zjqquery.isBjdc_bf_1b4() || zjqquery.isBjdc_bf_2b3()
                || zjqquery.isBjdc_bf_2b4()
                || zjqquery.isBjdc_bf_fqt()) {
            return true;
        }

        return false;
    }

    //判断用户是否选择数据
    public Boolean isTure2(Boolean[] bools) {
        for (int i = 0; i < bools.length; i++) {
            if (bools[i]) {
                return true;
            }
        }
        return false;
    }

    //当用户选择确定时提交数据
    public void SubmitUserchioce(XinTiBJDCEntity zjqquery, Boolean[] bools) {

        for (int i = 0; i < bools.length; i++) {
            //比分
            if (bools[0]) {
                zjqquery.setBjdc_bf_1b0(true);

            } else {
                zjqquery.setBjdc_bf_1b0(false);
            }
            if (bools[1]) {
                zjqquery.setBjdc_bf_2b0(true);

            } else {
                zjqquery.setBjdc_bf_2b0(false);
            }

            if (bools[2]) {
                zjqquery.setBjdc_bf_2b1(true);

            } else {
                zjqquery.setBjdc_bf_2b1(false);
            }

            if (bools[3]) {
                zjqquery.setBjdc_bf_3b0(true);

            } else {
                zjqquery.setBjdc_bf_3b0(false);
            }
            if (bools[4]) {
                zjqquery.setBjdc_bf_3b1(true);

            } else {
                zjqquery.setBjdc_bf_3b1(false);
            }

            if (bools[5]) {
                zjqquery.setBjdc_bf_3b2(true);

            } else {
                zjqquery.setBjdc_bf_3b2(false);
            }

            if (bools[6]) {
                zjqquery.setBjdc_bf_4b0(true);

            } else {
                zjqquery.setBjdc_bf_4b0(false);
            }
            if (bools[7]) {
                zjqquery.setBjdc_bf_4b1(true);

            } else {
                zjqquery.setBjdc_bf_4b1(false);
            }
            if (bools[8]) {
                zjqquery.setBjdc_bf_4b2(true);

            } else {
                zjqquery.setBjdc_bf_4b2(false);
            }
            if (bools[9]) {
                zjqquery.setBjdc_bf_sqt(true);

            } else {
                zjqquery.setBjdc_bf_sqt(false);
            }
            if (bools[10]) {
                zjqquery.setBjdc_bf_0b0(true);

            } else {
                zjqquery.setBjdc_bf_0b0(false);
            }
            if (bools[11]) {
                zjqquery.setBjdc_bf_1b1(true);

            } else {
                zjqquery.setBjdc_bf_1b1(false);
            }
            if (bools[12]) {
                zjqquery.setBjdc_bf_2b2(true);

            } else {
                zjqquery.setBjdc_bf_2b2(false);
            }
            if (bools[13]) {
                zjqquery.setBjdc_bf_3b3(true);

            } else {
                zjqquery.setBjdc_bf_3b3(false);
            }


            if (bools[14]) {
                zjqquery.setBjdc_bf_pqt(true);

            } else {
                zjqquery.setBjdc_bf_pqt(false);
            }
            if (bools[15]) {
                zjqquery.setBjdc_bf_0b1(true);

            } else {
                zjqquery.setBjdc_bf_0b1(false);
            }
            if (bools[16]) {
                zjqquery.setBjdc_bf_0b2(true);

            } else {
                zjqquery.setBjdc_bf_0b2(false);
            }
            if (bools[17]) {
                zjqquery.setBjdc_bf_0b3(true);

            } else {
                zjqquery.setBjdc_bf_0b3(false);
            }
            if (bools[18]) {
                zjqquery.setBjdc_bf_0b4(true);

            } else {
                zjqquery.setBjdc_bf_0b4(false);
            }

            if (bools[19]) {
                zjqquery.setBjdc_bf_1b2(true);

            } else {
                zjqquery.setBjdc_bf_1b2(false);
            }
            if (bools[20]) {
                zjqquery.setBjdc_bf_1b3(true);

            } else {
                zjqquery.setBjdc_bf_1b3(false);
            }
            if (bools[21]) {
                zjqquery.setBjdc_bf_1b4(true);

            } else {
                zjqquery.setBjdc_bf_1b4(false);
            }

            if (bools[22]) {
                zjqquery.setBjdc_bf_2b3(true);

            } else {
                zjqquery.setBjdc_bf_2b3(false);
            }
            if (bools[23]) {
                zjqquery.setBjdc_bf_2b4(true);

            } else {
                zjqquery.setBjdc_bf_2b4(false);
            }

            if (bools[24]) {
                zjqquery.setBjdc_bf_fqt(true);

            } else {
                zjqquery.setBjdc_bf_fqt(false);
            }


        }
    }

    //显示用户选择的类容
    //显示用户选择的类容
    private static final String BF_1b0 = "1:0";
    private static final String BF_2b0 = "2:0";
    private static final String BF_2b1 = "2:1";
    private static final String BF_3b0 = "3:0";
    private static final String BF_3b1 = "3:1";
    private static final String BF_3b2 = "3:2";
    private static final String BF_4b0 = "4:0";
    private static final String BF_4b1 = "4:1";
    private static final String BF_4b2 = "4:2";
    private static final String BF_5b1 = "5:1";
    private static final String BF_5b2 = "5:2";
    private static final String BF_5b3 = "5:3";
    private static final String BF_sqt = "sqt";
    private static final String BF_0b0 = "0:0";
    private static final String BF_1b1 = "1:1";
    private static final String BF_2b2 = "2:2";
    private static final String BF_3b3 = "3:3";
    private static final String BF_pqt = "pqt";
    private static final String BF_0b1 = "0:1";
    private static final String BF_0b2 = "0:2";
    private static final String BF_0b3 = "0:3";
    private static final String BF_0b4 = "0:4";
    private static final String BF_0b5 = "0:5";
    private static final String BF_1b2 = "1:2";
    private static final String BF_1b3 = "1:3";
    private static final String BF_1b4 = "1:4";
    private static final String BF_1b5 = "1:5";
    private static final String BF_2b3 = "2:3";
    private static final String BF_2b4 = "2:4";
    private static final String BF_2b5 = "2:5";
    private static final String BF_fqt = "负其他";
    private String str, strshow;

    public void showContent(XinTiBJDCEntity zjqquery) {

        //比分
        str = "";
        strshow = "";
        if (zjqquery.isBjdc_bf_1b0()) {
            str += ",10";
            strshow += "," + BF_1b0;
        }
        if (zjqquery.isBjdc_bf_2b0()) {
            str += ",20";
            strshow += "," + BF_2b0;
        }

        if (zjqquery.isBjdc_bf_2b1()) {
            str += ",21";
            strshow += "," + BF_2b1;
        }


        if (zjqquery.isBjdc_bf_3b0()) {
            str += ",30";
            strshow += "," + BF_3b0;
        }

        if (zjqquery.isBjdc_bf_3b1()) {
            str += ",31";
            strshow += "," + BF_3b1;
        }


        if (zjqquery.isBjdc_bf_3b2()) {
            str += ",32";
            strshow += "," + BF_3b2;
        }

        if (zjqquery.isBjdc_bf_4b0()) {
            str += ",40";
            strshow += "," + BF_4b0;
        }

        if (zjqquery.isBjdc_bf_4b1()) {
            str += ",41";
            strshow += "," + BF_4b1;
        }

        if (zjqquery.isBjdc_bf_4b2()) {
            str += ",42";
            strshow += "," + BF_4b2;
        }


        if (zjqquery.isBjdc_bf_sqt()) {
            str += ",90";
            strshow += "," + BF_sqt;
        }
        if (zjqquery.isBjdc_bf_0b0()) {
            str += ",00";
            strshow += "," + BF_0b0;
        }

        if (zjqquery.isBjdc_bf_1b1()) {
            str += ",11";
            strshow += "," + BF_1b1;
        }
        if (zjqquery.isBjdc_bf_2b2()) {
            str += ",22";
            strshow += "," + BF_2b2;
        }
        if (zjqquery.isBjdc_bf_3b3()) {
            str += ",33";
            strshow += "," + BF_3b3;
        }
        if (zjqquery.isBjdc_bf_pqt()) {
            str += ",99";
            strshow += "," + BF_pqt;
        }
        if (zjqquery.isBjdc_bf_0b1()) {
            str += ",01";
            strshow += "," + BF_0b1;
        }
        if (zjqquery.isBjdc_bf_0b2()) {
            str += ",02";
            strshow += "," + BF_0b2;
        }
        if (zjqquery.isBjdc_bf_0b3()) {
            str += ",03";
            strshow += "," + BF_0b3;
        }
        if (zjqquery.isBjdc_bf_0b4()) {
            str += ",04";
            strshow += "," + BF_0b4;
        }


        if (zjqquery.isBjdc_bf_1b2()) {
            str += ",12";
            strshow += "," + BF_1b2;
        }
        if (zjqquery.isBjdc_bf_1b3()) {
            str += ",13";
            strshow += "," + BF_1b3;
        }


        if (zjqquery.isBjdc_bf_2b3()) {
            str += ",23";
            strshow += "," + BF_2b3;
        }
        if (zjqquery.isBjdc_bf_2b4()) {
            str += ",24";
            strshow += "," + BF_2b4;
        }

        if (zjqquery.isBjdc_bf_fqt()) {
            str += ",09";
            strshow += "," + BF_fqt;
        }
    }

    /**
     * 用户选择显示数据
     */
    public ArrayList<XinTiSPFDentity> TeamarrsShowQuery() {
        ArrayList<XinTiSPFDentity> spfdlist = new ArrayList<XinTiSPFDentity>();
        for (int i = 0; i < zjqlisttest.size(); i++) {
            if (isTure(zjqlisttest.get(i))) {
                XinTiSPFDentity spfentity = new XinTiSPFDentity();
                spfentity.setHomename(zjqlisttest.get(i).getHomeTeamName());
                spfentity.setGuestname(zjqlisttest.get(i).getGuestTeamName());
                //获取方案号
                spfentity.setMatcharr("");
                spfentity.setIssusenumber("");
                spfentity.setGametypearr("BF");
                spfdlist.add(spfentity);
            }

        }
        return spfdlist;
    }

    /**
     * 显示用户选择数据
     */
    private ArrayList<String> TeamShowarrs = new ArrayList<String>();

    public ArrayList<String> TeamShowContentarrsQuery() {
        ArrayList<String> teamcontentarrs = new ArrayList<String>();
        for (int i = 0; i < zjqlisttest.size(); i++) {

            System.out.println("------------" + TeamShowarrs.get(i));
            if (isTure(zjqlisttest.get(i))) {
                String temp = TeamShowarrs.get(i).substring(1);
                teamcontentarrs.add(temp);
            }
        }
        return teamcontentarrs;
    }

    /**
     * 获取投注号码
     */
    private ArrayList<String> Teamarrs = new ArrayList<String>();

    public ArrayList<String> TeamContentarrsQuery() {
        ArrayList<String> teamcontentarrs = new ArrayList<String>();
        for (int i = 0; i < zjqlisttest.size(); i++) {
            if (isTure(zjqlisttest.get(i))) {
                String temp = Teamarrs.get(i).substring(1);
                teamcontentarrs.add(temp);
            }
        }
        return teamcontentarrs;
    }

    /**
     * 选择总球场集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceAllTeamarr;

    public ArrayList<ArrayList<Object>> JsAllTeam() {
        arrchoiceAllTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (zjqlisttest.get(i).isBjdc_bf_1b0()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_2b0()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_2b1()) {
                moneytemp.add(1);
            }


            if (zjqlisttest.get(i).isBjdc_bf_3b0()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_3b1()) {
                moneytemp.add(1);
            }


            if (zjqlisttest.get(i).isBjdc_bf_3b2()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_4b0()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_4b1()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_4b2()) {
                moneytemp.add(1);
            }


            if (zjqlisttest.get(i).isBjdc_bf_sqt()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_0b0()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_1b1()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_2b2()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_3b3()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_pqt()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_0b1()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_0b2()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_0b3()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_0b4()) {
                moneytemp.add(1);
            }


            if (zjqlisttest.get(i).isBjdc_bf_1b2()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_1b3()) {
                moneytemp.add(1);
            }


            if (zjqlisttest.get(i).isBjdc_bf_2b3()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_bf_2b4()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isBjdc_bf_fqt()) {
                moneytemp.add(1);
            }
            if (moneytemp.size() != 0) {
                arrchoiceAllTeamarr.add(moneytemp);
            }

        }
        return arrchoiceAllTeamarr;
    }

    /**
     * 选择的胆集合球场数
     */
    private ArrayList<ArrayList<Object>> arrchoiceDanTeamarr;

    public ArrayList<ArrayList<Object>> JsDanTeam() {
        arrchoiceDanTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (listd.get(i)) {
                if (zjqlisttest.get(i).isBjdc_bf_1b0()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_2b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_2b1()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_3b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_3b1()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_3b2()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_4b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_4b1()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_4b2()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_sqt()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_1b1()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_2b2()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_3b3()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_pqt()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b1()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b2()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b3()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b4()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_1b2()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_1b3()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_2b3()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_2b4()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_fqt()) {
                    moneytemp.add(1);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDanTeamarr.add(moneytemp);
                }
            }

        }
        return arrchoiceDanTeamarr;
    }

    /**
     * 选择的除胆的集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceDeleteDanTeam;

    public ArrayList<ArrayList<Object>> JsDeleteDanTeam() {
        arrchoiceDeleteDanTeam = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (!listd.get(i)) {
                if (zjqlisttest.get(i).isBjdc_bf_1b0()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_2b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_2b1()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_3b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_3b1()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_3b2()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_4b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_4b1()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_4b2()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_sqt()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b0()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_1b1()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_2b2()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_3b3()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_pqt()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b1()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b2()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b3()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_0b4()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_1b2()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_1b3()) {
                    moneytemp.add(1);
                }


                if (zjqlisttest.get(i).isBjdc_bf_2b3()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_bf_2b4()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isBjdc_bf_fqt()) {
                    moneytemp.add(1);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDeleteDanTeam.add(moneytemp);
                }
            }
        }
        return arrchoiceDeleteDanTeam;
    }

    /**
     * 日期筛选
     */
    private String datestr;

    public String JIEdate() {
        return datestr;
    }
}
