package com.fleaphpnet.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager.LayoutParams;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.fleaphpnet.Dao.CutDateQuery;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.dialog.ZJQDialog;
import com.fleaphpnet.entity.XinTiBJDCEntity;
import com.fleaphpnet.entity.XinTiSPFDentity;
import com.fleaphpnet.holder.BJDC_HHholderView;

import java.util.ArrayList;
import java.util.List;

public class bjdcSxdslistAdapter extends BaseAdapter {
    private Context mconn;
    private List<XinTiBJDCEntity> zjqlisttest;
    //设置胆
    private List<Drawable> listdd, listcontentd;
    //content
    private List<Boolean> listcontent;
    //胆
    private List<Boolean> listd;
    //判断胆是否可选
    private List<Boolean> isdaneable;

    public List<Boolean> getDan() {
        return this.listd;
    }

    public bjdcSxdslistAdapter(Context mconn, List<XinTiBJDCEntity> zjqlisttest) {
        super();
        this.mconn = mconn;
        this.zjqlisttest = zjqlisttest;
        listcontent = new ArrayList<Boolean>(zjqlisttest.size());
        listd = new ArrayList<Boolean>(zjqlisttest.size());
        isdaneable = new ArrayList<Boolean>(zjqlisttest.size());
        listdd = new ArrayList<Drawable>(zjqlisttest.size());
        listcontentd = new ArrayList<Drawable>(zjqlisttest.size());

        for (int i = 0; i < zjqlisttest.size(); i++) {
            listcontent.add(false);
            listd.add(false);
            isdaneable.add(false);
            listdd.add(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
            listcontentd.add(mconn.getResources().getDrawable(R.drawable.dialog_bg_sliver));

            //初始化用户选择数据
            Teamarrs.add("");
            TeamShowarrs.add("");
        }
    }

    public int getCount() {
        // TODO Auto-generated method stub
        return zjqlisttest.size();
    }

    public Object getItem(int position) {
        // TODO Auto-generated method stub
        return zjqlisttest.get(position);
    }

    public long getItemId(int position) {
        // TODO Auto-generated method stub
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        LinearLayout mli1, mli2, mli3;
        final ViewHolder holder;

        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(mconn).inflate(R.layout.update_ball_layout_dialog_item_qq, null);
            holder.mbtncontent = (Button) convertView.findViewById(R.id.userchoice_content);
            holder.mlidan = (LinearLayout) convertView.findViewById(R.id.mliqq4);

            holder.mtxtteamhome = (TextView) convertView.findViewById(R.id.all_hometeamid);
            holder.mtxtteamguest = (TextView) convertView.findViewById(R.id.all_guestteamid);
            holder.mtxtteamstoptime = (TextView) convertView.findViewById(R.id.all_timestopid);
            holder.mtxtmatch = (TextView) convertView.findViewById(R.id.all_matchnameid);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.mtxtmatch.setText(zjqlisttest.get(position).getMatchName());
        holder.mtxtteamhome.setText(zjqlisttest.get(position).getHomeTeamName());
        holder.mtxtteamguest.setText(zjqlisttest.get(position).getGuestTeamName());
        holder.mtxtteamstoptime.setText(CutDateQuery.CutDateTimeShow(zjqlisttest.get(position).getLocalStopTime()) + "截止");
        datestr = zjqlisttest.get(0).getLocalStopTime();
        holder.mlidan.setId(position);
        holder.mbtncontent.setId(position);
        holder.mbtncontent.setBackgroundDrawable(listcontentd.get(position));
        holder.mbtncontent.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                TeamDialog(holder.mbtncontent, holder.mlidan, zjqlisttest.get(position));

            }
        });

        holder.mlidan.setBackgroundDrawable(listdd.get(position));
        holder.mlidan.setEnabled(isdaneable.get(position));
        holder.mlidan.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                if (listd.get(position)) {
                    listd.set(v.getId(), false);
                    listdd.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    holder.mlidan.setBackgroundDrawable(listdd.get(position));
                } else {
                    listdd.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_red_trans));
                    holder.mlidan.setBackgroundDrawable(listdd.get(position));
                    listd.set(v.getId(), true);
                }
            }
        });
        return convertView;
    }

    class ViewHolder {
        TextView mtxtteamhome, mtxtteamguest, mtxtteamstoptime, mtxtmatch;
        Button mbtncontent;
        LinearLayout mlidan;
    }

    private Boolean[] usercheckboolean;

    public void TeamDialog(final Button btncontent, final LinearLayout mlidan, final XinTiBJDCEntity zjqquery) {
        final BJDC_HHholderView ZJQVIEW = new BJDC_HHholderView();
        final ZJQDialog dialog2 = new ZJQDialog(mconn, R.style.Theme_dialog,
                R.layout.update_ball_dialog_item_bjdc_sxds, LayoutParams.FILL_PARENT,
                LayoutParams.FILL_PARENT);
        usercheckboolean = new Boolean[8];
        str = "";
/*		for (int i = 0; i < usercheckboolean.length; i++) {
            usercheckboolean[i]=false;
		}*/
        ZJQVIEW.mlisxds_sd = (LinearLayout) dialog2.findViewById(R.id.mlisxds_sd);
        ZJQVIEW.mlisxds_ss = (LinearLayout) dialog2.findViewById(R.id.mlisxds_ss);
        ZJQVIEW.mlisxds_xd = (LinearLayout) dialog2.findViewById(R.id.mlisxds_xd);
        ZJQVIEW.mlisxds_xs = (LinearLayout) dialog2.findViewById(R.id.mlisxds_xs);

        ZJQVIEW.mlisxds_sd_txt = (TextView) dialog2.findViewById(R.id.mtextsxds_sd);
        ZJQVIEW.mlisxds_ss_txt = (TextView) dialog2.findViewById(R.id.mtextsxds_ss);
        ZJQVIEW.mlisxds_xd_txt = (TextView) dialog2.findViewById(R.id.mtextsxds_xd);
        ZJQVIEW.mlisxds_xs_txt = (TextView) dialog2.findViewById(R.id.mtextsxds_xs);

        ZJQVIEW.mlisxds_sd_sp = (TextView) dialog2.findViewById(R.id.mtextsxds_sd_sp);
        ZJQVIEW.mlisxds_ss_sp = (TextView) dialog2.findViewById(R.id.mtextsxds_ss_sp);
        ZJQVIEW.mlisxds_xd_sp = (TextView) dialog2.findViewById(R.id.mtextsxds_xs_sp);
        ZJQVIEW.mlisxds_xs_sp = (TextView) dialog2.findViewById(R.id.mtextsxds_xd_sp);
        ZJQVIEW.mlisxds_sd_sp.setText(zjqquery.getSH_D_Odds());
        ZJQVIEW.mlisxds_ss_sp.setText(zjqquery.getSH_S_Odds());
        ZJQVIEW.mlisxds_xd_sp.setText(zjqquery.getX_D_Odds());
        ZJQVIEW.mlisxds_xs_sp.setText(zjqquery.getX_S_Odds());

        ZJQVIEW.buttonok = (Button) dialog2.findViewById(R.id.dialog_button_ok);
        ZJQVIEW.buttoncancel = (Button) dialog2.findViewById(R.id.dialog_button_cancel);
        usercheckboolean[0] = zjqquery.isBjdc_sxds_sd();
        usercheckboolean[1] = zjqquery.isBjdc_sxds_ss();
        usercheckboolean[2] = zjqquery.isBjdc_sxds_xd();
        usercheckboolean[3] = zjqquery.isBjdc_sxds_xs();
        btnPress(zjqquery.isBjdc_sxds_sd(), ZJQVIEW.mlisxds_sd, ZJQVIEW.mlisxds_sd_txt, ZJQVIEW.mlisxds_sd_sp);
        btnPress(zjqquery.isBjdc_sxds_ss(), ZJQVIEW.mlisxds_ss, ZJQVIEW.mlisxds_ss_txt, ZJQVIEW.mlisxds_ss_sp);
        btnPress(zjqquery.isBjdc_sxds_xd(), ZJQVIEW.mlisxds_xd, ZJQVIEW.mlisxds_xd_txt, ZJQVIEW.mlisxds_xd_sp);
        btnPress(zjqquery.isBjdc_sxds_xs(), ZJQVIEW.mlisxds_xs, ZJQVIEW.mlisxds_xs_txt, ZJQVIEW.mlisxds_xs_sp);


        ZJQVIEW.mlisxds_sd.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[0]) {

                    usercheckboolean[0] = false;
                } else {
                    usercheckboolean[0] = true;
                }
                btnPress(usercheckboolean[0], ZJQVIEW.mlisxds_sd, ZJQVIEW.mlisxds_sd_txt, ZJQVIEW.mlisxds_sd_sp);
            }
        });
        ZJQVIEW.mlisxds_ss.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[1]) {

                    usercheckboolean[1] = false;
                } else {

                    usercheckboolean[1] = true;
                }
                btnPress(usercheckboolean[1], ZJQVIEW.mlisxds_ss, ZJQVIEW.mlisxds_ss_txt, ZJQVIEW.mlisxds_ss_sp);
            }
        });
        ZJQVIEW.mlisxds_xd.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[2]) {

                    usercheckboolean[2] = false;
                } else {

                    usercheckboolean[2] = true;
                }
                btnPress(usercheckboolean[2], ZJQVIEW.mlisxds_xd, ZJQVIEW.mlisxds_xd_txt, ZJQVIEW.mlisxds_xd_sp);
            }
        });
        ZJQVIEW.mlisxds_xs.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[3]) {

                    usercheckboolean[3] = false;
                } else {

                    usercheckboolean[3] = true;
                }
                btnPress(usercheckboolean[3], ZJQVIEW.mlisxds_xs, ZJQVIEW.mlisxds_xs_txt, ZJQVIEW.mlisxds_xs_sp);
            }
        });

        ZJQVIEW.buttonok.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                boolean flag = isTure2(usercheckboolean);
                SubmitUserchioce(zjqquery, usercheckboolean);
                if (flag) {
                    showContent(zjqquery);
                    isdaneable.set(mlidan.getId(), true);
                    mlidan.setEnabled(true);
                    listcontent.set(btncontent.getId(), true);
                    listcontentd.set(btncontent.getId(), mconn.getResources().getDrawable(R.drawable.dialog_item_red));
                    btncontent.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_item_red));
                    btncontent.setTextColor(mconn.getResources().getColor(R.color.white));
                    btncontent.setText(showstr.substring(1));
                    Teamarrs.set(btncontent.getId(), str);
                    TeamShowarrs.set(btncontent.getId(), showstr);
                } else {
                    isdaneable.set(mlidan.getId(), false);
                    mlidan.setEnabled(false);
                    listdd.set(mlidan.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    mlidan.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    listcontentd.set(btncontent.getId(), mconn.getResources().getDrawable(R.drawable.dialog_bg_sliver));
                    btncontent.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_bg_sliver));
                    btncontent.setTextColor(mconn.getResources().getColor(R.color.silver));
                    btncontent.setText("选择投注内容");
                    Teamarrs.set(btncontent.getId(), "");
                    TeamShowarrs.set(btncontent.getId(), "");
                }
                dialog2.dismiss();
            }
        });
        ZJQVIEW.buttoncancel.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                dialog2.dismiss();
            }
        });
        dialog2.show();// 显示Dialog
    }

    //自定义按钮
    public void btnPress(Boolean isflag, LinearLayout mliner, TextView texttitle, TextView textsp) {
        if (isflag) {
            texttitle.setTextColor(mconn.getResources().getColor(R.color.white));
            textsp.setTextColor(mconn.getResources().getColor(R.color.white));
            mliner.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_top_left_bottom_right_red));
        } else {
            texttitle.setTextColor(mconn.getResources().getColor(R.color.black));
            mliner.setBackgroundDrawable(mconn.getResources().getDrawable(R.drawable.dialog_top_left_bottom));
            textsp.setTextColor(mconn.getResources().getColor(R.color.silver));
        }

    }

    //判断用户是否选择数据
    public Boolean isTure(XinTiBJDCEntity zjqquery) {
        if (zjqquery.isBjdc_sxds_sd() || zjqquery.isBjdc_sxds_ss() || zjqquery.isBjdc_sxds_xd() || zjqquery.isBjdc_sxds_xs()) {
            return true;
        }

        return false;
    }

    //判断用户是否选择数据
    public Boolean isTure2(Boolean[] bools) {
        for (int i = 0; i < bools.length; i++) {
            if (bools[i]) {
                return true;
            }
        }
        return false;
    }

    //当用户选择确定时提交数据
    public void SubmitUserchioce(XinTiBJDCEntity zjqquery, Boolean[] bools) {

        for (int i = 0; i < bools.length; i++) {
            System.out.println("----------" + bools[i]);

            if (bools[0]) {
                zjqquery.setBjdc_sxds_sd(true);

            } else {
                zjqquery.setBjdc_sxds_sd(false);
            }

            if (bools[1]) {
                zjqquery.setBjdc_sxds_ss(true);

            } else {
                zjqquery.setBjdc_sxds_ss(false);
            }


            if (bools[2]) {
                zjqquery.setBjdc_sxds_xd(true);

            } else {
                zjqquery.setBjdc_sxds_xd(false);
            }

            if (bools[3]) {
                zjqquery.setBjdc_sxds_xs(true);

            } else {
                zjqquery.setBjdc_sxds_xs(false);
            }
        }
    }

    //显示用户选择的类容
    private static final String SD = "上单";
    private static final String SS = "上双";
    private static final String XD = "下单";
    private static final String XS = "下双";
    private String str, showstr;

    public void showContent(XinTiBJDCEntity zjqquery) {
        str = "";
        showstr = "";
        if (zjqquery.isBjdc_sxds_sd()) {
            str += ",SD";
            showstr += "," + SD;
        }
        if (zjqquery.isBjdc_sxds_ss()) {
            str += ",SS";
            showstr += "," + SS;
        }
        if (zjqquery.isBjdc_sxds_xs()) {
            str += ",XD";
            showstr += "," + XD;
        }
        if (zjqquery.isBjdc_sxds_xd()) {
            str += ",XS";
            showstr += "," + XS;
        }
    }


    /**
     * 用户选择显示数据
     */
    public ArrayList<XinTiSPFDentity> TeamarrsShowQuery() {
        ArrayList<XinTiSPFDentity> spfdlist = new ArrayList<XinTiSPFDentity>();
        for (int i = 0; i < zjqlisttest.size(); i++) {
            if (isTure(zjqlisttest.get(i))) {
                XinTiSPFDentity spfentity = new XinTiSPFDentity();
                spfentity.setHomename(zjqlisttest.get(i).getHomeTeamName());
                spfentity.setGuestname(zjqlisttest.get(i).getGuestTeamName());

                //获取方案号
                spfentity.setMatcharr("");
                spfentity.setIssusenumber("");
                spfentity.setGametypearr("SXDS");
                spfdlist.add(spfentity);
            }

        }
        return spfdlist;
    }

    /**
     * 显示用户选择数据
     */
    private ArrayList<String> TeamShowarrs = new ArrayList<String>();

    public ArrayList<String> TeamShowContentarrsQuery() {
        ArrayList<String> teamcontentarrs = new ArrayList<String>();
        for (int i = 0; i < zjqlisttest.size(); i++) {

            if (isTure(zjqlisttest.get(i))) {
                String temp = TeamShowarrs.get(i).substring(1);
                teamcontentarrs.add(temp);
            }
        }
        return teamcontentarrs;
    }

    /**
     * 获取投注号码
     */
    private ArrayList<String> Teamarrs = new ArrayList<String>();

    public ArrayList<String> TeamContentarrsQuery() {
        ArrayList<String> teamcontentarrs = new ArrayList<String>();
        for (int i = 0; i < zjqlisttest.size(); i++) {
            if (isTure(zjqlisttest.get(i))) {
                String temp = Teamarrs.get(i).substring(1);
                teamcontentarrs.add(temp);
            }
        }
        return teamcontentarrs;
    }

    /**
     * 选择总球场集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceAllTeamarr;

    public ArrayList<ArrayList<Object>> JsAllTeam() {
        arrchoiceAllTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (zjqlisttest.get(i).isBjdc_sxds_sd()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_sxds_ss()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_sxds_xs()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isBjdc_sxds_xd()) {
                moneytemp.add(1);
            }
            if (moneytemp.size() != 0) {
                arrchoiceAllTeamarr.add(moneytemp);
            }

        }
        return arrchoiceAllTeamarr;
    }

    /**
     * 选择的胆集合球场数
     */
    private ArrayList<ArrayList<Object>> arrchoiceDanTeamarr;

    public ArrayList<ArrayList<Object>> JsDanTeam() {
        arrchoiceDanTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (listd.get(i)) {
                if (zjqlisttest.get(i).isBjdc_sxds_sd()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_sxds_ss()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_sxds_xs()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_sxds_xd()) {
                    moneytemp.add(1);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDanTeamarr.add(moneytemp);
                }
            }

        }
        return arrchoiceDanTeamarr;
    }

    /**
     * 选择的除胆的集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceDeleteDanTeam;

    public ArrayList<ArrayList<Object>> JsDeleteDanTeam() {
        arrchoiceDeleteDanTeam = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (!listd.get(i)) {
                if (zjqlisttest.get(i).isBjdc_sxds_sd()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_sxds_ss()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_sxds_xs()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isBjdc_sxds_xd()) {
                    moneytemp.add(1);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDeleteDanTeam.add(moneytemp);
                }
            }
        }
        return arrchoiceDeleteDanTeam;
    }

    /**
     * 日期筛选
     */
    private String datestr;

    public String JIEdate() {
        return datestr;
    }
}
