package com.fleaphpnet.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager.LayoutParams;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.fleaphpnet.Dao.CutDateQuery;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.dialog.ZJQDialog;
import com.fleaphpnet.entity.XinTiJCLQntity;
import com.fleaphpnet.entity.XinTiSPFDentity;
import com.fleaphpnet.holder.JCLQ_HHholderView;

import java.util.ArrayList;
import java.util.List;

public class jclqHHlistAdapter extends BaseAdapter {
    private Context mconn;
    private List<XinTiJCLQntity> zjqlisttest;
    // 设置胆
    private List<Drawable> listdd, listcontentd;
    // content
    private List<Boolean> listcontent;
    // 胆
    private List<Boolean> listd;
    // 判断胆是否可选
    private List<Boolean> isdaneable;

    public List<Boolean> getDan() {
        return this.listd;
    }

    public jclqHHlistAdapter(Context mconn, List<XinTiJCLQntity> zjqlisttest) {
        super();
        this.mconn = mconn;
        this.zjqlisttest = zjqlisttest;
        listcontent = new ArrayList<Boolean>(zjqlisttest.size());
        listd = new ArrayList<Boolean>(zjqlisttest.size());
        isdaneable = new ArrayList<Boolean>(zjqlisttest.size());
        listdd = new ArrayList<Drawable>(zjqlisttest.size());
        listcontentd = new ArrayList<Drawable>(zjqlisttest.size());

        for (int i = 0; i < zjqlisttest.size(); i++) {
            listcontent.add(false);
            listd.add(false);
            isdaneable.add(false);
            listdd.add(mconn.getResources().getDrawable(
                    R.drawable.update_ball_white_trans));
            listcontentd.add(mconn.getResources().getDrawable(
                    R.drawable.dialog_bg_sliver));

            //初始化用户选择
            Teamarrs.add("");
            TeamShowarrs.add("");
        }
    }

    public int getCount() {
        // TODO Auto-generated method stub
        return zjqlisttest.size();
    }

    public Object getItem(int position) {
        // TODO Auto-generated method stub
        return zjqlisttest.get(position);
    }

    public long getItemId(int position) {
        // TODO Auto-generated method stub
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        LinearLayout mli1, mli2, mli3;
        final ViewHolder holder;

        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(mconn).inflate(
                    R.layout.update_ball_layout_dialog_item_qq, null);
            holder.mbtncontent = (Button) convertView
                    .findViewById(R.id.userchoice_content);
            holder.mlidan = (LinearLayout) convertView
                    .findViewById(R.id.mliqq4);
            holder.mtxtteamhome = (TextView) convertView.findViewById(R.id.all_hometeamid);
            holder.mtxtteamguest = (TextView) convertView.findViewById(R.id.all_guestteamid);
            holder.mtxtteamstoptime = (TextView) convertView.findViewById(R.id.all_timestopid);
            holder.mtxtmatch = (TextView) convertView.findViewById(R.id.all_matchnameid);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        holder.mtxtmatch.setText(zjqlisttest.get(position).getMatchIdName());
        holder.mtxtteamhome.setText(zjqlisttest.get(position).getHomeTeamName());
        holder.mtxtteamguest.setText(zjqlisttest.get(position).getGuestTeamName());
        holder.mtxtteamstoptime.setText(CutDateQuery.CutDateTimeShow(zjqlisttest.get(position).getFSStopBettingTime()) + "截止");
        datestr = zjqlisttest.get(0).getFSStopBettingTime();
        holder.mlidan.setId(position);
        holder.mbtncontent.setId(position);
        holder.mbtncontent.setBackgroundDrawable(listcontentd.get(position));
        holder.mbtncontent.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                TeamDialog(holder.mbtncontent, holder.mlidan,
                        zjqlisttest.get(position));

            }
        });

        holder.mlidan.setBackgroundDrawable(listdd.get(position));
        holder.mlidan.setEnabled(isdaneable.get(position));
        holder.mlidan.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                if (listd.get(position)) {
                    listd.set(v.getId(), false);
                    listdd.set(
                            v.getId(),
                            mconn.getResources().getDrawable(
                                    R.drawable.update_ball_white_trans)
                    );
                    holder.mlidan.setBackgroundDrawable(listdd.get(position));
                } else {
                    listdd.set(
                            v.getId(),
                            mconn.getResources().getDrawable(
                                    R.drawable.update_ball_red_trans)
                    );
                    holder.mlidan.setBackgroundDrawable(listdd.get(position));
                    listd.set(v.getId(), true);
                }
            }
        });
        return convertView;
    }

    class ViewHolder {
        TextView mtxtteamhome, mtxtteamguest, mtxtteamstoptime, mtxtmatch;
        Button mbtncontent;
        LinearLayout mlidan;
    }

    private Boolean[] usercheckboolean;


    public void TeamDialog(final Button btncontent, final LinearLayout mlidan,
                           final XinTiJCLQntity zjqquery) {
        final JCLQ_HHholderView ZJQVIEW = new JCLQ_HHholderView();
        final ZJQDialog dialog2 = new ZJQDialog(mconn, R.style.Theme_dialog,
                R.layout.update_ball_dialog_itemjclqhh,
                LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
        usercheckboolean = new Boolean[18];
        str = "";
        /*
		 * for (int i = 0; i < usercheckboolean.length; i++) {
		 * usercheckboolean[i]=false; }
		 */
        ZJQVIEW.mlisf_s = (LinearLayout) dialog2.findViewById(R.id.mlisf_s);
        ZJQVIEW.mlisf_f = (LinearLayout) dialog2.findViewById(R.id.mlisf_f);

        ZJQVIEW.mlirqsf_s = (LinearLayout) dialog2
                .findViewById(R.id.mlirqsf_rs);
        ZJQVIEW.mlirqsf_f = (LinearLayout) dialog2
                .findViewById(R.id.mlirqsf_rf);

        ZJQVIEW.mlidxf_d = (LinearLayout) dialog2.findViewById(R.id.mlidxf_d);
        ZJQVIEW.mlidxf_x = (LinearLayout) dialog2.findViewById(R.id.mlidxf_x);

        ZJQVIEW.mlisfc_s15 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_s15);
        ZJQVIEW.mlisfc_s610 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_s610);
        ZJQVIEW.mlisfc_s1115 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_s1115);
        ZJQVIEW.mlisfc_s1620 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_s1620);
        ZJQVIEW.mlisfc_s2125 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_s2125);
        ZJQVIEW.mlisfc_s26 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_s26);

        ZJQVIEW.mlisfc_f15 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_f15);
        ZJQVIEW.mlisfc_f610 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_f610);
        ZJQVIEW.mlisfc_f1115 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_f1115);
        ZJQVIEW.mlisfc_f1620 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_f1620);
        ZJQVIEW.mlisfc_f2125 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_f2125);
        ZJQVIEW.mlisfc_f26 = (LinearLayout) dialog2
                .findViewById(R.id.mlisfc_f26);

        ZJQVIEW.mlisf_s_txt = (TextView) dialog2.findViewById(R.id.mtextsf_s);
        ZJQVIEW.mlisf_f_txt = (TextView) dialog2.findViewById(R.id.mtextsf_f);


        ZJQVIEW.mlirqsf_s_txt = (TextView) dialog2.findViewById(R.id.mtextrqsf_rs);
        ZJQVIEW.mlirqsf_f_txt = (TextView) dialog2.findViewById(R.id.mtextrqsf_rf);
        ZJQVIEW.mlirqsf_p_txt = (TextView) dialog2.findViewById(R.id.mtextrf_zhi);


        ZJQVIEW.mlidxf_d_txt = (TextView) dialog2.findViewById(R.id.mtextdxf_d);
        ZJQVIEW.mlidxf_x_txt = (TextView) dialog2.findViewById(R.id.mtextdxf_x);
        ZJQVIEW.mlidxf_fen = (TextView) dialog2.findViewById(R.id.mtextdxf_fen);


        ZJQVIEW.mlisf_s_sp = (TextView) dialog2.findViewById(R.id.mtextsf_s_sp);
        ZJQVIEW.mlisf_f_sp = (TextView) dialog2.findViewById(R.id.mtextsf_f_sp);
        ZJQVIEW.mlisf_s_sp.setText(zjqquery.getSF_WinSP());
        ZJQVIEW.mlisf_s_sp.setText(zjqquery.getSF_LoseSP());

        ZJQVIEW.mlirqsf_s_sp = (TextView) dialog2.findViewById(R.id.mtextrqsf_rs);
        ZJQVIEW.mlirqsf_f_sp = (TextView) dialog2.findViewById(R.id.mtextrqsfrf_sp);
        ZJQVIEW.mlirqsf_p_txt.setText(zjqquery.getRF());
        ZJQVIEW.mlirqsf_s_sp.setText(zjqquery.getRF_WinSP());
        ZJQVIEW.mlirqsf_s_sp.setText(zjqquery.getRF_LoseSP());

        ZJQVIEW.mlidxf_d_sp = (TextView) dialog2.findViewById(R.id.mtextdxfd_sp);
        ZJQVIEW.mlidxf_x_sp = (TextView) dialog2.findViewById(R.id.mtextdxfx_sp);
        ZJQVIEW.mlidxf_d_sp.setText(zjqquery.getDF());
        ZJQVIEW.mlidxf_x_sp.setText(zjqquery.getXF());
        ZJQVIEW.mlidxf_fen.setText(zjqquery.getYSZF());

        ZJQVIEW.mlisfc_s15_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_s15);
        ZJQVIEW.mlisfc_s610_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_s610);
        ZJQVIEW.mlisfc_s1115_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_s1115);
        ZJQVIEW.mlisfc_s1620_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_s1620);
        ZJQVIEW.mlisfc_s2125_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_s2125);
        ZJQVIEW.mlisfc_s26_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_s26);


        ZJQVIEW.mlisfc_f15_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_f15);
        ZJQVIEW.mlisfc_f610_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_f610);
        ZJQVIEW.mlisfc_f1115_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_f1115);
        ZJQVIEW.mlisfc_f1620_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_f1620);
        ZJQVIEW.mlisfc_f2125_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_f2125);
        ZJQVIEW.mlisfc_f26_txt = (TextView) dialog2.findViewById(R.id.mtextsfc_f26);


        ZJQVIEW.mlisfc_s15_sp = (TextView) dialog2.findViewById(R.id.mtextsfcs15_sp);
        ZJQVIEW.mlisfc_s610_sp = (TextView) dialog2.findViewById(R.id.mtextsfc610_sp);
        ZJQVIEW.mlisfc_s1115_sp = (TextView) dialog2.findViewById(R.id.mtextsfc1115_sp);
        ZJQVIEW.mlisfc_s1620_sp = (TextView) dialog2.findViewById(R.id.mtextsfc1620_sp);
        ZJQVIEW.mlisfc_s2125_sp = (TextView) dialog2.findViewById(R.id.mtextsfc2125_sp);
        ZJQVIEW.mlisfc_s26_sp = (TextView) dialog2.findViewById(R.id.mtextsfc26_sp);

        ZJQVIEW.mlisfc_s15_sp.setText(zjqquery.getHomeWin1_5());
        ZJQVIEW.mlisfc_s610_sp.setText(zjqquery.getHomeWin6_10());
        ZJQVIEW.mlisfc_s1115_sp.setText(zjqquery.getHomeWin11_15());
        ZJQVIEW.mlisfc_s1620_sp.setText(zjqquery.getHomeWin16_20());
        ZJQVIEW.mlisfc_s2125_sp.setText(zjqquery.getHomeWin21_25());
        ZJQVIEW.mlisfc_s26_sp.setText(zjqquery.getHomeWin26());

        ZJQVIEW.mlisfc_f15_sp = (TextView) dialog2.findViewById(R.id.mtextsfc15_sp);
        ZJQVIEW.mlisfc_f610_sp = (TextView) dialog2.findViewById(R.id.mtextsfcf610_sp);
        ZJQVIEW.mlisfc_f1115_sp = (TextView) dialog2.findViewById(R.id.mtextsfcf1115_sp);
        ZJQVIEW.mlisfc_f1620_sp = (TextView) dialog2.findViewById(R.id.mtextsfcf1620_sp);
        ZJQVIEW.mlisfc_f2125_sp = (TextView) dialog2.findViewById(R.id.mtextsfcf2125_sp);
        ZJQVIEW.mlisfc_f26_sp = (TextView) dialog2.findViewById(R.id.mtextsfcf26_sp);

        ZJQVIEW.mlisfc_f15_sp.setText(zjqquery.getGuestWin1_5());
        ZJQVIEW.mlisfc_f610_sp.setText(zjqquery.getGuestWin6_10());
        ZJQVIEW.mlisfc_f1115_sp.setText(zjqquery.getGuestWin11_15());
        ZJQVIEW.mlisfc_f1620_sp.setText(zjqquery.getGuestWin16_20());
        ZJQVIEW.mlisfc_f2125_sp.setText(zjqquery.getGuestWin21_25());
        ZJQVIEW.mlisfc_f26_sp.setText(zjqquery.getGuestWin26());


        ZJQVIEW.buttonok = (Button) dialog2.findViewById(R.id.dialog_button_ok);
        ZJQVIEW.buttoncancel = (Button) dialog2
                .findViewById(R.id.dialog_button_cancel);
        usercheckboolean[0] = zjqquery.isJclq_sf_s();
        usercheckboolean[1] = zjqquery.isJclq_sf_f();
        usercheckboolean[2] = zjqquery.isJclq_rfsf_f();
        usercheckboolean[3] = zjqquery.isJclq_rfsf_s();

        usercheckboolean[4] = zjqquery.isJclq_dxf_d();
        usercheckboolean[5] = zjqquery.isJclq_dxf_x();

        usercheckboolean[6] = zjqquery.isJclq_sfc_s_1_5();
        usercheckboolean[7] = zjqquery.isJclq_sfc_s_6_10();
        usercheckboolean[8] = zjqquery.isJclq_sfc_s_11_15();
        usercheckboolean[9] = zjqquery.isJclq_sfc_s_16_20();
        usercheckboolean[10] = zjqquery.isJclq_sfc_s_21_25();
        usercheckboolean[11] = zjqquery.isJclq_sfc_s_26();

        usercheckboolean[12] = zjqquery.isJclq_sfc_f_1_5();
        usercheckboolean[13] = zjqquery.isJclq_sfc_f_6_10();
        usercheckboolean[14] = zjqquery.isJclq_sfc_f_11_15();
        usercheckboolean[15] = zjqquery.isJclq_sfc_f_16_20();
        usercheckboolean[16] = zjqquery.isJclq_sfc_f_21_25();
        usercheckboolean[17] = zjqquery.isJclq_sfc_f_26();

        btnPress(zjqquery.isJclq_sf_s(), ZJQVIEW.mlisf_s, ZJQVIEW.mlisf_s_txt,
                ZJQVIEW.mlisf_s_sp);
        btnPress(zjqquery.isJclq_sf_f(), ZJQVIEW.mlisf_f, ZJQVIEW.mlisf_f_txt,
                ZJQVIEW.mlisf_f_sp);

        btnPress(zjqquery.isJclq_rfsf_f(), ZJQVIEW.mlirqsf_f,
                ZJQVIEW.mlirqsf_f_txt, ZJQVIEW.mlirqsf_f_sp);
        btnPress(zjqquery.isJclq_rfsf_s(), ZJQVIEW.mlirqsf_s,
                ZJQVIEW.mlirqsf_s_txt, ZJQVIEW.mlirqsf_s_sp);


        btnPress(zjqquery.isJclq_dxf_d(), ZJQVIEW.mlidxf_d,
                ZJQVIEW.mlidxf_d_txt, ZJQVIEW.mlidxf_d_sp);
        btnPress(zjqquery.isJclq_dxf_x(), ZJQVIEW.mlidxf_x,
                ZJQVIEW.mlidxf_x_txt, ZJQVIEW.mlidxf_x_sp);

        btnPress(zjqquery.isJclq_sfc_s_1_5(), ZJQVIEW.mlisfc_s15,
                ZJQVIEW.mlisfc_s15_txt, ZJQVIEW.mlisfc_s15_sp);
        btnPress(zjqquery.isJclq_sfc_s_6_10(), ZJQVIEW.mlisfc_s610,
                ZJQVIEW.mlisfc_s610_txt, ZJQVIEW.mlisfc_s610_sp);

        btnPress(zjqquery.isJclq_sfc_s_11_15(), ZJQVIEW.mlisfc_s1115,
                ZJQVIEW.mlisfc_s1115_txt, ZJQVIEW.mlisfc_s1115_sp);
        btnPress(zjqquery.isJclq_sfc_s_16_20(), ZJQVIEW.mlisfc_s1115,
                ZJQVIEW.mlisfc_s1115_txt, ZJQVIEW.mlisfc_s1115_sp);
        btnPress(zjqquery.isJclq_sfc_s_21_25(), ZJQVIEW.mlisfc_s1115,
                ZJQVIEW.mlisfc_s1115_txt, ZJQVIEW.mlisfc_s1115_sp);
        btnPress(zjqquery.isJclq_sfc_s_26(), ZJQVIEW.mlisfc_s1115,
                ZJQVIEW.mlisfc_s1115_txt, ZJQVIEW.mlisfc_s1115_sp);

        btnPress(zjqquery.isJclq_sfc_f_1_5(), ZJQVIEW.mlisfc_f15,
                ZJQVIEW.mlisfc_f15_txt, ZJQVIEW.mlisfc_f15_sp);
        btnPress(zjqquery.isJclq_sfc_f_6_10(), ZJQVIEW.mlisfc_f610,
                ZJQVIEW.mlisfc_f610_txt, ZJQVIEW.mlisfc_f610_sp);
        btnPress(zjqquery.isJclq_sfc_f_11_15(), ZJQVIEW.mlisfc_f1115,
                ZJQVIEW.mlisfc_f1115_txt, ZJQVIEW.mlisfc_f1115_sp);
        btnPress(zjqquery.isJclq_sfc_f_16_20(), ZJQVIEW.mlisfc_f1620,
                ZJQVIEW.mlisfc_f1620_txt, ZJQVIEW.mlisfc_f1620_sp);
        btnPress(zjqquery.isJclq_sfc_f_21_25(), ZJQVIEW.mlisfc_f2125,
                ZJQVIEW.mlisfc_f2125_txt, ZJQVIEW.mlisfc_f2125_sp);
        btnPress(zjqquery.isJclq_sfc_f_26(), ZJQVIEW.mlisfc_f26,
                ZJQVIEW.mlisfc_f26_txt, ZJQVIEW.mlisfc_f26_sp);

        ZJQVIEW.mlisf_s.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[0]) {

                    usercheckboolean[0] = false;
                } else {
                    usercheckboolean[0] = true;
                }
                btnPress(usercheckboolean[0], ZJQVIEW.mlisf_s,
                        ZJQVIEW.mlisf_s_txt, ZJQVIEW.mlisf_s_sp);
            }
        });
        ZJQVIEW.mlisf_f.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[1]) {

                    usercheckboolean[1] = false;
                } else {

                    usercheckboolean[1] = true;
                }
                btnPress(usercheckboolean[1], ZJQVIEW.mlisf_f,
                        ZJQVIEW.mlisf_f_txt, ZJQVIEW.mlisf_f_sp);
            }
        });
        ZJQVIEW.mlirqsf_f.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[2]) {

                    usercheckboolean[2] = false;
                } else {

                    usercheckboolean[2] = true;
                }
                btnPress(usercheckboolean[2], ZJQVIEW.mlirqsf_f,
                        ZJQVIEW.mlirqsf_f_txt, ZJQVIEW.mlirqsf_f_sp);
            }
        });
        ZJQVIEW.mlirqsf_s.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[3]) {

                    usercheckboolean[3] = false;
                } else {

                    usercheckboolean[3] = true;
                }
                btnPress(usercheckboolean[3], ZJQVIEW.mlirqsf_s,
                        ZJQVIEW.mlirqsf_s_txt, ZJQVIEW.mlirqsf_s_sp);
            }
        });
        ZJQVIEW.mlidxf_d.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {

                if (usercheckboolean[4]) {

                    usercheckboolean[4] = false;
                } else {

                    usercheckboolean[4] = true;
                }
                btnPress(usercheckboolean[4], ZJQVIEW.mlidxf_d,
                        ZJQVIEW.mlidxf_d_txt, ZJQVIEW.mlidxf_d_sp);
            }
        });
        ZJQVIEW.mlidxf_x.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[5]) {

                    usercheckboolean[5] = false;
                } else {

                    usercheckboolean[5] = true;
                }
                btnPress(usercheckboolean[5], ZJQVIEW.mlidxf_x,
                        ZJQVIEW.mlidxf_x_txt, ZJQVIEW.mlidxf_x_sp);
            }
        });
        ZJQVIEW.mlisfc_s15.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[6]) {

                    usercheckboolean[6] = false;
                } else {

                    usercheckboolean[6] = true;
                }
                btnPress(usercheckboolean[6], ZJQVIEW.mlisfc_s15,
                        ZJQVIEW.mlisfc_s15_txt, ZJQVIEW.mlisfc_s15_sp);
            }
        });
        ZJQVIEW.mlisfc_s610.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[7]) {

                    usercheckboolean[7] = false;
                } else {

                    usercheckboolean[7] = true;
                }
                btnPress(usercheckboolean[7], ZJQVIEW.mlisfc_s610,
                        ZJQVIEW.mlisfc_s610_txt, ZJQVIEW.mlisfc_s610_sp);
            }
        });

        ZJQVIEW.mlisfc_s1115.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[8]) {

                    usercheckboolean[8] = false;
                } else {

                    usercheckboolean[8] = true;
                }
                btnPress(usercheckboolean[8], ZJQVIEW.mlisfc_s1115,
                        ZJQVIEW.mlisfc_s1115_txt, ZJQVIEW.mlisfc_s1115_sp);
            }
        });


        ZJQVIEW.mlisfc_s1620.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[9]) {

                    usercheckboolean[9] = false;
                } else {

                    usercheckboolean[9] = true;
                }
                btnPress(usercheckboolean[9], ZJQVIEW.mlisfc_s1620,
                        ZJQVIEW.mlisfc_s1620_txt, ZJQVIEW.mlisfc_s1620_sp);
            }
        });


        ZJQVIEW.mlisfc_s2125.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[10]) {

                    usercheckboolean[10] = false;
                } else {

                    usercheckboolean[10] = true;
                }
                btnPress(usercheckboolean[10], ZJQVIEW.mlisfc_s2125,
                        ZJQVIEW.mlisfc_s2125_txt, ZJQVIEW.mlisfc_s2125_sp);
            }
        });


        ZJQVIEW.mlisfc_s26.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[11]) {

                    usercheckboolean[11] = false;
                } else {

                    usercheckboolean[11] = true;
                }
                btnPress(usercheckboolean[11], ZJQVIEW.mlisfc_s26,
                        ZJQVIEW.mlisfc_s26_txt, ZJQVIEW.mlisfc_s26_sp);
            }
        });


        ZJQVIEW.mlisfc_f15.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[12]) {

                    usercheckboolean[12] = false;
                } else {

                    usercheckboolean[12] = true;
                }
                btnPress(usercheckboolean[12], ZJQVIEW.mlisfc_f15,
                        ZJQVIEW.mlisfc_f15_txt, ZJQVIEW.mlisfc_f15_sp);
            }
        });
        ZJQVIEW.mlisfc_f610.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[13]) {

                    usercheckboolean[13] = false;
                } else {

                    usercheckboolean[13] = true;
                }
                btnPress(usercheckboolean[13], ZJQVIEW.mlisfc_f610,
                        ZJQVIEW.mlisfc_f610_txt, ZJQVIEW.mlisfc_f610_sp);
            }
        });
        ZJQVIEW.mlisfc_f1115.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[14]) {

                    usercheckboolean[14] = false;
                } else {

                    usercheckboolean[14] = true;
                }
                btnPress(usercheckboolean[14], ZJQVIEW.mlisfc_f1115,
                        ZJQVIEW.mlisfc_f1115_txt, ZJQVIEW.mlisfc_f1115_sp);
            }
        });

        ZJQVIEW.mlisfc_f1620.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[15]) {

                    usercheckboolean[15] = false;
                } else {

                    usercheckboolean[15] = true;
                }
                btnPress(usercheckboolean[15], ZJQVIEW.mlisfc_f1620,
                        ZJQVIEW.mlisfc_f1620_txt, ZJQVIEW.mlisfc_f1620_sp);
            }
        });

        ZJQVIEW.mlisfc_f2125.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[16]) {

                    usercheckboolean[16] = false;
                } else {

                    usercheckboolean[16] = true;
                }
                btnPress(usercheckboolean[16], ZJQVIEW.mlisfc_f2125,
                        ZJQVIEW.mlisfc_f2125_txt, ZJQVIEW.mlisfc_f2125_sp);
            }
        });


        ZJQVIEW.mlisfc_f26.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub

                if (usercheckboolean[17]) {

                    usercheckboolean[17] = false;
                } else {

                    usercheckboolean[17] = true;
                }
                btnPress(usercheckboolean[17], ZJQVIEW.mlisfc_f26,
                        ZJQVIEW.mlisfc_f26_txt, ZJQVIEW.mlisfc_f26_sp);
            }
        });


        ZJQVIEW.buttonok.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                boolean flag = isTure2(usercheckboolean);
                SubmitUserchioce(zjqquery, usercheckboolean);
                if (flag) {
                    showContent(zjqquery);
                    isdaneable.set(mlidan.getId(), true);
                    mlidan.setEnabled(true);
                    listcontent.set(btncontent.getId(), true);
                    listcontentd.set(btncontent.getId(), mconn.getResources()
                            .getDrawable(R.drawable.dialog_item_red));
                    btncontent.setBackgroundDrawable(mconn.getResources()
                            .getDrawable(R.drawable.dialog_item_red));
                    btncontent.setTextColor(mconn.getResources().getColor(
                            R.color.white));
                    btncontent.setText(showstr.substring(1));
                    Teamarrs.set(btncontent.getId(), str);
                    TeamShowarrs.set(btncontent.getId(), showstr);
                } else {
                    isdaneable.set(mlidan.getId(), false);
                    mlidan.setEnabled(false);
                    listdd.set(mlidan.getId(), mconn.getResources()
                            .getDrawable(R.drawable.update_ball_white_trans));
                    mlidan.setBackgroundDrawable(mconn.getResources()
                            .getDrawable(R.drawable.update_ball_white_trans));
                    listcontentd.set(btncontent.getId(), mconn.getResources()
                            .getDrawable(R.drawable.dialog_bg_sliver));
                    btncontent.setBackgroundDrawable(mconn.getResources()
                            .getDrawable(R.drawable.dialog_bg_sliver));
                    btncontent.setTextColor(mconn.getResources().getColor(
                            R.color.silver));
                    btncontent.setText("选择投注内容");
                    Teamarrs.set(btncontent.getId(), "");
                    TeamShowarrs.set(btncontent.getId(), "");
                }
                dialog2.dismiss();
            }
        });
        ZJQVIEW.buttoncancel.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                dialog2.dismiss();
            }
        });
        dialog2.show();// 显示Dialog
    }

    // 自定义按钮
    public void btnPress(Boolean isflag, LinearLayout mliner,
                         TextView texttitle, TextView textsp) {
        if (isflag) {
            texttitle
                    .setTextColor(mconn.getResources().getColor(R.color.white));
            textsp.setTextColor(mconn.getResources().getColor(R.color.white));
            mliner.setBackgroundDrawable(mconn.getResources().getDrawable(
                    R.drawable.dialog_top_left_bottom_right_red));
        } else {
            texttitle
                    .setTextColor(mconn.getResources().getColor(R.color.black));
            mliner.setBackgroundDrawable(mconn.getResources().getDrawable(
                    R.drawable.dialog_top_left_bottom));
            textsp.setTextColor(mconn.getResources().getColor(R.color.silver));
        }

    }

    // 判断用户是否选择数据
    public Boolean isTure(XinTiJCLQntity zjqquery) {
        if (zjqquery.isJclq_sf_s() || zjqquery.isJclq_sf_f()
                || zjqquery.isJclq_rfsf_s() || zjqquery.isJclq_rfsf_f()
                || zjqquery.isJclq_dxf_d() || zjqquery.isJclq_dxf_x()
                || zjqquery.isJclq_sfc_s_1_5() || zjqquery.isJclq_sfc_s_6_10()
                || zjqquery.isJclq_sfc_s_11_15()
                || zjqquery.isJclq_sfc_s_16_20()
                || zjqquery.isJclq_sfc_s_21_25() || zjqquery.isJclq_sfc_s_26()
                || zjqquery.isJclq_sfc_f_1_5() || zjqquery.isJclq_sfc_f_6_10()
                || zjqquery.isJclq_sfc_f_11_15()
                || zjqquery.isJclq_sfc_f_16_20()
                || zjqquery.isJclq_sfc_f_21_25() || zjqquery.isJclq_sfc_f_26()) {
            return true;
        }

        return false;
    }

    // 判断用户是否选择数据
    public Boolean isTure2(Boolean[] bools) {
        for (int i = 0; i < bools.length; i++) {
            if (bools[i]) {
                return true;
            }
        }
        return false;
    }

    // 当用户选择确定时提交数据
    public void SubmitUserchioce(XinTiJCLQntity zjqquery, Boolean[] bools) {

        for (int i = 0; i < bools.length; i++) {
            System.out.println("----------" + bools[i]);

            if (bools[0]) {
                zjqquery.setJclq_sf_s(true);

            } else {
                zjqquery.setJclq_sf_s(false);
            }

            if (bools[1]) {
                zjqquery.setJclq_sf_f(true);

            } else {
                zjqquery.setJclq_sf_f(false);
            }

            if (bools[2]) {
                zjqquery.setJclq_rfsf_s(true);

            } else {
                zjqquery.setJclq_rfsf_s(false);
            }

            if (bools[3]) {
                zjqquery.setJclq_rfsf_f(true);

            } else {
                zjqquery.setJclq_rfsf_f(false);
            }

            if (bools[4]) {
                zjqquery.setJclq_dxf_d(true);

            } else {
                zjqquery.setJclq_dxf_d(false);
            }

            if (bools[5]) {
                zjqquery.setJclq_dxf_x(true);

            } else {
                zjqquery.setJclq_dxf_x(false);
            }

            if (bools[6]) {
                zjqquery.setJclq_sfc_s_1_5(true);

            } else {
                zjqquery.setJclq_sfc_s_1_5(false);
            }
            if (bools[7]) {
                zjqquery.setJclq_sfc_s_6_10(true);

            } else {
                zjqquery.setJclq_sfc_s_6_10(false);
            }
            if (bools[8]) {
                zjqquery.setJclq_sfc_s_11_15(true);

            } else {
                zjqquery.setJclq_sfc_s_11_15(false);
            }
            if (bools[9]) {
                zjqquery.setJclq_sfc_s_16_20(true);

            } else {
                zjqquery.setJclq_sfc_s_16_20(false);
            }
            if (bools[10]) {
                zjqquery.setJclq_sfc_s_21_25(true);

            } else {
                zjqquery.setJclq_sfc_s_21_25(false);
            }
            if (bools[11]) {
                zjqquery.setJclq_sfc_s_26(true);

            } else {
                zjqquery.setJclq_sfc_s_26(false);
            }

            if (bools[12]) {
                zjqquery.setJclq_sfc_f_1_5(true);

            } else {
                zjqquery.setJclq_sfc_f_1_5(false);
            }
            if (bools[13]) {
                zjqquery.setJclq_sfc_f_6_10(true);

            } else {
                zjqquery.setJclq_sfc_f_6_10(false);
            }
            if (bools[14]) {
                zjqquery.setJclq_sfc_f_11_15(true);

            } else {
                zjqquery.setJclq_sfc_f_11_15(false);
            }
            if (bools[15]) {
                zjqquery.setJclq_sfc_f_16_20(true);

            } else {
                zjqquery.setJclq_sfc_f_16_20(false);
            }
            if (bools[16]) {
                zjqquery.setJclq_sfc_f_21_25(true);

            } else {
                zjqquery.setJclq_sfc_f_21_25(false);
            }
            if (bools[17]) {
                zjqquery.setJclq_sfc_f_26(true);

            } else {
                zjqquery.setJclq_sfc_f_26(false);
            }
        }
    }

    // 显示用户选择的类容
    private static final String SF_Z = "主胜";
    private static final String SF_K = "客胜";
    private static final String DF_Z = "大分";
    private static final String XF_Z = "小分";
    private static final String SFC_S1Z5 = "胜1-5分";
    private static final String SFC_S6Z10 = "胜6-10分";
    private static final String SFC_S11Z15 = "胜11-15分";
    private static final String SFC_S16Z20 = "胜16-20分";
    private static final String SFC_S21Z25 = "胜21-25分";
    private static final String SFC_S26 = "胜26分";


    private static final String SFC_F1Z5 = "负1-5分";
    private static final String SFC_F6Z10 = "负6-10分";
    private static final String SFC_F11Z15 = "负11-15分";
    private static final String SFC_F16Z20 = "负16-20分";
    private static final String SFC_F21Z25 = "负21-25分";
    private static final String SFC_F26 = "负26分";
    private String str, showstr;

    public void showContent(XinTiJCLQntity zjqquery) {
        str = "";
        showstr = "";
        if (zjqquery.isJclq_sf_s()) {
            str += ",3";
            showstr += "," + SF_Z;
        }
        if (zjqquery.isJclq_sf_f()) {
            str += ",0";
            showstr += "," + SF_K;
        }
        //让分
        if (zjqquery.isJclq_rfsf_s()) {
            str += ",3";
            showstr += "," + SF_Z;
        }
        if (zjqquery.isJclq_rfsf_f()) {
            str += ",0";
            showstr += "," + SF_K;
        }
        //大小分
        if (zjqquery.isJclq_dxf_d()) {
            str += ",3";
            showstr += "," + DF_Z;
        }
        if (zjqquery.isJclq_dxf_x()) {
            str += ",0";
            showstr += "," + XF_Z;
        }
        //胜分差
        if (zjqquery.isJclq_sfc_s_1_5()) {
            str += ",01";
            showstr += "," + SFC_S1Z5;
        }
        if (zjqquery.isJclq_sfc_s_6_10()) {
            str += ",02";
            showstr += "," + SFC_S6Z10;
        }
        if (zjqquery.isJclq_sfc_s_11_15()) {
            str += ",03";
            showstr += "," + SFC_S11Z15;
        }
        if (zjqquery.isJclq_sfc_s_16_20()) {
            str += ",04";
            showstr += "," + SFC_S16Z20;
        }
        if (zjqquery.isJclq_sfc_s_21_25()) {
            str += ",05";
            showstr += "," + SFC_S21Z25;
        }
        if (zjqquery.isJclq_sfc_s_26()) {
            str += ",06";
            showstr += "," + SFC_S26;
        }

        if (zjqquery.isJclq_sfc_f_1_5()) {
            str += ",11";
            showstr += "," + SFC_F1Z5;
        }
        if (zjqquery.isJclq_sfc_f_6_10()) {
            str += ",12";
            showstr += "," + SFC_F6Z10;
        }
        if (zjqquery.isJclq_sfc_f_11_15()) {
            str += ",13";
            showstr += "," + SFC_F11Z15;
        }
        if (zjqquery.isJclq_sfc_f_16_20()) {
            str += ",14";
            showstr += "," + SFC_F16Z20;
        }
        if (zjqquery.isJclq_sfc_f_21_25()) {
            str += ",15";
            showstr += "," + SFC_F21Z25;
        }
        if (zjqquery.isJclq_sfc_f_26()) {
            str += ",16";
            showstr += "," + SFC_F26;
        }
    }

    /**
     * 用户选择显示数据
     */
    public ArrayList<XinTiSPFDentity> TeamarrsShowQuery() {
        ArrayList<XinTiSPFDentity> spfdlist = new ArrayList<XinTiSPFDentity>();
        for (int i = 0; i < zjqlisttest.size(); i++) {
            if (isTure(zjqlisttest.get(i))) {
                XinTiSPFDentity spfentity = new XinTiSPFDentity();
                spfentity.setHomename(zjqlisttest.get(i).getHomeTeamName());
                spfentity.setGuestname(zjqlisttest.get(i).getGuestTeamName());

                //获取方案号
                spfentity.setMatcharr(zjqlisttest.get(i).getMatchId());
                spfentity.setIssusenumber("");
                spfentity.setGametypearr("RFSF");
                spfdlist.add(spfentity);
            }

        }
        return spfdlist;
    }

    /**
     * 显示用户选择数据
     */
    private ArrayList<String> TeamShowarrs = new ArrayList<String>();

    public ArrayList<String> TeamShowContentarrsQuery() {
        ArrayList<String> teamcontentarrs = new ArrayList<String>();
        for (int i = 0; i < zjqlisttest.size(); i++) {

            System.out.println("------------" + TeamShowarrs.get(i));
            if (isTure(zjqlisttest.get(i))) {
                String temp = TeamShowarrs.get(i).substring(1);
                teamcontentarrs.add(temp);
            }
        }
        return teamcontentarrs;
    }

    /**
     * 获取投注号码
     */
    private ArrayList<String> Teamarrs = new ArrayList<String>();

    public ArrayList<String> TeamContentarrsQuery() {
        ArrayList<String> teamcontentarrs = new ArrayList<String>();
        for (int i = 0; i < zjqlisttest.size(); i++) {
            if (isTure(zjqlisttest.get(i))) {
                String temp = Teamarrs.get(i).substring(1);
                teamcontentarrs.add(temp);
            }
        }
        return teamcontentarrs;
    }

    /**
     * 选择总球场集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceAllTeamarr;

    public ArrayList<ArrayList<Object>> JsAllTeam() {
        arrchoiceAllTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (zjqlisttest.get(i).isJclq_sf_s()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sf_f()) {
                moneytemp.add(1);
            }
            //让分
            if (zjqlisttest.get(i).isJclq_rfsf_s()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_rfsf_f()) {
                moneytemp.add(1);
            }
            //大小分
            if (zjqlisttest.get(i).isJclq_dxf_d()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_dxf_x()) {
                moneytemp.add(1);
            }
            //胜分差
            if (zjqlisttest.get(i).isJclq_sfc_s_1_5()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_s_6_10()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_s_11_15()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_s_16_20()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_s_21_25()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_s_26()) {
                moneytemp.add(1);
            }

            if (zjqlisttest.get(i).isJclq_sfc_f_1_5()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_f_6_10()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_f_11_15()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_f_16_20()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_f_21_25()) {
                moneytemp.add(1);
            }
            if (zjqlisttest.get(i).isJclq_sfc_f_26()) {
                moneytemp.add(1);
            }
            if (moneytemp.size() != 0) {
                arrchoiceAllTeamarr.add(moneytemp);
            }

        }
        return arrchoiceAllTeamarr;
    }

    /**
     * 选择的胆集合球场数
     */
    private ArrayList<ArrayList<Object>> arrchoiceDanTeamarr;

    public ArrayList<ArrayList<Object>> JsDanTeam() {
        arrchoiceDanTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (listd.get(i)) {
                if (zjqlisttest.get(i).isJclq_sf_s()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sf_f()) {
                    moneytemp.add(1);
                }
                //让分
                if (zjqlisttest.get(i).isJclq_rfsf_s()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_rfsf_f()) {
                    moneytemp.add(1);
                }
                //大小分
                if (zjqlisttest.get(i).isJclq_dxf_d()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_dxf_x()) {
                    moneytemp.add(1);
                }
                //胜分差
                if (zjqlisttest.get(i).isJclq_sfc_s_1_5()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_6_10()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_11_15()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_16_20()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_21_25()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_26()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isJclq_sfc_f_1_5()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_6_10()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_11_15()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_16_20()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_21_25()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_26()) {
                    moneytemp.add(1);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDanTeamarr.add(moneytemp);
                }
            }

        }
        return arrchoiceDanTeamarr;
    }

    /**
     * 选择的除胆的集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceDeleteDanTeam;

    public ArrayList<ArrayList<Object>> JsDeleteDanTeam() {
        arrchoiceDeleteDanTeam = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < zjqlisttest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (!listd.get(i)) {
                if (zjqlisttest.get(i).isJclq_sf_s()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sf_f()) {
                    moneytemp.add(1);
                }
                //让分
                if (zjqlisttest.get(i).isJclq_rfsf_s()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_rfsf_f()) {
                    moneytemp.add(1);
                }
                //大小分
                if (zjqlisttest.get(i).isJclq_dxf_d()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_dxf_x()) {
                    moneytemp.add(1);
                }
                //胜分差
                if (zjqlisttest.get(i).isJclq_sfc_s_1_5()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_6_10()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_11_15()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_16_20()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_21_25()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_s_26()) {
                    moneytemp.add(1);
                }

                if (zjqlisttest.get(i).isJclq_sfc_f_1_5()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_6_10()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_11_15()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_16_20()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_21_25()) {
                    moneytemp.add(1);
                }
                if (zjqlisttest.get(i).isJclq_sfc_f_26()) {
                    moneytemp.add(1);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDeleteDanTeam.add(moneytemp);
                }
            }
        }
        return arrchoiceDeleteDanTeam;
    }

    /**
     * 日期筛选
     */
    private String datestr;

    public String JIEdate() {
        return datestr;
    }

}
