package com.fleaphpnet.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.fleaphpnet.Dao.CutDateQuery;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.entity.XinTiJCZQEntity;
import com.fleaphpnet.entity.XinTiSPFDentity;

import java.util.ArrayList;
import java.util.List;

public class jczqSfplistAdapter extends BaseAdapter {
    private Context mconn;
    private List<XinTiJCZQEntity> listtest;
    //设置图片
    private List<Drawable> listdl;
    private List<Drawable> listdc;
    private List<Drawable> listdr;
    private List<Drawable> listdd;
    //胜
    private List<Boolean> listl;
    //平
    private List<Boolean> listc;
    //负
    private List<Boolean> listr;
    //胆
    private List<Boolean> listd;


    public jczqSfplistAdapter(Context mconn, List<XinTiJCZQEntity> listtest) {
        super();
        this.mconn = mconn;
        this.listtest = listtest;
        listl = new ArrayList<Boolean>(listtest.size());
        listc = new ArrayList<Boolean>(listtest.size());
        listr = new ArrayList<Boolean>(listtest.size());
        listd = new ArrayList<Boolean>(listtest.size());

        listdl = new ArrayList<Drawable>(listtest.size());
        listdc = new ArrayList<Drawable>(listtest.size());
        listdr = new ArrayList<Drawable>(listtest.size());
        listdd = new ArrayList<Drawable>(listtest.size());
        for (int i = 0; i < listtest.size(); i++) {
            listl.add(false);
            listc.add(false);
            listr.add(false);
            listd.add(false);
            listdl.add(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
            listdc.add(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
            listdr.add(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
            listdd.add(mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
        }
    }

    public int getCount() {
        // TODO Auto-generated method stub
        return listtest.size();
    }

    public Object getItem(int position) {
        // TODO Auto-generated method stub
        return listtest.get(position);
    }

    public long getItemId(int position) {
        // TODO Auto-generated method stub
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        LinearLayout mli1, mli2, mli3;
        final ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(mconn).inflate(R.layout.update_ball_layout_item_qq4, null);
            holder.liner1 = (LinearLayout) convertView.findViewById(R.id.mliqq1);
            holder.liner2 = (LinearLayout) convertView.findViewById(R.id.mliqq2);
            holder.liner3 = (LinearLayout) convertView.findViewById(R.id.mliqq3);
            holder.mliner4 = (LinearLayout) convertView.findViewById(R.id.mliqq4);
            holder.mmatchname = (TextView) convertView.findViewById(R.id.ctzq_matchnameid);
            holder.mtimestop = (TextView) convertView.findViewById(R.id.ctzq_timestopid);
            holder.mhometeam = (TextView) convertView.findViewById(R.id.ctzq_hometeamid);
            holder.mguestteam = (TextView) convertView.findViewById(R.id.ctzq_guestteamid);

            //赔率
            holder.ms_sp = (TextView) convertView.findViewById(R.id.all_s_sp);
            holder.mp_sp = (TextView) convertView.findViewById(R.id.all_p_sp);
            holder.mf_sp = (TextView) convertView.findViewById(R.id.all_f_sp);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.mmatchname.setText(listtest.get(position).getLeagueName());
        holder.mtimestop.setText(CutDateQuery.CutDateTimeShow(listtest.get(position).getFSStopBettingTime()) + "截止");
        holder.mhometeam.setText(Html.fromHtml(listtest.get(position).getHomeTeamName()));
        holder.mguestteam.setText(Html.fromHtml(listtest.get(position).getGuestTeamName()));


        holder.ms_sp.setText("胜" + listtest.get(position).getSP_Win_Odds_BRQ());
        holder.mp_sp.setText("平" + listtest.get(position).getSP_Flat_Odds_BRQ());
        holder.mf_sp.setText("负" + listtest.get(position).getSP_Lose_Odds_BRQ());

        datestr = listtest.get(0).getFSStopBettingTime();
        holder.liner1.setId(position);
        holder.liner1.setBackgroundDrawable(listdl.get(position));
        holder.liner1.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                if (listl.get(position)) {
                    listl.set(v.getId(), false);
                    listdl.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    holder.liner1.setBackgroundDrawable(listdl.get(position));
                } else {
                    listdl.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_red_trans));
                    holder.liner1.setBackgroundDrawable(listdl.get(position));
                    listl.set(v.getId(), true);
                }

            }
        });
        holder.liner2.setId(position);
        holder.liner2.setBackgroundDrawable(listdc.get(position));
        holder.liner2.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                if (listc.get(position)) {
                    listc.set(v.getId(), false);
                    listdc.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    holder.liner2.setBackgroundDrawable(listdc.get(position));
                } else {
                    listdc.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_red_trans));
                    holder.liner2.setBackgroundDrawable(listdc.get(position));
                    listc.set(v.getId(), true);
                }

            }
        });
        holder.liner3.setId(position);
        holder.liner3.setBackgroundDrawable(listdr.get(position));
        holder.liner3.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                if (listr.get(position)) {
                    listr.set(v.getId(), false);
                    listdr.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    holder.liner3.setBackgroundDrawable(listdr.get(position));
                } else {
                    listdr.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_red_trans));
                    holder.liner3.setBackgroundDrawable(listdr.get(position));
                    listr.set(v.getId(), true);
                }
            }
        });
        holder.mliner4.setId(position);
        holder.mliner4.setBackgroundDrawable(listdd.get(position));
        holder.mliner4.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                // TODO Auto-generated method stub
                if (listd.get(position)) {
                    listd.set(v.getId(), false);
                    listdd.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_white_trans));
                    holder.mliner4.setBackgroundDrawable(listdd.get(position));
                } else {
                    listdd.set(v.getId(), mconn.getResources().getDrawable(R.drawable.update_ball_red_trans));
                    holder.mliner4.setBackgroundDrawable(listdd.get(position));
                    listd.set(v.getId(), true);
                }
            }
        });
        return convertView;
    }

    class ViewHolder {
        TextView mmatchname, mtimestop, mhometeam, mguestteam;
        TextView ms_sp, mp_sp, mf_sp;
        LinearLayout liner1, liner2, liner3, mliner4;
    }

    /**
     * 用户选择显示数据
     */
    public ArrayList<XinTiSPFDentity> TeamarrsShowQuery() {
        ArrayList<XinTiSPFDentity> spfdlist = new ArrayList<XinTiSPFDentity>();
        //胆值集合
        List<Boolean> isdanarr = new ArrayList<Boolean>();
        //方案号集合
        List<String> matcharr = new ArrayList<String>();

        XinTiSPFDentity spfentity = new XinTiSPFDentity();
        for (int i = 0; i < listtest.size(); i++) {
            if (listl.get(i) || listc.get(i) || listr.get(i)) {

                spfentity.setHomename(listtest.get(i).getHomeTeamName());
                spfentity.setGuestname(listtest.get(i).getGuestTeamName());

                spfentity.setS_z_sp("胜 " + listtest.get(i).getSP_Win_Odds_BRQ());

                spfentity.setP_z_sp("平 " + listtest.get(i).getSP_Flat_Odds_BRQ());

                spfentity.setF_z_sp("负 " + listtest.get(i).getSP_Lose_Odds_BRQ());
                //获取方案号
                spfentity.setMatcharr(listtest.get(i).getMatchId());
                spfentity.setIssusenumber("");
                spfentity.setGametypearr("BRQSPF");
                if (listl.get(i)) {
                    spfentity.setS_z(true);

                }
                if (listc.get(i)) {
                    spfentity.setP_z(true);
                }
                if (listr.get(i)) {
                    spfentity.setF_z(true);
                }
                if (listd.get(i)) {
                    spfentity.setD_z(true);
                }
                spfdlist.add(spfentity);
            }

        }
        return spfdlist;
    }

    /**
     * 用户选择数据
     */
    private static final String WIN_Z = "3";
    private static final String Flat_Z = "1";
    private static final String LOSE_Z = "0";

    public ArrayList<String> TeamarrsQuery() {
        ArrayList<String> UserChoicetemp = new ArrayList<String>();
        ArrayList<String> UserChoicearrs = new ArrayList<String>();
        for (int i = 0; i < listtest.size(); i++) {
            String temp = "";

            if (listl.get(i)) {
                temp += "," + WIN_Z;
            }
            if (listc.get(i)) {
                temp += "," + Flat_Z;
            }
            if (listr.get(i)) {
                temp += "," + LOSE_Z;
            }
            if (temp.length() != 0) {

                UserChoicetemp.add(temp);
            }
        }
        for (int i = 0; i < UserChoicetemp.size(); i++) {
            if (UserChoicetemp.get(i).length() != 0) {
                String temp2 = UserChoicetemp.get(i).substring(1);
                UserChoicearrs.add(temp2);
            }

        }
        return UserChoicearrs;
    }

    /**
     * 选择总球场集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceAllTeamarr;

    public ArrayList<ArrayList<Object>> JsAllTeam() {
        arrchoiceAllTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < listtest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (listl.get(i)) {
                moneytemp.add(WIN_Z);
            }
            if (listc.get(i)) {

                moneytemp.add(Flat_Z);
            }
            if (listr.get(i)) {
                moneytemp.add(LOSE_Z);
            }
            if (moneytemp.size() != 0) {
                arrchoiceAllTeamarr.add(moneytemp);
            }

        }
        return arrchoiceAllTeamarr;
    }

    /**
     * 选择的胆集合球场数
     */
    private ArrayList<ArrayList<Object>> arrchoiceDanTeamarr;

    public ArrayList<ArrayList<Object>> JsDanTeam() {
        arrchoiceDanTeamarr = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < listtest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (listd.get(i)) {
                if (listl.get(i)) {
                    moneytemp.add(WIN_Z);
                }
                if (listc.get(i)) {

                    moneytemp.add(Flat_Z);
                }
                if (listr.get(i)) {
                    moneytemp.add(LOSE_Z);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDanTeamarr.add(moneytemp);
                }
            }

        }
        return arrchoiceDanTeamarr;
    }

    /**
     * 选择的除胆的集合
     */
    private ArrayList<ArrayList<Object>> arrchoiceDeleteDanTeam;

    public ArrayList<ArrayList<Object>> JsDeleteDanTeam() {
        arrchoiceDeleteDanTeam = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> moneytemp;
        for (int i = 0; i < listtest.size(); i++) {
            moneytemp = new ArrayList<Object>();
            if (!listd.get(i)) {
                if (listl.get(i)) {
                    moneytemp.add(WIN_Z);
                }
                if (listc.get(i)) {

                    moneytemp.add(Flat_Z);
                }
                if (listr.get(i)) {
                    moneytemp.add(LOSE_Z);
                }
                if (moneytemp.size() != 0) {
                    arrchoiceDeleteDanTeam.add(moneytemp);
                }
            }
        }
        return arrchoiceDeleteDanTeam;
    }

    /**
     * 日期筛选
     */
    private String datestr;

    public String JIEdate() {
        return datestr;
    }
}
