package com.fleaphpnet.caiyuntong;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;

import com.fleaphpnet.view.BaseActivity;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;

public class GuideActivity extends BaseActivity {
    private ListView mGuideListView;
    private GuideAdapter mGuideAdapter;
    private TextView mGuideTitle;
    private JSONObject mGuideBook;
    private JSONArray mGuideList;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_guide);

        String guideCategory = null;
        try {
            guideCategory = getIntent().getExtras().getString("category");
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (guideCategory == null) {
            guideCategory = "about";
        }
        mGuideListView = (ListView) findViewById(R.id.guide_list);
        mGuideTitle = (TextView) findViewById(R.id.guide_title);
        mGuideTitle.setText("帮助");

        InputStream in;
        String s = null;
        try {
            in = getResources().getAssets().open("GuideBook.json");
            int len = in.available();
            byte[] b = new byte[len];
            in.read(b, 0, len);
            s = new String(b);
            mGuideBook = new JSONObject(s);
            mGuideList = mGuideBook.getJSONArray(guideCategory);

            mGuideAdapter = new GuideAdapter();
            mGuideListView.setAdapter(mGuideAdapter);
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
            if (BuildConfig.DEBUG) Log.e("asd", "教程文件读取错误", e);
        }

        // 返回按钮
        Button backBtn = (Button) findViewById(R.id.more_about_back);
        backBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                GuideActivity.this.finish();
            }
        });
    }

    class GuideAdapter extends BaseAdapter {
        @Override
        public int getCount() {
            return mGuideList.length();
        }

        @Override
        public JSONObject getItem(int position) {
            try {
                return mGuideList.getJSONObject(position);
            } catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from(GuideActivity.this).inflate(R.layout.item_guide, null);
            }
            TextView titleText = (TextView) convertView.findViewById(R.id.item_guide_title);
            TextView contentText = (TextView) convertView.findViewById(R.id.item_guide_content);
            try {
                JSONObject GuideInfo = (JSONObject) mGuideList.get(position);
                titleText.setText(GuideInfo.getString("title"));
                String type = GuideInfo.getString("type");
                if (type.equals("text")) {
                    contentText.setText(GuideInfo.getString("content"));
                } else {
                    GuideInfo.getString("content");
                    contentText.setBackgroundResource(R.drawable.lottery_liucheng);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return convertView;
        }
    }
}
