package com.fleaphpnet.caiyuntong;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.fleaphpnet.caiyuntong.component.BaseActivity;

/**
 * Created by lizf on 2014/4/17.
 */
public class WebActivity extends BaseActivity {
    private WebView webView;
    private ProgressBar webProgress;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.web);
        //webView = (WebView) findViewById(R.id.web_content);
        //webProgress = (ProgressBar) findViewById(R.id.web_progress);
        webProgress.setVisibility(View.VISIBLE);
        Intent mIntent = getIntent();
        Bundle bundle = mIntent.getExtras();
        //        webView.getSettings().setTextZoom(WebSettings.TextSize.LARGER);
        //        webView.getSettings().setDefaultFontSize();
        //        webView.getSettings().setDefaultTextEncodingName("utf-8");
        webView.getSettings().setLoadsImagesAutomatically(true);
        //        setStandardFontFamily
        webView.setWebChromeClient(new WebChromeClient() {
            public void onProgressChanged(WebView view, int progress) {
                // Activities and WebViews measure progress with different scales.
                // The progress meter will automatically disappear when we reach 100%
                webProgress.setProgress(progress);
                if (progress == 100) {
                    webProgress.setVisibility(View.GONE);
                }
            }
        });
        webView.setWebViewClient(new WebViewClient() {
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                //                Toast.makeText(activity, "Oh no! " + description, Toast.LENGTH_SHORT).show();
            }
        });
        //        webView.setOnTouchListener(new View.OnTouchListener() {
        //            @Override
        //            public boolean onTouch(View view, MotionEvent motionEvent) {
        //                return true;
        //            }
        //        });

        if (bundle != null) {
            String url = bundle.getString("url");
            webView.loadUrl(url);
        } else {
            webView.loadDataWithBaseURL("file:///android_assert", "内容没有找到！", "text/plain", "UTF-8", "");
        }
    }
}
