package com.fleaphpnet.caiyuntong.component;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import  android.util.*;


import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.BinaryHttpResponseHandler;
import com.loopj.android.http.JsonHttpResponseHandler;
import com.loopj.android.http.RequestParams;

import org.apache.http.*;
import org.apache.http.client.*;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.*;

import java.io.*;
import java.util.*;

public class HttpUtils {

    public final static String UTF8 = "UTF-8";

    static final String state = Environment.getExternalStorageState();
    public static String SDCARD = "";
    private static AsyncHttpClient client = new AsyncHttpClient();

    static {
        client.setTimeout(10 * 1000);
        if (state.equals(Environment.MEDIA_MOUNTED) || state.equals(Environment.MEDIA_MOUNTED_READ_ONLY)) {// sd card is ready to us
            SDCARD = Environment.getExternalStorageDirectory().getAbsolutePath();
        } else {
            Log.e("SDCARD_READY", "无sd卡");
        }
    }
//
//    public static RequestParams getRequestParams(Context context){
//
//        RequestParams params  = new RequestParams();
//        params.put("client_id", CLIENT_ID);
//        try {
//            SharedPreferences sp=  context.getSharedPreferences("customset",Context.MODE_PRIVATE);
//            String access_token = sp.getString("access_token",null);
//
//            if(access_token != null)
//                params.put("access_token",access_token);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return params;
//    }

//    private static RequestParams initParams(RequestParams params) {
//
//        if (null == params)
//            params = new RequestParams();
//        params.put("client_id", CLIENT_ID);
//        return params;
//
//    }

    public static void get(String url, AsyncHttpResponseHandler response) {

        client.get(url, response);
    }

    public static void get(String url, RequestParams params, AsyncHttpResponseHandler response) {

        client.get(url, params, response);
    }

    public static void get(String url, RequestParams params, JsonHttpResponseHandler json) {
        client.get(url, params, json);
    }

    public static void get(String url, RequestParams params, int timeOutSecond, JsonHttpResponseHandler responseHandler) {
        client.setTimeout(timeOutSecond * 1000);
        client.get(url, params, responseHandler);
    }

    public static void get(String url, RequestParams params, BinaryHttpResponseHandler binary) {
        client.get(url, params, binary);
    }

    public static void post(String url, RequestParams params, AsyncHttpResponseHandler responseHandler) {
        client.post(url, params, responseHandler);
    }

    public static void post(Context context, String url, HttpEntity params, AsyncHttpResponseHandler responseHandler) {
        client.post(context, url, params, "application/json", responseHandler);
    }

    public static void post(String url, RequestParams params, JsonHttpResponseHandler responseHandler) {
        client.post(url, params, responseHandler);
    }

    public static void post(String url, RequestParams params, int timeOutSecond, JsonHttpResponseHandler responseHandler) {
        client.setTimeout(timeOutSecond * 1000);
        client.post(url, params, responseHandler);
    }

    public static InputStream getStream(String url) {
        return HttpUtils.getStream(url, null);
    }

    public static InputStream getStream(String url, HashMap params) {
        if (null != params && !params.isEmpty()) {
            Iterator<?> iter = params.entrySet().iterator();
            url += "?";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                url += key + "=" + val + "&";
            }
        }

        Log.e("UTL:",url);
        HttpGet request = new HttpGet(url);
        HttpClient httpClient = getHttpClient();
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute(request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.SC_OK) {
                HttpEntity responseHttpEntity = httpResponse.getEntity();
                return responseHttpEntity.getContent();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Bitmap getImg(String url) {
        InputStream in = HttpUtils.getStream(url);
        if (null == in)
            return null;
        return BitmapFactory.decodeStream(in);
    }


    public static String httpGet(String url, HashMap params) throws Exception {

        String result = "";
        InputStream in = HttpUtils.getStream(url, params);
        result = getData(in, HttpUtils.UTF8);
        result = decodeUnicode(result);

        return result;
    }

    public static String httpPost(String url, HashMap params) throws Exception {
        String result = "";
        HttpPost request = new HttpPost(url);
        HttpParams httpParams = new BasicHttpParams();
        if (null != params && !params.isEmpty()) {

            List<NameValuePair> postParameters = new ArrayList<NameValuePair>();
            Iterator<?> iter = params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                postParameters.add(new BasicNameValuePair((String) key, (String) val));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(postParameters);
            request.setEntity(formEntity);

        }
        request.setParams(httpParams);

        HttpClient httpClient = getHttpClient();
        // 接受客户端发回的响应
        HttpResponse httpResponse = httpClient.execute(request);
        // httpResponse.getAllHeaders();

        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == HttpStatus.SC_OK) {
            // 得到客户段响应的实体内容
            HttpEntity responseHttpEntity = httpResponse.getEntity();
            // 得到输入流
            InputStream in = responseHttpEntity.getContent();
            // 得到输入流的内容
            result = getData(in, HttpUtils.UTF8);
            // 轉換unicode
            result = decodeUnicode(result);
        }
        return result;
    }

    private static HttpClient getHttpClient() {
        HttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, 30 * 1000);
        HttpConnectionParams.setSoTimeout(httpParams, 30 * 1000);
        HttpConnectionParams.setSocketBufferSize(httpParams, 8192);
        HttpClientParams.setRedirecting(httpParams, true);
        // String userAgent =
        // "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Ubuntu Chromium/28.0.1500.71 Chrome/28.0.1500.71 Safari/537.36";
        // HttpProtocolParams.setUserAgent(httpParams, userAgent);
        return new DefaultHttpClient(httpParams);
    }

    private static String getData(InputStream in, String encode) throws Exception {
        InputStreamReader inreader = new InputStreamReader(in, encode);
        BufferedReader breader = new BufferedReader(inreader);
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = breader.readLine()) != null) {
            sb.append(line + "\n");
        }
        inreader.close();
        breader.close();
        return sb.toString();
    }


    // 将带\u0000的string 转换为中文
    public static String decodeUnicode(String theString) {
        char aChar;
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        for (int x = 0; x < len; ) {
            aChar = theString.charAt(x++);
            if (aChar == '\\') {
                aChar = theString.charAt(x++);
                if (aChar == 'u') {
                    int value = 0;
                    for (int i = 0; i < 4; i++) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case '0':
                            case '1':
                            case '2':
                            case '3':
                            case '4':
                            case '5':
                            case '6':
                            case '7':
                            case '8':
                            case '9':
                                value = (value << 4) + aChar - '0';
                                break;
                            case 'a':
                            case 'b':
                            case 'c':
                            case 'd':
                            case 'e':
                            case 'f':
                                value = (value << 4) + 10 + aChar - 'a';
                                break;
                            case 'A':
                            case 'B':
                            case 'C':
                            case 'D':
                            case 'E':
                            case 'F':
                                value = (value << 4) + 10 + aChar - 'A';
                                break;
                            default:
                                throw new IllegalArgumentException("Malformed      encoding.");
                        }
                    }
                    outBuffer.append((char) value);
                } else {
                    if (aChar == 't') {
                        aChar = '\t';
                    } else if (aChar == 'r') {
                        aChar = '\r';
                    } else if (aChar == 'n') {
                        aChar = '\n';
                    } else if (aChar == 'f') {
                        aChar = '\f';
                    }
                    outBuffer.append(aChar);
                }
            } else {
                outBuffer.append(aChar);
            }
        }
        return outBuffer.toString();
    }
}
