package com.fleaphpnet.caiyuntong.component;

import java.text.*;
import java.util.Date;

/**
 * TimeUtils
 * 
 */
public class TimeUtils {

    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT_DATE    = new SimpleDateFormat("yyyy-MM-dd");

    /**
     * long time to string
     * 
     * @param timeInMillis
     * @param dateFormat
     * @return
     */
    public static String getTime(long timeInMillis, SimpleDateFormat dateFormat) {
        return dateFormat.format(new Date(timeInMillis));
    }

    /**
     * long time to string, format is {@link #DEFAULT_DATE_FORMAT}
     * 
     * @param timeInMillis
     * @return
     */
    public static String getTime(long timeInMillis) {
        return getTime(timeInMillis, DEFAULT_DATE_FORMAT);
    }

    /**
     * get current time in milliseconds
     * 
     * @return
     */
    public static long getCurrentTimeInLong() {
        return System.currentTimeMillis();
    }

    /**
     * get current time in milliseconds, format is {@link #DEFAULT_DATE_FORMAT}
     * 
     * @return
     */
    public static String getCurrentTimeInString() {
        return getTime(getCurrentTimeInLong());
    }

    /**
     * get current time in milliseconds
     * 
     * @return
     */
    public static String getCurrentTimeInString(SimpleDateFormat dateFormat) {
        return getTime(getCurrentTimeInLong(), dateFormat);
    }

    public static Date getToday(){
        String today =  DATE_FORMAT_DATE.format(new Date());
        ParsePosition pos = new ParsePosition(0);
        Date date = DATE_FORMAT_DATE.parse(today, pos);
        return  date;
    }

    public static String getTodayString () {
        String today =  DATE_FORMAT_DATE.format(new Date());
        return today;
    }

    public static Date getTommorrow(){
        Date date = getToday();
        date.setDate(date.getDate()+1);
        return date;
    }

    public static String getTimeString(Date date){
        if(null ==  date)
            return null;
        return  DATE_FORMAT_DATE.format(date);
    }
    public static Date getStringTime(String str) throws ParseException {
        return DATE_FORMAT_DATE.parse(str);
    }
}
