package com.fleaphpnet.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

public class ZJQDialog extends Dialog {
    public ZJQDialog(Context context, int theme) {
        super(context, theme);
        // TODO Auto-generated constructor stub  
    }

    /**
     * @param context NewDialog的上下文
     * @param theme   NewDialog的显示主题，比如可以是noTitile等
     * @param view    NewDialog的view
     * @author Jasonzhou
     */
    public ZJQDialog(Context context, int theme, View view) {
        super(context, theme);
        setContentView(view);
        Window wi = getWindow();

        WindowManager.LayoutParams params = wi.getAttributes();
        params.gravity = Gravity.CENTER_HORIZONTAL | Gravity.BOTTOM;
    }

    /**
     * @param context NewDialog的上下文
     * @param theme   NewDialog的显示主题，比如可以是noTitile等
     * @param view    NewDialog的view
     * @param width   NewDialog的宽度
     * @param height  NewDialog的高度
     * @author Jasonzhou
     */
    public ZJQDialog(Context context, int theme, int view, int width,
                     int height) {
        super(context, theme);
        setContentView(view);
        // set window params  
        Window window = getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        // set width,height by density and gravity  
        float density = getDensity(context);
        params.width = (int) (width * density);
        params.height = (int) (height * density);
        params.gravity = Gravity.CENTER;
        window.setAttributes(params);
    }

    private float getDensity(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        return dm.density;
    }
}
