package com.fleaphpnet.view;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.fleaphpnet.Hemai.XinTiHemai_item_choice;
import com.fleaphpnet.caiyuntong.R;

public class HeMaiActivity extends BaseActivity {
    private int[] mLotteryTypeDrawable;
    private String[] mLotteryTypeName;
    private ListView mLotteryTypeListView;
    private LotteryTypeAdapter mLotteryTypeAdapter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_hemai);
        // 初始化资源
        mLotteryTypeName = getResources().getStringArray(R.array.hemai_lottery_type_name);
        mLotteryTypeDrawable = new int[mLotteryTypeName.length];
        TypedArray imgs = getResources().obtainTypedArray(R.array.hemai_lottery_type_drawable);
        for ( int i = 0; i < imgs.length(); ++i ) {
            mLotteryTypeDrawable[i] = imgs.getResourceId(i, -1);
        }

        // 初始化界面
        mLotteryTypeListView = (ListView) findViewById(R.id.hegoulistviewid);
        mLotteryTypeAdapter = new LotteryTypeAdapter();
        mLotteryTypeListView.setAdapter(mLotteryTypeAdapter);
        mLotteryTypeListView.setDividerHeight(0);
        mLotteryTypeListView.setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                if (arg2 < 6) {
                    Intent intent = new Intent();
                    intent.setClass(HeMaiActivity.this, XinTiHemai_item_choice.class);
                    intent.putExtra("CaiZhongName", mLotteryTypeName[arg2]);
                    intent.putExtra("CaiZhongbianhao", arg2);
                    startActivity(intent);
                } else {
                    Toast.makeText(HeMaiActivity.this, "功能未实现", Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    class LotteryTypeAdapter extends BaseAdapter {
        ImageView mImagView;
        TextView mTextView;
        public int getCount() {
            return mLotteryTypeName.length;
        }

        public Object getItem(int position) {
            return mLotteryTypeName[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = LayoutInflater.from(HeMaiActivity.this).inflate(R.layout.mainlistview_item, null);
            }
            mImagView = (ImageView) convertView.findViewById(R.id.hemailogoimagerid);
            mImagView.setImageResource(mLotteryTypeDrawable[position]);
            mTextView = (TextView) convertView.findViewById(R.id.hemaicontextid);
            mTextView.setText(mLotteryTypeName[position]);
            return convertView;
        }

    }
}
