package com.fleaphpnet.view;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager.LayoutParams;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.fleaphpnet.Dao.XinTiEntityDao;
import com.fleaphpnet.XinTiJson;
import com.fleaphpnet.XinTiPostQuery;
import com.fleaphpnet.XinTiRequestcode;
import com.fleaphpnet.adapter.Loadingprogressdialog;
import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.dialog.ZJQDialog;
import com.fleaphpnet.entity.XinTiVersionEntity;
import com.fleaphpnet.msg.XinTiUserphone;

import org.apache.http.NameValuePair;
import org.json.JSONObject;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class XinTiDialogVersion extends BaseActivity {
    private String urlconn = "http://xinticai.com/Android/xinticai.apk";
    XinTiEntityDao entitydao = new XinTiEntityDao();
    private Loadingprogressdialog progressDialog = null;
    private Context mContext;

    public XinTiDialogVersion(Context mconn) {
        super();
        this.mContext = mconn;
    }

    //    public void VersioStart(){
    //        new Thread(new CheckVersionTask()).start();
    //    }

    public void VersionDialogMethod() {
        new AsyncTask<String, String, XinTiVersionEntity>() {
            private void startProgressDialog() {

                if (progressDialog == null) {
                    progressDialog = Loadingprogressdialog.createDialog(mContext);
                    progressDialog.setCancelable(false);
                    progressDialog.setMessage("正在加载中...");

                }

                progressDialog.show();

            }

            private void stopProgressDialog() {

                if (progressDialog != null) {
                    progressDialog.dismiss();

                    progressDialog = null;

                }

            }

            @Override
            protected void onCancelled() {

                stopProgressDialog();

                super.onCancelled();
            }

            @Override
            protected void onPreExecute() {

                startProgressDialog();

            }

            /*	@Override
                protected List<XinTiVersionEntity> doInBackground(String... params) {
                    // TODO Auto-generated method stub
                    List<XinTiVersionEntity> versionlist=null;
                    try{
                    List<NameValuePair> namevalue = XinTiJson.Zeroparameter0(XinTiRequestcode.XinTi_SJ, "xintishengji");
                    JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
                    versionlist=entitydao.SelecVersion(jsonobj.toString());
                    }catch (Exception e) {
                        e.printStackTrace();
                        stopProgressDialog();
                    }
                    return versionlist;
                }
    */
            @Override
            protected void onPostExecute(XinTiVersionEntity result) {
                // TODO Auto-generated method stub
                stopProgressDialog();
                try {
                    XinTiUserphone userversion = new XinTiUserphone(mContext);
                    if (!userversion.getVersion().trim().equals(result.getVersion())) {
                        VersionDialog(result.getArrs());
                        //new Thread(new CheckVersionTask(result)).start();
                        //startActivity(new Intent().setClass(AboutActivity.this, XinTihightTestVersion.class));
                        //VersionDialog(result.get(0).getArrs());
                        //new Thread(new CheckVersionTask(result)).start();
                    /*	}else{
                    //VersionDialog(result.get(0).getArrs());
					Toast.makeText(mContext, "未检测到新版本！", 200).show();
				}*/
                    } else {
                        Toast.makeText(mContext, "未检测到新版本！", 200).show();
                    }
                } catch (NullPointerException e) {
                    e.printStackTrace();
                    stopProgressDialog();
                } catch (Exception e) {
                    e.printStackTrace();
                    stopProgressDialog();
                }
                super.onPostExecute(result);
            }

            @Override
            protected XinTiVersionEntity doInBackground(String... params) {
                XinTiVersionEntity versionlist = null;
                try {
                    List<NameValuePair> namevalue = XinTiJson.Zeroparameter0(XinTiRequestcode.XinTi_SJ, "xintishengji");
                    JSONObject jsonobj = XinTiPostQuery.UserRegister(namevalue);
                    versionlist = entitydao.SelecVersion(jsonobj.toString());
                } catch (Exception e) {
                    e.printStackTrace();
                    stopProgressDialog();
                }
                return versionlist;
            }

        }.execute();
    }

    /**
     * 升级弹窗
     */
    private Dialog dialogVersion;
    private CheckBox mchecksj;
    private SharedPreferences mshared;
    private TextView tesj, wangzhi;
    private ProgressBar progress;
    //下载的点击事件
    private Button btnok;
    //是否停止下载
    private boolean stopversion;

    public void VersionDialog(final ArrayList<String> contenats) {
        stopversion = true;
        dialogVersion = new ZJQDialog(mContext, R.style.Theme_dialog,
                R.layout.dialog_item_version, LayoutParams.FILL_PARENT,
                LayoutParams.FILL_PARENT);
        dialogVersion.getWindow().setGravity(Gravity.CENTER);

        mshared = mContext.getSharedPreferences("test", 0);
        mchecksj = (CheckBox) dialogVersion.findViewById(R.id.shengjicheck);
        mchecksj.setChecked(mshared.getBoolean("sjcheck", false));

        wangzhi = (TextView) dialogVersion.findViewById(R.id.wangzhi);
        wangzhi.setOnClickListener(new internetonclick(urlconn));
        progress = (ProgressBar) dialogVersion.findViewById(R.id.progress_bar);
        ListView mlist = (ListView) dialogVersion.findViewById(R.id.dialog_content);
        BaseAdapter adapter = new BaseAdapter() {

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                if (convertView == null) {
                    convertView = LinearLayout.inflate(mContext, R.layout.dialog_item_version_item, null);
                }
                TextView textid, textcontent;
                textid = (TextView) convertView.findViewById(R.id.contenttextpostionid);
                textcontent = (TextView) convertView.findViewById(R.id.contenttextid);
                textid.setText(position + ".");
                textcontent.setText(contenats.get(position));
                return convertView;
            }

            @Override
            public long getItemId(int position) {
                // TODO Auto-generated method stub
                return 0;
            }

            @Override
            public Object getItem(int position) {
                // TODO Auto-generated method stub
                return null;
            }

            @Override
            public int getCount() {
                // TODO Auto-generated method stub
                return contenats.size();
            }
        };
        mlist.setAdapter(adapter);
        mlist.setDividerHeight(0);
        btnok = (Button) dialogVersion.findViewById(R.id.dialog_button_ok);
        Button btncancel = (Button) dialogVersion.findViewById(R.id.dialog_button_cancel);
        btnok.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                // TODO Auto-generated method stub
                //dialogVersion.dismiss();
                down();
				/* new Thread(new Runnable() {
					public void run() {
						try {
							
							File file= XinTiDialogVersion.getFileFromServer(urlconn, progress,btnok,mContext,stopversion);
							Thread.sleep(3000);  
							btnok.setEnabled(true);
				            installApk(file);  
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
				}).start();*/


            }
        });
        btncancel.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                // TODO Auto-generated method stub
                stopversion = false;
                dialogVersion.dismiss();
            }
        });

        mchecksj.setOnCheckedChangeListener(new OnCheckedChangeListener() {

            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                SharedPreferences.Editor msharecheck = mshared.edit();
                msharecheck.putBoolean("sjcheck", isChecked);
                msharecheck.commit();
            }
        });
        dialogVersion.show();

    }

    /**
     * 访问andorid内置浏览器
     */
    class internetonclick implements OnClickListener {
        private String ul;

        public internetonclick(String ul) {
            super();
            this.ul = ul;
        }

        @Override
        public void onClick(View v) {
            // TODO Auto-generated method stub
            final Uri uri = Uri.parse(ul);
            final Intent it = new Intent(Intent.ACTION_VIEW, uri);

            Timer timer = new Timer();
            TimerTask task = new TimerTask() {
                @Override
                public void run() {
                    mContext.startActivity(it); //执行
                }
            };
            timer.schedule(task, 1); //10秒后
        }

    }

    //获取进度下载进度
    public static File getFileFromServer(String path, ProgressBar pd, Button btn, Context mconn, boolean isflag) throws Exception {
        //如果相等的话表示当前的sdcard挂载在手机上并且是可用的
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            int fileLength = conn.getContentLength();
            conn.setConnectTimeout(5000);
            //获取到文件的大小
            pd.setMax(conn.getContentLength());
            InputStream is = conn.getInputStream();
            File file = new File(Environment.getExternalStorageDirectory(), "updata.apk");
            FileOutputStream fos = new FileOutputStream(file);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buffer = new byte[1024];
            int len;
            int total = 0;
            while ((len = bis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
                total += len;
                //获取当前下载量
                pd.setProgress(total);
                btn.setEnabled(false);

            }
            fos.close();
            bis.close();
            is.close();
            return file;
        } else {
            Toast.makeText(mconn, "请插入内存卡！", 1000).show();
            return null;
        }
    }


    //private ProgressBar bar;
    OutputStream output;// 输入出流
    Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            super.handleMessage(msg);
            switch (msg.what) {
                case 0:
                    progress.setVisibility(View.VISIBLE);
                    break;
                case 1:
                    System.out.println("--------------->" + msg.arg1);
                    String barnum = msg.arg1 + "%";
                    btnok.setText("更新" + barnum);

                    progress.setProgress(msg.arg1);
                    if (msg.arg1 == 100) {
                        btnok.setEnabled(true);
                        try {
                            Thread.sleep(1000);
                            installApk(file);
                        } catch (InterruptedException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }

                    }
                    break;
            }
        }
    };
    private File file;

    // 下载方法 必须放在单独的线程里
    private void down() throws RuntimeException {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    Message m = handler.obtainMessage();
                    m.what = 0;
                    m.sendToTarget();
                    // 创建URL 写入下载地址
                    //URL url = new URL(urlconn);
                    // 创建HttpURLConnection
                    //HttpURLConnection urlcon = (HttpURLConnection) url.openConnection();
                    //或者上两句使用URLConnection connection = new URL("下载路径").
                    //openConnection(); 下面的urlcon 换成connection
                    // 获得文件大小
                    URLConnection connection = new URL(urlconn).openConnection();
                    long TotalSize = Long.parseLong(connection
                            .getHeaderField("Content-Length"));
                    // 获得文件大小
                    int fileLength = connection.getContentLength();
                    // 获得输入流
                    InputStream is = connection.getInputStream();
                    // 创建目录
                    File dir = new File("/mnt/sdcard/abc");
                    dir.mkdir();
                    // 创建文件
                    file = new File("/mnt/sdcard/abc/update.apk");
                    // 如果存在则删除
                    if (file.exists())
                        file.delete();
                    // 创建文件
                    file.createNewFile();
                    // 创建文件输入流
                    output = new FileOutputStream(file);
                    byte buffer[] = new byte[4 * 1024];
                    // 已下载
                    int downsize = 0;

                    while (stopversion) {
                        int down = is.read(buffer);
                        if (down == -1) {
                            break;
                        }
                        downsize += down;
                        output.write(buffer, 0, down);
                        Message m2 = handler.obtainMessage();
                        m2.what = 1;
                        // 提示已下载百分之多少
                        m2.arg1 = downsize * 100 / fileLength;
                        m2.sendToTarget();
                    }
                    // 清除缓存
                    output.flush();
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } finally {
                    try {
                        // 关闭输出流
                        output.close();
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
            }

        }).start();
    }

    //安装apk
    protected void installApk(File file) {
        Intent intent = new Intent();
        //执行动作
        intent.setAction(Intent.ACTION_VIEW);
        //执行的数据类型
        intent.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
        mContext.startActivity(intent);
    }


    /*
     * 进入程序的主界面
     */
    private void LoginMain() {
        Intent intent = new Intent(mContext, XinTiActivity.class);
        mContext.startActivity(intent);
        //结束掉当前的activity
        this.finish();
    }
}
