package com.fleaphpnet.view;

import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.Toast;

import com.fleaphpnet.caiyuntong.R;
import com.fleaphpnet.entity.XinTiVersionEntity;
import com.fleaphpnet.msg.XinTiUserphone;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class XinTihightVersion extends BaseActivity {
    private String urlconn = "http://xinticai.com/Android/xinticai.apk";

    //private ProgressBar progressBar;
    private Button btnproess;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // TODO Auto-generated method stub
        super.onCreate(savedInstanceState);
        setContentView(R.layout.xinti_gonggaotishi);
        Window windows = this.getWindow();
        windows.setWindowAnimations(R.style.ctzqmystyle);
        windows.setGravity(Gravity.BOTTOM);
        windows.setBackgroundDrawableResource(R.style.passworddialog);
        SHITI();
    }

    private void SHITI() {
        btnproess = (Button) findViewById(R.id.gonggaoandshengji_btn);
        btnproess.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                // TODO Auto-generated method stub
                new Thread(new CheckVersionTask()).start();
            }
        });
    }

    /*
     * 从服务器获取xml解析并进行比对版本号
     */
    private int UPDATA_CLIENT = 0;
    private int GET_UNDATAINFO_ERROR = 1;
    private int DOWN_ERROR = 2;

    public class CheckVersionTask implements Runnable {

        public void run() {
            try {
                XinTiVersionEntity versionn = new XinTiVersionEntity();
                XinTiUserphone userphone = new XinTiUserphone(XinTihightVersion.this);
                if (versionn.getVersion().equals(userphone.getVersion())) {

                    LoginMain();
                } else {
                    Message msg = new Message();
                    msg.what = UPDATA_CLIENT;
                    handler.sendMessage(msg);
                }
            } catch (Exception e) {
                // 待处理
                Message msg = new Message();
                msg.what = GET_UNDATAINFO_ERROR;
                handler.sendMessage(msg);
                e.printStackTrace();
            }
        }
    }

    Handler handler = new Handler() {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            super.handleMessage(msg);
            switch (msg.what) {
                case 0:
                    //对话框通知用户升级程序
                    showUpdataDialog();
                    break;
                case 1:
                    //服务器超时
                    Toast.makeText(getApplicationContext(), "获取服务器更新信息失败", 1).show();
                    LoginMain();
                    break;
                case 2:
                    //下载apk失败
                    Toast.makeText(getApplicationContext(), "下载新版本失败", 1).show();
                    LoginMain();
                    break;
            }
        }
    };

    public static File getFileFromServer(String path, ProgressDialog pd) throws Exception {
        //如果相等的话表示当前的sdcard挂载在手机上并且是可用的
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setConnectTimeout(5000);
            //获取到文件的大小
            pd.setMax(conn.getContentLength());
            InputStream is = conn.getInputStream();
            File file = new File(Environment.getExternalStorageDirectory(), "updata.apk");
            FileOutputStream fos = new FileOutputStream(file);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buffer = new byte[1024];
            int len;
            int total = 0;
            while ((len = bis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
                total += len;
                //获取当前下载量
                pd.setProgress(total);
            }
            fos.close();
            bis.close();
            is.close();
            return file;
        } else {
            return null;
        }
    }

    /*
     *
     * 弹出对话框通知用户更新程序
     *
     * 弹出对话框的步骤：
     *  1.创建alertDialog的builder.
     *  2.要给builder设置属性, 对话框的内容,样式,按钮
     *  3.通过builder 创建一个对话框
     *  4.对话框show()出来
     */
    protected void showUpdataDialog() {
        AlertDialog.Builder builer = new Builder(this);
        builer.setTitle("版本升级");
        builer.setMessage("替换新版本！");
        //当点确定按钮时从服务器上下载 新的apk 然后安装
        builer.setPositiveButton("", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                // TODO Auto-generated method stub
                downLoadApk();
            }
        });
        builer.setNegativeButton("取消", new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                // TODO Auto-generated method stub
                LoginMain();
            }
        });
        AlertDialog dialog = builer.create();
        dialog.show();
    }


    /*
     * 从服务器中下载APK
     */
    protected void downLoadApk() {
        final ProgressDialog pd;    //进度条对话框
        pd = new ProgressDialog(this);
        pd.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
        pd.setMessage("正在下载更新");
        pd.show();
        new Thread() {
            @Override
            public void run() {
                try {
                    File file = XinTihightVersion.getFileFromServer(urlconn, pd);
                    sleep(3000);
                    installApk(file);
                    pd.dismiss(); //结束掉进度条对话框
                } catch (Exception e) {
                    Message msg = new Message();
                    msg.what = DOWN_ERROR;
                    handler.sendMessage(msg);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    //安装apk
    protected void installApk(File file) {
        Intent intent = new Intent();
        //执行动作
        intent.setAction(Intent.ACTION_VIEW);
        //执行的数据类型
        intent.setDataAndType(Uri.fromFile(file), "application/vnd.android.package-archive");
        startActivity(intent);
    }

    /*
     * 进入程序的主界面
     */
    private void LoginMain() {
        Intent intent = new Intent(this, XinTiActivity.class);
        startActivity(intent);
        //结束掉当前的activity
        this.finish();
    }
}
