package com.fleaphpnet.view;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;

import java.util.Stack;

/**
 * 应用程序Activity管理类
 *
 * @author liux
 *         权限添加
 *         <uses-permission android:name="android.permission.RESTART_PACKAGES" />
 *         <p/>
 *         Activity启动时，在的onCreate方法里面，将该Activity实例添加到AppManager的堆栈
 *         ZXExitManager.getAppManager().addActivity(this);
 *         <p/>
 *         需要退出程序时，调用
 *         ZXExitManager.getAppManager().AppExit(this);
 */
public class ZXExitManager {

    private static Stack<Activity> activityStack;
    private static ZXExitManager instance;

    private ZXExitManager() {
    }

    /**
     * 单一实例
     */
    public static ZXExitManager getAppManager() {
        if (instance == null) {
            instance = new ZXExitManager();
        }
        return instance;
    }

    /**
     * 添加Activity到堆栈
     */
    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack<Activity>();
        }
        activityStack.add(activity);
    }

    /**
     * 获取当前Activity（堆栈中最后一个压入的）
     */
    public Activity currentActivity() {
        Activity activity = activityStack.lastElement();
        return activity;
    }

    /**
     * 结束当前Activity（堆栈中最后一个压入的）
     */
    public void finishActivity() {
        Activity activity = activityStack.lastElement();
        if (activity != null) {
            activity.finish();
            activity = null;
        }
    }

    /**
     * 结束指定的Activity
     */
    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    /**
     * 结束指定类名的Activity
     */
    public void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (activity.getClass().equals(cls)) {
                finishActivity(activity);
            }
        }
    }

    /**
     * 结束所有Activity
     */
    public void finishAllActivity() {
        for (int i = 0, size = activityStack.size(); i < size; i++) {
            if (null != activityStack.get(i)) {
                activityStack.get(i).finish();
            }
        }
        activityStack.clear();
    }

    /**
     * 退出应用程序
     */
    public void AppExit(Context context) {
        try {
            finishAllActivity();
            ActivityManager activityMgr = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            activityMgr.restartPackage(context.getPackageName());
            System.exit(0);
        } catch (Exception e) {
        }
    }


    /**
     *
     * 退出程序的方法
     *
     */

/*	(1)     System.exit(0);

	(2)     Process.killProcess(Process.myPid());

	(3)     ActivityManager activityManager = (ActivityManager) this

	                  .getSystemService(Context.ACTIVITY_SERVICE);

	activityManager.restartPackage("packagename");*/


}
