package com.fleaphpnet.yijipay;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import com.fleaphpnet.caiyuntong.R;
import com.yiji.micropay.payplugin.YijixPayHelper;

public class PaypluginTestDemo extends Activity {

    private EditText mParterId;
    //private EditText mSellerAccount;
    private EditText mOderId;
    private EditText mSellerId;
    private EditText mNotofyUrl;
    private EditText mUserId;

    private Spinner mSpinnerMode;
    private EditText mTextPrice;
    private String mPluginMode = YijixPayHelper.MODE_PRODUCT;
    private SharedPreferences mPreferences;

    private static final int REQUEST_CODE_PAY = 100;
    private static final String TAG = "YijixPayClientDemo";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.v(TAG, "onCreate");

        setContentView(R.layout.activity_test_demo);

        mParterId = (EditText) findViewById(R.id.textPartnerId);
        //mSellerAccount = (EditText) findViewById(R.id.textSellerAccount);
        mOderId = (EditText) findViewById(R.id.textOrderNo);
        mSellerId = (EditText) findViewById(R.id.textSellerId);
        mNotofyUrl = (EditText) findViewById(R.id.textNotifyUrl);
        mUserId = (EditText) findViewById(R.id.textUserId);
        //mTradeName = (EditText) findViewById(R.id.tradeName);
        mSpinnerMode = (Spinner) findViewById(R.id.spinnerMode);

        mTextPrice = (EditText) findViewById(R.id.textPrice);

        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this, R.array.pay_modes, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        mSpinnerMode.setAdapter(adapter);

        //TextView label = (TextView) findViewById(R.id.labelSellerAccount);
        //label.setText("Seller\nAccount");

        mPreferences = getSharedPreferences("PaypluginTestDemo", MODE_PRIVATE);

        mParterId.setText(mPreferences.getString("partner", PartnerConfig.PARTNER_ID));
        mSellerId.setText(mPreferences.getString("seller", PartnerConfig.SELLER_ID));
        //mSellerAccount.setText(mPreferences.getString("account", PartnerConfig.SELLER_ACCOUNT));
        mOderId.setText(mPreferences.getString("orderId", PartnerConfig.ORDER_ID));
        mNotofyUrl.setText(mPreferences.getString("notifyUrl", "http://218.70.82.178:8630/gateway.html"));
        mUserId.setText(mPreferences.getString("userId", PartnerConfig.USER_ID));
        mSpinnerMode.setSelection(mPreferences.getInt("mode", 0));


        //设置支付模式
        mPluginMode = (0 == mSpinnerMode.getSelectedItemPosition() ? YijixPayHelper.MODE_PRODUCT : YijixPayHelper.MODE_TESTING);
        //mPluginMode=YijixPayHelper.MODE_TESTING;
        mSpinnerMode.setOnItemSelectedListener(new OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                mPluginMode = (0 == position ? YijixPayHelper.MODE_PRODUCT : YijixPayHelper.MODE_TESTING);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        //生成订单
        Button btnGetOrderId = (Button) findViewById(R.id.btnGetOrderId);
        btnGetOrderId.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {

                final ProgressDialog dialog = ProgressDialog.show(PaypluginTestDemo.this, "", "正在努力的生成订单中,请稍候...", true);

                new Thread() {
                    public void run() {

                        YijixPayHelper.OnGetTestOrderIdListner resultListner = new YijixPayHelper.OnGetTestOrderIdListner() {
                            @Override
                            public void onCreatedOrderId(final String orderId) {

                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        if (dialog.isShowing()) {
                                            dialog.dismiss();
                                        }
                                        if (null != orderId && orderId.length() > 0) {
                                            mOderId.setText(orderId);
                                        } else {
                                            showTipDialog("提示", "生成订单号失败", R.drawable.yjf_title_icon_error);
                                        }
                                    }
                                });
                            }
                        };

                        savePreferences();
                        Bundle params = new Bundle();
                        params.putString(YijixPayHelper.PARAM_PARTNER_ID, mParterId.getText().toString());
                        params.putString(YijixPayHelper.PARAM_SELLER_ID, mSellerId.getText().toString());
                        params.putString(YijixPayHelper.PARAM_NOTIFY_URL, mNotofyUrl.getText().toString());
                        params.putString(YijixPayHelper.PARAM_MODE, mPluginMode);
                        params.putString(YijixPayHelper.PARAM_PRICE, mTextPrice.getText().toString());

                        YijixPayHelper.createOrderId(PaypluginTestDemo.this, params, resultListner);

                    }

                    ;
                }.start();
            }
        });

        Button btnPay = (Button) findViewById(R.id.btnPay);
        btnPay.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                savePreferences();
                Bundle params = new Bundle();
                params.putString(YijixPayHelper.PARAM_PARTNER_ID, mParterId.getText().toString());
                params.putString(YijixPayHelper.PARAM_ORDER_ID, mOderId.getText().toString());
                params.putString(YijixPayHelper.PARAM_MODE, mPluginMode);
                params.putString(YijixPayHelper.PARAM_ACCESS_ID, PartnerConfig.ACCESS_ID);

                YijixPayHelper.startMacroPay(PaypluginTestDemo.this, REQUEST_CODE_PAY, params);
            }
        });

        Button btnTrustPay = (Button) findViewById(R.id.btnTrustPay);
        btnTrustPay.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                savePreferences();
                Bundle params = new Bundle();
                params.putString(YijixPayHelper.PARAM_PARTNER_ID, mParterId.getText().toString());
                params.putString(YijixPayHelper.PARAM_ORDER_ID, mOderId.getText().toString());
                params.putString(YijixPayHelper.PARAM_MODE, mPluginMode);
                params.putString(YijixPayHelper.PARAM_ACCESS_ID, PartnerConfig.ACCESS_ID);
                params.putString(YijixPayHelper.PARAM_USER_ID, mUserId.getText().toString());

                YijixPayHelper.startMacroPay(PaypluginTestDemo.this, REQUEST_CODE_PAY, params);

            }
        });

    }

    private void savePreferences() {
        SharedPreferences.Editor editor = mPreferences.edit();
        editor.putString("partner", mParterId.getText().toString());
        editor.putString("seller", mSellerId.getText().toString());
        //editor.putString("account", mSellerAccount.getText().toString());
        editor.putString("orderId", mOderId.getText().toString());
        editor.putString("notifyUrl", mNotofyUrl.getText().toString());
        editor.putString("userId", mUserId.getText().toString());
        editor.putInt("mode", mSpinnerMode.getSelectedItemPosition());
        editor.apply();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK && requestCode == REQUEST_CODE_PAY) {
            // 获取交易状态码，具体状态代码请参看文档
            int result = data.getIntExtra(YijixPayHelper.RESULT_CODE, -1);
            if (result == YijixPayHelper.RESULT_SUCCESS) {
                showTipDialog("提示", "支付成功，交易状态码：" + result, R.drawable.yjf_title_icon_info);
            } else if (result == YijixPayHelper.RESULT_CANCELLED) {
                showTipDialog("提示", "支付取消，交易状态码：" + result, R.drawable.yjf_title_icon_info);
            } else {
                showTipDialog("提示", "支付失败，交易状态码：" + result, R.drawable.yjf_title_icon_info);
            }
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            new AlertDialog.Builder(this).setTitle("提示").setMessage("您是否确定退出支付?").setNegativeButton("取消", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int which) {
                }
            }).setPositiveButton("确定", new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialog, int whichButton) {
                    finish();
                }

            }).show();

            return true;
        }

        return false;
    }

    public void showTipDialog(String title, String message, int titleIcon) {
        AlertDialog.Builder tDialog = new AlertDialog.Builder(this);
        tDialog.setTitle(title);
        tDialog.setMessage(message);
        tDialog.setIcon(titleIcon);
        tDialog.setPositiveButton("关闭", null);
        tDialog.show();
    }
}
