/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FunctionCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVCloud {
    public static void setProductionMode(boolean productionMode) {
        PaasClient.cloudInstance().setProduction(productionMode);
    }

    public static <T> T callFunction(String name, Map<String, ?> params) throws AVException {
        final AtomicReference reference = new AtomicReference();
        PaasClient.cloudInstance().postObject("functions/" + name, AVUtils.restfulServerData(params), true, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                reference.set(AVCloud.convertCloudResponse(content));
            }

            public void onFailure(Throwable error, String content) {
                LogUtil.log.d(content + error);
                AVExceptionHolder.add(AVErrorUtils.createException(error, content));
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)reference.get();
    }

    public static <T> void callFunctionInBackground(String name, Map<String, ?> params, final FunctionCallback<T> callback) {
        PaasClient.cloudInstance().postObject("functions/" + name, AVUtils.restfulServerData(params), false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (callback != null) {
                    callback.internalDone(AVCloud.convertCloudResponse(content), e);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone((Object)null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public static Object convertCloudResponse(String response) {
        Map resultMap = AVUtils.getFromJSON(response, Map.class);
        Object resultValue = resultMap.get("result");
        Object newResultValue = null;
        newResultValue = resultValue instanceof Collection ? AVUtils.getObjectFrom((Collection)resultValue) : (resultValue instanceof Map ? AVUtils.getObjectFrom((Map)resultValue) : resultValue);
        return newResultValue;
    }
}

