/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class AVOSCloud {
    public static Context applicationContext;
    public static String applicationId;
    public static String clientKey;
    protected static Handler handler;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 4;
    public static final int LOG_LEVEL_INFO = 8;
    public static final int LOG_LEVEL_WARNING = 16;
    public static final int LOG_LEVEL_ERROR = 32;
    public static final int LOG_LEVEL_NONE = -1;
    public static final String AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY = "AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY";
    public static final String AV_CLOUD_CACHE_EXPIRE_DATE_KEY = "AV_CLOUD_CACHE_EXPIRE_DATE_KEY";
    public static final Integer AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE;
    public static final String AV_CLOUD_CACHE_EXPIRE_KEY_ZONE = "AV_CLOUD_CACHE_EXPIRE_KEY_ZONE";
    private static int logLevel;
    private static boolean internalDebugLog;
    public static final int DEFAULT_NETWORK_TIMEOUT = 15000;
    public static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static int networkTimeoutInMills;
    private static int threadPoolSize;
    private static ServerHostList hostList;
    private static final String URL_HOST_LIST = "appHosts";
    private static StorageType storageType;

    public static void setNetworkTimeout(int timeoutInMills) {
        networkTimeoutInMills = timeoutInMills;
    }

    public static int getNetworkTimeout() {
        return networkTimeoutInMills;
    }

    public static int getThreadPoolSize() {
        return threadPoolSize;
    }

    public static void setThreadPoolSize(int size) {
        threadPoolSize = size;
    }

    private AVOSCloud() {
    }

    public static void initialize(Context context, String applicationId, String clientKey) {
        if (handler == null && !AVUtils.isMainThread()) {
            throw new IllegalStateException("Please call AVOSCloud.initialize in main thread.");
        }
        AVOSCloud.applicationId = applicationId;
        AVOSCloud.clientKey = clientKey;
        applicationContext = context;
        try {
            Class<?> statisticsClass = Class.forName("com.avos.avoscloud.AVAnalytics");
            Method startMethod = statisticsClass.getMethod("start", Context.class);
            startMethod.invoke(statisticsClass, context);
        }
        catch (Exception e) {
            LogUtil.avlog.i("statistics library not started since not included");
        }
        if (handler == null) {
            handler = new Handler();
        }
        if (AVPersistenceUtils.sharedInstance().getPersistentSettingBoolean(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY, true)) {
            AVCacheManager.clearCacheMoreThanDays(AVPersistenceUtils.sharedInstance().getPersistentSettingInteger(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_DATE_KEY, AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE));
        }
        if (!AVUtils.isBlankString((hostList = ServerHostList.getLocalInstance()).getSelectedHost())) {
            PaasClient.setServiceHost(AVOSServices.STORAGE_SERVICE, hostList.getSelectedHost());
        }
        new ServerHostFetchTask().execute(new ServerHostList[]{hostList});
    }

    @Deprecated
    public static void useAVCloudUS() {
        PaasClient.storageInstance().useAVCloudUS();
    }

    public static void useAVCloudCN() {
        PaasClient.storageInstance().useAVCloudCN();
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        AVOSCloud.logLevel = logLevel;
    }

    static void showInternalDebugLog(boolean show) {
        internalDebugLog = show;
    }

    public static boolean showInternalDebugLog() {
        return internalDebugLog;
    }

    public static StorageType getStorageType() {
        return storageType;
    }

    public static void setStorageType(StorageType storageType) {
        AVOSCloud.storageType = storageType;
    }

    public static boolean isLastModifyEnabled() {
        return PaasClient.isLastModifyEnabled();
    }

    public static void setLastModifyEnabled(boolean e) {
        PaasClient.setLastModifyEnabled(e);
    }

    public static void clearLastModifyCache() {
        PaasClient.clearLastModifyCache();
    }

    public static void enableAutoCacheCleaner() {
        AVPersistenceUtils.sharedInstance().savePersistentSettingBoolean(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY, true);
    }

    public static void disableAutoCacheCleaner() {
        AVPersistenceUtils.sharedInstance().savePersistentSettingBoolean(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_AUTO_CLEAN_KEY, false);
    }

    public static void setCacheFileAutoExpireDate(int expireDays) {
        AVPersistenceUtils.sharedInstance().savePersistentSettingInteger(AV_CLOUD_CACHE_EXPIRE_KEY_ZONE, AV_CLOUD_CACHE_EXPIRE_DATE_KEY, expireDays);
    }

    public static void setBaseUrl(String baseUrl) {
        PaasClient.storageInstance().setBaseUrl(baseUrl);
    }

    static {
        AV_CLOUD_CACHE_DEFAULT_EXPIRE_DATE = 30;
        logLevel = -1;
        internalDebugLog = false;
        networkTimeoutInMills = 15000;
        threadPoolSize = 10;
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        storageType = StorageType.StorageTypeQiniu;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @SuppressLint(value={"NewApi"})
    public static class ServerHostFetchTask
    extends AsyncTask<ServerHostList, Integer, Void> {
        protected Void doInBackground(ServerHostList ... params) {
            final ServerHostList hostList = params[0];
            LogUtil.avlog.d("try to fetch host list");
            PaasClient.storageInstance().getObject(AVOSCloud.URL_HOST_LIST, null, true, null, new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    Map result;
                    Object h;
                    if (e == null && (h = (result = (Map)JSON.parseObject((String)content, Map.class)).get("hosts")) != null && h instanceof List) {
                        hostList.setHosts((List)h);
                        hostList.saveToLocal();
                        if (!AVUtils.isBlankString(hostList.getSelectedHost())) {
                            PaasClient.setServiceHost(AVOSServices.STORAGE_SERVICE, hostList.getSelectedHost());
                            if (internalDebugLog) {
                                LogUtil.avlog.d("host set to :" + hostList.getSelectedHost());
                            }
                        }
                    }
                }

                public void onFailure(Throwable error, String content) {
                    LogUtil.avlog.e(error.getMessage());
                }
            });
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServerHostList {
        List<String> hosts;
        List<String> ips;
        String selectedHost;
        Random random = new Random();
        static final String AVOS_SERVER_HOST_ZONE = "avoscloud_server_host_zone";
        static final String AVOS_SERVER_HOST_LIST_KEY = "avoscloud_server_host_list_key";
        static final String AVOS_SELECTED_SERVER_HOST = "avoscloud_selected_server_host";
        static final String AVOS_SERVER_IP_LIST_KEY = "avoscloud_server_ip_list_key";

        ServerHostList() {
        }

        protected String getSelectedHost() {
            return this.selectedHost;
        }

        protected void setSelectedHost(String selectedHost) {
            this.selectedHost = selectedHost;
        }

        protected void setIPs(List<String> ips) {
            this.ips = ips;
        }

        protected List<String> getIPs() {
            return this.ips;
        }

        protected String getRandomIP() {
            return this.ips.get(this.random.nextInt(this.ips.size()));
        }

        protected void setHosts(List<String> h) {
            this.hosts = new LinkedList<String>();
            for (String host : h) {
                this.hosts.add(AVUtils.urlCleanLastSlash(host));
            }
            this.selectedHost = this.hosts.get(this.random.nextInt(this.hosts.size()));
        }

        protected List<String> getHosts() {
            return this.hosts;
        }

        protected void saveToLocal() {
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(AVOS_SERVER_HOST_ZONE, AVOS_SERVER_HOST_LIST_KEY, JSON.toJSONString(this.hosts));
            AVPersistenceUtils.sharedInstance().savePersistentSettingString(AVOS_SERVER_HOST_ZONE, AVOS_SELECTED_SERVER_HOST, this.selectedHost);
        }

        protected static ServerHostList getLocalInstance() {
            ServerHostList hostList = new ServerHostList();
            String hostListString = AVPersistenceUtils.sharedInstance().getPersistentSettingString(AVOS_SERVER_HOST_ZONE, AVOS_SERVER_HOST_LIST_KEY, null);
            if (!AVUtils.isBlankString(hostListString)) {
                hostList.setHosts((List)JSON.parseObject((String)hostListString, List.class));
            }
            hostList.setSelectedHost(AVPersistenceUtils.sharedInstance().getPersistentSettingString(AVOS_SERVER_HOST_ZONE, AVOS_SELECTED_SERVER_HOST, null));
            return hostList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StorageType {
        StorageTypeQiniu,
        StorageTypeAV,
        StorageTypeS3;

    }
}

