/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVClassName;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVGeoPoint;
import com.avos.avoscloud.AVKeyValues;
import com.avos.avoscloud.AVOperation;
import com.avos.avoscloud.AVOperationQueue;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRelation;
import com.avos.avoscloud.AVRole;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DeleteCallback;
import com.avos.avoscloud.FindCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RefreshCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.AddOp;
import com.avos.avoscloud.ops.AddRelationOp;
import com.avos.avoscloud.ops.AddUniqueOp;
import com.avos.avoscloud.ops.DeleteOp;
import com.avos.avoscloud.ops.IncrementOp;
import com.avos.avoscloud.ops.NullOP;
import com.avos.avoscloud.ops.RemoveOp;
import com.avos.avoscloud.ops.RemoveRelationOp;
import com.avos.avoscloud.ops.SetOp;
import com.loopj.android.http.RequestParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVObject {
    private static final String LOGTAG;
    private String className;
    protected String objectId;
    private String updatedAt;
    private String createdAt;
    private String uuid;
    private volatile boolean fetchWhenSave = false;
    @JSONField
    protected Map<String, AVKeyValues<?>> keyValues = new HashMap();
    private Set<String> pendingKeys = new HashSet<String>();
    private boolean isDataReady;
    protected transient AVACL acl;
    private volatile transient boolean running;
    private transient AVOperationQueue queue;
    private static final Map<String, Class<? extends AVObject>> SUB_CLASSES_MAP;
    private static final Map<Class<? extends AVObject>, String> SUB_CLASSES_REVERSE_MAP;
    public static final Set<String> INVALID_KEYS;
    protected static ThreadLocal<Boolean> deserializing;

    public AVObject() {
        this.init();
    }

    public String toString() {
        return "AVObject [className=" + this.getClassName() + ", objectId=" + this.objectId + ", updatedAt=" + this.updatedAt + ", createdAt=" + this.createdAt + ", uuid=" + this.uuid + ", fetchWhenSave=" + this.fetchWhenSave + ", keyValues=" + this.keyValues + "]";
    }

    Map<String, AVKeyValues<?>> getKeyValues() {
        return this.keyValues;
    }

    void setKeyValues(Map<String, AVKeyValues<?>> keyValues) {
        this.keyValues = keyValues;
    }

    Set<String> getPendingKeys() {
        return this.pendingKeys;
    }

    void setPendingKeys(Set<String> pendingKeys) {
        this.pendingKeys = pendingKeys;
    }

    boolean isDataReady() {
        return this.isDataReady;
    }

    void setDataReady(boolean isDataReady) {
        this.isDataReady = isDataReady;
    }

    void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isFetchWhenSave() {
        return this.fetchWhenSave;
    }

    public void setFetchWhenSave(boolean fetchWhenSave) {
        this.fetchWhenSave = fetchWhenSave;
    }

    public String getUuid() {
        if (AVUtils.isBlankString(this.uuid)) {
            this.uuid = UUID.randomUUID().toString().toLowerCase();
        }
        return this.uuid;
    }

    static Class<? extends AVObject> getSubClass(String className) {
        return SUB_CLASSES_MAP.get(className);
    }

    static String getSubClassName(Class<? extends AVObject> clazz) {
        if (AVUser.class.isAssignableFrom(clazz)) {
            return AVUser.userClassName();
        }
        if (AVRole.class.isAssignableFrom(clazz)) {
            return "_Role";
        }
        return SUB_CLASSES_REVERSE_MAP.get(clazz);
    }

    public static <T extends AVObject> void registerSubclass(Class<T> clazz) {
        AVClassName parseClassName = clazz.getAnnotation(AVClassName.class);
        if (parseClassName == null) {
            throw new IllegalArgumentException("The class is not annotated by @AVClassName");
        }
        String className = parseClassName.value();
        AVUtils.checkClassName(className);
        SUB_CLASSES_MAP.put(className, clazz);
        SUB_CLASSES_REVERSE_MAP.put(clazz, className);
    }

    public AVObject(String theClassName) {
        AVUtils.checkClassName(theClassName);
        this.className = theClassName;
        this.init();
    }

    private void init() {
        this.objectId = "";
        this.isDataReady = false;
        if (PaasClient.storageInstance().getDefaultACL() != null) {
            this.acl = new AVACL(PaasClient.storageInstance().getDefaultACL());
        }
        this.running = false;
        this.queue = new AVOperationQueue();
    }

    public void add(String key, Object value) {
        this.addObjectToArray(key, value, false);
    }

    public void addAll(String key, Collection<?> values) {
        for (Object item : values) {
            this.addObjectToArray(key, item, false);
        }
    }

    public static <T extends AVObject> AVQuery<T> getQuery(Class<T> clazz) {
        return new AVQuery<T>(AVObject.getSubClassName(clazz), clazz);
    }

    public void addAllUnique(String key, Collection<?> values) {
        for (Object item : values) {
            this.addObjectToArray(key, item, true);
        }
    }

    public void addUnique(String key, Object value) {
        this.addObjectToArray(key, value, true);
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public static AVObject create(String className) {
        return new AVObject(className);
    }

    public static AVObject createWithoutData(String className, String objectId) {
        AVObject object = new AVObject(className);
        object.setObjectId(objectId);
        return object;
    }

    void setClassName(String className) {
        this.className = className;
    }

    public static <T extends AVObject> T createWithoutData(Class<T> clazz, String objectId) throws AVException {
        try {
            AVObject result = (AVObject)clazz.newInstance();
            result.setClassName(AVObject.getSubClassName(clazz));
            result.setObjectId(objectId);
            return (T)result;
        }
        catch (Exception e) {
            throw new AVException("Create subclass instance failed.", e);
        }
    }

    public void delete() throws AVException {
        this.delete(true, false, new DeleteCallback(){

            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void deleteAll(Collection<? extends AVObject> objects) throws AVException {
        AVObject.deleteAll(true, false, objects, new DeleteCallback(){

            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void deleteAllInBackground(Collection<? extends AVObject> objects, DeleteCallback deleteCallback) {
        AVObject.deleteAll(false, false, objects, deleteCallback);
    }

    private static void deleteAll(boolean sync, boolean isEventually, Collection<? extends AVObject> objects, DeleteCallback callback) {
        if (objects == null || objects.isEmpty()) {
            callback.internalDone(null, null);
            return;
        }
        if (isEventually) {
            for (AVObject aVObject : objects) {
                if (aVObject == null) continue;
                aVObject.deleteEventually(callback);
            }
        } else {
            String className = null;
            boolean bl = true;
            StringBuilder sb = new StringBuilder();
            for (AVObject aVObject : objects) {
                boolean bl2;
                if (AVUtils.isBlankString(aVObject.getClassName()) || AVUtils.isBlankString(aVObject.objectId)) {
                    throw new IllegalArgumentException("Invalid AVObject, the class name or objectId is blank.");
                }
                if (className == null) {
                    className = aVObject.getClassName();
                } else if (!className.equals(aVObject.getClassName())) {
                    throw new IllegalArgumentException("The objects class name must be the same.");
                }
                if (bl2) {
                    sb.append(AVPowerfulUtils.getEndpoint(aVObject));
                    bl2 = false;
                    continue;
                }
                sb.append(",").append(aVObject.getObjectId());
            }
            final DeleteCallback internalCallback = callback;
            String string2 = sb.toString();
            PaasClient.storageInstance().deleteObject(string2, sync, false, new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    if (internalCallback != null) {
                        internalCallback.internalDone(null, null);
                    }
                }

                public void onFailure(Throwable error, String content) {
                    if (internalCallback != null) {
                        internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                    }
                }
            }, null, null);
        }
    }

    public void deleteEventually() {
        this.deleteEventually(null);
    }

    public void deleteEventually(DeleteCallback callback) {
        this.delete(false, true, callback);
    }

    public void deleteInBackground() {
        this.deleteInBackground(null);
    }

    public void deleteInBackground(DeleteCallback callback) {
        this.delete(false, false, callback);
    }

    private void delete(boolean sync, boolean isEventually, DeleteCallback callback) {
        final DeleteCallback internalCallback = callback;
        PaasClient.storageInstance().deleteObject(AVPowerfulUtils.getEndpoint(this), sync, isEventually, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, this.getObjectId(), this.internalId());
    }

    public AVObject fetch() throws AVException {
        return this.fetch(null);
    }

    public AVObject fetch(String includeKeys) throws AVException {
        this.fetchInBackground(true, includeKeys, new GetCallback<AVObject>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return this;
    }

    public static List<AVObject> fetchAll(List<AVObject> objects) throws AVException {
        return null;
    }

    public static List<AVObject> fetchAllIfNeeded(List<AVObject> objects) throws AVException {
        return null;
    }

    public static void fetchAllIfNeededInBackground(List<AVObject> objects, FindCallback<AVObject> callback) {
        final FindCallback<AVObject> internalCallback = callback;
        final ArrayList result = new ArrayList();
        AVObject.fetchAllInBackground(true, objects, new GenericObjectCallback(){

            public void onGroupRequestFinished(int left, int total, AVObject object) {
                if (object != null) {
                    result.add(object);
                }
                if (left <= 0 && internalCallback != null) {
                    internalCallback.internalDone(result, null);
                }
            }
        });
    }

    public static void fetchAllInBackground(List<AVObject> objects, FindCallback<AVObject> callback) {
        final FindCallback<AVObject> internalCallback = callback;
        final ArrayList result = new ArrayList();
        AVObject.fetchAllInBackground(false, objects, new GenericObjectCallback(){

            public void onGroupRequestFinished(int left, int total, AVObject object) {
                if (object != null) {
                    result.add(object);
                }
                if (left <= 0 && internalCallback != null) {
                    internalCallback.internalDone(result, null);
                }
            }
        });
    }

    private static void fetchAllInBackground(boolean check, List<AVObject> objects, GenericObjectCallback callback) {
        final GenericObjectCallback internalCallback = callback;
        final int total = objects.size();
        final AtomicInteger counter = new AtomicInteger(objects.size());
        for (AVObject object : objects) {
            if (!check || !object.isDataAvailable()) {
                object.fetchInBackground(false, null, new GetCallback<AVObject>(){

                    @Override
                    public void done(AVObject object, AVException e) {
                        if (internalCallback != null) {
                            internalCallback.onGroupRequestFinished(counter.decrementAndGet(), total, object);
                        }
                    }
                });
                continue;
            }
            if (internalCallback == null) continue;
            internalCallback.onGroupRequestFinished(counter.decrementAndGet(), total, object);
        }
        if (objects.size() <= 0 && internalCallback != null) {
            internalCallback.onGroupRequestFinished(0, 0, null);
        }
    }

    public AVObject fetchIfNeeded() throws AVException {
        return this.fetchIfNeeded(null);
    }

    public AVObject fetchIfNeeded(String includeKeys) throws AVException {
        if (!this.isDataAvailable()) {
            this.fetchInBackground(true, includeKeys, new GetCallback<AVObject>(){

                @Override
                public void done(AVObject object, AVException e) {
                    if (e != null) {
                        AVExceptionHolder.add(e);
                    }
                }

                @Override
                protected boolean mustRunOnUIThread() {
                    return false;
                }
            });
        }
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return this;
    }

    public void fetchIfNeededInBackground(GetCallback<AVObject> callback) {
        this.fetchIfNeededInBackground(null, callback);
    }

    public void fetchIfNeededInBackground(String includeKeys, GetCallback<AVObject> callback) {
        if (!this.isDataAvailable()) {
            this.fetchInBackground(includeKeys, callback);
        } else if (callback != null) {
            callback.internalDone(this, null);
        }
    }

    public void fetchInBackground(GetCallback<AVObject> callback) {
        this.fetchInBackground(null, callback);
    }

    public void fetchInBackground(String includeKeys, GetCallback<AVObject> callback) {
        this.fetchInBackground(false, includeKeys, callback);
    }

    private void fetchInBackground(boolean sync, String includeKeys, GetCallback<AVObject> callback) {
        if (AVUtils.isBlankString(this.getObjectId())) {
            if (callback != null) {
                AVException exception = AVErrorUtils.createException(104, "Missing objectId");
                callback.internalDone(null, exception);
            }
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (!AVUtils.isBlankString(includeKeys)) {
            params.put("include", includeKeys);
        }
        PaasClient.storageInstance().getObject(AVPowerfulUtils.getEndpoint(this), new RequestParams(params), sync, this.headerMap(), new FetchObjectCallback(callback));
    }

    public Object get(String key) {
        AVKeyValues<?> kv = this.keyValues.get(key);
        if (kv != null) {
            return kv.value;
        }
        return null;
    }

    public AVACL getACL() {
        return this.acl;
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? false : b;
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public String getClassName() {
        if (AVUtils.isBlankString(this.className)) {
            this.className = AVObject.getSubClassName(this.getClass());
        }
        return this.className;
    }

    public Date getCreatedAt() {
        return AVUtils.dateFromString(this.createdAt);
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public double getDouble(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public int getInt(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.intValue();
        }
        return 0;
    }

    public JSONArray getJSONArray(String key) {
        Object list = this.get(key);
        if (list == null) {
            return null;
        }
        if (list instanceof JSONArray) {
            return (JSONArray)list;
        }
        if (list instanceof Collection) {
            JSONArray array = new JSONArray((Collection)list);
            return array;
        }
        if (list instanceof Object[]) {
            JSONArray array = new JSONArray();
            for (Object obj : (Object[])list) {
                array.put(obj);
            }
            return array;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object object = this.get(key);
        String jsonString = JSON.toJSONString((Object)object);
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalid json string", exception);
        }
        return jsonObject;
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public long getLong(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public <V> Map<String, V> getMap(String key) {
        return (Map)this.get(key);
    }

    public Number getNumber(String key) {
        Number number = (Number)this.get(key);
        return number;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public <T extends AVFile> T getAVFile(String key) {
        return (T)((AVFile)this.get(key));
    }

    public AVGeoPoint getAVGeoPoint(String key) {
        return (AVGeoPoint)this.get(key);
    }

    public <T extends AVObject> T getAVObject(String key) {
        return (T)((AVObject)this.get(key));
    }

    public <T extends AVUser> T getAVUser(String key) {
        return (T)((AVUser)this.get(key));
    }

    public <T extends AVObject> AVRelation<T> getRelation(String key) {
        this.checkKey(key);
        AVRelation relation = new AVRelation(this, key);
        AVKeyValues<?> kv = this.keyValues.get(key);
        if (kv != null) {
            kv.relationKey = true;
            if (!AVUtils.isBlankString(kv.relationClassName)) {
                relation.setTargetClass(kv.relationClassName);
            } else {
                AVObject target;
                Collection set = (Collection)kv.value;
                if (set != null && !set.isEmpty() && (target = (AVObject)set.iterator().next()) != null) {
                    relation.setTargetClass(target.getClassName());
                }
            }
        }
        return relation;
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public Date getUpdatedAt() {
        return AVUtils.dateFromString(this.updatedAt);
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public boolean hasSameId(AVObject other) {
        return other.objectId.equals(this.objectId);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(final String key, final Number amount) {
        this.checkKey(key);
        KeyValueCallback<Number> cb = new KeyValueCallback<Number>(){

            @Override
            public AVOp createOp() {
                return new IncrementOp(key, amount);
            }

            @Override
            public void applyOp(AVKeyValues<Number> kvs) {
                kvs.value = ((Number)kvs.value).longValue() + amount.longValue();
            }

            @Override
            public Number initValue() {
                return 0L;
            }
        };
        cb.execute(key);
    }

    boolean isDataAvailable() {
        return !AVUtils.isBlankString(this.objectId) && this.isDataReady;
    }

    public Set<String> keySet() {
        return this.keyValues.keySet();
    }

    private void checkKey(String key) {
        if (AVUtils.isBlankString(key)) {
            throw new IllegalArgumentException("Blank key");
        }
        if (key.startsWith("_")) {
            throw new IllegalArgumentException("The key should not start with '_'");
        }
        if (INVALID_KEYS.contains(key)) {
            throw new IllegalArgumentException("Internal key name:`" + key + "`,please use setter/getter for it.");
        }
    }

    public static void beginDeserialize() {
        deserializing.set(true);
    }

    public static void endDeserialize() {
        deserializing.set(false);
    }

    public void put(String key, Object value) {
        this.put(key, value, true);
    }

    protected void put(final String key, final Object value, boolean pending) {
        this.checkKey(key);
        KeyValueCallback<Object> cb = new KeyValueCallback<Object>(){

            @Override
            public AVOp createOp() {
                return new SetOp(key, value);
            }

            @Override
            public void applyOp(AVKeyValues<Object> kvs) {
                kvs.value = value;
            }

            @Override
            public Object initValue() {
                return null;
            }
        };
        cb.execute(key, pending);
    }

    public void refresh() throws AVException {
        this.refresh(null);
    }

    public void refresh(String includeKeys) throws AVException {
        this.refreshInBackground(true, includeKeys, new RefreshCallback<AVObject>(){

            @Override
            public void done(AVObject object, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            @Override
            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public void refreshInBackground(RefreshCallback<AVObject> callback) {
        this.refreshInBackground(false, null, callback);
    }

    public void refreshInBackground(String includeKeys, RefreshCallback<AVObject> callback) {
        this.refreshInBackground(false, includeKeys, callback);
    }

    private void refreshInBackground(boolean sync, String includeKeys, RefreshCallback<AVObject> callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!AVUtils.isBlankString(includeKeys)) {
            params.put("include", includeKeys);
        }
        PaasClient.storageInstance().getObject(AVPowerfulUtils.getEndpoint(this), new RequestParams(params), sync, this.headerMap(), new FetchObjectCallback(callback));
    }

    public void remove(String key) {
        this.removeObjectForKey(key);
    }

    public void removeAll(final String key, final Collection<?> values) {
        this.checkKey(key);
        KeyValueCallback<List<Object>> cb = new KeyValueCallback<List<Object>>(){

            @Override
            public AVOp createOp() {
                return new RemoveOp(key, values);
            }

            @Override
            public void applyOp(AVKeyValues<List<Object>> kvs) {
                ((List)kvs.value).removeAll(values);
            }

            @Override
            public List<Object> initValue() {
                return new ArrayList<Object>();
            }
        };
        cb.execute(key);
    }

    public void save() throws AVException {
        this.saveObject(true, false, new SaveCallback(){

            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void saveAll(List<? extends AVObject> objects) throws AVException {
        AVObject._saveAll(true, objects, new SaveCallback(){

            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public static void saveAllInBackground(List<? extends AVObject> objects) {
        AVObject._saveAll(false, objects, null);
    }

    public static void saveAllInBackground(List<? extends AVObject> objects, SaveCallback callback) {
        AVObject._saveAll(false, objects, callback);
    }

    private static void _saveAll(final boolean sync, final List<? extends AVObject> objects, final SaveCallback callback) {
        block9: {
            final LinkedList list = new LinkedList();
            LinkedList<AVFile> files = new LinkedList<AVFile>();
            for (AVObject aVObject : objects) {
                if (!aVObject.checkCircleReference()) {
                    if (callback != null) {
                        callback.internalDone(AVErrorUtils.circleException());
                    }
                    return;
                }
                try {
                    List<AVFile> filesNeedToUpload = aVObject.addBatchSaveRequest(list, sync);
                    if (filesNeedToUpload == null || filesNeedToUpload.size() <= 0) continue;
                    files.addAll(filesNeedToUpload);
                }
                catch (AVException e) {
                    if (callback == null) continue;
                    callback.done(e);
                }
            }
            final GenericObjectCallback genericObjectCallback = new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    for (AVObject o : objects) {
                        o.copyFromJson(content);
                    }
                    LogUtil.log.d(content);
                    LinkedList list = new LinkedList();
                    for (AVObject o : objects) {
                        o.addPendingBatchRequest(list);
                    }
                    if (!list.isEmpty()) {
                        PaasClient.storageInstance().postBatchSave(list, sync, false, null, new GenericObjectCallback(){

                            public void onSuccess(String content, AVException e) {
                                for (AVObject o : objects) {
                                    o.copyFromJson(content);
                                    o.onSaveSuccess();
                                }
                                if (callback != null) {
                                    callback.internalDone(null);
                                }
                            }

                            public void onFailure(Throwable error, String content) {
                                if (callback != null) {
                                    callback.internalDone(AVErrorUtils.createException(error, content));
                                }
                                for (AVObject o : objects) {
                                    o.onSaveFailure();
                                }
                                LogUtil.log.d(content);
                            }
                        }, null, null);
                    } else if (callback != null) {
                        for (AVObject o : objects) {
                            o.onSaveSuccess();
                        }
                        callback.internalDone(null);
                    }
                }

                public void onFailure(Throwable error, String content) {
                    if (callback != null) {
                        callback.internalDone(null, AVErrorUtils.createException(error, content));
                    }
                    for (AVObject o : objects) {
                        o.onSaveFailure();
                    }
                    LogUtil.log.d(content);
                }
            };
            try {
                if (files != null && files.size() > 0) {
                    AVObject.saveFileBeforeSave(files, sync, list, new SaveCallback(){

                        public void done(AVException e) {
                            PaasClient.storageInstance().postBatchSave(list, sync, false, null, genericObjectCallback, null, null);
                        }
                    });
                } else {
                    PaasClient.storageInstance().postBatchSave(list, sync, false, null, genericObjectCallback, null, null);
                }
            }
            catch (AVException aVException) {
                if (callback == null) break block9;
                callback.done(aVException);
            }
        }
    }

    public void saveEventually() {
        this.saveEventually(null);
    }

    public void saveEventually(SaveCallback callback) {
        PaasClient.registerEventuallyObject(this);
        this.saveInBackground(callback, true);
    }

    protected void onSaveSuccess() {
    }

    protected void onSaveFailure() {
    }

    protected Map<String, String> headerMap() {
        return PaasClient.storageInstance().userHeaderMap();
    }

    private void saveObject(final boolean sync, final boolean isEventually, final SaveCallback callback) {
        block4: {
            LinkedList list = new LinkedList();
            try {
                List<AVFile> files = this.addBatchSaveRequest(list, sync);
                if (files != null && files.size() > 0) {
                    AVObject.saveFileBeforeSave(files, sync, list, new SaveCallback(){

                        public void done(AVException e) {
                            AVObject.this.saveObject(sync, isEventually, callback);
                        }
                    });
                } else {
                    this._saveObject(list, sync, isEventually, callback);
                }
            }
            catch (AVException e) {
                if (callback == null) break block4;
                callback.done(e);
            }
        }
    }

    private void _saveObject(List list, boolean sync, boolean isEventually, SaveCallback callback) {
        boolean runCallback = true;
        AVOperation operation = null;
        if (!list.isEmpty()) {
            operation = this.queue.addSnapshotOperation(list, callback);
            runCallback = false;
        }
        if (this.pendingKeys.size() > 0) {
            if (operation != null) {
                operation.setLast(false);
            }
            LinkedList pendingRequests = new LinkedList();
            this.addPendingBatchRequest(pendingRequests);
            if (!pendingRequests.isEmpty()) {
                this.queue.addPendingOperation(pendingRequests, callback);
                runCallback = false;
            }
        }
        this.queue.increaseSequence();
        if (this.running) {
            LogUtil.avlog.d("already has one request sending");
            return;
        }
        this.running = true;
        if (runCallback) {
            if (callback != null) {
                this.onSaveSuccess();
                callback.internalDone(null);
            }
            this.running = false;
        } else {
            this.saveObjectToAVOSCloud(sync, isEventually, callback);
        }
    }

    private void saveObjectToAVOSCloud(final boolean sync, final boolean isEventually, SaveCallback callback) {
        final AVOperation operation = this.queue.popHead();
        if (operation == null) {
            return;
        }
        if (operation.isPendingRequest()) {
            List requests = operation.getBatchRequest();
            for (Map request : requests) {
                String path = AVPowerfulUtils.getBatchEndpoint(PaasClient.storageInstance().getApiVersion(), this);
                Map body = (Map)request.get("body");
                if (body != null) {
                    List children = (List)body.get("__children");
                    if (children != null && children.size() > 0) {
                        for (Map child : children) {
                            String key = (String)child.get("key");
                            if (AVUtils.isBlankString(key)) continue;
                            child.putAll(AVUtils.mapFromChildObject(this.getAVObject(key), key));
                        }
                    }
                    body.put("__internalId", this.internalId());
                }
                request.put("path", path);
            }
        }
        List list = operation.getBatchRequest();
        PaasClient.storageInstance().postBatchSave(list, sync, isEventually, this.headerMap(), new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                AVObject.this.copyFromJson(content);
                if (operation.getLast()) {
                    AVObject.this.running = false;
                    AVObject.this.onSaveSuccess();
                    operation.invokeCallback(e);
                }
                AVObject.this.saveObjectToAVOSCloud(sync, isEventually, null);
            }

            public void onFailure(Throwable error, String content) {
                AVObject.this.running = false;
                if (AVObject.this.shouldThrowException(error, content)) {
                    operation.invokeCallback(AVErrorUtils.createException(error, content));
                } else {
                    operation.invokeCallback(null);
                }
                AVObject.this.queue.clearOperationWithSequence(operation.getSequence());
                AVObject.this.onSaveFailure();
                AVObject.this.saveObjectToAVOSCloud(sync, isEventually, null);
            }
        }, this.getObjectId(), this.internalId());
    }

    private AVException copyFromJsonArray(String jsonStr) {
        ArrayList array = AVUtils.getFromJSON(jsonStr, ArrayList.class);
        for (Map map : array) {
            Map item = (Map)map.get("success");
            if (item != null) {
                AVUtils.copyPropertiesFromMapToAVObject(item, this);
                continue;
            }
            Map errorMap = (Map)map.get("error");
            return AVErrorUtils.createException(((Number)errorMap.get("code")).intValue(), (String)errorMap.get("error"));
        }
        return null;
    }

    protected void copyFromJson(String jsonStr) {
        Map map = AVUtils.getFromJSON(jsonStr, Map.class);
        this.copyFromMap(map);
    }

    protected void copyFromMap(Map map) {
        Object item = map.get(this.uuid);
        if (item != null && item instanceof Map) {
            AVUtils.copyPropertiesFromMapToAVObject((Map)item, this);
        }
        if ((item = map.get(this.getObjectId())) != null && item instanceof Map) {
            AVUtils.copyPropertiesFromMapToAVObject((Map)item, this);
        }
        for (AVKeyValues<?> kv : this.keyValues.values()) {
            Object o = kv.value;
            if (!(o instanceof AVObject)) continue;
            ((AVObject)o).copyFromMap(map);
        }
    }

    protected boolean alwaysUsePost() {
        return false;
    }

    protected List<Map> batchRequestFromPendingKeys() {
        ArrayList<Map> result = new ArrayList<Map>();
        int maxSize = -1;
        HashMap pendingKeyValues = new HashMap();
        for (AVKeyValues<?> kv : this.keyValues.values()) {
            if (!this.pendingKeys.contains(kv.key)) continue;
            if (kv.opSize() > maxSize) {
                maxSize = kv.opSize();
            }
            pendingKeyValues.put(kv.key, kv);
        }
        if (maxSize <= 0) {
            maxSize = 1;
        }
        for (int i = 0; i < maxSize; ++i) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            ArrayList<Map<String, String>> children = new ArrayList<Map<String, String>>();
            for (AVKeyValues kv : pendingKeyValues.values()) {
                AVOp op = kv.getOp(i);
                if (op == null || op == NullOP.INSTANCE) continue;
                if (kv.value instanceof AVObject) {
                    Map<String, String> child = AVUtils.mapFromChildObject((AVObject)kv.value, kv.key);
                    children.add(child);
                    continue;
                }
                body.putAll(op.encodeOp());
            }
            if (body.isEmpty() && children.isEmpty()) continue;
            body.put("__children", children);
            if (this.acl != null) {
                body.putAll(AVUtils.getParsedMap(this.acl.getACLMap()));
            }
            body.put("__internalId", this.internalId());
            String method = "PUT";
            String path = AVPowerfulUtils.getBatchEndpoint(PaasClient.storageInstance().getApiVersion(), this);
            result.add(PaasClient.storageInstance().batchItemMap(method, path, body, this.getBatchParams()));
        }
        for (AVKeyValues<?> kv : this.keyValues.values()) {
            kv.resetOp();
        }
        this.pendingKeys.clear();
        return result;
    }

    protected String internalId() {
        return AVUtils.isBlankString(this.getObjectId()) ? this.getUuid() : this.getObjectId();
    }

    protected boolean alwaysSaveAllKeyValues() {
        return false;
    }

    protected Map batchRequestFromKeyValues() {
        if (AVUtils.isBlankString(this.objectId) || this.alwaysSaveAllKeyValues()) {
            boolean post;
            HashMap<String, Object> body = new HashMap<String, Object>();
            ArrayList<Map<String, String>> children = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, AVKeyValues<?>> entry : this.keyValues.entrySet()) {
                String key = entry.getKey();
                AVKeyValues<?> kv = entry.getValue();
                Object o = kv.value;
                if (kv.relationKey) continue;
                if (o instanceof AVObject) {
                    AVObject oo = (AVObject)o;
                    Map<String, String> child = AVUtils.mapFromChildObject(oo, key);
                    children.add(child);
                } else if (o instanceof AVGeoPoint) {
                    body.put(key, AVUtils.mapFromGeoPoint((AVGeoPoint)o));
                } else if (o instanceof Date) {
                    body.put(key, AVUtils.mapFromDate((Date)o));
                } else if (o instanceof byte[]) {
                    body.put(key, AVUtils.mapFromByteArray((byte[])o));
                } else if (o instanceof AVFile) {
                    body.put(key, AVUtils.mapFromFile((AVFile)o));
                } else {
                    body.put(key, AVUtils.getParsedObject(o));
                }
                this.pendingKeys.remove(key);
                kv.resetOp();
            }
            body.put("__children", children);
            if (this.acl != null) {
                body.putAll(AVUtils.getParsedMap(this.acl.getACLMap()));
            }
            body.put("__internalId", this.internalId());
            String method = "PUT";
            boolean bl = post = AVUtils.isBlankString(this.getObjectId()) || this.alwaysUsePost();
            if (post) {
                method = "POST";
            }
            String path = AVPowerfulUtils.getBatchEndpoint(PaasClient.storageInstance().getApiVersion(), this, post);
            return PaasClient.storageInstance().batchItemMap(method, path, body, this.getBatchParams());
        }
        return Collections.emptyMap();
    }

    private Map getBatchParams() {
        if (this.fetchWhenSave) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("new", this.fetchWhenSave);
            return hashMap;
        }
        return null;
    }

    private List<AVFile> addBatchSaveRequest(LinkedList list, boolean sync) throws AVException {
        LinkedList<AVFile> fileNeedToUpload = new LinkedList<AVFile>();
        for (Map.Entry<String, AVKeyValues<?>> entry : this.keyValues.entrySet()) {
            AVFile file;
            AVKeyValues<?> kv = entry.getValue();
            Object o = kv.value;
            String k = kv.key;
            if (o != null && AVObject.class.isInstance(o)) {
                List<AVFile> files = ((AVObject)o).addBatchSaveRequest(list, sync);
                if (files == null || files.size() <= 0) continue;
                fileNeedToUpload.addAll(files);
                continue;
            }
            if (o == null || !AVFile.class.isInstance(o) || (file = (AVFile)o).getObjectId() != null) continue;
            if (sync) {
                file.save();
                continue;
            }
            fileNeedToUpload.add(file);
        }
        Map map = this.batchRequestFromKeyValues();
        if (!map.isEmpty()) {
            list.add(map);
        }
        return fileNeedToUpload;
    }

    private void addPendingBatchRequest(LinkedList list) {
        List<Map> requests = this.batchRequestFromPendingKeys();
        int i = 0;
        for (Map map : requests) {
            if (map.isEmpty()) continue;
            list.add(i++, map);
        }
        for (Map.Entry entry : this.keyValues.entrySet()) {
            AVKeyValues kv = (AVKeyValues)entry.getValue();
            Object o = kv.value;
            if (o == null || !AVObject.class.isInstance(o)) continue;
            ((AVObject)o).addPendingBatchRequest(list);
        }
    }

    private boolean checkCircleReference() {
        return this.checkCircleReference(new HashMap<AVObject, Boolean>());
    }

    private boolean checkCircleReference(Map<AVObject, Boolean> status) {
        boolean result = true;
        if (status.get(this) != null) {
            if (!status.get(this).booleanValue()) {
                LogUtil.log.e("Found a circular dependency while saving");
                return false;
            }
            return true;
        }
        status.put(this, false);
        for (AVKeyValues<?> kv : this.keyValues.values()) {
            Object o = kv.value;
            if (!(o instanceof AVObject)) continue;
            result = result && ((AVObject)o).checkCircleReference(status);
        }
        status.put(this, true);
        return result;
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, false);
    }

    private void saveInBackground(SaveCallback callback, boolean isEventually) {
        this.saveObject(false, isEventually, callback);
    }

    public void setACL(AVACL acl) {
        this.acl = acl;
    }

    public void setObjectId(String newObjectId) {
        this.objectId = newObjectId;
    }

    private List findArray(Map<String, Object> parent, String key, boolean create) {
        ArrayList array = null;
        try {
            array = (ArrayList)parent.get(key);
            if (array != null || !create) {
                return array;
            }
            array = new ArrayList();
            parent.put(key, array);
            return array;
        }
        catch (Exception exception) {
            LogUtil.log.e(LOGTAG, "find array failed.", exception);
            return array;
        }
    }

    protected String internalClassName() {
        return this.getClassName();
    }

    protected boolean shouldThrowException(Throwable error, String content) {
        return true;
    }

    void addRelationFromServer(final String key, final String className, boolean submit) {
        this.checkKey(key);
        KeyValueCallback<Set<AVObject>> cb = new KeyValueCallback<Set<AVObject>>(){

            @Override
            public AVOp createOp() {
                return new AddRelationOp(key, new AVObject[0]);
            }

            @Override
            public void applyOp(AVKeyValues<Set<AVObject>> kvs) {
                kvs.relationKey = true;
                kvs.relationClassName = className;
            }

            @Override
            public Set<AVObject> initValue() {
                return new HashSet<AVObject>();
            }
        };
        cb.execute(key, submit);
    }

    void addRelation(final AVObject object, final String key, boolean submit) {
        this.checkKey(key);
        KeyValueCallback<Set<AVObject>> cb = new KeyValueCallback<Set<AVObject>>(){

            @Override
            public AVOp createOp() {
                return new AddRelationOp(key, object);
            }

            @Override
            public void applyOp(AVKeyValues<Set<AVObject>> kvs) {
                kvs.relationKey = true;
                if (!((Set)kvs.value).contains(object)) {
                    ((Set)kvs.value).add(object);
                    kvs.relationClassName = object.getClassName();
                }
            }

            @Override
            public Set<AVObject> initValue() {
                return new HashSet<AVObject>();
            }
        };
        cb.execute(key, submit);
    }

    void removeRelation(final AVObject object, final String key, boolean submit) {
        this.checkKey(key);
        KeyValueCallback<Set<AVObject>> cb = new KeyValueCallback<Set<AVObject>>(){

            @Override
            public AVOp createOp() {
                return new RemoveRelationOp(key, object);
            }

            @Override
            public void applyOp(AVKeyValues<Set<AVObject>> kvs) {
                kvs.relationKey = true;
                if (((Set)kvs.value).add(object)) {
                    kvs.relationClassName = object.getClassName();
                }
            }

            @Override
            public Set<AVObject> initValue() {
                return new HashSet<AVObject>();
            }
        };
        cb.execute(key, submit);
    }

    private void addObjectToArray(final String key, final Object value, final boolean unique) {
        this.checkKey(key);
        KeyValueCallback<Collection<Object>> cb = new KeyValueCallback<Collection<Object>>(){

            @Override
            public AVOp createOp() {
                boolean isPointer = value instanceof AVObject;
                Map<String, Object> realValue = value;
                if (isPointer) {
                    realValue = AVUtils.mapFromPointerObject((AVObject)value);
                }
                if (unique) {
                    return new AddUniqueOp(key, realValue);
                }
                return new AddOp(key, realValue);
            }

            @Override
            public void applyOp(AVKeyValues<Collection<Object>> kvs) {
                if (unique) {
                    if (!((Collection)kvs.value).contains(value)) {
                        ((Collection)kvs.value).add(value);
                    }
                } else {
                    ((Collection)kvs.value).add(value);
                }
            }

            @Override
            public Collection<Object> initValue() {
                return new ArrayList<Object>();
            }
        };
        cb.execute(key);
    }

    private void removeObjectForKey(final String key) {
        this.checkKey(key);
        KeyValueCallback<Void> cb = new KeyValueCallback<Void>(){

            @Override
            public AVOp createOp() {
                return new DeleteOp(key);
            }

            @Override
            public void applyOp(AVKeyValues<Void> kvs) {
                kvs.value = null;
            }

            @Override
            public Void initValue() {
                return null;
            }
        };
        cb.execute(key);
    }

    public static void saveFileBeforeSave(List<AVFile> files, boolean sync, List list, final SaveCallback callback) throws AVException {
        if (sync) {
            for (AVFile file : files) {
                if (file == null) continue;
                file.save();
            }
            callback.done(null);
        } else {
            final AtomicInteger lock = new AtomicInteger(AVUtils.collectionNonNullCount(files));
            final AtomicBoolean failureLock = new AtomicBoolean(false);
            for (AVFile file : files) {
                if (file == null) continue;
                file.saveInBackground(new SaveCallback(){

                    public void done(AVException e) {
                        if (e != null && failureLock.compareAndSet(false, true)) {
                            callback.done(e);
                        } else {
                            if (e != null) {
                                return;
                            }
                            if (lock.decrementAndGet() == 0) {
                                callback.done(null);
                            }
                        }
                    }
                });
            }
        }
    }

    public int hashCode() {
        if (AVUtils.isBlankString(this.objectId)) {
            return super.hashCode();
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getClassName() == null ? 0 : this.getClassName().hashCode());
        result = 31 * result + (this.objectId == null ? 0 : this.objectId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (AVUtils.isBlankString(this.objectId)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AVObject other = (AVObject)obj;
        if (this.getClassName() == null ? other.getClassName() != null : !this.getClassName().equals(other.getClassName())) {
            return false;
        }
        return !(this.objectId == null ? other.objectId != null : !this.objectId.equals(other.objectId));
    }

    static {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        LOGTAG = AVObject.class.getName();
        SUB_CLASSES_MAP = new HashMap<String, Class<? extends AVObject>>();
        SUB_CLASSES_REVERSE_MAP = new HashMap<Class<? extends AVObject>, String>();
        INVALID_KEYS = new HashSet<String>();
        INVALID_KEYS.add("code");
        INVALID_KEYS.add("uuid");
        INVALID_KEYS.add("className");
        INVALID_KEYS.add("keyValues");
        INVALID_KEYS.add("fetchWhenSave");
        INVALID_KEYS.add("running");
        INVALID_KEYS.add("acl");
        INVALID_KEYS.add("ACL");
        INVALID_KEYS.add("isDataReady");
        INVALID_KEYS.add("pendingKeys");
        INVALID_KEYS.add("createdAt");
        INVALID_KEYS.add("updatedAt");
        INVALID_KEYS.add("objectId");
        deserializing = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class KeyValueCallback<T> {
        private KeyValueCallback() {
        }

        public void execute(String key) {
            this.execute(key, true);
        }

        public void execute(String key, boolean pending) {
            AVKeyValues<Object> kvs = AVObject.this.keyValues.get(key);
            AVOp op = this.createOp();
            if (kvs == null) {
                kvs = new AVKeyValues<T>(key, this.initValue(), op);
                AVObject.this.keyValues.put(key, kvs);
            } else {
                kvs.addOp(op);
            }
            this.applyOp(kvs);
            if (pending && !deserializing.get().booleanValue()) {
                AVObject.this.pendingKeys.add(key);
            } else {
                kvs.op = NullOP.INSTANCE;
            }
        }

        public abstract AVOp createOp();

        public abstract void applyOp(AVKeyValues<T> var1);

        public abstract T initValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FetchObjectCallback
    extends GenericObjectCallback {
        private final AVCallback<AVObject> internalCallback;

        private FetchObjectCallback(AVCallback<AVObject> internalCallback) {
            this.internalCallback = internalCallback;
        }

        @Override
        public void onSuccess(String content, AVException e) {
            AVException error = e;
            AVObject object = AVObject.this;
            if (!AVUtils.isBlankContent(content)) {
                AVUtils.copyPropertiesFromJsonStringToAVObject(content, object);
                AVObject.this.isDataReady = true;
            } else {
                object = null;
                error = new AVException(101, "The object is not Found");
            }
            if (this.internalCallback != null) {
                this.internalCallback.internalDone(object, error);
            }
        }

        @Override
        public void onFailure(Throwable error, String content) {
            if (this.internalCallback != null) {
                this.internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
            }
        }
    }
}

