/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.avos.avoscloud.AVCallback;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVExceptionHolder;
import com.avos.avoscloud.AVFollowResponse;
import com.avos.avoscloud.AVFriendshipQuery;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVPowerfulUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.FindCallback;
import com.avos.avoscloud.FollowCallback;
import com.avos.avoscloud.FollowersAndFolloweesCallback;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogInCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.RequestEmailVerifyCallback;
import com.avos.avoscloud.RequestPasswordResetCallback;
import com.avos.avoscloud.SaveCallback;
import com.avos.avoscloud.SignUpCallback;
import com.avos.avoscloud.UpdatePasswordCallback;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JSONType(ignores={"query"})
public class AVUser
extends AVObject {
    private static transient boolean enableAutomatic = false;
    private String sessionToken;
    private transient boolean isNew;
    private String username;
    private transient String password;
    private String email;
    private transient String facebookToken;
    private transient String twitterToken;
    private transient String sinaWeiboToken;
    private transient String qqWeiboToken;
    private transient boolean anonymous;
    public static final String LOG_TAG = AVUser.class.getSimpleName();
    public static final String FOLLOWER_TAG = "follower";
    public static final String FOLLOWEE_TAG = "followee";
    private static Class<? extends AVUser> subClazz;
    private static final String accessTokenTag = "access_token";
    private static final String expiresAtTag = "expires_at";
    private static final String authDataTag = "authData";

    private static File currentUserArchivePath() {
        File file = new File(AVPersistenceUtils.getPaasDocumentDir() + "/currentUser");
        return file;
    }

    private static boolean userArchiveExist() {
        return AVUser.currentUserArchivePath().exists();
    }

    public String getFacebookToken() {
        return this.facebookToken;
    }

    void setFacebookToken(String facebookToken) {
        this.facebookToken = facebookToken;
    }

    public String getTwitterToken() {
        return this.twitterToken;
    }

    void setTwitterToken(String twitterToken) {
        this.twitterToken = twitterToken;
    }

    public String getQqWeiboToken() {
        return this.qqWeiboToken;
    }

    void setQqWeiboToken(String qqWeiboToken) {
        this.qqWeiboToken = qqWeiboToken;
    }

    String getPassword() {
        return this.password;
    }

    static void setEnableAutomatic(boolean enableAutomatic) {
        AVUser.enableAutomatic = enableAutomatic;
    }

    void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public AVUser() {
        super(AVUser.userClassName());
    }

    public static void enableAutomaticUser() {
        enableAutomatic = true;
    }

    public static boolean isEnableAutomatic() {
        return enableAutomatic;
    }

    public static void disableAutomaticUser() {
        enableAutomatic = false;
    }

    public static synchronized void changeCurrentUser(AVUser newUser, boolean save) {
        File currentUserArchivePath = AVUser.currentUserArchivePath();
        if (newUser != null && save) {
            String jsonString = JSON.toJSONString((Object)newUser, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField, SerializerFeature.WriteClassName, SerializerFeature.QuoteFieldNames, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
            AVPersistenceUtils.saveContentToFile(jsonString, currentUserArchivePath);
        } else if (save) {
            AVPersistenceUtils.removeLock(currentUserArchivePath.getAbsolutePath());
            currentUserArchivePath.delete();
        }
        PaasClient.storageInstance().setCurrentUser(newUser);
    }

    public static AVUser getCurrentUser() {
        return AVUser.getCurrentUser(AVUser.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends AVUser> T getCurrentUser(Class<T> userClass) {
        AVUser user = PaasClient.storageInstance().getCurrentUser();
        if (user != null) {
            return (T)user;
        }
        if (AVUser.userArchiveExist()) {
            Class<AVUser> clazz = AVUser.class;
            // MONITORENTER : com.avos.avoscloud.AVUser.class
            String jsonString = AVPersistenceUtils.readContentFromFile(AVUser.currentUserArchivePath());
            if (jsonString.indexOf("@type") <= 0) {
                T userObject = AVUser.newAVUser(userClass, null);
                AVUtils.copyPropertiesFromJsonStringToAVObject(jsonString, userObject);
                AVUser.changeCurrentUser(userObject, true);
                // MONITOREXIT : clazz
                return userObject;
            }
            try {
                AVObject.beginDeserialize();
                AVUser aVUser = (AVUser)JSON.parseObject((String)jsonString, userClass);
                return (T)aVUser;
            }
            catch (Exception e) {
                LogUtil.log.e(LOG_TAG, jsonString, e);
            }
            finally {
                AVObject.endDeserialize();
            }
            // MONITOREXIT : clazz
        }
        if (!enableAutomatic) {
            return (T)user;
        }
        user = AVUser.newAVUser(userClass, null);
        AVUser.changeCurrentUser(user, false);
        return (T)user;
    }

    static String userClassName() {
        return AVPowerfulUtils.getAVClassName(AVUser.class.getSimpleName());
    }

    void setNewFlag(boolean isNew) {
        this.isNew = isNew;
    }

    public String getEmail() {
        return this.email;
    }

    public static <T extends AVUser> AVQuery<T> getUserQuery(Class<T> clazz) {
        AVQuery<T> query = new AVQuery<T>(AVUser.userClassName(), clazz);
        return query;
    }

    public static AVQuery<AVUser> getQuery() {
        return AVUser.getQuery(AVUser.class);
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAuthenticated() {
        return !AVUtils.isBlankString(this.sessionToken) || !AVUtils.isBlankString(this.sinaWeiboToken) || !AVUtils.isBlankString(this.qqWeiboToken);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    protected void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public static AVUser logIn(String username, String password) throws AVException {
        return AVUser.logIn(username, password, AVUser.class);
    }

    public static <T extends AVUser> T logIn(String username, String password, Class<T> clazz) throws AVException {
        final AVUser[] list = new AVUser[]{null};
        AVUser.logInInBackground(username, password, true, new LogInCallback<T>(){

            @Override
            public void done(T user, AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                } else {
                    list[0] = user;
                }
            }

            @Override
            public boolean mustRunOnUIThread() {
                return false;
            }
        }, clazz);
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
        return (T)list[0];
    }

    private static String logInPath() {
        return "login";
    }

    public static void logInInBackground(String username, String password, LogInCallback<AVUser> callback) {
        AVUser.logInInBackground(username, password, callback, AVUser.class);
    }

    public static <T extends AVUser> void logInInBackground(String username, String password, LogInCallback<T> callback, Class<T> clazz) {
        AVUser.logInInBackground(username, password, false, callback, clazz);
    }

    private static Map<String, String> createUserMap(String username, String password, String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", username);
        if (AVUtils.isBlankString(username)) {
            throw new IllegalArgumentException("Blank username.");
        }
        if (!AVUtils.isBlankString(password)) {
            map.put("password", password);
        }
        if (!AVUtils.isBlankString(email)) {
            map.put("email", email);
        }
        return map;
    }

    private static <T extends AVUser> void logInInBackground(String username, String password, boolean sync, LogInCallback<T> callback, Class<T> clazz) {
        Map<String, String> map = AVUser.createUserMap(username, password, "");
        LogInCallback<T> internalCallback = callback;
        T user = AVUser.newAVUser(clazz, callback);
        if (user == null) {
            return;
        }
        ((AVUser)user).setUsername(username);
        ((AVUser)user).setPassword(password);
        PaasClient.storageInstance().postObject(AVUser.logInPath(), JSON.toJSONString(map), sync, false, new GenericObjectCallback((AVUser)user, internalCallback){
            final /* synthetic */ AVUser val$user;
            final /* synthetic */ LogInCallback val$internalCallback;
            {
                this.val$user = aVUser;
                this.val$internalCallback = logInCallback;
            }

            public void onSuccess(String content, AVException e) {
                AVException error = e;
                AVUser resultUser = this.val$user;
                if (!AVUtils.isBlankContent(content)) {
                    AVUtils.copyPropertiesFromJsonStringToAVObject(content, this.val$user);
                    AVUser.changeCurrentUser(this.val$user, true);
                } else {
                    resultUser = null;
                    error = new AVException(101, "User is not found.");
                }
                if (this.val$internalCallback != null) {
                    this.val$internalCallback.internalDone(resultUser, error);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (this.val$internalCallback != null) {
                    this.val$internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    public static <T extends AVUser> T newAVUser(Class<T> clazz, LogInCallback<T> cb) {
        try {
            AVUser user = (AVUser)clazz.newInstance();
            return (T)user;
        }
        catch (Exception e) {
            if (cb == null) {
                throw new AVRuntimeException("Create user instance failed.", e);
            }
            cb.internalDone(null, AVErrorUtils.createException(e, null));
            return null;
        }
    }

    protected static <T extends AVUser> T newAVUser() {
        return (T)AVUser.newAVUser(subClazz == null ? AVUser.class : subClazz, null);
    }

    public static void logOut() {
        AVUser.changeCurrentUser(null, true);
        PaasClient.storageInstance().setDefaultACL(null);
    }

    @Override
    public void put(String key, Object value) {
        super.put(key, value);
    }

    @Override
    public void remove(String key) {
        super.remove(key);
    }

    public static void requestPasswordReset(String email) {
        AVUser.requestPasswordResetInBackground(email, true, null);
    }

    public static void requestPasswordResetInBackground(String email, RequestPasswordResetCallback callback) {
        AVUser.requestPasswordResetInBackground(email, false, callback);
    }

    private static void requestPasswordResetInBackground(String email, boolean sync, RequestPasswordResetCallback callback) {
        final RequestPasswordResetCallback internalCallback = callback;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        String object = AVUtils.jsonStringFromMapWithNull(map);
        PaasClient.storageInstance().postObject("requestPasswordReset", object, sync, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    public void updatePassword(String oldPassword, String newPassword) throws AVException {
        final AVException[] errors = new AVException[1];
        this.updatePasswordInBackground(oldPassword, newPassword, new UpdatePasswordCallback(){

            public void done(AVException e) {
                errors[0] = e;
            }
        }, true);
        if (errors[0] != null) {
            throw errors[0];
        }
    }

    public void updatePasswordInBackground(String oldPassword, String newPassword, UpdatePasswordCallback callback) {
        this.updatePasswordInBackground(oldPassword, newPassword, callback, false);
    }

    private void updatePasswordInBackground(String oldPassword, String newPassword, final UpdatePasswordCallback callback, boolean sync) {
        if (!this.isAuthenticated() || AVUtils.isBlankString(this.getObjectId())) {
            callback.done(AVErrorUtils.sessionMissingException());
        } else {
            String relativePath = String.format("users/%s/updatePassword", this.getObjectId());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("old_password", oldPassword);
            params.put("new_password", newPassword);
            String paramsString = AVUtils.restfulServerData(params);
            PaasClient.storageInstance().putObject(relativePath, paramsString, sync, this.headerMap(), new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    callback.done(e);
                }

                public void onFailure(Throwable error, String content) {
                    callback.done(new AVException(error));
                }
            }, this.getObjectId(), this.getObjectId());
        }
    }

    public static void requestEmailVerify(String email) {
        AVUser.requestEmailVerfiyInBackground(email, true, null);
    }

    public static void requestEmailVerfiyInBackground(String email, RequestEmailVerifyCallback callback) {
        AVUser.requestEmailVerfiyInBackground(email, false, callback);
    }

    private static void requestEmailVerfiyInBackground(String email, boolean sync, RequestEmailVerifyCallback callback) {
        final RequestEmailVerifyCallback internalCallback = callback;
        if (AVUtils.isBlankString(email) || !AVUtils.checkEmailAddress(email)) {
            callback.internalDone(new AVException(125, "Invalid Email"));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        String object = AVUtils.jsonStringFromMapWithNull(map);
        PaasClient.storageInstance().postObject("requestEmailVerify", object, sync, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, null);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (internalCallback != null) {
                    internalCallback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    public void setEmail(String email) {
        this.email = email;
        this.put("email", email);
    }

    public void setPassword(String password) {
        this.password = password;
        this.put("password", password);
    }

    public void setUsername(String username) {
        this.username = username;
        this.put("username", username);
    }

    private String signUpPath() {
        return "users";
    }

    private void signUp(boolean sync, final SignUpCallback callback) {
        block5: {
            if (sync) {
                try {
                    this.save();
                    if (callback != null) {
                        callback.internalDone(null);
                    }
                    break block5;
                }
                catch (AVException e) {
                    if (callback != null) {
                        callback.internalDone(e);
                    }
                    break block5;
                }
            }
            this.saveInBackground(new SaveCallback(){

                public void done(AVException e) {
                    if (callback != null) {
                        callback.internalDone(e);
                    }
                }
            });
        }
    }

    public void signUp() throws AVException {
        this.signUp(true, new SignUpCallback(){

            public void done(AVException e) {
                if (e != null) {
                    AVExceptionHolder.add(e);
                }
            }

            protected boolean mustRunOnUIThread() {
                return false;
            }
        });
        if (AVExceptionHolder.exists()) {
            throw AVExceptionHolder.remove();
        }
    }

    public void signUpInBackground(SignUpCallback callback) {
        this.signUp(false, callback);
    }

    void setSinaWeiboToken(String token) {
        this.sinaWeiboToken = token;
    }

    public String getSinaWeiboToken() {
        return this.sinaWeiboToken;
    }

    void setQQWeiboToken(String token) {
        this.qqWeiboToken = token;
    }

    public String getQQWeiboToken() {
        return this.qqWeiboToken;
    }

    @Override
    protected void onSaveSuccess() {
        AVUser.changeCurrentUser(this, true);
    }

    @Override
    protected Map<String, String> headerMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!AVUtils.isBlankString(this.sessionToken)) {
            map.put(PaasClient.sessionTokenField, this.sessionToken);
        }
        return map;
    }

    static AVUser userFromSinaWeibo(String weiboToken, String userName) {
        Object user = AVUser.newAVUser();
        ((AVUser)user).sinaWeiboToken = weiboToken;
        ((AVUser)user).username = userName;
        return user;
    }

    static AVUser userFromQQWeibo(String weiboToken, String userName) {
        Object user = AVUser.newAVUser();
        ((AVUser)user).qqWeiboToken = weiboToken;
        ((AVUser)user).username = userName;
        return user;
    }

    private boolean checkUserAuthentication(AVCallback callback) {
        if (!this.isAuthenticated() || AVUtils.isBlankString(this.getObjectId())) {
            if (callback != null) {
                callback.internalDone(AVErrorUtils.createException(206, "No valid session token, make sure signUp or login has been called."));
            }
            return false;
        }
        return true;
    }

    public void followInBackground(String userObjectId, final FollowCallback callback) {
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        String endPoint = AVPowerfulUtils.getFollowEndPoint(this.getObjectId(), userObjectId);
        PaasClient.storageInstance().postObject(endPoint, "", false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                super.onSuccess(content, e);
                if (callback != null) {
                    callback.internalDone0(AVUser.this, (AVException)null);
                }
            }

            public void onFailure(Throwable error, String content) {
                super.onFailure(error, content);
                if (callback != null) {
                    callback.internalDone0(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public void unfollowInBackground(String userObjectId, final FollowCallback callback) {
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        String endPoint = AVPowerfulUtils.getFollowEndPoint(this.getObjectId(), userObjectId);
        PaasClient.storageInstance().deleteObject(endPoint, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                super.onSuccess(content, e);
                if (callback != null) {
                    callback.internalDone0(AVUser.this, (AVException)null);
                }
            }

            public void onFailure(Throwable error, String content) {
                super.onFailure(error, content);
                if (callback != null) {
                    callback.internalDone0(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    private List<AVUser> processResultByTag(String content, String tag) {
        LinkedList<AVUser> list = new LinkedList<AVUser>();
        if (AVUtils.isBlankString(content)) {
            return list;
        }
        AVFollowResponse resp = new AVFollowResponse();
        resp = (AVFollowResponse)JSON.parseObject((String)content, resp.getClass());
        this.processResultList(resp.results, list, tag);
        return list;
    }

    private Map<String, List<AVUser>> processFollowerAndFollowee(String content) {
        HashMap<String, List<AVUser>> map = new HashMap<String, List<AVUser>>();
        if (AVUtils.isBlankString(content)) {
            return map;
        }
        AVFollowResponse resp = new AVFollowResponse();
        resp = (AVFollowResponse)JSON.parseObject((String)content, resp.getClass());
        LinkedList<AVUser> followers = new LinkedList<AVUser>();
        LinkedList<AVUser> followees = new LinkedList<AVUser>();
        this.processResultList(resp.followers, followers, FOLLOWER_TAG);
        this.processResultList(resp.followees, followees, FOLLOWEE_TAG);
        map.put(FOLLOWER_TAG, followers);
        map.put(FOLLOWEE_TAG, followees);
        return map;
    }

    private void processResultList(Map[] results, List<AVUser> list, String tag) {
        for (Map item : results) {
            if (item == null || item.isEmpty()) continue;
            AVUser user = (AVUser)AVUtils.getObjectFrom(item.get(tag));
            list.add(user);
        }
    }

    public static <T extends AVUser> AVQuery<T> followerQuery(String userObjectId, Class<T> clazz) {
        if (AVUtils.isBlankString(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId.");
        }
        AVFriendshipQuery<T> query = new AVFriendshipQuery<T>(AVUser.userClassName(), clazz);
        String endPoint = AVPowerfulUtils.getFollowersEndPoint(userObjectId);
        query.setExternalQueryPath(endPoint);
        query.setFriendshipTag(FOLLOWER_TAG);
        return query;
    }

    public <T extends AVUser> AVQuery<T> followerQuery(Class<T> clazz) throws Exception {
        if (!AVUtils.isBlankString(this.getObjectId())) {
            throw AVErrorUtils.sessionMissingException();
        }
        return AVUser.followerQuery(this.getObjectId(), clazz);
    }

    public static <T extends AVUser> AVQuery<T> followeeQuery(String userObjectId, Class<T> clazz) {
        if (AVUtils.isBlankString(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId.");
        }
        AVFriendshipQuery<T> query = new AVFriendshipQuery<T>(AVUser.userClassName(), clazz);
        String endPoint = AVPowerfulUtils.getFolloweesEndPoint(userObjectId);
        query.setExternalQueryPath(endPoint);
        query.setFriendshipTag(FOLLOWEE_TAG);
        return query;
    }

    public <T extends AVUser> AVQuery<T> followeeQuery(Class<T> clazz) throws Exception {
        if (AVUtils.isBlankString(this.getObjectId())) {
            throw AVErrorUtils.sessionMissingException();
        }
        return AVUser.followeeQuery(this.getObjectId(), clazz);
    }

    @Deprecated
    public void getFollowersInBackground(final FindCallback callback) {
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        String endPoint = AVPowerfulUtils.getFollowersEndPoint(this.getObjectId());
        PaasClient.storageInstance().getObject(endPoint, null, false, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                super.onSuccess(content, e);
                List list = AVUser.this.processResultByTag(content, AVUser.FOLLOWER_TAG);
                if (callback != null) {
                    callback.internalDone0(list, (AVException)null);
                }
            }

            public void onFailure(Throwable error, String content) {
                super.onFailure(error, content);
                if (callback != null) {
                    callback.internalDone0(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    @Deprecated
    public void getMyFolloweesInBackground(final FindCallback callback) {
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        String endPoint = AVPowerfulUtils.getFolloweesEndPoint(this.getObjectId());
        PaasClient.storageInstance().getObject(endPoint, null, false, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                super.onSuccess(content, e);
                List list = AVUser.this.processResultByTag(content, AVUser.FOLLOWEE_TAG);
                if (callback != null) {
                    callback.internalDone0(list, (AVException)null);
                }
            }

            public void onFailure(Throwable error, String content) {
                super.onFailure(error, content);
                if (callback != null) {
                    callback.internalDone0(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    @Deprecated
    public void getFollowersAndFolloweesInBackground(final FollowersAndFolloweesCallback callback) {
        if (!this.checkUserAuthentication(callback)) {
            return;
        }
        String endPoint = AVPowerfulUtils.getFollowersAndFollowees(this.getObjectId());
        PaasClient.storageInstance().getObject(endPoint, null, false, null, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                super.onSuccess(content, e);
                Map map = AVUser.this.processFollowerAndFollowee(content);
                if (callback != null) {
                    callback.internalDone0(map, (AVException)null);
                }
            }

            public void onFailure(Throwable error, String content) {
                super.onFailure(error, content);
                if (callback != null) {
                    callback.internalDone0(null, AVErrorUtils.createException(error, content));
                }
            }
        });
    }

    public static <T extends AVUser> T cast(AVUser user, Class<T> clazz) {
        try {
            String jsonString = JSON.toJSONString((Object)user, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField, SerializerFeature.QuoteFieldNames, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse});
            AVUser newUser = (AVUser)JSON.parseObject((String)jsonString, clazz);
            return (T)newUser;
        }
        catch (Exception e) {
            LogUtil.log.e("ClassCast Exception", e);
            return null;
        }
    }

    public static void alwaysUseSubUserClass(Class<? extends AVUser> clazz) {
        subClazz = clazz;
    }

    private static Map<String, Object> authData(AVThirdPartyUserAuth userInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(accessTokenTag, userInfo.accessToken);
        map.put(expiresAtTag, userInfo.expiredAt);
        if (!AVUtils.isBlankString(userInfo.snsType)) {
            map.put(AVThirdPartyUserAuth.platformUserIdTag(userInfo.snsType), userInfo.userId);
        }
        result.put(userInfo.snsType, map);
        return result;
    }

    public static void loginWithAuthData(AVThirdPartyUserAuth userInfo, LogInCallback<AVUser> callback) {
        AVUser.loginWithAuthData(AVUser.class, userInfo, callback);
    }

    public static <T extends AVUser> void loginWithAuthData(final Class<T> clazz, AVThirdPartyUserAuth userInfo, final LogInCallback<T> callback) {
        if (userInfo == null) {
            if (callback != null) {
                callback.internalDone(null, AVErrorUtils.createException(-1, "NULL userInfo."));
            }
            return;
        }
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        data.put(authDataTag, AVUser.authData(userInfo));
        String jsonString = JSON.toJSONString(data);
        PaasClient.storageInstance().postObject("users", jsonString, false, false, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (e == null) {
                    Object userObject = AVUser.newAVUser(clazz, callback);
                    if (userObject == null) {
                        return;
                    }
                    AVUtils.copyPropertiesFromJsonStringToAVObject(content, userObject);
                    AVUser.changeCurrentUser(userObject, true);
                    if (callback != null) {
                        callback.internalDone(userObject, null);
                    }
                }
            }

            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.internalDone(null, AVErrorUtils.createException(error, content));
                }
            }
        }, null, null);
    }

    public static void associateWithAuthData(AVUser user, AVThirdPartyUserAuth userInfo, SaveCallback callback) {
        if (userInfo == null) {
            if (callback != null) {
                callback.internalDone(AVErrorUtils.createException(-1, "NULL userInfo."));
            }
            return;
        }
        Map<String, Object> authData = AVUser.authData(userInfo);
        if (user.get(authDataTag) != null && user.get(authDataTag) instanceof Map) {
            authData.putAll((Map)user.get(authDataTag));
        }
        user.put(authDataTag, authData);
        user.saveInBackground(callback);
    }

    public static void dissociateAuthData(AVUser user, String type, SaveCallback callback) {
        Map authData = (Map)user.get(authDataTag);
        if (authData != null) {
            authData.remove(type);
        }
        user.put(authDataTag, authData);
        if (!AVUtils.isBlankString(user.getSessionToken()) && !AVUtils.isBlankString(user.getObjectId())) {
            user.saveInBackground(callback);
        } else if (callback != null) {
            callback.internalDone(new AVException(206, "the user object missing a valid session"));
        }
    }

    public static class AVThirdPartyUserAuth {
        String accessToken;
        String expiredAt;
        String snsType;
        String userId;
        public static final String SNS_TENCENT_WEIBO = "qq";
        public static final String SNS_SINA_WEIBO = "weibo";

        public AVThirdPartyUserAuth(String accessToken, String expiredAt, String snstype) {
            this.accessToken = accessToken;
            this.snsType = snstype;
            this.expiredAt = expiredAt;
        }

        protected static String platformUserIdTag(String type) {
            if (SNS_TENCENT_WEIBO.equalsIgnoreCase(type)) {
                return "openid";
            }
            if (SNS_SINA_WEIBO.equalsIgnoreCase(type)) {
                return "uid";
            }
            throw new IllegalStateException("Unknown SNSType:" + type);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getExpireAt() {
            return this.expiredAt;
        }

        public void setExpireAt(String expireAt) {
            this.expiredAt = expireAt;
        }

        public String getSnsType() {
            return this.snsType;
        }

        public void setSnsType(String snsType) {
            this.snsType = snsType;
        }
    }
}

