/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVACL;
import com.avos.avoscloud.AVCacheManager;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVOSSSLSocketFactory;
import com.avos.avoscloud.AVOSServices;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVObjectReferenceCount;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVQuery;
import com.avos.avoscloud.AVRuntimeException;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.DataFetchCallbackWithFailureRetry;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.GetHttpResponseHandler;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PostHttpResponseHandler;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SyncHttpClient;
import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaasClient {
    private static final CookieStore COOKIE_STORE = new ForgotCookieStore();
    private String baseUrl;
    private final String apiVersion;
    static String applicationIdField;
    static String apiKeyField;
    static AVOSSSLSocketFactory socketFactory;
    public static String sessionTokenField;
    private static boolean isUrulu;
    private boolean isProduction = true;
    private static final String defaultEncoding = "UTF-8";
    private static final String defaultContentType = "application/json";
    public static final String DEFAULT_FAIL_STRING = "request failed!!!";
    public static final String sdkVersion = "v2.5.8.1";
    private static final String userAgent = "AVOS Cloud android-v2.5.8.1 SDK";
    private AVUser currentUser = null;
    private AVACL defaultACL;
    private SyncHttpClient syncHttpClient;
    private AsyncHttpClient asyncHttpClient;
    private static boolean lastModifyEnabled;
    static Map<String, String> serviceHostMap;
    static HashMap<String, PaasClient> serviceClientMap;
    static Map<String, AVObjectReferenceCount> internalObjectsForEventuallySave;
    private static Map<String, String> lastModify;
    private static Comparator<File> fileModifiedDateComparator;

    void setProduction(boolean production) {
        this.isProduction = production;
    }

    public static boolean isAVOSCloud() {
        return isUrulu;
    }

    protected static PaasClient sharedInstance(AVOSServices service) {
        String host = AVUtils.isBlankString(serviceHostMap.get(service.toString())) ? serviceHostMap.get(AVOSServices.STORAGE_SERVICE.toString()) : serviceHostMap.get(service.toString());
        PaasClient instance = serviceClientMap.get(host);
        if (instance == null) {
            instance = new PaasClient();
            instance.setBaseUrl(host);
            serviceClientMap.put(host, instance);
        }
        return instance;
    }

    public static PaasClient storageInstance() {
        return PaasClient.sharedInstance(AVOSServices.STORAGE_SERVICE);
    }

    public static PaasClient cloudInstance() {
        return PaasClient.sharedInstance(AVOSServices.FUNCTION_SERVICE);
    }

    public static PaasClient statistisInstance() {
        return PaasClient.sharedInstance(AVOSServices.STATISTICS_SERVICE);
    }

    AVACL getDefaultACL() {
        return this.defaultACL;
    }

    void setDefaultACL(AVACL acl) {
        this.defaultACL = acl;
    }

    AVUser getCurrentUser() {
        return this.currentUser;
    }

    public Map<String, String> userHeaderMap() {
        AVUser user = AVUser.getCurrentUser();
        if (user != null) {
            return user.headerMap();
        }
        return null;
    }

    void setCurrentUser(AVUser user) {
        this.currentUser = user;
    }

    private PaasClient() {
        this.apiVersion = "1";
        if (isUrulu) {
            this.useUruluServer();
        } else {
            this.useOfficalParseServer();
        }
    }

    private String signRequest() {
        StringBuilder builder = new StringBuilder();
        long ts = AVUtils.getCurrentTimestamp();
        StringBuilder result = new StringBuilder();
        result.append(AVUtils.md5(builder.append(ts).append(AVOSCloud.clientKey).toString()).toLowerCase());
        return result.append(",").append(ts).toString();
    }

    private void updateHeaders(AsyncHttpClient client) {
        client.addHeader("X-Uluru-Application-Production", this.isProduction ? "1" : "0");
        AVUser currAVUser = AVUser.getCurrentUser();
        client.addHeader(sessionTokenField, currAVUser != null && currAVUser.getSessionToken() != null ? currAVUser.getSessionToken() : "");
        client.addHeader(applicationIdField, AVOSCloud.applicationId);
        client.addHeader("Accept", defaultContentType);
        client.addHeader("Content-Type", defaultContentType);
        client.setUserAgent(userAgent);
        client.addHeader("x-avoscloud-request-sign", this.signRequest());
    }

    private synchronized AVOSSSLSocketFactory sslSocketFactory() {
        if (socketFactory != null) {
            return socketFactory;
        }
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            socketFactory = new AVOSSSLSocketFactory(trustStore);
            socketFactory.setHostnameVerifier(AVOSSSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return socketFactory;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Create SSL socket factory failed", exception);
        }
    }

    private void configHttpClient(AsyncHttpClient client) {
        client.getHttpClient().getParams().setBooleanParameter("http.tcp.nodelay", true);
        client.setTimeout(AVOSCloud.getNetworkTimeout());
        client.setCookieStore(COOKIE_STORE);
        client.setThreadPool((ThreadPoolExecutor)Executors.newFixedThreadPool(AVOSCloud.getThreadPoolSize()));
    }

    private synchronized AsyncHttpClient clientInstance(boolean sync) {
        if (sync) {
            if (this.syncHttpClient == null) {
                this.syncHttpClient = new SyncHttpClient(){

                    public String onRequestFailed(Throwable throwable, String s) {
                        return s != null ? s : throwable.getMessage();
                    }
                };
                this.syncHttpClient.setSSLSocketFactory((SSLSocketFactory)this.sslSocketFactory());
                this.configHttpClient((AsyncHttpClient)this.syncHttpClient);
            }
            this.updateHeaders((AsyncHttpClient)this.syncHttpClient);
            return this.syncHttpClient;
        }
        if (this.asyncHttpClient == null) {
            this.asyncHttpClient = new AsyncHttpClient();
            this.asyncHttpClient.setSSLSocketFactory((SSLSocketFactory)this.sslSocketFactory());
            this.configHttpClient(this.asyncHttpClient);
        }
        this.updateHeaders(this.asyncHttpClient);
        return this.asyncHttpClient;
    }

    public void useUruluServer() {
        this.useAVCloudCN();
    }

    public void useOfficalParseServer() {
        isUrulu = false;
        this.baseUrl = "https://api.parse.com";
        applicationIdField = "X-AVOSCloud-Application-Id";
        apiKeyField = "X-AVOSCloud-REST-API-Key";
        sessionTokenField = "X-AVOSCloud-Session-Token";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeAV);
    }

    public void useAVCloudUS() {
        isUrulu = true;
        this.baseUrl = "https://us.avoscloud.com";
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), this.baseUrl);
        applicationIdField = "X-avoscloud-Application-Id";
        apiKeyField = "X-avoscloud-Application-Key";
        sessionTokenField = "X-avoscloud-Session-Token";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeS3);
    }

    public void useAVCloudCN() {
        isUrulu = true;
        this.baseUrl = "https://cn.avoscloud.com";
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), this.baseUrl);
        applicationIdField = "X-avoscloud-Application-Id";
        apiKeyField = "X-avoscloud-Application-Key";
        sessionTokenField = "X-avoscloud-Session-Token";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeQiniu);
    }

    public void useLocalStg() {
        isUrulu = true;
        this.baseUrl = "https://cn-stg1.avoscloud.com";
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), this.baseUrl);
        applicationIdField = "X-avoscloud-Application-Id";
        apiKeyField = "X-avoscloud-Application-Key";
        sessionTokenField = "X-avoscloud-Session-Token";
        AVOSCloud.setStorageType(AVOSCloud.StorageType.StorageTypeQiniu);
    }

    public String buildUrl(String path) {
        return String.format("%s/%s/%s", this.baseUrl, this.apiVersion, path);
    }

    private String batchUrl() {
        return String.format("%s/%s/batch", this.baseUrl, this.apiVersion);
    }

    private String batchSaveRelativeUrl() {
        return "batch/save";
    }

    private AsyncHttpResponseHandler createGetHandler(GenericObjectCallback callback) {
        GetHttpResponseHandler handler = new GetHttpResponseHandler(callback, AVQuery.CachePolicy.IGNORE_CACHE, null);
        return handler;
    }

    private AsyncHttpResponseHandler createGetHandler(GenericObjectCallback callback, AVQuery.CachePolicy policy, String absoluteURLString) {
        GetHttpResponseHandler handler = new GetHttpResponseHandler(callback, policy, absoluteURLString);
        return handler;
    }

    private AsyncHttpResponseHandler createPostHandler(GenericObjectCallback callback) {
        PostHttpResponseHandler handler = new PostHttpResponseHandler(callback);
        return handler;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    protected static void setServiceHost(AVOSServices service, String host) {
        serviceHostMap.put(service.toString(), host);
    }

    public String getObject(final String relativePath, final RequestParams parameters, final boolean sync, final Map<String, String> header, final GenericObjectCallback callback, final AVQuery.CachePolicy policy, final long maxAgeInMilliseconds) {
        final String absolutURLString = this.generateQueryPath(relativePath, parameters);
        final String lastModify = this.updateHeaderForPath(relativePath, parameters, header);
        switch (policy) {
            default: {
                this.getObject(relativePath, parameters, sync, header, callback, policy);
                break;
            }
            case CACHE_ONLY: {
                AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModify, callback);
                break;
            }
            case NETWORK_ONLY: {
                this.getObject(relativePath, parameters, sync, header, callback, policy);
                break;
            }
            case CACHE_ELSE_NETWORK: {
                AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModify, new GenericObjectCallback(){

                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                    }

                    public void onFailure(Throwable error, String content) {
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                this.getObject(relativePath, parameters, sync, header, new GenericObjectCallback(){

                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                    }

                    public void onFailure(Throwable error, String content) {
                        AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModify, callback);
                    }
                }, policy);
                break;
            }
            case CACHE_THEN_NETWORK: {
                AVCacheManager.sharedInstance().get(absolutURLString, maxAgeInMilliseconds, lastModify, new GenericObjectCallback(){

                    public void onSuccess(String content, AVException e) {
                        callback.onSuccess(content, e);
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }

                    public void onFailure(Throwable error, String content) {
                        callback.onFailure(error, content);
                        PaasClient.this.getObject(relativePath, parameters, sync, header, callback, policy);
                    }
                });
            }
        }
        return absolutURLString;
    }

    String generateQueryPath(String relativePath, RequestParams parameters) {
        String absolutURLString = AsyncHttpClient.getUrlWithQueryString((boolean)true, (String)this.buildUrl(relativePath), (RequestParams)parameters);
        return absolutURLString;
    }

    public void getObject(String relativePath, RequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy) {
        this.getObject(relativePath, parameters, sync, inputHeader, callback, policy, !policy.equals((Object)AVQuery.CachePolicy.CACHE_ONLY) && PaasClient.isLastModifyEnabled());
    }

    public void getObject(String relativePath, RequestParams parameters, boolean sync, Map<String, String> inputHeader, GenericObjectCallback callback, AVQuery.CachePolicy policy, boolean retry) {
        Map<String, String> myHeader = inputHeader;
        if (inputHeader == null) {
            myHeader = new HashMap<String, String>();
        }
        this.updateHeaderForPath(relativePath, parameters, myHeader);
        String url = this.buildUrl(relativePath);
        if (retry) {
            callback = new DataFetchCallbackWithFailureRetry(relativePath, parameters, sync, null, callback, policy);
        }
        AsyncHttpResponseHandler handler = this.createGetHandler(callback, policy, AsyncHttpClient.getUrlWithQueryString((boolean)true, (String)url, (RequestParams)parameters));
        if (AVOSCloud.showInternalDebugLog()) {
            this.dumpHttpGetRequest(url, parameters);
        }
        AsyncHttpClient client = this.clientInstance(sync);
        this.addHeader(client, myHeader);
        client.get(url, parameters, (ResponseHandlerInterface)handler);
    }

    public void getObject(String relativePath, RequestParams parameters, boolean sync, Map<String, String> header, GenericObjectCallback callback) {
        this.getObject(relativePath, parameters, sync, header, callback, AVQuery.CachePolicy.IGNORE_CACHE);
    }

    public void putObject(String relativePath, String object, boolean sync, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        this.putObject(relativePath, object, sync, false, header, callback, objectId, _internalId);
    }

    private void addHeader(AsyncHttpClient client, Map<String, String> header) {
        if (header == null) {
            return;
        }
        Set<String> keys = header.keySet();
        for (String key : keys) {
            client.addHeader(key, header.get(key));
        }
    }

    public void putObject(String relativePath, String object, boolean sync, boolean isEventually, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            if (isEventually) {
                File archivedFile = this.archiveRequest("put", relativePath, object, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(relativePath);
                ByteArrayEntity entity = new ByteArrayEntity(object.getBytes(defaultEncoding));
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                if (AVOSCloud.showInternalDebugLog()) {
                    this.dumpHttpPutRequest(header, url, object);
                }
                AsyncHttpClient client = this.clientInstance(sync);
                this.addHeader(client, header);
                client.put(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    private void processException(Exception e, GenericObjectCallback cb) {
        if (cb != null) {
            cb.onFailure(e, null);
        }
    }

    Map<String, Object> batchItemMap(String method, String path, Object body, Map params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("method", method);
        result.put("path", path);
        result.put("body", body);
        if (params != null) {
            result.put("params", params);
        }
        return result;
    }

    Map<String, Object> batchItemMap(String method, String path, Object body) {
        return this.batchItemMap(method, path, body, null);
    }

    @Deprecated
    List<Object> assembleBatchOpsList(List<Object> itemList, String path) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : itemList) {
            Map<String, Object> opDict = this.batchItemMap("PUT", path, object);
            list.add(opDict);
        }
        return list;
    }

    private Map<String, Object> batchRequest(List<Object> list) {
        HashMap<String, Object> requests = new HashMap<String, Object>();
        requests.put("requests", list);
        return requests;
    }

    public void postBatchObject(List<Object> parameters, boolean sync, Map<String, String> header, GenericObjectCallback callback) {
        try {
            String url = this.batchUrl();
            Map<String, Object> requests = this.batchRequest(parameters);
            String json = JSON.toJSONString(requests);
            ByteArrayEntity entity = new ByteArrayEntity(json.getBytes(defaultEncoding));
            if (AVOSCloud.showInternalDebugLog()) {
                this.dumpHttpPostRequest(header, url, json);
            }
            PostHttpResponseHandler handler = new PostHttpResponseHandler(callback);
            AsyncHttpClient client = this.clientInstance(sync);
            this.addHeader(client, header);
            client.post(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postBatchSave(List list, boolean sync, boolean isEventually, Map<String, String> header, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("requests", list);
            String paramString = AVUtils.jsonStringFromMapWithNull(params);
            if (isEventually) {
                File archivedFile = this.archiveRequest("post", this.batchSaveRelativeUrl(), paramString, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(this.batchSaveRelativeUrl());
                ByteArrayEntity entity = new ByteArrayEntity(paramString.getBytes(defaultEncoding));
                if (AVOSCloud.showInternalDebugLog()) {
                    this.dumpHttpPostRequest(header, url, paramString);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                AsyncHttpClient client = this.clientInstance(sync);
                this.addHeader(client, header);
                client.post(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postObject(String relativePath, String object, boolean sync, boolean isEventually, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            if (isEventually) {
                File archivedFile = this.archiveRequest("post", relativePath, object, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(relativePath);
                ByteArrayEntity entity = new ByteArrayEntity(object.getBytes(defaultEncoding));
                if (AVOSCloud.showInternalDebugLog()) {
                    this.dumpHttpPostRequest(null, url, object);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                this.clientInstance(sync).post(null, url, (HttpEntity)entity, defaultContentType, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void postObject(String relativePath, String object, boolean sync, GenericObjectCallback callback) {
        this.postObject(relativePath, object, sync, false, callback, null, null);
    }

    public void deleteObject(String relativePath, boolean sync, boolean isEventually, GenericObjectCallback callback, String objectId, String _internalId) {
        try {
            if (isEventually) {
                File archivedFile = this.archiveRequest("delete", relativePath, null, objectId, _internalId);
                this.handleArchivedRequest(archivedFile, sync, callback);
            } else {
                String url = this.buildUrl(relativePath);
                if (AVOSCloud.showInternalDebugLog()) {
                    this.dumpHttpPostRequest(null, url, null);
                }
                AsyncHttpResponseHandler handler = this.createPostHandler(callback);
                this.clientInstance(sync).delete(url, (ResponseHandlerInterface)handler);
            }
        }
        catch (Exception exception) {
            this.processException(exception, callback);
        }
    }

    public void deleteObject(String relativePath, boolean sync, GenericObjectCallback callback, String objectId, String _internalId) {
        this.deleteObject(relativePath, sync, false, callback, objectId, _internalId);
    }

    private File archiveRequest(String method, String relativePath, String paramString, String objectId, String _internalId) {
        File theArchivedFile = new File(AVPersistenceUtils.getCommandCacheDir(), AVUtils.getArchiveRequestFileName(objectId, _internalId, method, relativePath, paramString));
        HashMap<String, String> fileMap = new HashMap<String, String>(3);
        fileMap.put("method", method);
        fileMap.put("relativePath", relativePath);
        fileMap.put("paramString", paramString);
        fileMap.put("objectId", objectId);
        fileMap.put("_internalId", _internalId);
        AVPersistenceUtils.saveContentToFile(AVUtils.toJSON(fileMap), theArchivedFile);
        if (AVOSCloud.showInternalDebugLog()) {
            LogUtil.log.d(AVUtils.restfulServerData(fileMap) + "\n" + "did save to " + theArchivedFile.getAbsolutePath());
        }
        return theArchivedFile;
    }

    private void handleArchivedRequest(File archivedFile, boolean sync) {
        this.handleArchivedRequest(archivedFile, sync, null);
    }

    private void handleArchivedRequest(final File archivedFile, boolean sync, final GenericObjectCallback callback) {
        String archivedFileContent = AVPersistenceUtils.readContentFromFile(archivedFile);
        Map fileMap = AVUtils.getFromJSON(archivedFileContent, Map.class);
        String method = (String)fileMap.get("method");
        String relativePath = (String)fileMap.get("relativePath");
        String paramString = (String)fileMap.get("paramString");
        String objectId = (String)fileMap.get("objectId");
        String _internalId = (String)fileMap.get("_internalId");
        GenericObjectCallback newCallback = new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (callback != null) {
                    callback.onSuccess(content, e);
                }
                Map objectMap = AVUtils.getFromJSON(content, Map.class);
                for (String _internalId : objectMap.keySet()) {
                    if (internalObjectsForEventuallySave.get(_internalId) == null) continue;
                    internalObjectsForEventuallySave.get(_internalId).getValue().copyFromMap(objectMap);
                    PaasClient.unregisterEvtuallyObject(internalObjectsForEventuallySave.get(_internalId).getValue());
                }
                archivedFile.delete();
                AVPersistenceUtils.removeLock(archivedFile.getAbsolutePath());
            }

            public void onFailure(Throwable error, String content) {
                if (callback != null) {
                    callback.onFailure(error, content);
                }
                AVPersistenceUtils.removeLock(archivedFile.getAbsolutePath());
            }
        };
        if (method == null) {
            newCallback.onFailure(new AVRuntimeException("Null method."), null);
        }
        if ("post".equalsIgnoreCase(method)) {
            this.postObject(relativePath, paramString, sync, newCallback);
        } else if ("put".equalsIgnoreCase(method)) {
            this.putObject(relativePath, paramString, sync, null, newCallback, objectId, _internalId);
        } else if ("delete".equalsIgnoreCase(method)) {
            this.deleteObject(relativePath, sync, newCallback, objectId, _internalId);
        }
    }

    public void handleAllArchivedRequest() {
        this.handleAllArchivedRequest(false);
    }

    protected void handleAllArchivedRequest(boolean sync) {
        File commandCacheDir = AVPersistenceUtils.getCommandCacheDir();
        File[] archivedRequests = commandCacheDir.listFiles();
        if (archivedRequests != null && archivedRequests.length > 0) {
            Arrays.sort(archivedRequests, fileModifiedDateComparator);
            for (File file : archivedRequests) {
                this.handleArchivedRequest(file, sync);
            }
        }
    }

    public void dumpHttpGetRequest(String path, RequestParams parameters) {
        String string2 = "";
        if (parameters != null) {
            Object[] objectArray = new Object[6];
            objectArray[0] = applicationIdField;
            objectArray[1] = AVOSCloud.applicationId;
            objectArray[2] = apiKeyField;
            objectArray[3] = AVOSCloud.clientKey;
            objectArray[4] = parameters.toString();
            objectArray[5] = path;
            string2 = String.format("curl -X GET -H \"%s: %s\" -H \"%s: %s\" -G --data-urlencode '%s' %s", objectArray);
        } else {
            Object[] objectArray = new Object[5];
            objectArray[0] = applicationIdField;
            objectArray[1] = AVOSCloud.applicationId;
            objectArray[2] = apiKeyField;
            objectArray[3] = AVOSCloud.clientKey;
            objectArray[4] = path;
            string2 = String.format("curl -X GET -H \"%s: %s\" -H \"%s: %s\"  %s", objectArray);
        }
        LogUtil.avlog.d(string2);
    }

    private String headerString(Map<String, String> header) {
        Object[] objectArray = new Object[4];
        objectArray[0] = applicationIdField;
        objectArray[1] = AVOSCloud.applicationId;
        objectArray[2] = apiKeyField;
        objectArray[3] = AVOSCloud.clientKey;
        String string2 = String.format(" -H \"%s: %s\" -H \"%s: %s\" ", objectArray);
        if (header != null) {
            for (String key : header.keySet()) {
                String value = header.get(key);
                String item = String.format(" -H \"%s: %s\" ", key, value);
                string2 = string2 + item;
            }
        }
        string2 = string2 + " -H \"Content-Type: application/json\" ";
        return string2;
    }

    public void dumpHttpPutRequest(Map<String, String> header, String path, String object) {
        String string2 = String.format("curl -X PUT %s  -d ' %s ' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string2);
    }

    public void dumpHttpPostRequest(Map<String, String> header, String path, String object) {
        String string2 = String.format("curl -X POST %s  -d '%s' %s", this.headerString(header), object, path);
        LogUtil.avlog.d(string2);
    }

    public String updateHeaderForPath(String relativePath, RequestParams parameters, Map<String, String> header) {
        if (!PaasClient.isLastModifyEnabled()) {
            return null;
        }
        String absoluteURLString = this.generateQueryPath(relativePath, parameters);
        String modify = PaasClient.getLastModify(absoluteURLString);
        boolean exist = AVCacheManager.sharedInstance().hasCache(absoluteURLString, modify);
        if (modify != null && header != null && exist) {
            header.put("If-Modified-Since", modify);
        }
        return modify;
    }

    public static String getLastModify(String absolutURLString) {
        if (!PaasClient.isLastModifyEnabled()) {
            return null;
        }
        return lastModify.get(absolutURLString);
    }

    public static boolean isLastModifyEnabled() {
        return lastModifyEnabled;
    }

    public static void setLastModifyEnabled(boolean e) {
        lastModifyEnabled = e;
    }

    public static void clearLastModifyCache() {
        for (Map.Entry<String, String> pairs : lastModify.entrySet()) {
            AVCacheManager.sharedInstance().remove(pairs.getKey(), pairs.getValue());
        }
        lastModify.clear();
    }

    public static String lastModifyFromHeaders(Header[] headers) {
        for (Header h : headers) {
            if (!h.getName().equalsIgnoreCase("Last-Modified")) continue;
            return h.getValue();
        }
        return null;
    }

    public static boolean updateLastModify(String absolutURLString, String ts) {
        if (!PaasClient.isLastModifyEnabled()) {
            return false;
        }
        if (!AVUtils.isBlankString(ts)) {
            lastModify.put(absolutURLString, ts);
            return true;
        }
        return false;
    }

    public static void removeLastModifyForUrl(String absolutURLString) {
        lastModify.remove(absolutURLString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerEventuallyObject(AVObject object) {
        if (object != null) {
            AVObject aVObject = object;
            synchronized (aVObject) {
                AVObjectReferenceCount counter = internalObjectsForEventuallySave.get(object.internalId());
                if (counter != null) {
                    counter.increment();
                } else {
                    counter = new AVObjectReferenceCount(object);
                    internalObjectsForEventuallySave.put(object.internalId(), counter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterEvtuallyObject(AVObject object) {
        if (object != null) {
            AVObject aVObject = object;
            synchronized (aVObject) {
                AVObjectReferenceCount counter;
                AVObjectReferenceCount aVObjectReferenceCount = counter = internalObjectsForEventuallySave.get(object.internalId()) == null ? internalObjectsForEventuallySave.get(object.internalId()) : internalObjectsForEventuallySave.get(object.getUuid());
                if (counter != null && counter.desc() <= 0) {
                    internalObjectsForEventuallySave.remove(object.internalId());
                    internalObjectsForEventuallySave.remove(object.getUuid());
                }
            }
        }
    }

    static {
        socketFactory = null;
        isUrulu = true;
        lastModifyEnabled = false;
        serviceHostMap = Collections.synchronizedMap(new HashMap());
        serviceClientMap = new HashMap();
        internalObjectsForEventuallySave = Collections.synchronizedMap(new HashMap());
        serviceHostMap.put(AVOSServices.STORAGE_SERVICE.toString(), "https://cn.avoscloud.com");
        lastModify = Collections.synchronizedMap(new WeakHashMap());
        fileModifiedDateComparator = new Comparator<File>(){

            @Override
            public int compare(File f, File s) {
                return (int)(f.lastModified() - s.lastModified());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ForgotCookieStore
    implements CookieStore {
        private ForgotCookieStore() {
        }

        public List<Cookie> getCookies() {
            return Collections.emptyList();
        }

        public boolean clearExpired(Date date) {
            return true;
        }

        public void clear() {
        }

        public void addCookie(Cookie cookie) {
        }
    }
}

