/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.util.Base64;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVFile;
import com.avos.avoscloud.AVMultiPartEntity;
import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.HttpClientUploader;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ProgressCallback;
import com.avos.avoscloud.SaveCallback;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

class QiniuUploader
extends HttpClientUploader {
    private String bucket;
    private String token;
    private String key;
    private String hash;
    private String objectId;
    private String url;

    QiniuUploader(AVFile parseFile, SaveCallback saveCallback, ProgressCallback progressCallback) {
        super(parseFile, saveCallback, progressCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AVException doWork() {
        this.key = AVUtils.getRandomString(40);
        int idx = 0;
        if (this.parseFile.getName() != null) {
            idx = this.parseFile.getName().indexOf(".");
        }
        if (idx > 0) {
            String postFix = this.parseFile.getName().substring(idx);
            this.key = this.key + postFix;
        }
        DefaultHttpClient httpClient = QiniuUploader.getHttpClient();
        HttpResponse response = null;
        String serverResponse = null;
        try {
            byte[] bytes = this.parseFile.getData();
            AVException getBucketException = this.fetchUploadBucket();
            if (getBucketException != null) {
                AVException aVException = getBucketException;
                return aVException;
            }
            BasicHttpContext httpContext = new BasicHttpContext();
            this.httpPostRef.set(new HttpPost("http://up.qbox.me/upload"));
            AVMultiPartEntity multipartContent = new AVMultiPartEntity(new AVMultiPartEntity.ProgressListener(){

                public void transferred(long num) {
                    HttpPost httpPost;
                    if (QiniuUploader.this.isCancelled() && (httpPost = (HttpPost)QiniuUploader.this.httpPostRef.get()) != null) {
                        httpPost.abort();
                    }
                    QiniuUploader.this.publishProgress((int)((float)num / (float)QiniuUploader.this.totalSize * 100.0f));
                }
            });
            multipartContent.addPart("auth", (ContentBody)new StringBody(this.token));
            String encodedEntry = Base64.encodeToString((byte[])String.format("%s:%s", this.bucket, this.key).getBytes(), (int)10);
            String encodedMIMEType = Base64.encodeToString((byte[])this.parseFile.mimeType().getBytes(), (int)10);
            String action = "/rs-put/" + encodedEntry + "/mimeType/" + encodedMIMEType;
            multipartContent.addPart("action", (ContentBody)new StringBody(action));
            multipartContent.addPart("file", (ContentBody)new ByteArrayBody(bytes, this.key));
            this.totalSize = multipartContent.getContentLength();
            ((HttpPost)this.httpPostRef.get()).setEntity((HttpEntity)multipartContent);
            response = httpClient.execute((HttpUriRequest)this.httpPostRef.get(), (HttpContext)httpContext);
            serverResponse = EntityUtils.toString((HttpEntity)response.getEntity());
            if (!this.isCancelled()) {
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 201) {
                    this.destroyFileObject();
                    AVException aVException = AVErrorUtils.createException(-1, "upload file failure");
                    return aVException;
                }
                this.parseFile.handleUploadedResponse(this.objectId, this.objectId, this.url);
            }
        }
        catch (Exception e) {
            if (this.httpPostRef.get() != null) {
                ((HttpPost)this.httpPostRef.get()).abort();
            }
            LogUtil.log.e(e.toString());
            this.destroyFileObject();
            AVException aVException = new AVException(e.getCause());
            return aVException;
        }
        finally {
            if (serverResponse == null && response != null && response.getEntity() != null) {
                try {
                    AVPersistenceUtils.closeQuietly(response.getEntity().getContent());
                }
                catch (Exception e) {}
            }
        }
        this.closeExpiredConnections();
        return null;
    }

    private void destroyFileObject() {
        if (!AVUtils.isBlankString(this.objectId)) {
            try {
                AVObject fileObject = AVObject.createWithoutData("_File", this.objectId);
                fileObject.deleteInBackground();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private AVException handleGetBucketResponse(String responseStr, AVException exception) {
        if (exception != null) {
            return exception;
        }
        try {
            JSONObject jsonObject = new JSONObject(responseStr);
            this.bucket = jsonObject.getString("bucket");
            this.objectId = jsonObject.getString("objectId");
            this.token = jsonObject.getString("token");
            this.url = jsonObject.getString("url");
        }
        catch (JSONException e) {
            return new AVException(e);
        }
        return null;
    }

    private String getGetBucketParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("key", this.key);
        parameters.put("name", this.parseFile.getName());
        parameters.put("mime_type", this.parseFile.mimeType());
        parameters.put("metaData", this.parseFile.getMetaData());
        parameters.put("__type", AVFile.className());
        return AVUtils.restfulServerData(parameters);
    }

    protected String getUploadPath() {
        return "qiniu";
    }

    protected AVException fetchUploadBucket() {
        final AVException[] exceptionWhenGetBucket = new AVException[1];
        PaasClient.storageInstance().postObject(this.getUploadPath(), this.getGetBucketParameters(), true, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                exceptionWhenGetBucket[0] = QiniuUploader.this.handleGetBucketResponse(content, e);
            }

            public void onFailure(Throwable error, String content) {
                exceptionWhenGetBucket[0] = AVErrorUtils.createException(error, content);
            }
        });
        if (exceptionWhenGetBucket[0] != null) {
            this.destroyFileObject();
            return exceptionWhenGetBucket[0];
        }
        return null;
    }
}

