/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud.ops;

import com.avos.avoscloud.AVObject;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.ops.AVOp;
import com.avos.avoscloud.ops.BaseOp;
import com.avos.avoscloud.ops.CompoundOp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveOp
extends BaseOp {
    private Set<Object> values = new HashSet<Object>();

    public RemoveOp(String key, Collection<?> values) {
        super(key, AVOp.OpType.Remove);
        if (values != null) {
            for (Object obj : values) {
                this.values.add(obj);
            }
        }
    }

    public RemoveOp() {
    }

    Set<Object> getValues() {
        return this.values;
    }

    void setValues(Set<Object> values) {
        this.values = values;
    }

    @Override
    public Map<String, Object> encodeOp() {
        return AVUtils.createArrayOpMap(this.key, "Remove", this.values);
    }

    @Override
    public AVObject apply(AVObject obj) {
        obj.removeAll(this.key, this.values);
        return obj;
    }

    @Override
    public AVOp merge(AVOp other) {
        this.assertKeyEquals(other);
        switch (other.type()) {
            case Null: {
                return this;
            }
            case Set: {
                return other;
            }
            case Remove: {
                this.values.addAll(other.cast(RemoveOp.class).values);
                return this;
            }
            case AddUnique: 
            case Add: 
            case AddRelation: 
            case RemoveRelation: {
                return new CompoundOp(this.key, this, other);
            }
            case Increment: {
                throw new UnsupportedOperationException("Could not increment an non-numberic value.");
            }
            case Delete: {
                return other;
            }
            case Compound: {
                other.cast(CompoundOp.class).addFirst(this);
                return other;
            }
        }
        throw new IllegalStateException("Unknow op type " + (Object)((Object)other.type()));
    }
}

