/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.map.e;
import com.baidu.platform.comapi.map.w;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    private static final String a = BaiduMap.class.getSimpleName();
    private Projection b;
    private UiSettings c;
    private e d;
    private List<Overlay> e;
    private Overlay.a f;
    private OnMapStatusChangeListener g;
    private OnMapClickListener h;
    private OnMapLoadedCallback i;
    private OnMapDoubleClickListener j;
    private OnMapLongClickListener k;
    private OnMarkerClickListener l;
    private OnMarkerDragListener m;
    private OnMyLocationClickListener n;
    private SnapshotReadyCallback o;
    private HeatMap p;
    private Lock q = new ReentrantLock();
    private InfoWindow r;
    private Marker s;
    private Marker t;
    private MyLocationData u;
    private MyLocationConfiguration v;
    private boolean w;

    BaiduMap(e e2) {
        this.d = e2;
        this.c = new UiSettings(this.d);
        this.e = new LinkedList<Overlay>();
        this.f = new a(this);
        b b2 = new b(this);
        this.d.a(b2);
        c c2 = new c(this);
        this.d.a(c2);
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.f;
        Bundle bundle = new Bundle();
        overlay.a(bundle);
        this.d.a(bundle);
        this.e.add(overlay);
        return overlay;
    }

    public final void clear() {
        this.e.clear();
        this.d.n();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        w w2 = this.a(mapStatusUpdate);
        this.d.a(w2);
        if (this.g != null) {
            this.g.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        w w2 = this.d.m();
        return MapStatus.a(w2);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        w w2 = this.a(mapStatusUpdate);
        if (!this.w) {
            this.d.a(w2);
        } else {
            this.d.a(w2, n2);
        }
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private w a(MapStatusUpdate mapStatusUpdate) {
        w w2 = this.d.m();
        MapStatus mapStatus = mapStatusUpdate.a(this.d, this.getMapStatus());
        w w3 = mapStatus.b(w2);
        return w3;
    }

    public final void setMapType(int n2) {
        if (n2 == 1) {
            this.d.b(false);
        } else if (n2 == 2) {
            this.d.b(true);
        }
    }

    public final int getMapType() {
        return this.d.c() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        return this.d.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 19.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        this.d.a = f2;
        this.d.b = f3;
    }

    public final float getMinZoomLevel() {
        return this.d.b;
    }

    public final Projection getProjection() {
        return this.b;
    }

    public final UiSettings getUiSettings() {
        return this.c;
    }

    public final void setBuildingsEnabled(boolean bl) {
        this.d.c(bl);
    }

    public final boolean isBuildingsEnabled() {
        return this.d.d();
    }

    public final void setMyLocationEnabled(boolean bl) {
        this.d.e(bl);
    }

    public final boolean isMyLocationEnabled() {
        return this.d.f();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.u = myLocationData;
        if (this.v == null) {
            this.v = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.v);
    }

    public final MyLocationData getLocationData() {
        return this.u;
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.v = myLocationConfiguration;
        this.a(this.u, this.v);
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.v;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        com.baidu.platform.comapi.a.b b2 = com.baidu.mapapi.model.a.a(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", b2.b());
            jSONObject2.put("pty", b2.a());
            float f2 = com.baidu.mapapi.model.a.a(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", b2.b());
                jSONObject3.put("pty", b2.a());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        this.d.a(jSONObject.toString(), bundle);
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.q.lock();
        try {
            if (heatMap == this.p) {
                return;
            }
            if (this.p != null) {
                this.p.a();
                this.p.b();
                this.p.b = null;
                this.d.o();
            }
            this.p = heatMap;
            this.p.b = this;
            this.d.f(true);
        }
        finally {
            this.q.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(HeatMap heatMap) {
        this.q.lock();
        try {
            if (this.p != null && heatMap == this.p) {
                this.p.a();
                this.p.b();
                this.p.b = null;
                this.d.o();
                this.p = null;
                this.d.f(false);
            }
        }
        finally {
            this.q.unlock();
        }
    }

    void a() {
        this.d.g();
    }

    public final void setTrafficEnabled(boolean bl) {
        this.d.a(bl);
    }

    public final boolean isTrafficEnabled() {
        return this.d.b();
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.o = snapshotReadyCallback;
        this.d.a("anything");
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            this.hideInfoWindow();
            this.r = infoWindow;
            BitmapDescriptor bitmapDescriptor = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            MarkerOptions markerOptions = new MarkerOptions().perspective(false).icon(bitmapDescriptor).position(infoWindow.c).zIndex(Integer.MAX_VALUE);
            this.s = (Marker)this.addOverlay(markerOptions);
        }
    }

    public void hideInfoWindow() {
        if (this.r != null) {
            this.r = null;
            this.s.remove();
            this.s = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.g = onMapStatusChangeListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.h = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.i = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.j = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.k = onMapLongClickListener;
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        this.l = onMarkerClickListener;
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.m = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.n = onMyLocationClickListener;
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.e;
    }

    static /* synthetic */ e b(BaiduMap baiduMap) {
        return baiduMap.d;
    }

    static /* synthetic */ OnMapStatusChangeListener c(BaiduMap baiduMap) {
        return baiduMap.g;
    }

    static /* synthetic */ OnMapClickListener d(BaiduMap baiduMap) {
        return baiduMap.h;
    }

    static /* synthetic */ OnMapDoubleClickListener e(BaiduMap baiduMap) {
        return baiduMap.j;
    }

    static /* synthetic */ OnMapLongClickListener f(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.b = projection;
        return baiduMap.b;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.w = bl;
        return baiduMap.w;
    }

    static /* synthetic */ OnMapLoadedCallback g(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ SnapshotReadyCallback h(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ OnMyLocationClickListener i(BaiduMap baiduMap) {
        return baiduMap.n;
    }

    static /* synthetic */ InfoWindow j(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ Marker k(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ OnMarkerClickListener l(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ Marker m(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ Projection n(BaiduMap baiduMap) {
        return baiduMap.b;
    }

    static /* synthetic */ OnMarkerDragListener o(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.t = marker;
        return baiduMap.t;
    }

    static /* synthetic */ Lock p(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ HeatMap q(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

