/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.support.v4.util.LongSparseArray;
import android.util.SparseIntArray;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.map.e;
import com.baidu.mapapi.map.i;
import com.baidu.mapapi.map.j;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.c.a;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public class HeatMap {
    private static final String c = HeatMap.class.getSimpleName();
    private static final SparseIntArray d = new SparseIntArray();
    private static final int[] e;
    private static final float[] f;
    private i<WeightedLatLng> g;
    private Collection<WeightedLatLng> h;
    private int i;
    private Gradient j;
    private double k;
    private d l;
    private int[] m;
    private double[] n;
    private double[] o;
    private HashMap<String, j> p = new HashMap();
    private ExecutorService q = Executors.newFixedThreadPool(1);
    HashSet<String> a = new HashSet();
    BaiduMap b;
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    public static final Gradient DEFAULT_GRADIENT;

    private HeatMap(Builder builder) {
        this.h = builder.a;
        this.i = builder.b;
        this.j = builder.c;
        this.k = builder.d;
        this.n = HeatMap.a(this.i, (double)this.i / 3.0);
        this.a(this.j);
        this.b(this.h);
    }

    public void removeHeatMap() {
        if (this.b != null) {
            this.b.a(this);
        }
    }

    private void b(Collection<WeightedLatLng> collection) {
        this.h = collection;
        if (this.h.isEmpty()) {
            throw new IllegalArgumentException("No input points.");
        }
        this.l = HeatMap.d(this.h);
        this.g = new i(this.l);
        for (WeightedLatLng weightedLatLng : this.h) {
            this.g.a(weightedLatLng);
        }
        this.o = this.a(this.i);
    }

    private static Collection<WeightedLatLng> c(Collection<LatLng> collection) {
        ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
        for (LatLng latLng : collection) {
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    j a(int n2, int n3, int n4) {
        String string = n2 + "_" + n3 + "_" + n4;
        j j2 = this.a(string);
        if (j2 != null) {
            return j2;
        }
        if (!this.a.contains(string) && !this.q.isShutdown()) {
            try {
                this.q.execute(new e(this, n2, n3, n4));
                this.a.add(string);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                rejectedExecutionException.printStackTrace();
                com.baidu.platform.comapi.c.a.b(c, "tile " + n2 + "_" + n3 + "_" + n4 + "task rejected!");
            }
        }
        return null;
    }

    private synchronized j a(String string) {
        if (this.p.containsKey(string)) {
            j j2 = this.p.get(string);
            this.p.remove(string);
            return j2;
        }
        return null;
    }

    private synchronized void a(String string, j j2) {
        this.p.put(string, j2);
    }

    private synchronized void c() {
        this.p.clear();
    }

    void a() {
        this.c();
    }

    void b() {
        this.q.shutdownNow();
    }

    private void b(int n2, int n3, int n4) {
        Object object;
        WeightedLatLng weightedLatLng2;
        double d2 = d.get(n4);
        double d3 = d2 * (double)this.i / 256.0;
        double d4 = d2 + 2.0 * d3;
        double d5 = d4 / (double)(256 + this.i * 2);
        if (n2 < 0 || n3 < 0) {
            return;
        }
        double d6 = (double)n2 * d2 - d3;
        double d7 = (double)(n2 + 1) * d2 + d3;
        double d8 = (double)n3 * d2 - d3;
        double d9 = (double)(n3 + 1) * d2 + d3;
        d d10 = new d(d6, d7, d8, d9);
        d d11 = new d(this.l.a - d3, this.l.c + d3, this.l.b - d3, this.l.d + d3);
        if (!d10.a(d11)) {
            return;
        }
        Collection<WeightedLatLng> collection = this.g.a(d10);
        if (collection.isEmpty()) {
            return;
        }
        double[][] dArray = new double[256 + this.i * 2][256 + this.i * 2];
        for (WeightedLatLng weightedLatLng2 : collection) {
            object = weightedLatLng2.a();
            int n5 = (int)(((double)object.x - d6) / d5);
            int n6 = (int)((d9 - (double)object.y) / d5);
            if (n5 >= 256 + this.i * 2) {
                n5 = 256 + this.i * 2 - 1;
            }
            if (n6 >= 256 + this.i * 2) {
                n6 = 256 + this.i * 2 - 1;
            }
            double[] dArray2 = dArray[n5];
            int n7 = n6;
            dArray2[n7] = dArray2[n7] + weightedLatLng2.intensity;
        }
        Object object2 = HeatMap.a(dArray, this.n);
        weightedLatLng2 = HeatMap.a((double[][])object2, this.m, this.o[n4 - 1]);
        object = HeatMap.a((Bitmap)weightedLatLng2);
        weightedLatLng2.recycle();
        String string = n2 + "_" + n3 + "_" + n4;
        this.a(string, (j)object);
        if (this.b != null) {
            this.b.a();
        }
    }

    private void a(Gradient gradient) {
        this.j = gradient;
        this.m = gradient.a(this.k);
    }

    private double[] a(int n2) {
        int n3;
        double[] dArray = new double[19];
        for (n3 = 5; n3 < 11; ++n3) {
            dArray[n3] = HeatMap.a(this.h, this.l, n2, (int)(1280.0 * Math.pow(2.0, n3 - 3)));
            if (n3 != 5) continue;
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray[i2] = dArray[n3];
            }
        }
        for (n3 = 11; n3 < 19; ++n3) {
            dArray[n3] = dArray[10];
        }
        return dArray;
    }

    private static j a(Bitmap bitmap) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        byte[] byArray = byteBuffer.array();
        return new j(256, 256, byArray);
    }

    private static d d(Collection<WeightedLatLng> collection) {
        Iterator<WeightedLatLng> iterator = collection.iterator();
        WeightedLatLng weightedLatLng = iterator.next();
        double d2 = weightedLatLng.a().x;
        double d3 = weightedLatLng.a().x;
        double d4 = weightedLatLng.a().y;
        double d5 = weightedLatLng.a().y;
        while (iterator.hasNext()) {
            WeightedLatLng weightedLatLng2 = iterator.next();
            double d6 = weightedLatLng2.a().x;
            double d7 = weightedLatLng2.a().y;
            if (d6 < d2) {
                d2 = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (d7 < d4) {
                d4 = d7;
            }
            if (!(d7 > d5)) continue;
            d5 = d7;
        }
        return new d(d2, d3, d4, d5);
    }

    private static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -n2; i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (2.0 * d2 * d2));
        }
        return dArray;
    }

    private static double[][] a(double[][] dArray, double[] dArray2) {
        int n2;
        double d2;
        int n3;
        int n4;
        int n5 = (int)Math.floor((double)dArray2.length / 2.0);
        int n6 = dArray.length;
        int n7 = n6 - 2 * n5;
        int n8 = n5;
        int n9 = n5 + n7 - 1;
        double[][] dArray3 = new double[n6][n6];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray[n4][n3];
                if (d2 == 0.0) continue;
                int n10 = (n9 < n4 + n5 ? n9 : n4 + n5) + 1;
                for (int i2 = n2 = n8 > n4 - n5 ? n8 : n4 - n5; i2 < n10; ++i2) {
                    double[] dArray4 = dArray3[i2];
                    int n11 = n3;
                    dArray4[n11] = dArray4[n11] + d2 * dArray2[i2 - (n4 - n5)];
                }
            }
        }
        double[][] dArray5 = new double[n7][n7];
        for (n4 = n8; n4 < n9 + 1; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray3[n4][n3];
                if (d2 == 0.0) continue;
                int n12 = (n9 < n3 + n5 ? n9 : n3 + n5) + 1;
                for (int i3 = n2 = n8 > n3 - n5 ? n8 : n3 - n5; i3 < n12; ++i3) {
                    double[] dArray6 = dArray5[n4 - n5];
                    int n13 = i3 - n5;
                    dArray6[n13] = dArray6[n13] + d2 * dArray2[i3 - (n3 - n5)];
                }
            }
        }
        return dArray5;
    }

    private static Bitmap a(double[][] dArray, int[] nArray, double d2) {
        int n2 = nArray[nArray.length - 1];
        double d3 = (double)(nArray.length - 1) / d2;
        int n3 = dArray.length;
        int[] nArray2 = new int[n3 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = dArray[i3][i2];
                int n4 = i2 * n3 + i3;
                int n5 = (int)(d4 * d3);
                if (d4 != 0.0) {
                    if (n5 < nArray.length) {
                        nArray2[n4] = nArray[n5];
                        continue;
                    }
                    nArray2[n4] = n2;
                    continue;
                }
                nArray2[n4] = 0;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(nArray2, 0, n3, 0, 0, n3, n3);
        return bitmap;
    }

    private static double a(Collection<WeightedLatLng> collection, d d2, int n2, int n3) {
        double d3 = d2.c;
        double d4 = d2.a;
        double d5 = d2.d;
        double d6 = d2.b;
        double d7 = d3 - d4 > d5 - d6 ? d3 - d4 : d5 - d6;
        int n4 = (int)((double)(n3 / (2 * n2)) + 0.5);
        double d8 = (double)n4 / d7;
        LongSparseArray longSparseArray = new LongSparseArray();
        double d9 = 0.0;
        for (WeightedLatLng weightedLatLng : collection) {
            Double d10;
            double d11 = weightedLatLng.a().x;
            double d12 = weightedLatLng.a().y;
            int n5 = (int)((d11 - d4) * d8);
            int n6 = (int)((d12 - d6) * d8);
            LongSparseArray longSparseArray2 = (LongSparseArray)longSparseArray.get((long)n5);
            if (longSparseArray2 == null) {
                longSparseArray2 = new LongSparseArray();
                longSparseArray.put((long)n5, (Object)longSparseArray2);
            }
            if ((d10 = (Double)longSparseArray2.get((long)n6)) == null) {
                d10 = 0.0;
            }
            d10 = d10 + weightedLatLng.intensity;
            longSparseArray2.put((long)n6, (Object)d10);
            if (!(d10 > d9)) continue;
            d9 = d10;
        }
        return d9;
    }

    /* synthetic */ HeatMap(Builder builder, e e2) {
        this(builder);
    }

    static /* synthetic */ void a(HeatMap heatMap, int n2, int n3, int n4) {
        heatMap.b(n2, n3, n4);
    }

    static {
        d.put(3, 0x800000);
        d.put(4, 0x400000);
        d.put(5, 0x200000);
        d.put(6, 0x100000);
        d.put(7, 524288);
        d.put(8, 262144);
        d.put(9, 131072);
        d.put(10, 65536);
        d.put(11, 32768);
        d.put(12, 16384);
        d.put(13, 8192);
        d.put(14, 4096);
        d.put(15, 2048);
        d.put(16, 1024);
        d.put(17, 512);
        d.put(18, 256);
        d.put(19, 128);
        e = new int[]{Color.rgb((int)0, (int)0, (int)200), Color.rgb((int)0, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
        f = new float[]{0.08f, 0.4f, 1.0f};
        DEFAULT_GRADIENT = new Gradient(e, f);
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private int b = 12;
        private Gradient c = DEFAULT_GRADIENT;
        private double d = 0.6;

        public Builder data(Collection<LatLng> collection) {
            if (collection == null || collection.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            if (collection.contains(null)) {
                throw new IllegalArgumentException("input points can not contain null.");
            }
            return this.weightedData(HeatMap.c(collection));
        }

        public Builder weightedData(Collection<WeightedLatLng> collection) {
            if (collection == null || collection.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            if (collection.contains(null)) {
                throw new IllegalArgumentException("input points can not contain null.");
            }
            ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
            for (WeightedLatLng weightedLatLng : collection) {
                LatLng latLng = weightedLatLng.latLng;
                if (!(latLng.latitude < 0.37532 || latLng.latitude > 54.562495 || latLng.longitude < 72.508319) && !(latLng.longitude > 135.942198)) continue;
                arrayList.add(weightedLatLng);
            }
            collection.removeAll(arrayList);
            this.a = collection;
            return this;
        }

        public Builder radius(int n2) {
            this.b = n2;
            if (this.b < 10 || this.b > 50) {
                throw new IllegalArgumentException("Radius not within bounds.");
            }
            return this;
        }

        public Builder gradient(Gradient gradient) {
            if (gradient == null) {
                throw new IllegalArgumentException("gradient can not be null");
            }
            this.c = gradient;
            return this;
        }

        public Builder opacity(double d2) {
            this.d = d2;
            if (this.d < 0.0 || this.d > 1.0) {
                throw new IllegalArgumentException("Opacity must be in range [0, 1]");
            }
            return this;
        }

        public HeatMap build() {
            if (this.a == null) {
                throw new IllegalStateException("No input data: you must use either .data or .weightedData before building");
            }
            return new HeatMap(this, null);
        }
    }
}

