/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.overlayutil;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.Toast;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.PolylineOptions;
import com.baidu.mapapi.overlayutil.OverlayManager;
import com.baidu.mapapi.search.route.TransitRouteLine;
import java.util.ArrayList;
import java.util.List;

public class TransitRouteOverlay
extends OverlayManager {
    private TransitRouteLine c = null;

    public TransitRouteOverlay(BaiduMap baiduMap) {
        super(baiduMap);
    }

    @Override
    public final List<OverlayOptions> getOverlayOptions() {
        ArrayList arrayList;
        if (this.c == null) {
            return null;
        }
        ArrayList<OverlayOptions> arrayList2 = new ArrayList<OverlayOptions>();
        if (this.c.getAllStep() != null && this.c.getAllStep().size() > 0) {
            arrayList = new ArrayList();
            for (TransitRouteLine.TransitStep transitStep : this.c.getAllStep()) {
                Bundle bundle = new Bundle();
                bundle.putInt("index", this.c.getAllStep().indexOf(transitStep));
                if (transitStep.getEntrace() != null) {
                    arrayList2.add(new MarkerOptions().position(transitStep.getEntrace().getLocation()).anchor(0.5f, 0.5f).zIndex(10).extraInfo(bundle).icon(this.a(transitStep)));
                }
                if (this.c.getAllStep().indexOf(transitStep) != this.c.getAllStep().size() - 1 || transitStep.getExit() == null) continue;
                arrayList2.add(new MarkerOptions().position(transitStep.getExit().getLocation()).anchor(0.5f, 0.5f).zIndex(10).icon(this.a(transitStep)));
            }
        }
        if (this.c.getStarting() != null) {
            arrayList2.add(new MarkerOptions().position(this.c.getStarting().getLocation()).icon(this.getStartMarker() != null ? this.getStartMarker() : BitmapDescriptorFactory.fromAsset("Icon_start.png")).zIndex(10));
        }
        if (this.c.getTerminal() != null) {
            arrayList2.add(new MarkerOptions().position(this.c.getTerminal().getLocation()).icon(this.getTerminalMarker() != null ? this.getTerminalMarker() : BitmapDescriptorFactory.fromAsset("Icon_end.png")).zIndex(10));
        }
        if (this.c.getAllStep() != null && this.c.getAllStep().size() > 0) {
            arrayList = new ArrayList();
            for (TransitRouteLine.TransitStep transitStep : this.c.getAllStep()) {
                if (transitStep.getWayPoints() == null) continue;
                int n2 = 0;
                n2 = transitStep.getStepType() != TransitRouteLine.TransitStep.TransitRouteStepType.WAKLING ? Color.argb((int)178, (int)0, (int)78, (int)255) : Color.argb((int)178, (int)88, (int)208, (int)0);
                arrayList2.add(new PolylineOptions().points(transitStep.getWayPoints()).width(10).color(n2).zIndex(0));
            }
        }
        return arrayList2;
    }

    private BitmapDescriptor a(TransitRouteLine.TransitStep transitStep) {
        switch (transitStep.getStepType()) {
            case BUSLINE: {
                return BitmapDescriptorFactory.fromAsset("Icon_bus_station.png");
            }
            case SUBWAY: {
                return BitmapDescriptorFactory.fromAsset("Icon_subway_station.png");
            }
            case WAKLING: {
                return BitmapDescriptorFactory.fromAsset("Icon_walk_route.png");
            }
        }
        return null;
    }

    public void setData(TransitRouteLine transitRouteLine) {
        this.c = transitRouteLine;
    }

    public BitmapDescriptor getStartMarker() {
        return null;
    }

    public BitmapDescriptor getTerminalMarker() {
        return null;
    }

    public boolean onRouteNodeClick(int n2) {
        Toast.makeText((Context)com.baidu.mapapi.a.a().d(), (CharSequence)((TransitRouteLine.TransitStep)this.c.getAllStep().get(n2)).getInstructions(), (int)1).show();
        return false;
    }

    @Override
    public final boolean onMarkerClick(Marker marker) {
        if (marker.getExtraInfo() != null) {
            this.onRouteNodeClick(marker.getExtraInfo().getInt("index"));
        }
        return true;
    }
}

