/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.avos.avoscloud.AVErrorUtils;
import com.avos.avoscloud.AVException;
import com.avos.avoscloud.AVOSCloud;
import com.avos.avoscloud.AVOnlineConfigureListener;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AnalyticsEvent;
import com.avos.avoscloud.AnalyticsImpl;
import com.avos.avoscloud.AnalyticsUtils;
import com.avos.avoscloud.GenericObjectCallback;
import com.avos.avoscloud.LogUtil;
import com.avos.avoscloud.PaasClient;
import com.avos.avoscloud.ReportPolicy;
import com.avos.avoscloud.SaveCallback;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVAnalytics {
    public static final String TAG = AVAnalytics.class.getSimpleName();
    private static String endPoint = "statistics";
    private static String appOpen = "_appOpen";
    private static String appOpenWithPush = "_appOpenWithPush";
    private static final String defaultChannel = "AVOS Cloud";
    private static AnalyticsImpl impl = new AnalyticsImpl();

    public static void trackAppOpened(Intent intent) {
        Map<String, String> map = AVAnalytics.statisticsDictionary(appOpen);
        AVAnalytics.onEvent(AVOSCloud.applicationContext, "!AV!AppOpen", map);
        if (intent != null && intent.getIntExtra("com.avoscloud.push", -1) == 1) {
            AVAnalytics.trackPushOpened(intent);
        }
    }

    @Deprecated
    public void setDefaultReportPolicy(Context ctx, ReportPolicy policy) {
        impl.setReportPolicy(ctx, policy);
    }

    private static void trackPushOpened(Intent intent) {
        Map<String, String> map = AVAnalytics.statisticsDictionary(appOpenWithPush);
        AVAnalytics.onEvent(AVOSCloud.applicationContext, "!AV!PushOpen", map);
    }

    public static void setAppChannel(String channel) {
        if (AVUtils.isBlankString((String)channel)) {
            throw new IllegalArgumentException("Blank channel string.");
        }
        impl.setAppChannel(channel);
    }

    static String getAppChannel() {
        return impl.getAppChannel();
    }

    @Deprecated
    public static void SetCustomInfo(Map<String, String> customInfo) {
        impl.setCustomInfo(customInfo);
    }

    public static void setCustomInfo(Map<String, String> customInfo) {
        impl.setCustomInfo(customInfo);
    }

    public static Map<String, String> getCustomInfo() {
        return impl.getCustomInfo();
    }

    private static Map<String, String> statisticsDictionary(String event) {
        if (AVUtils.isBlankString((String)event)) {
            throw new IllegalArgumentException("Blank event string.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("event_id", event);
        map.put("channel", impl.getAppChannel());
        return map;
    }

    private static void postAnalytics(Map<String, Object> map) {
        try {
            String postData = AVUtils.jsonStringFromMapWithNull(map);
            PaasClient.statistisInstance().postObject(endPoint, postData, false, true, new GenericObjectCallback(){

                public void onSuccess(String content, AVException e) {
                    LogUtil.log.d((String)content);
                }

                public void onFailure(Throwable error, String content) {
                    LogUtil.log.e((String)content);
                }
            }, null, AVUtils.md5((String)postData));
        }
        catch (Exception e) {
            LogUtil.log.e((String)TAG, (String)"post analytics data failed.", (Exception)e);
        }
    }

    public static void start(Context context) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = info.metaData;
            if (bundle != null) {
                String channel = (String)info.metaData.get("Channel ID");
                if (!AVUtils.isBlankString((String)channel)) {
                    impl.setAppChannel(channel);
                } else {
                    impl.setAppChannel(defaultChannel);
                }
            }
            impl.flushLastSession(context);
            impl.updateOnlineConfig(context);
            impl.beginSession();
            impl.reportFirstBoot(context);
        }
        catch (Exception exception) {
            LogUtil.log.e((String)TAG, (String)"Start context failed.", (Exception)exception);
        }
    }

    public static void onFragmentStart(String pageName) {
        if (AVUtils.isBlankString((String)pageName)) {
            throw new IllegalArgumentException("Blank page name string.");
        }
        impl.beginFragment(pageName);
    }

    public static void onFragmentEnd(String pageName) {
        if (AVUtils.isBlankString((String)pageName)) {
            throw new IllegalArgumentException("Blank page name string.");
        }
        impl.endFragment(pageName);
    }

    public static void setAutoLocation(boolean b) {
        impl.setAutoLocation(b);
    }

    public static void setSessionContinueMillis(long ms) {
        if (ms <= 0L) {
            throw new IllegalArgumentException("Invalid session continute milliseconds.");
        }
        impl.setSessionContinueMillis(ms);
    }

    public static void setDebugMode(boolean enable) {
        impl.setEnableDebugLog(enable);
    }

    public static void enableCrashReport(Context context, boolean enable) {
        impl.enableCrashReport(context, enable);
    }

    public static void onPause(Context context) {
        impl.pauseSession();
        impl.endActivity(context.getClass().getSimpleName());
        impl.postRecording(context);
    }

    public static void onResume(Context context) {
        AVAnalytics.onResume(context, "", "");
    }

    private static void onResume(Context context, String s, String s1) {
        String name = context.getClass().getSimpleName();
        if (impl.shouldRegardAsNewSession()) {
            impl.endSession(context);
            impl.beginSession();
            LogUtil.avlog.d((String)"new session start when resume");
        }
        impl.endActivity(name);
        impl.beginActivity(name);
        impl.postRecording(context);
    }

    public static void onError(Context context) {
    }

    public static void onError(Context context, String s) {
    }

    public static void reportError(Context context, String s) {
    }

    public static void reportError(Context context, Throwable throwable) {
    }

    static void reportError(Context context, Map<String, Object> crashData, final SaveCallback callback) {
        Map<String, Object> map = AnalyticsUtils.deviceInfo(context);
        map.putAll(crashData);
        String jsonString = JSON.toJSONString(map);
        PaasClient.statistisInstance().postObject("stats/crash", jsonString, false, true, new GenericObjectCallback(){

            public void onSuccess(String content, AVException e) {
                if (impl.isEnableDebugLog()) {
                    Log.i((String)TAG, (String)("Save success: " + content));
                }
                if (callback != null) {
                    callback.done(null);
                }
            }

            public void onFailure(Throwable error, String content) {
                if (impl.isEnableDebugLog()) {
                    Log.i((String)TAG, (String)("Save failed: " + content));
                }
                if (callback != null) {
                    callback.done(AVErrorUtils.createException((Throwable)error, (String)content));
                }
            }
        }, null, AVUtils.md5((String)jsonString));
    }

    public static void flush(Context context) {
        impl.report(context, true);
    }

    protected static void debugDump(Context context) {
        impl.debugDump(context);
    }

    public static void onEvent(Context context, String eventId) {
        AVAnalytics.onEvent(context, eventId, 1);
    }

    public static void onEvent(Context context, String eventId, int acc) {
        AVAnalytics.onEvent(context, eventId, "", acc);
    }

    public static void onEvent(Context context, String eventId, String label) {
        AVAnalytics.onEvent(context, eventId, label, 1);
    }

    public static void onEvent(Context context, String eventId, String label, int acc) {
        AnalyticsEvent event = impl.beginEvent(context, eventId, label, "");
        event.setDurationValue(0L);
        event.setAccumulation(acc);
        impl.endEvent(context, eventId, label, "");
        impl.postRecording(context);
    }

    public static void onEvent(Context context, String eventId, Map<String, String> stringHashMap) {
        AnalyticsEvent event = impl.beginEvent(context, eventId, "", "");
        event.addAttributes(stringHashMap);
        impl.endEvent(context, eventId, "", "");
        impl.postRecording(context);
    }

    public static void onEventDuration(Context context, String eventId, long msDuration) {
        AVAnalytics.onEventDuration(context, eventId, "", msDuration);
    }

    public static void onEventDuration(Context context, String eventId, String label, long msDuration) {
        AVAnalytics.onEventDuration(context, eventId, label, null, msDuration);
    }

    public static void onEventDuration(Context context, String eventId, Map<String, String> stringHashMap, long msDuration) {
        AVAnalytics.onEventDuration(context, eventId, "", stringHashMap, msDuration);
    }

    private static void onEventDuration(Context context, String eventId, String label, Map<String, String> stringHashMap, long msDuration) {
        AnalyticsEvent event = impl.beginEvent(context, eventId, label, "");
        event.addAttributes(stringHashMap);
        event.setDurationValue(msDuration);
        impl.endEvent(context, eventId, label, "");
        impl.postRecording(context);
    }

    public static void onEventBegin(Context context, String eventId) {
        AVAnalytics.onEventBegin(context, eventId, "");
    }

    public static void onEventEnd(Context context, String eventId) {
        impl.endEvent(context, eventId, "", "");
        impl.postRecording(context);
    }

    public static void onEventBegin(Context context, String eventId, String label) {
        impl.beginEvent(context, eventId, label, "");
    }

    public static void onEventEnd(Context context, String eventId, String label) {
        impl.endEvent(context, eventId, label, "");
        impl.postRecording(context);
    }

    public static void onKVEventBegin(Context context, String eventId, HashMap<String, String> stringStringHashMap, String primaryKey) {
        AnalyticsEvent event = impl.beginEvent(context, eventId, "", primaryKey);
        event.setPrimaryKey(primaryKey);
    }

    public static void onKVEventEnd(Context context, String eventId, String primaryKey) {
        impl.endEvent(context, eventId, "", primaryKey);
        impl.postRecording(context);
    }

    public static String getConfigParams(Context context, String key) {
        return AVAnalytics.getConfigParams(context, key, "");
    }

    public static String getConfigParams(Context ctx, String key, String defaultValue) {
        return impl.getConfigParams(key, defaultValue);
    }

    public static void updateOnlineConfig(Context context) {
        impl.updateOnlineConfig(context);
    }

    public void setGender(Context context, String gender) {
    }

    public void setAge(Context context, int i) {
    }

    public void setUserID(Context context, String s, String s1) {
    }

    public static void onKillProcess(Context context) {
    }

    @Deprecated
    public static void setReportPolicy(Context context, ReportPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Null report policy.");
        }
        impl.setReportPolicy(context, policy);
    }

    public static void setOnlineConfigureListener(AVOnlineConfigureListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null AVOnlineConfigureListener.");
        }
        impl.setAVOnlineConfigureListener(listener);
    }

    public static void setAnalyticsEnabled(boolean enable) {
        impl.setAnalyticsEnabled(enable);
    }
}

