/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import com.avos.avoscloud.LogUtil;

public class AVDuration {
    private long createTimeStamp;
    private long resumeTimeStamp;
    private long duration;
    private boolean stopped;
    private boolean internalDebug = false;

    public long getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    public long getDuration() {
        this.sync();
        if (this.duration < 0L) {
            if (this.internalDebug) {
                LogUtil.log.e((String)("Negative duration " + this.duration));
            }
            this.duration = 0L;
        }
        return this.duration;
    }

    public void start() {
        this.stopped = false;
        this.resumeTimeStamp = this.createTimeStamp = AVDuration.currentTS();
    }

    public void stop() {
        this.sync();
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void resume() {
        if (this.stopped) {
            return;
        }
        this.resumeTimeStamp = AVDuration.currentTS();
    }

    public void pause() {
        this.sync();
    }

    public void setDuration(long ms) {
        this.duration = ms;
        this.resumeTimeStamp = this.createTimeStamp = AVDuration.currentTS() - this.duration;
    }

    public void addDuration(long ms) {
        this.duration += ms;
    }

    public void sync() {
        if (this.stopped) {
            return;
        }
        long d = AVDuration.currentTS() - this.resumeTimeStamp;
        this.duration += d;
        this.resumeTimeStamp = AVDuration.currentTS();
    }

    public static long currentTS() {
        return System.currentTimeMillis();
    }

    protected long getResumeTimeStamp() {
        return this.resumeTimeStamp;
    }

    protected void setResumeTimeStamp(long resumeTimeStamp) {
        this.resumeTimeStamp = resumeTimeStamp;
    }

    protected void setCreateTimeStamp(long createTimeStamp) {
        this.createTimeStamp = createTimeStamp;
    }

    protected void setStopped(boolean stopped) {
        this.stopped = stopped;
    }
}

