/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.Context;
import android.os.Process;
import android.util.Log;
import com.avos.avoscloud.AVAnalytics;
import com.avos.avoscloud.AVUtils;
import com.avos.avoscloud.AnalyticsUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private boolean enabled = false;
    private final String LOG_TAG = AVUncaughtExceptionHandler.class.getSimpleName();
    private final Context context;
    private Thread brokenThread;
    private Throwable unhandledThrowable;

    public AVUncaughtExceptionHandler(Context c) {
        this.context = c;
        this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void enableCrashHanlder(boolean e) {
        this.enabled = e;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        block5: {
            try {
                if (!this.enabled) {
                    if (this.defaultExceptionHandler != null) {
                        Log.w((String)this.LOG_TAG, (String)"AVUncaughtExceptionHandler is disabled and fallback to default handler.");
                        this.defaultExceptionHandler.uncaughtException(t, e);
                    } else {
                        Log.w((String)this.LOG_TAG, (String)"AVUncaughtExceptionHandler is disabled and there is no default handler, good luck.");
                    }
                    return;
                }
                this.brokenThread = t;
                this.unhandledThrowable = e;
                Log.e((String)this.LOG_TAG, (String)("AVUncaughtExceptionHandler caught a " + e.getClass().getSimpleName() + " exception "));
                this.handleException(this.unhandledThrowable, false, true);
            }
            catch (Throwable fatality) {
                if (this.defaultExceptionHandler == null) break block5;
                this.defaultExceptionHandler.uncaughtException(t, e);
            }
        }
    }

    public void handleException(Throwable e, boolean endApplication) {
        this.handleException(e, false, endApplication);
    }

    public void handleException(Throwable e) {
        this.handleException(e, false, false);
    }

    private void handleException(Throwable e, boolean forceSilentReport, boolean endApplication) {
        if (!this.enabled) {
            return;
        }
        boolean sendOnlySilentReports = false;
        if (e == null) {
            e = new Exception("Report requested by developer");
        }
        Map<String, Object> map = this.crashData(this.context, e);
        AVAnalytics.reportError(this.context, map, null);
        if (endApplication) {
            this.endApplication();
        }
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        String stacktraceAsString = ((Object)result).toString();
        printWriter.close();
        return stacktraceAsString;
    }

    private Map<String, Object> crashData(Context context, Throwable throwable) {
        HashMap<String, Object> crashReportData = new HashMap<String, Object>();
        try {
            crashReportData.put("reason", throwable.toString());
            crashReportData.put("stack_trace", this.getStackTrace(throwable));
            crashReportData.put("date", AVUtils.stringFromDate((Date)new Date()));
            try {
                Class<?> installationClass = Class.forName("com.avos.avoscloud.AVInstallation");
                Method getMethod = installationClass.getMethod("getCurrentInstallation", new Class[0]);
                Method getInstallationIdMethod = installationClass.getMethod("getInstallationId", new Class[0]);
                Object installation = getMethod.invoke(installationClass, new Object[0]);
                String installationId = (String)getInstallationIdMethod.invoke(installation, new Object[0]);
                crashReportData.put("installationId", installationId);
            }
            catch (Exception e) {
                // empty catch block
            }
            crashReportData.put("packageName", context.getPackageName());
            crashReportData.putAll(AnalyticsUtils.getDeviceInfo(context));
            crashReportData.put("memInfo", AnalyticsUtils.collectMemInfo());
            crashReportData.put("totalDiskSpace", AnalyticsUtils.getTotalInternalMemorySize());
            crashReportData.put("availableDiskSpace", AnalyticsUtils.getAvailableInternalMemorySize());
            crashReportData.put("appFilePath", AnalyticsUtils.getApplicationFilePath(context));
            crashReportData.put("ipAddress", AnalyticsUtils.getLocalIpAddress());
        }
        catch (RuntimeException e) {
            Log.e((String)this.LOG_TAG, (String)"Error while retrieving crash data", (Throwable)e);
        }
        return crashReportData;
    }

    private void endApplication() {
        if (this.defaultExceptionHandler != null) {
            this.defaultExceptionHandler.uncaughtException(this.brokenThread, this.unhandledThrowable);
        } else {
            Log.e((String)this.LOG_TAG, (String)(this.context.getPackageName() + " fatal error : " + this.unhandledThrowable.getMessage()), (Throwable)this.unhandledThrowable);
            Process.killProcess((int)Process.myPid());
            System.exit(10);
        }
    }
}

