/*
 * Decompiled with CFR 0.152.
 */
package com.avos.avoscloud;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.avos.avoscloud.AVAnalytics;
import com.avos.avoscloud.AVPersistenceUtils;
import com.avos.avoscloud.AVUser;
import com.avos.avoscloud.AVUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsUtils {
    private static final String TAG = AnalyticsUtils.class.getSimpleName();

    public static Map<String, String> getNetworkInfo(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        HashMap<String, String> map = new HashMap<String, String>();
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info == null || !info.isConnectedOrConnecting()) {
            map.put("access_subtype", "offline");
            map.put("access", "offline");
            map.put("carrier", "");
        } else {
            map.put("access_subtype", info.getSubtypeName());
            map.put("access", AnalyticsUtils.cleanNetworkTypeName(info.getTypeName()));
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            String carrierName = manager.getNetworkOperatorName();
            map.put("carrier", carrierName);
        }
        return map;
    }

    private static String cleanNetworkTypeName(String type) {
        if (AVUtils.isBlankString((String)type)) {
            return "offline";
        }
        String t = type.toUpperCase();
        if (t.contains("WIFI")) {
            return "WiFi";
        }
        if (type.contains("MOBILE")) {
            return "Mobile";
        }
        return type;
    }

    public static Map<String, Object> deviceInfo(Context context) {
        Map<String, Object> deviceInfo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, String> networkInfo = AnalyticsUtils.getNetworkInfo(context);
        if (networkInfo != null) {
            map.putAll(networkInfo);
        }
        if ((deviceInfo = AnalyticsUtils.getDeviceInfo(context)) != null) {
            map.putAll(deviceInfo);
        }
        return map;
    }

    public static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public static long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    public static Map<String, Object> getDeviceInfo(Context context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String packageName = context.getApplicationContext().getPackageName();
        map.put("package_name", packageName);
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 0);
            map.put("app_version", info.versionName);
            map.put("version_code", info.versionCode);
            map.put("sdk_version", "Android v2.5.8.1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        map.put("resolution", "" + width + "*" + height);
        map.put("device_model", Build.MODEL);
        map.put("device_manufacturer", Build.MANUFACTURER);
        map.put("os_version", Build.VERSION.RELEASE);
        map.put("device_name", Build.DEVICE);
        map.put("device_brand", Build.BRAND);
        map.put("device_board", Build.BOARD);
        map.put("device_manuid", Build.FINGERPRINT);
        map.put("cpu", AnalyticsUtils.getCPUInfo());
        map.put("os", "Android");
        map.put("sdk_type", "Android");
        map.put("device_id", Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
        try {
            Class<?> installationClass = Class.forName("com.avos.avoscloud.AVInstallation");
            Method getMethod = installationClass.getMethod("getCurrentInstallation", new Class[0]);
            Method getInstallationIdMethod = installationClass.getMethod("getObjectId", new Class[0]);
            Object installation = getMethod.invoke(installationClass, new Object[0]);
            String installationId = (String)getInstallationIdMethod.invoke(installation, new Object[0]);
            map.put("iid", installationId);
        }
        catch (Exception e) {
            // empty catch block
        }
        long offset = TimeZone.getDefault().getRawOffset();
        AVUser loginedUser = AVUser.getCurrentUser();
        if (loginedUser != null && !AVUtils.isBlankString((String)loginedUser.getObjectId())) {
            map.put("uid", loginedUser.getObjectId());
        }
        try {
            offset = TimeUnit.HOURS.convert(offset, TimeUnit.MILLISECONDS);
        }
        catch (NoSuchFieldError e) {
            offset /= 3600000L;
        }
        map.put("time_zone", offset);
        map.put("channel", AVAnalytics.getAppChannel());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String collectMemInfo() {
        StringBuilder meminfo;
        block8: {
            meminfo = new StringBuilder();
            InputStream in = null;
            InputStreamReader reader = null;
            BufferedReader bufferedReader = null;
            try {
                String line;
                String line2;
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add("dumpsys");
                commandLine.add("meminfo");
                commandLine.add(Integer.toString(android.os.Process.myPid()));
                Process process = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()]));
                in = process.getInputStream();
                reader = new InputStreamReader(in);
                bufferedReader = new BufferedReader(reader, 8192);
                while ((line2 = bufferedReader.readLine()) != null) {
                    meminfo.append(line2);
                    meminfo.append("\n");
                }
                AVPersistenceUtils.closeQuietly((Closeable)bufferedReader);
                AVPersistenceUtils.closeQuietly((Closeable)reader);
                AVPersistenceUtils.closeQuietly((Closeable)in);
                in = process.getErrorStream();
                reader = new InputStreamReader(in);
                bufferedReader = new BufferedReader(reader, 8192);
                StringBuilder errorInfo = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    errorInfo.append(line);
                }
                if (process.waitFor() != 0) {
                    Log.e((String)TAG, (String)errorInfo.toString());
                }
                AVPersistenceUtils.closeQuietly((Closeable)bufferedReader);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"DumpSysCollector.meminfo could not retrieve data", (Throwable)e);
                break block8;
            }
            finally {
                AVPersistenceUtils.closeQuietly(bufferedReader);
                AVPersistenceUtils.closeQuietly(reader);
                AVPersistenceUtils.closeQuietly(in);
            }
            AVPersistenceUtils.closeQuietly((Closeable)reader);
            AVPersistenceUtils.closeQuietly((Closeable)in);
        }
        return meminfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPUInfo() {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        if (new File("/proc/cpuinfo").exists()) {
            try {
                String line;
                br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                while ((line = br.readLine()) != null) {
                    if (!line.contains("Processor")) continue;
                    int position = line.indexOf(":");
                    if (position < 0 || position >= line.length() - 1) break;
                    sb.append(line.substring(position + 1).trim());
                    break;
                }
                AVPersistenceUtils.closeQuietly((Closeable)br);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"getCPUInfo", (Throwable)e);
            }
            finally {
                AVPersistenceUtils.closeQuietly(br);
            }
        }
        return sb.toString();
    }

    public static String getLocalIpAddress() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (!first) {
                        result.append('\n');
                    }
                    result.append(inetAddress.getHostAddress().toString());
                    first = false;
                }
            }
        }
        catch (SocketException ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result.toString();
    }

    public static String getApplicationFilePath(Context context) {
        File filesDir = context.getFilesDir();
        if (filesDir != null) {
            return filesDir.getAbsolutePath();
        }
        return "Couldn't retrieve ApplicationFilePath";
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public static String getRandomString(int length) {
        String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder randomString = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            randomString.append(letters.charAt(new Random().nextInt(letters.length())));
        }
        return randomString.toString();
    }

    public static String uniqueId() {
        return UUID.randomUUID().toString();
    }

    public static boolean isStringEqual(String src, String target) {
        if (src == null && target == null) {
            return true;
        }
        if (src != null) {
            return src.equals(target);
        }
        return false;
    }
}

