/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class FileAsyncHttpResponseHandler
extends AsyncHttpResponseHandler {
    private File mFile;
    private static final String LOG_TAG = "FileAsyncHttpResponseHandler";

    public FileAsyncHttpResponseHandler(File file) {
        assert (file != null);
        this.mFile = file;
    }

    public FileAsyncHttpResponseHandler(Context c) {
        assert (c != null);
        this.mFile = this.getTemporaryFile(c);
    }

    protected File getTemporaryFile(Context c) {
        try {
            return File.createTempFile("temp_", "_handled", c.getCacheDir());
        }
        catch (Throwable t) {
            Log.e((String)LOG_TAG, (String)"Cannot create temporary file", (Throwable)t);
            return null;
        }
    }

    protected File getTargetFile() {
        assert (this.mFile != null);
        return this.mFile;
    }

    public void onSuccess(File file) {
    }

    public void onSuccess(int statusCode, File file) {
        this.onSuccess(file);
    }

    public void onSuccess(int statusCode, Header[] headers, File file) {
        this.onSuccess(statusCode, file);
    }

    public void onFailure(Throwable e, File response) {
        this.onFailure(e);
    }

    public void onFailure(int statusCode, Throwable e, File response) {
        this.onFailure(e, response);
    }

    public void onFailure(int statusCode, Header[] headers, Throwable e, File response) {
        this.onFailure(statusCode, e, response);
    }

    @Override
    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        this.onFailure(statusCode, headers, error, this.getTargetFile());
    }

    @Override
    public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
        this.onSuccess(statusCode, headers, this.getTargetFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] getResponseData(HttpEntity entity) throws IOException {
        if (entity != null) {
            InputStream instream = entity.getContent();
            long contentLength = entity.getContentLength();
            FileOutputStream buffer = new FileOutputStream(this.getTargetFile());
            if (instream != null) {
                try {
                    int l;
                    byte[] tmp = new byte[4096];
                    int count = 0;
                    while ((l = instream.read(tmp)) != -1 && !Thread.currentThread().isInterrupted()) {
                        buffer.write(tmp, 0, l);
                        this.sendProgressMessage(count += l, (int)contentLength);
                    }
                }
                finally {
                    instream.close();
                    buffer.flush();
                    buffer.close();
                }
            }
        }
        return null;
    }
}

