package com.testtabhost.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.View.OnCreateContextMenuListener;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.AdapterView.OnItemSelectedListener;

import com.testtabhost.DataBase.*;

//import android.util.Log;

public class TabActivity3 extends Activity implements OnItemSelectedListener,
OnItemClickListener, OnItemLongClickListener {	
	
	ListView  recordList;
	SimpleAdapter aaData;
	ArrayList<HashMap<String,Object>> listCont=new ArrayList<HashMap<String,Object>>();
	
	static LinkedList<DataBaseInfo> linkList;
	DatabaseHelper db;
	Date date;
	Tool tool;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);		
		setContentView(R.layout.tab3);	
		
		recordList=(ListView) findViewById(R.id.checklist);
		recordList.setCacheColorHint(Color.TRANSPARENT);
		db=new DatabaseHelper(this);
		linkList=new LinkedList<DataBaseInfo>();
		date=new Date();
		tool=new Tool();
		recordList.setOnItemClickListener(this);
		recordList.setOnItemSelectedListener(this);
		recordList.setOnItemLongClickListener(this);
		
		showList();
	}
	
	@Override
	protected void onStart() {
		super.onStart();
		
		showList();
		
	}
	
	private void showList(){
		
		Cursor cursor=db.query("select * from smsgs_tb");
		cursor.moveToFirst();
		//Log.v("debug", cursor.getString(cursor.getColumnIndex("smsgs_msg")));
		
		for(int x=0;x<linkList.size();x++){
			linkList.remove(x);
		}
		linkList.removeAll(linkList);
		listCont.removeAll(listCont);
		
		while(!cursor.isAfterLast()){
			String ss1 = cursor.getString(cursor.getColumnIndex("_id"));
			String ss2 = cursor.getString(cursor.getColumnIndex("smsgs_phone"));
			String ss3 = cursor.getString(cursor.getColumnIndex("smsgs_msg"));
			String ss4 = cursor.getString(cursor.getColumnIndex("smsgs_time"));
			DataBaseInfo dbInfo=new DataBaseInfo(ss1, ss2, ss3, ss4);
			linkList.add(dbInfo);
			cursor.moveToNext();
		}
		
		//
				linkList=tool.InvertedOrder(linkList);
				for(int i=0;i<linkList.size();i++){
					DataBaseInfo dbi=linkList.get(i);
					HashMap<String, Object> map=new HashMap<String, Object>();
					map.put("time", dbi.getNextTime());
					map.put("phone", dbi.getPhone());
					map.put("content", dbi.getMsg());
					map.put("id", dbi.getId());
					listCont.add(map);
					}
				
				String[] from={"time","phone","content","id"};
				int[] to={R.id.sendTime,R.id.receiveMan,R.id.messContent,R.id.id};
				aaData=new SimpleAdapter(this, listCont, R.layout.messageitem,
						from, to);
				recordList.setAdapter(aaData);
				cursor.close();
	}
	
	

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int position,
			long id) {
	}



	@Override
	public void onNothingSelected(AdapterView<?> parent) {
	}
	

	@Override
	public boolean onItemLongClick(AdapterView<?> parent, View view,
			int position, long id) {
		final int i=position;
		recordList.setOnCreateContextMenuListener(new OnCreateContextMenuListener() {
			@Override
			public void onCreateContextMenu(ContextMenu menu, View v,
					ContextMenuInfo menuInfo) {
				menu.setHeaderTitle("ɾöʱ");   
				menu.add(i, 1, 1, "ɾ");
				menu.add(i, 2, 2, "ȡ");
			}
		});
		return false;
	}
	
	
	@Override
	public boolean onContextItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case 1:
		DataBaseInfo dbi=linkList.get(item.getGroupId());
		db.deleteID(Integer.parseInt(dbi.getId()));
		onStart();
		return super.onContextItemSelected(item);
		case 2: break;
		}
		return true;
	}
	
	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position,
			long id) {
		Intent intent=new Intent();
		intent.setClass(this, DetailActivity.class);
		intent.putExtra("position", position);
	
		TabActivity3.this.startActivity(intent);
	}
}