package com.testtabhost.activity;

import android.annotation.SuppressLint;
import android.app.ActivityGroup;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TabHost;
import android.widget.TabHost.OnTabChangeListener;

//import android.util.Log;

@SuppressLint("InflateParams")
@SuppressWarnings("deprecation")
public class TestTabHostActivity extends ActivityGroup {
    /** Called when the activity is first created. */
	private TabHost tabHost = null;
	private LayoutInflater mInflater = null;
	
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        
        mInflater = LayoutInflater.from(this);
        
        tabHost = (TabHost) findViewById(R.id.mytabhost);
		tabHost.setup(this.getLocalActivityManager());
		
		Intent intent=new Intent();
		intent=getIntent();
		String phoneNum=intent.getStringExtra("phoneNum");
		if(phoneNum!=null){
		      intent = new Intent(this, TabActivity1.class)
		    		  .putExtra("phoneNum", phoneNum);
		      //Log.v("debug",phoneNum);
		}
		else{
			intent = new Intent(this, TabActivity1.class);
			//Log.v("debug","NO");
			}
		View tab1Spec = mInflater.inflate(R.layout.tab1_spec, null);
		tabHost.addTab(tabHost
			   .newTabSpec("tab1")
			   .setIndicator(tab1Spec)
			   .setContent(intent));
		
		intent = new Intent(this, TabActivity2.class);
		View tab2Spec = mInflater.inflate(R.layout.tab2_spec, null);
		tabHost.addTab(tabHost.newTabSpec("tab2").setIndicator(tab2Spec).setContent(intent));
		
		intent = new Intent(this, TabActivity3.class);
		View tab3Spec = mInflater.inflate(R.layout.tab3_spec, null);
		tabHost.addTab(tabHost
				.newTabSpec("tab3")
				.setIndicator(tab3Spec)
				.setContent(intent));
		
		intent = new Intent(this, TabActivity4.class);
		View tab4Spec = mInflater.inflate(R.layout.tab4_spec, null);
		tabHost.addTab(tabHost
				.newTabSpec("tab4")
				.setIndicator(tab4Spec)
				.setContent(intent));
		
		Intent serviceIntent=new Intent(this, MessageService.class);
		this.startService(serviceIntent);
		
    }
    
	class MyOnTabChangeListener implements OnTabChangeListener {
		public void onTabChanged(String tabId) {
			
		}
	}   
}