/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfigeration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.map.e;
import com.baidu.platform.comapi.map.g;
import com.baidu.platform.comapi.map.u;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    private static final String a = BaiduMap.class.getSimpleName();
    private Projection b;
    private UiSettings c;
    private e d;
    private List<Overlay> e;
    private Overlay.a f;
    private g g;
    private OnMapStatusChangeListener h;
    private OnMapClickListener i;
    private OnMapLoadedCallback j;
    private OnMapDoubleClickListener k;
    private OnMapLongClickListener l;
    private OnMarkerClickListener m;
    private OnMyLocationClickListener n;
    private SnapshotReadyCallback o;
    private InfoWindow p;
    private Marker q;
    private MyLocationData r;
    private MyLocationConfigeration s;

    BaiduMap(e e2) {
        this.d = e2;
        this.c = new UiSettings(this.d);
        this.e = new LinkedList<Overlay>();
        this.f = new a(this);
        this.g = new b(this);
        this.d.a(this.g);
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.f;
        Bundle bundle = new Bundle();
        overlay.a(bundle);
        this.d.a(bundle);
        this.e.add(overlay);
        return overlay;
    }

    public final void clear() {
        this.e.clear();
        this.d.m();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        u u2 = this.a(mapStatusUpdate);
        this.d.a(u2);
        if (this.h != null) {
            this.h.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        u u2 = this.d.l();
        return MapStatus.a(u2);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        u u2 = this.a(mapStatusUpdate);
        this.d.a(u2, n2);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private u a(MapStatusUpdate mapStatusUpdate) {
        u u2 = this.d.l();
        MapStatus mapStatus = mapStatusUpdate.a(this.d, this.getMapStatus());
        u u3 = mapStatus.b(u2);
        return u3;
    }

    public final void setMapType(int n2) {
        if (n2 == 1) {
            this.d.b(false);
        } else if (n2 == 2) {
            this.d.b(true);
        }
    }

    public final int getMapType() {
        return this.d.c() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        return this.d.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 19.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        this.d.a = f2;
        this.d.b = f3;
    }

    public final float getMinZoomLevel() {
        return this.d.b;
    }

    public final Projection getProjection() {
        return this.b;
    }

    public final UiSettings getUiSettings() {
        return this.c;
    }

    public final void setBuildingsEnabled(boolean bl) {
        this.d.c(bl);
    }

    public final boolean isBuildingsEnabled() {
        return this.d.d();
    }

    public final void setMyLocationEnabled(boolean bl) {
        this.d.e(bl);
    }

    public final boolean isMyLocationEnabled() {
        return this.d.f();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.r = myLocationData;
        if (this.s == null) {
            this.s = new MyLocationConfigeration(MyLocationConfigeration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.s);
    }

    public final MyLocationData getLocationData() {
        return this.r;
    }

    public final void setMyLocationConfigeration(MyLocationConfigeration myLocationConfigeration) {
        this.s = myLocationConfigeration;
        this.a(this.r, this.s);
    }

    public final MyLocationConfigeration getLocationConfigeration() {
        return this.s;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfigeration myLocationConfigeration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfigeration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        com.baidu.platform.comapi.a.b b2 = com.baidu.mapapi.model.a.a(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", b2.b());
            jSONObject2.put("pty", b2.a());
            float f2 = com.baidu.mapapi.model.a.a(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfigeration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfigeration.locationMode == MyLocationConfigeration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", b2.b());
                jSONObject3.put("pty", b2.a());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfigeration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfigeration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        this.d.a(jSONObject.toString(), bundle);
        switch (myLocationConfigeration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder(this.getMapStatus()).rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder(this.getMapStatus()).rotate(0.0f).overlook(0.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                MapStatus mapStatus = new MapStatus.Builder(this.getMapStatus()).rotate(0.0f).overlook(0.0f).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
        }
    }

    public final void setTrafficEnabled(boolean bl) {
        this.d.a(bl);
    }

    public final boolean isTrafficEnabled() {
        return this.d.b();
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.o = snapshotReadyCallback;
        this.d.a("anything");
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            this.hideInfoWindow();
            this.p = infoWindow;
            BitmapDescriptor bitmapDescriptor = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            MarkerOptions markerOptions = new MarkerOptions().perspective(false).icon(bitmapDescriptor).position(infoWindow.c).zIndex(Integer.MAX_VALUE);
            this.q = (Marker)this.addOverlay(markerOptions);
        }
    }

    public void hideInfoWindow() {
        if (this.p != null) {
            this.p = null;
            this.q.remove();
            this.q = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.h = onMapStatusChangeListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.i = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.j = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.k = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.l = onMapLongClickListener;
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        this.m = onMarkerClickListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.n = onMyLocationClickListener;
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.e;
    }

    static /* synthetic */ e b(BaiduMap baiduMap) {
        return baiduMap.d;
    }

    static /* synthetic */ OnMapStatusChangeListener c(BaiduMap baiduMap) {
        return baiduMap.h;
    }

    static /* synthetic */ OnMapClickListener d(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ OnMapDoubleClickListener e(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ OnMapLongClickListener f(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.b = projection;
        return baiduMap.b;
    }

    static /* synthetic */ OnMapLoadedCallback g(BaiduMap baiduMap) {
        return baiduMap.j;
    }

    static /* synthetic */ SnapshotReadyCallback h(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ OnMyLocationClickListener i(BaiduMap baiduMap) {
        return baiduMap.n;
    }

    static /* synthetic */ InfoWindow j(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ Marker k(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ OnMarkerClickListener l(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

