/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.View;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BitmapDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BitmapDescriptorFactory {
    public static BitmapDescriptor fromAsset(String string) {
        Context context = a.a().d();
        if (context == null) {
            return null;
        }
        try {
            AssetManager assetManager = context.getAssets();
            InputStream inputStream = null;
            inputStream = assetManager.open(string);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            inputStream.close();
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        BitmapDescriptor bitmapDescriptor = new BitmapDescriptor(bitmap);
        return bitmapDescriptor;
    }

    public static BitmapDescriptor fromFile(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            Context context = a.a().d();
            if (context != null) {
                FileInputStream fileInputStream = context.openFileInput(string);
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream);
                fileInputStream.close();
                if (bitmap != null) {
                    BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
                    bitmap.recycle();
                    return bitmapDescriptor;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static BitmapDescriptor fromPath(String string) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)string);
        if (bitmap != null && bitmap != null) {
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        return null;
    }

    public static BitmapDescriptor fromResource(int n2) {
        Context context = a.a().d();
        if (context != null) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
            if (bitmap == null) {
                return null;
            }
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        return null;
    }

    public static BitmapDescriptor fromView(View view) {
        if (view == null) {
            return null;
        }
        view.destroyDrawingCache();
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = view.getDrawingCache(true);
        if (bitmap != null) {
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.fromBitmap(bitmap);
            bitmap.recycle();
            return bitmapDescriptor;
        }
        return null;
    }
}

