/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.navi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.baidu.mapapi.model.a;
import com.baidu.mapapi.navi.BaiduMapAppNotSupportNaviException;
import com.baidu.mapapi.navi.IllegalNaviArgumentException;
import com.baidu.mapapi.navi.NaviPara;
import com.baidu.platform.comapi.a.b;
import java.net.URISyntaxException;

public class BaiduMapNavigation {
    private static int a(Context context) {
        String string = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo("com.baidu.BaiduMap", 0);
            string = packageInfo.versionName;
            if (string == null || string.length() <= 0) {
                return 0;
            }
            string = string.trim();
            string = string.replace(".", "");
            string = string.trim();
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void openBaiduMapNavi(NaviPara naviPara, Context context) {
        if (naviPara == null || context == null) {
            return;
        }
        if (naviPara.endPoint == null || naviPara.startPoint == null) {
            throw new IllegalNaviArgumentException("start point or end point can not be null.");
        }
        int n2 = BaiduMapNavigation.a(context);
        if (n2 == 0) {
            throw new BaiduMapAppNotSupportNaviException("BaiduMap app is not installed");
        }
        if (n2 < 500) {
            throw new BaiduMapAppNotSupportNaviException("current baidumap app version not support navigation.");
        }
        try {
            Intent intent = Intent.parseUri((String)BaiduMapNavigation.a(naviPara), (int)0);
            context.startActivity(intent);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }

    public static void openWebBaiduMapNavi(NaviPara naviPara, Context context) throws IllegalNaviArgumentException {
        if (naviPara == null || context == null) {
            return;
        }
        if (naviPara.startPoint != null && naviPara.endPoint != null) {
            b b2 = a.a(naviPara.startPoint);
            b b3 = a.a(naviPara.endPoint);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("http://daohang.map.baidu.com/mobile/#navi/naving/start=");
            stringBuilder.append(b2.b());
            stringBuilder.append(",");
            stringBuilder.append(b2.a());
            stringBuilder.append("&endp=");
            stringBuilder.append(b3.b());
            stringBuilder.append(",");
            stringBuilder.append(b3.a());
            stringBuilder.append("&fromprod=");
            stringBuilder.append(BaiduMapNavigation.b(context));
            stringBuilder.append("/vt=map&state=entry");
            Uri uri = Uri.parse((String)stringBuilder.toString());
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(uri);
            context.startActivity(intent);
        } else if (naviPara.startName != null && !naviPara.startName.equals("") && naviPara.endName != null && !naviPara.endName.equals("")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("http://daohang.map.baidu.com/mobile/#search/search/qt=nav&sn=2$$$$$$");
            stringBuilder.append(naviPara.startName);
            stringBuilder.append("$$$$$$&en=2$$$$$$");
            stringBuilder.append(naviPara.endName);
            stringBuilder.append("$$$$$$&fromprod=");
            stringBuilder.append(BaiduMapNavigation.b(context));
            Uri uri = Uri.parse((String)stringBuilder.toString());
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(uri);
            context.startActivity(intent);
        } else {
            throw new IllegalNaviArgumentException("you must set start and end point or set the start and end name.");
        }
    }

    private static String a(NaviPara naviPara) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("intent://map/direction?");
        stringBuffer.append("origin=");
        if (naviPara.startName != null) {
            stringBuffer.append("name:" + naviPara.startName + "|");
        }
        stringBuffer.append(String.format("latlng:%f,%f", naviPara.startPoint.latitude, naviPara.startPoint.longitude));
        stringBuffer.append("&destination=");
        if (naviPara.endName != null) {
            stringBuffer.append("name:" + naviPara.endName + "|");
        }
        stringBuffer.append(String.format("latlng:%f,%f", naviPara.endPoint.latitude, naviPara.endPoint.longitude));
        stringBuffer.append("&coord_type=bd09ll");
        stringBuffer.append("&mode=navigation");
        stringBuffer.append("#Intent;scheme=bdapp;");
        stringBuffer.append("package=com.baidu.BaiduMap;");
        stringBuffer.append("end");
        return stringBuffer.toString();
    }

    public static void getLatestBaiduMapApp(Context context) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        Uri uri = Uri.parse((String)"http://mo.baidu.com/map/");
        intent.setData(uri);
        context.startActivity(intent);
    }

    private static String b(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            applicationInfo = null;
        }
        String string = (String)packageManager.getApplicationLabel(applicationInfo);
        return string;
    }
}

