/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.overlayutil;

import android.content.Context;
import android.graphics.Color;
import android.widget.Toast;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.PolylineOptions;
import com.baidu.mapapi.overlayutil.OverlayManager;
import com.baidu.mapapi.search.busline.BusLineResult;
import java.util.ArrayList;
import java.util.List;

public class BusLineOverlay
extends OverlayManager {
    private BusLineResult c = null;

    public BusLineOverlay(BaiduMap baiduMap) {
        super(baiduMap);
    }

    public void setData(BusLineResult busLineResult) {
        this.c = busLineResult;
    }

    @Override
    public final List<OverlayOptions> getOverlayOptions() {
        if (this.c == null || this.c.getStations() == null) {
            return null;
        }
        ArrayList<OverlayOptions> arrayList = new ArrayList<OverlayOptions>();
        for (BusLineResult.BusStation object : this.c.getStations()) {
            arrayList.add(new MarkerOptions().position(object.getLocation()).zIndex(10).anchor(0.5f, 0.5f).icon(BitmapDescriptorFactory.fromAsset("Icon_bus_station.png")));
        }
        ArrayList arrayList2 = new ArrayList();
        for (BusLineResult.BusStep busStep : this.c.getSteps()) {
            if (busStep.getWayPoints() == null) continue;
            arrayList2.addAll(busStep.getWayPoints());
        }
        if (arrayList2.size() > 0) {
            arrayList.add(new PolylineOptions().width(10).color(Color.argb((int)178, (int)0, (int)78, (int)255)).zIndex(0).points(arrayList2));
        }
        return arrayList;
    }

    public boolean onBusStationClick(int n2) {
        if (this.c.getStations() != null && this.c.getStations().get(n2) != null) {
            Toast.makeText((Context)com.baidu.mapapi.a.a().d(), (CharSequence)this.c.getStations().get(n2).getTitle(), (int)1).show();
        }
        return false;
    }

    @Override
    public final boolean onMarkerClick(Marker marker) {
        return this.onBusStationClick(this.b.indexOf(marker));
    }
}

