/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.overlayutil;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.Toast;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.PolylineOptions;
import com.baidu.mapapi.overlayutil.OverlayManager;
import com.baidu.mapapi.search.route.WalkingRouteLine;
import java.util.ArrayList;
import java.util.List;

public class WalkingRouteOverlay
extends OverlayManager {
    private WalkingRouteLine c = null;

    public WalkingRouteOverlay(BaiduMap baiduMap) {
        super(baiduMap);
    }

    public void setData(WalkingRouteLine walkingRouteLine) {
        this.c = walkingRouteLine;
    }

    @Override
    public final List<OverlayOptions> getOverlayOptions() {
        if (this.c == null) {
            return null;
        }
        ArrayList<OverlayOptions> arrayList = new ArrayList<OverlayOptions>();
        if (this.c.getAllStep() != null && this.c.getAllStep().size() > 0) {
            for (WalkingRouteLine.WalkingStep object : this.c.getAllStep()) {
                Bundle bundle = new Bundle();
                bundle.putInt("index", this.c.getAllStep().indexOf(object));
                if (object.getEntrace() != null) {
                    arrayList.add(new MarkerOptions().position(object.getEntrace().getLocation()).rotate(360 - object.getDirection()).zIndex(10).extraInfo(bundle).icon(BitmapDescriptorFactory.fromAsset("Icon_line_node.png")));
                }
                if (this.c.getAllStep().indexOf(object) != this.c.getAllStep().size() - 1 || object.getExit() == null) continue;
                arrayList.add(new MarkerOptions().position(object.getExit().getLocation()).anchor(0.5f, 0.5f).zIndex(10).icon(BitmapDescriptorFactory.fromAsset("Icon_line_node.png")));
            }
        }
        if (this.c.getStarting() != null) {
            arrayList.add(new MarkerOptions().position(this.c.getStarting().getLocation()).icon(this.getStartMarker() != null ? this.getStartMarker() : BitmapDescriptorFactory.fromAsset("Icon_start.png")).zIndex(10));
        }
        if (this.c.getTerminal() != null) {
            arrayList.add(new MarkerOptions().position(this.c.getTerminal().getLocation()).icon(this.getTerminalMarker() != null ? this.getTerminalMarker() : BitmapDescriptorFactory.fromAsset("Icon_end.png")).zIndex(10));
        }
        if (this.c.getAllStep() != null && this.c.getAllStep().size() > 0) {
            ArrayList arrayList2 = new ArrayList();
            for (WalkingRouteLine.WalkingStep walkingStep : this.c.getAllStep()) {
                if (walkingStep.getWayPoints() == null) continue;
                arrayList2.addAll(walkingStep.getWayPoints());
            }
            arrayList.add(new PolylineOptions().points(arrayList2).width(10).color(Color.argb((int)178, (int)0, (int)78, (int)255)).zIndex(0));
        }
        return arrayList;
    }

    public BitmapDescriptor getStartMarker() {
        return null;
    }

    public BitmapDescriptor getTerminalMarker() {
        return null;
    }

    public boolean onRouteNodeClick(int n2) {
        if (this.c.getAllStep() != null && this.c.getAllStep().get(n2) != null) {
            Toast.makeText((Context)com.baidu.mapapi.a.a().d(), (CharSequence)this.c.getAllStep().get(n2).getInstructions(), (int)1).show();
        }
        return false;
    }

    @Override
    public final boolean onMarkerClick(Marker marker) {
        if (marker.getExtraInfo() != null) {
            this.onRouteNodeClick(marker.getExtraInfo().getInt("index"));
        }
        return true;
    }
}

