/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import android.graphics.Bitmap;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.exception.WeiboHttpException;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.net.WeiboParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

class HttpManager {
    private static final String BOUNDARY = HttpManager.getBoundry();
    private static final String MP_BOUNDARY = "--" + BOUNDARY;
    private static final String END_MP_BOUNDARY = "--" + BOUNDARY + "--";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_GET = "GET";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 20000;
    private static final int BUFFER_SIZE = 8192;

    HttpManager() {
    }

    public static String openUrl(String url, String method, WeiboParameters params) throws WeiboException {
        HttpResponse response = HttpManager.requestHttpExecute(url, method, params);
        return HttpManager.readRsponse(response);
    }

    private static HttpResponse requestHttpExecute(String url, String method, WeiboParameters params) {
        HttpResponse response = null;
        try {
            HttpClient client = HttpManager.getNewHttpClient();
            client.getParams().setParameter("http.route.default-proxy", (Object)NetStateManager.getAPN());
            HttpPost request = null;
            ByteArrayOutputStream baos = null;
            if (method.equals(HTTP_METHOD_GET)) {
                url = String.valueOf(url) + "?" + params.encodeUrl();
                request = new HttpGet(url);
            } else if (method.equals(HTTP_METHOD_POST)) {
                HttpPost post;
                request = post = new HttpPost(url);
                baos = new ByteArrayOutputStream();
                if (params.hasBinaryData()) {
                    post.setHeader("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                    HttpManager.buildParams(baos, params);
                } else {
                    Object value = params.get("content-type");
                    if (value != null && value instanceof String) {
                        params.remove("content-type");
                        post.setHeader("Content-Type", (String)value);
                    } else {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    String postParam = params.encodeUrl();
                    baos.write(postParam.getBytes("UTF-8"));
                }
                post.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                baos.close();
            } else if (method.equals("DELETE")) {
                request = new HttpDelete(url);
            }
            response = client.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode != 200) {
                String result = HttpManager.readRsponse(response);
                throw new WeiboHttpException(result, statusCode);
            }
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
        return response;
    }

    private static HttpClient getNewHttpClient() {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            MySSLSocketFactory sf = new MySSLSocketFactory(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)sf, 443));
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
            DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            return client;
        }
        catch (Exception e) {
            return new DefaultHttpClient();
        }
    }

    private static void buildParams(OutputStream baos, WeiboParameters params) throws WeiboException {
        try {
            StringBuilder sb;
            Object value;
            Set<String> keys = params.keySet();
            for (String key : keys) {
                value = params.get(key);
                if (!(value instanceof String)) continue;
                sb = new StringBuilder(100);
                sb.setLength(0);
                sb.append(MP_BOUNDARY).append("\r\n");
                sb.append("content-disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
                sb.append(params.get(key)).append("\r\n");
                baos.write(sb.toString().getBytes());
            }
            for (String key : keys) {
                value = params.get(key);
                if (value instanceof Bitmap) {
                    sb = new StringBuilder();
                    sb.append(MP_BOUNDARY).append("\r\n");
                    sb.append("content-disposition: form-data; name=\"").append(key).append("\"; filename=\"file\"\r\n");
                    sb.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
                    baos.write(sb.toString().getBytes());
                    Bitmap bmp = (Bitmap)value;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    bmp.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                    byte[] bytes = stream.toByteArray();
                    baos.write(bytes);
                    baos.write("\r\n".getBytes());
                    continue;
                }
                if (!(value instanceof ByteArrayOutputStream)) continue;
                sb = new StringBuilder();
                sb.append(MP_BOUNDARY).append("\r\n");
                sb.append("content-disposition: form-data; name=\"").append(key).append("\"; filename=\"file\"\r\n");
                sb.append("Content-Type: application/octet-stream; charset=utf-8\r\n\r\n");
                baos.write(sb.toString().getBytes());
                ByteArrayOutputStream stream = (ByteArrayOutputStream)value;
                baos.write(stream.toByteArray());
                baos.write("\r\n".getBytes());
                stream.close();
            }
            baos.write(("\r\n" + END_MP_BOUNDARY).getBytes());
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
    }

    private static String readRsponse(HttpResponse response) throws WeiboException {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        InputStream inputStream = null;
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try {
            inputStream = entity.getContent();
            Header header = response.getFirstHeader("Content-Encoding");
            if (header != null && header.getValue().toLowerCase().indexOf("gzip") > -1) {
                inputStream = new GZIPInputStream(inputStream);
            }
            int readBytes = 0;
            byte[] buffer = new byte[8192];
            while ((readBytes = inputStream.read(buffer)) != -1) {
                content.write(buffer, 0, readBytes);
            }
            String string = new String(content.toByteArray(), "UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new WeiboException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getBoundry() {
        StringBuffer sb = new StringBuffer();
        int t = 1;
        while (t < 12) {
            long time = System.currentTimeMillis() + (long)t;
            if (time % 3L == 0L) {
                sb.append((char)time % 9);
            } else if (time % 3L == 1L) {
                sb.append((char)(65L + time % 26L));
            } else {
                sb.append((char)(97L + time % 26L));
            }
            ++t;
        }
        return sb.toString();
    }

    private static class MySSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

