/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatDispatchCallback;
import com.tencent.stat.common.RC4;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.event.Event;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

class StatDispatcher {
    private static StatLogger logger = StatCommonHelper.getLogger();
    private static long dispatcherThreadId = -1L;
    DefaultHttpClient client = null;
    Handler handler = null;
    private static StatDispatcher instance = null;
    private static Context applicationContext = null;

    private StatDispatcher() {
        try {
            HandlerThread handlerThread = new HandlerThread("StatDispatcher");
            handlerThread.start();
            dispatcherThreadId = handlerThread.getId();
            this.handler = new Handler(handlerThread.getLooper());
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)10000);
            this.client = new DefaultHttpClient((HttpParams)basicHttpParams);
            this.client.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                    long l = super.getKeepAliveDuration(httpResponse, httpContext);
                    if (l == -1L) {
                        l = 20000L;
                    }
                    return l;
                }
            });
            if (StatConfig.getStatHttpProxy() != null) {
                this.client.getParams().setParameter("http.route.default-proxy", (Object)StatConfig.getStatHttpProxy());
            }
        }
        catch (Throwable throwable) {
            logger.e(throwable);
        }
    }

    static void setApplicationContext(Context context) {
        applicationContext = context.getApplicationContext();
    }

    static Context getApplicationContext() {
        return applicationContext;
    }

    static StatDispatcher getInstance() {
        if (null == instance) {
            instance = new StatDispatcher();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendHttpPost(List<String> list, StatDispatchCallback statDispatchCallback) {
        block33: {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
                if (i == list.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            String string = StatConfig.getStatReportUrl();
            logger.i("[" + string + "]Send request(" + stringBuilder.toString().length() + "bytes):" + stringBuilder.toString());
            HttpPost httpPost = new HttpPost(string);
            try {
                Object object;
                GZIPOutputStream gZIPOutputStream;
                httpPost.addHeader("Accept-Encoding", "gzip");
                httpPost.setHeader("Connection", "Keep-Alive");
                httpPost.removeHeaders("Cache-Control");
                HttpHost httpHost = StatCommonHelper.getHttpProxy(applicationContext);
                boolean bl = false;
                if (null != httpHost) {
                    this.client.getParams().setParameter("http.route.default-proxy", (Object)StatCommonHelper.getHttpProxy(applicationContext));
                    httpPost.addHeader("X-Online-Host", "pingma.qq.com:80");
                    httpPost.addHeader("Accept", "*/*");
                    httpPost.addHeader("Content-Type", "json");
                    bl = true;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = stringBuilder.toString().getBytes("UTF-8");
                int n = byArray.length;
                byte[] byArray2 = byArray;
                if (stringBuilder.length() < 256) {
                    if (httpHost == null) {
                        httpPost.addHeader("Content-Encoding", "rc4");
                    } else {
                        httpPost.addHeader("X-Content-Encoding", "rc4");
                    }
                } else {
                    if (httpHost == null) {
                        httpPost.addHeader("Content-Encoding", "rc4,gzip");
                    } else {
                        httpPost.addHeader("X-Content-Encoding", "rc4,gzip");
                    }
                    byteArrayOutputStream.write(new byte[4]);
                    gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    gZIPOutputStream.write(byArray2);
                    gZIPOutputStream.close();
                    byArray2 = byteArrayOutputStream.toByteArray();
                    object = ByteBuffer.wrap(byArray2, 0, 4);
                    ((ByteBuffer)object).putInt(n);
                    logger.d("before Gzip:" + n + " bytes, after Gzip:" + byArray2.length + " bytes");
                }
                byArray2 = RC4.encrypt(byArray2);
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray2);
                httpPost.setEntity((HttpEntity)byteArrayEntity);
                gZIPOutputStream = this.client.execute((HttpUriRequest)httpPost);
                if (bl) {
                    this.client.getParams().removeParameter("http.route.default-proxy");
                }
                object = gZIPOutputStream.getEntity();
                int n2 = gZIPOutputStream.getStatusLine().getStatusCode();
                long l = object.getContentLength();
                logger.i("recv response status code:" + n2 + ", content length:" + l);
                if (l == 0L) {
                    EntityUtils.toString((HttpEntity)object);
                    if (n2 == 200) {
                        if (null != statDispatchCallback) {
                            statDispatchCallback.onDispatchSuccess();
                        }
                    } else {
                        logger.error("Server response error code:" + n2);
                    }
                    break block33;
                }
                if (l > 0L) {
                    InputStream inputStream = object.getContent();
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    byte[] byArray3 = new byte[(int)object.getContentLength()];
                    dataInputStream.readFully(byArray3);
                    Header header = gZIPOutputStream.getFirstHeader("Content-Encoding");
                    if (header != null) {
                        if (header.getValue().equalsIgnoreCase("gzip,rc4")) {
                            byArray3 = StatCommonHelper.deocdeGZipContent(byArray3);
                            byArray3 = RC4.decrypt(byArray3);
                        } else if (header.getValue().equalsIgnoreCase("rc4,gzip")) {
                            byArray3 = RC4.decrypt(byArray3);
                            byArray3 = StatCommonHelper.deocdeGZipContent(byArray3);
                        } else if (header.getValue().equalsIgnoreCase("gzip")) {
                            byArray3 = StatCommonHelper.deocdeGZipContent(byArray3);
                        } else if (header.getValue().equalsIgnoreCase("rc4")) {
                            byArray3 = RC4.decrypt(byArray3);
                        }
                    }
                    if (n2 == 200) {
                        try {
                            logger.d(new String(byArray3, "UTF-8"));
                            JSONObject jSONObject = new JSONObject(new String(byArray3, "UTF-8"));
                            JSONObject jSONObject2 = jSONObject.getJSONObject("cfg");
                            if (jSONObject2 != null) {
                                StatConfig.updateOnlineConfig(jSONObject2);
                            }
                        }
                        catch (JSONException jSONException) {
                            logger.i(jSONException.toString());
                        }
                        if (null != statDispatchCallback) {
                            statDispatchCallback.onDispatchSuccess();
                        }
                    } else {
                        logger.error("Server response error code:" + n2 + ", error:" + new String(byArray3, "UTF-8"));
                    }
                    inputStream.close();
                    break block33;
                }
                EntityUtils.toString((HttpEntity)object);
            }
            catch (Throwable throwable) {
                logger.e(throwable);
                if (null != statDispatchCallback) {
                    statDispatchCallback.onDispatchFailure();
                }
            }
        }
    }

    void send(final List<String> list, final StatDispatchCallback statDispatchCallback) {
        if (list.isEmpty() || this.handler == null) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                StatDispatcher.this.sendHttpPost(list, statDispatchCallback);
            }
        });
    }

    void send(Event event, StatDispatchCallback statDispatchCallback) {
        this.send(Arrays.asList(event.toJsonString()), statDispatchCallback);
    }
}

