/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Handler;
import android.os.HandlerThread;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatDispatchCallback;
import com.tencent.stat.StatDispatcher;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.User;
import com.tencent.stat.event.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class StatStore {
    private StatStoreHelper helper;
    Handler handler = null;
    volatile int numStoredEvents = 0;
    User user = null;
    private static StatLogger logger = StatCommonHelper.getLogger();
    private static StatStore instance = null;
    private HashMap<String, String> kvMap = new HashMap();

    public int getNumStoredEvents() {
        return this.numStoredEvents;
    }

    private StatStore(Context context) {
        try {
            HandlerThread handlerThread = new HandlerThread("StatStore");
            handlerThread.start();
            HandlerThread handlerThread2 = handlerThread;
            logger.w("Launch store thread:" + handlerThread2);
            this.handler = new Handler(handlerThread.getLooper());
            context = context.getApplicationContext();
            this.helper = new StatStoreHelper(context);
            this.helper.getWritableDatabase();
            this.helper.getReadableDatabase();
            this.getUser(context);
            this.loadConfig();
            this.loadKeyValues();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    StatStore.this.loadUnsentEventCount();
                }
            });
        }
        catch (Throwable throwable) {
            logger.e(throwable);
        }
    }

    private void loadUnsentEventCount() {
        ContentValues contentValues = new ContentValues();
        contentValues.put("status", Integer.valueOf(1));
        this.helper.getWritableDatabase().update("events", contentValues, "status=?", new String[]{Long.toString(2L)});
        this.numStoredEvents = (int)DatabaseUtils.queryNumEntries((SQLiteDatabase)this.helper.getReadableDatabase(), (String)"events");
        logger.i("Total " + this.numStoredEvents + " unsent events.");
    }

    public static StatStore getInstance(Context context) {
        if (null == instance) {
            instance = new StatStore(context);
        }
        return instance;
    }

    public static StatStore getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(Context context) {
        if (null != this.user) {
            return this.user;
        }
        Cursor cursor = null;
        try {
            String string;
            String string2;
            cursor = this.helper.getReadableDatabase().query("user", null, null, null, null, null, null, null);
            boolean bl = false;
            String string3 = "";
            if (cursor.moveToNext()) {
                String string4;
                String string5;
                String[] stringArray;
                string3 = string2 = cursor.getString(0);
                string2 = StatCommonHelper.decode(string2);
                int n = cursor.getInt(1);
                string = cursor.getString(2);
                long l = cursor.getLong(3);
                bl = true;
                int n2 = n;
                long l2 = System.currentTimeMillis() / 1000L;
                if (n2 != 1 && !(stringArray = StatCommonHelper.getDateFormat(l * 1000L)).equals(string5 = StatCommonHelper.getDateFormat(l2 * 1000L))) {
                    n2 = 1;
                }
                if (!string.equals(StatCommonHelper.getAppVersion(context))) {
                    n2 |= 2;
                }
                stringArray = string2.split(",");
                boolean bl2 = false;
                String string6 = null;
                String string7 = null;
                if (stringArray != null && stringArray.length > 0) {
                    string6 = stringArray[0];
                    if ((string6 == null || string6.length() < 11) && (string4 = StatCommonHelper.getDeviceID(context)) != null && string4.length() > 10) {
                        string6 = string4;
                        bl2 = true;
                    }
                } else {
                    string2 = string6 = StatCommonHelper.getUserID(context);
                    bl2 = true;
                }
                if (stringArray != null && stringArray.length >= 2) {
                    string7 = stringArray[1];
                    string2 = string6 + "," + string7;
                } else {
                    string7 = StatCommonHelper.getMacId(context);
                    if (string7 != null && string7.length() > 0) {
                        string2 = string6 + "," + string7;
                        bl2 = true;
                    }
                }
                this.user = new User(string6, string7, n2);
                string4 = new ContentValues();
                string2 = StatCommonHelper.encode(string2);
                string4.put("uid", string2);
                string4.put("user_type", Integer.valueOf(n2));
                string4.put("app_ver", StatCommonHelper.getAppVersion(context));
                string4.put("ts", Long.valueOf(l2));
                if (bl2) {
                    this.helper.getWritableDatabase().update("user", (ContentValues)string4, "uid=?", new String[]{string3});
                }
                if (n2 != n) {
                    this.helper.getWritableDatabase().replace("user", null, (ContentValues)string4);
                }
            }
            if (!bl) {
                string2 = StatCommonHelper.getUserID(context);
                String string8 = StatCommonHelper.getMacId(context);
                string = string2;
                if (string8 != null && string8.length() > 0) {
                    string = string2 + "," + string8;
                }
                int n = 0;
                long l = System.currentTimeMillis() / 1000L;
                String string9 = StatCommonHelper.getAppVersion(context);
                ContentValues contentValues = new ContentValues();
                string = StatCommonHelper.encode(string);
                contentValues.put("uid", string);
                contentValues.put("user_type", Integer.valueOf(n));
                contentValues.put("app_ver", string9);
                contentValues.put("ts", Long.valueOf(l));
                this.helper.getWritableDatabase().insert("user", null, contentValues);
                this.user = new User(string2, string8, n);
            }
        }
        catch (Throwable throwable) {
            logger.e(throwable);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directDeleteEvents(List<StoredEvent> list) {
        logger.i("Delete " + list.size() + " sent events in thread:" + Thread.currentThread());
        try {
            this.helper.getWritableDatabase().beginTransaction();
            for (StoredEvent storedEvent : list) {
                this.numStoredEvents -= this.helper.getWritableDatabase().delete("events", "event_id = ?", new String[]{Long.toString(storedEvent.id)});
            }
            this.helper.getWritableDatabase().setTransactionSuccessful();
            this.numStoredEvents = (int)DatabaseUtils.queryNumEntries((SQLiteDatabase)this.helper.getReadableDatabase(), (String)"events");
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
        finally {
            try {
                this.helper.getWritableDatabase().endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                logger.e((Exception)((Object)sQLiteException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directUpdateEvents(List<StoredEvent> list, int n) {
        logger.i("Update " + list.size() + " sending events to status:" + n + " in thread:" + Thread.currentThread());
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("status", Integer.toString(n));
            this.helper.getWritableDatabase().beginTransaction();
            for (StoredEvent storedEvent : list) {
                if (storedEvent.send_count + 1 > StatConfig.getMaxSendRetryCount()) {
                    this.numStoredEvents -= this.helper.getWritableDatabase().delete("events", "event_id=?", new String[]{Long.toString(storedEvent.id)});
                    continue;
                }
                contentValues.put("send_count", Integer.valueOf(storedEvent.send_count + 1));
                logger.i("Update event:" + storedEvent.id + " for content:" + contentValues);
                int n2 = this.helper.getWritableDatabase().update("events", contentValues, "event_id=?", new String[]{Long.toString(storedEvent.id)});
                if (n2 > 0) continue;
                logger.e("Failed to update db, error code:" + Integer.toString(n2));
            }
            this.helper.getWritableDatabase().setTransactionSuccessful();
            this.numStoredEvents = (int)DatabaseUtils.queryNumEntries((SQLiteDatabase)this.helper.getReadableDatabase(), (String)"events");
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
        finally {
            try {
                this.helper.getWritableDatabase().endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                logger.e((Exception)((Object)sQLiteException));
            }
        }
    }

    void updateEvents(final List<StoredEvent> list, final int n) {
        try {
            if (Thread.currentThread().getId() == this.handler.getLooper().getThread().getId()) {
                this.directUpdateEvents(list, n);
            } else {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        StatStore.this.directUpdateEvents(list, n);
                    }
                });
            }
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
    }

    void deleteEvents(final List<StoredEvent> list) {
        try {
            if (Thread.currentThread().getId() == this.handler.getLooper().getThread().getId()) {
                this.directDeleteEvents(list);
            } else {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        StatStore.this.directDeleteEvents(list);
                    }
                });
            }
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peekEvents(List<StoredEvent> list, int n) {
        Cursor cursor = null;
        try {
            cursor = this.helper.getReadableDatabase().query("events", null, "status=?", new String[]{Integer.toString(1)}, null, null, "event_id", Integer.toString(n));
            while (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                String string = cursor.getString(1);
                string = StatCommonHelper.decode(string);
                int n2 = cursor.getInt(2);
                int n3 = cursor.getInt(3);
                StoredEvent storedEvent = new StoredEvent(l, string, n2, n3);
                list.add(storedEvent);
            }
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    void directStoreEvent(Event event, StatDispatchCallback statDispatchCallback) {
        if (StatConfig.getMaxStoreEventCount() <= 0) {
            return;
        }
        if (this.numStoredEvents > StatConfig.getMaxStoreEventCount()) {
            logger.warn("Too many events stored in db.");
            this.numStoredEvents -= this.helper.getWritableDatabase().delete("events", "event_id in (select event_id from events where timestamp in (select min(timestamp) from events) limit 1)", null);
        }
        ContentValues contentValues = new ContentValues();
        String string = event.toJsonString();
        string = StatCommonHelper.encode(string);
        contentValues.put("content", string);
        contentValues.put("send_count", "0");
        contentValues.put("status", Integer.toString(1));
        contentValues.put("timestamp", Long.valueOf(event.getTimestamp()));
        long l = this.helper.getWritableDatabase().insert("events", null, contentValues);
        if (l == -1L) {
            logger.error("Failed to store event:" + string);
        } else {
            ++this.numStoredEvents;
            if (statDispatchCallback != null) {
                statDispatchCallback.onDispatchSuccess();
            }
        }
    }

    void storeEvent(final Event event, final StatDispatchCallback statDispatchCallback) {
        if (!StatConfig.isEnableStatService()) {
            return;
        }
        try {
            if (Thread.currentThread().getId() == this.handler.getLooper().getThread().getId()) {
                this.directStoreEvent(event, statDispatchCallback);
            } else {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        StatStore.this.directStoreEvent(event, statDispatchCallback);
                    }
                });
            }
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
    }

    void storeCfg(final StatConfig.OnlineConfig onlineConfig) {
        if (null == onlineConfig) {
            return;
        }
        try {
            this.handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String string = onlineConfig.toJsonString();
                    String string2 = StatCommonHelper.md5sum(string);
                    if (!string2.equals(onlineConfig.md5sum)) {
                        long l;
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("content", onlineConfig.props.toString());
                        contentValues.put("md5sum", string2);
                        onlineConfig.md5sum = string2;
                        contentValues.put("version", Integer.valueOf(onlineConfig.version));
                        boolean bl = false;
                        Cursor cursor = null;
                        try {
                            cursor = StatStore.this.helper.getReadableDatabase().query("config", null, null, null, null, null, null);
                            while (cursor.moveToNext()) {
                                if (cursor.getInt(0) != onlineConfig.type) continue;
                                bl = true;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            logger.e(exception);
                        }
                        finally {
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                        if (bl) {
                            l = StatStore.this.helper.getWritableDatabase().update("config", contentValues, "type=?", new String[]{Integer.toString(onlineConfig.type)});
                        } else {
                            contentValues.put("type", Integer.valueOf(onlineConfig.type));
                            l = StatStore.this.helper.getWritableDatabase().insert("config", null, contentValues);
                        }
                        if (l == -1L) {
                            logger.error("Failed to store cfg:" + string);
                        } else {
                            logger.i("Sucessed to store cfg:" + string);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.e(exception);
        }
    }

    void loadConfig() {
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = null;
                try {
                    cursor = StatStore.this.helper.getReadableDatabase().query("config", null, null, null, null, null, null);
                    while (cursor.moveToNext()) {
                        int n = cursor.getInt(0);
                        String string = cursor.getString(1);
                        String string2 = cursor.getString(2);
                        int n2 = cursor.getInt(3);
                        StatConfig.OnlineConfig onlineConfig = new StatConfig.OnlineConfig(n);
                        onlineConfig.type = n;
                        onlineConfig.props = new JSONObject(string);
                        onlineConfig.md5sum = string2;
                        onlineConfig.version = n2;
                        StatConfig.setConfig(onlineConfig);
                    }
                }
                catch (Exception exception) {
                    logger.e(exception);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    void loadEvents(final int n) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (StatStore.this.numStoredEvents == 0) {
                    return;
                }
                logger.i("Load " + Integer.toString(StatStore.this.numStoredEvents) + " unsent events");
                ArrayList<String> arrayList = new ArrayList<String>();
                final ArrayList arrayList2 = new ArrayList();
                int n3 = n;
                if (n3 == -1 || n3 > StatConfig.getMaxLoadEventCount()) {
                    n3 = StatConfig.getMaxLoadEventCount();
                }
                final int n2 = n3;
                StatStore.this.numStoredEvents -= n2;
                StatStore.this.peekEvents(arrayList2, n3);
                logger.i("Peek " + Integer.toString(arrayList2.size()) + " unsent events.");
                if (!arrayList2.isEmpty()) {
                    StatStore.this.directUpdateEvents(arrayList2, 2);
                    for (StoredEvent storedEvent : arrayList2) {
                        arrayList.add(storedEvent.content);
                    }
                    StatDispatcher.getInstance().send(arrayList, new StatDispatchCallback(){

                        @Override
                        public void onDispatchSuccess() {
                            int n;
                            StatStore.this.deleteEvents(arrayList2);
                            int n22 = n = n == -1 ? n : n - arrayList2.size();
                            if (n == -1 || n > 0) {
                                StatStore.this.loadEvents(n);
                            }
                        }

                        @Override
                        public void onDispatchFailure() {
                            StatStore.this.numStoredEvents += n2;
                            StatStore.this.updateEvents(arrayList2, 1);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyValues() {
        Cursor cursor = null;
        try {
            cursor = this.helper.getReadableDatabase().query("keyvalues", null, null, null, null, null, null);
            while (cursor.moveToNext()) {
                this.kvMap.put(cursor.getString(0), cursor.getString(1));
            }
        }
        catch (SQLiteException sQLiteException) {
            logger.e((Exception)((Object)sQLiteException));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    static class StatStoreHelper
    extends SQLiteOpenHelper {
        private static String DATABASE_NAME = "tencent_analysis.db";
        private static int DATABASE_VERSION = 3;

        public StatStoreHelper(Context context) {
            super(context, DATABASE_NAME, null, DATABASE_VERSION);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("create table if not exists events(event_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, content TEXT, status INTEGER, send_count INTEGER, timestamp LONG)");
            sQLiteDatabase.execSQL("create table if not exists user(uid TEXT PRIMARY KEY, user_type INTEGER, app_ver TEXT, ts INTEGER)");
            sQLiteDatabase.execSQL("create table if not exists config(type INTEGER PRIMARY KEY NOT NULL, content TEXT, md5sum TEXT, version INTEGER)");
            sQLiteDatabase.execSQL("create table if not exists keyvalues(key TEXT PRIMARY KEY NOT NULL, value TEXT)");
        }

        private void upgradeUserToVer3(SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = sQLiteDatabase.query("user", null, null, null, null, null, null);
            ContentValues contentValues = new ContentValues();
            String string = null;
            if (cursor.moveToNext()) {
                String string2;
                string = string2 = cursor.getString(0);
                int n = cursor.getInt(1);
                String string3 = cursor.getString(2);
                long l = cursor.getLong(3);
                string2 = StatCommonHelper.encode(string2);
                contentValues.put("uid", string2);
            }
            if (string != null) {
                sQLiteDatabase.update("user", contentValues, "uid=?", new String[]{string});
            }
        }

        private void upgradeEventsToVer3(SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = sQLiteDatabase.query("events", null, null, null, null, null, null);
            ArrayList<StoredEvent> arrayList = new ArrayList<StoredEvent>();
            while (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                String object = cursor.getString(1);
                int n = cursor.getInt(2);
                int n2 = cursor.getInt(3);
                StoredEvent storedEvent = new StoredEvent(l, object, n, n2);
                arrayList.add(storedEvent);
            }
            ContentValues contentValues = new ContentValues();
            for (StoredEvent storedEvent : arrayList) {
                contentValues.put("content", StatCommonHelper.encode(storedEvent.content));
                sQLiteDatabase.update("events", contentValues, "event_id=?", new String[]{Long.toString(storedEvent.id)});
            }
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            logger.debug("upgrade DB from oldVersion " + n + " to newVersion " + n2);
            if (n == 1) {
                sQLiteDatabase.execSQL("create table if not exists keyvalues(key TEXT PRIMARY KEY NOT NULL, value TEXT)");
                this.upgradeUserToVer3(sQLiteDatabase);
                this.upgradeEventsToVer3(sQLiteDatabase);
            }
            if (n == 2) {
                this.upgradeUserToVer3(sQLiteDatabase);
                this.upgradeEventsToVer3(sQLiteDatabase);
            }
        }
    }

    static class StoredEvent {
        long id;
        String content;
        int status;
        int send_count;

        public StoredEvent(long l, String string, int n, int n2) {
            this.id = l;
            this.content = string;
            this.status = n;
            this.send_count = n2;
        }
    }
}

