/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.tencent.stat.common.RC4;
import com.tencent.stat.common.StatBase64;
import com.tencent.stat.common.StatLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpHost;
import org.json.JSONException;
import org.json.JSONObject;

public class StatCommonHelper {
    private static String userId = null;
    private static String appkey = null;
    private static String macId = null;
    private static String deviceModel = null;
    private static Random random = null;
    private static StatLogger logger = null;

    private static Random getRandom() {
        if (null == random) {
            random = new Random();
        }
        return random;
    }

    public static int getNextSessionID() {
        return StatCommonHelper.getRandom().nextInt(Integer.MAX_VALUE);
    }

    public static byte[] deocdeGZipContent(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n = 0;
        while ((n = gZIPInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String md5sum(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                int n = 0xFF & byArray[i];
                if (n < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.e(noSuchAlgorithmException);
            return "0";
        }
    }

    public static HttpHost getHttpProxy(Context context) {
        if (null == context) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
            return null;
        }
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return null;
            }
            if (networkInfo.getTypeName() != null && networkInfo.getTypeName().equalsIgnoreCase("WIFI")) {
                return null;
            }
            String string = networkInfo.getExtraInfo();
            if (string == null) {
                return null;
            }
            if (string.equals("cmwap") || string.equals("3gwap") || string.equals("uniwap")) {
                return new HttpHost("10.0.0.172", 80);
            }
            if (string.equals("ctwap")) {
                return new HttpHost("10.0.0.200", 80);
            }
        }
        catch (Exception exception) {
            logger.e(exception);
        }
        return null;
    }

    public static String getUserID(Context context) {
        if (null != userId && userId.trim().length() != 0) {
            return userId;
        }
        userId = StatCommonHelper.getDeviceID(context);
        if (null == userId || userId.trim().length() == 0) {
            userId = Integer.toString(StatCommonHelper.getRandom().nextInt(Integer.MAX_VALUE));
        }
        return userId;
    }

    public static String getMacId(Context context) {
        if (null == macId || "" == macId) {
            macId = StatCommonHelper.getWifiMacAddress(context);
        }
        return macId;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static boolean checkPermission(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission(string, context.getPackageName()) == 0;
    }

    public static boolean isWiFiActive(Context context) {
        if (StatCommonHelper.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            NetworkInfo[] networkInfoArray;
            Context context2 = context.getApplicationContext();
            ConnectivityManager connectivityManager = (ConnectivityManager)context2.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfoArray = connectivityManager.getAllNetworkInfo()) != null) {
                for (int i = 0; i < networkInfoArray.length; ++i) {
                    if (!networkInfoArray[i].getTypeName().equalsIgnoreCase("WIFI") || !networkInfoArray[i].isConnected()) continue;
                    return true;
                }
            }
            return false;
        }
        logger.warn("can not get the permission of android.permission.ACCESS_WIFI_STATE");
        return false;
    }

    public static String getWifiMacAddress(Context context) {
        if (StatCommonHelper.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) {
                    return "";
                }
                return wifiManager.getConnectionInfo().getMacAddress();
            }
            catch (Exception exception) {
                logger.e(exception);
                return "";
            }
        }
        logger.e("Could not get permission of android.permission.ACCESS_WIFI_STATE");
        return "";
    }

    public static boolean isWifiNet(Context context) {
        if (StatCommonHelper.checkPermission(context, "android.permission.INTERNET")) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isAvailable() && networkInfo.getTypeName().equalsIgnoreCase("WIFI");
        }
        logger.warn("can not get the permisson of android.permission.INTERNET");
        return false;
    }

    public static boolean isNetworkAvailable(Context context) {
        if (StatCommonHelper.checkPermission(context, "android.permission.INTERNET")) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isAvailable()) {
                return true;
            }
            logger.w("Network error");
            return false;
        }
        logger.warn("can not get the permisson of android.permission.INTERNET");
        return false;
    }

    public static String getAppKey(Context context) {
        if (null != appkey) {
            return appkey;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                String string = applicationInfo.metaData.getString("TA_APPKEY");
                if (string != null) {
                    appkey = string;
                    return string;
                }
                logger.w("Could not read APPKEY meta-data from AndroidManifest.xml");
            }
        }
        catch (Exception exception) {
            logger.w("Could not read APPKEY meta-data from AndroidManifest.xml");
        }
        return null;
    }

    public static String getInstallChannel(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null) {
                Object object = applicationInfo.metaData.get("InstallChannel");
                if (object != null) {
                    return object.toString();
                }
                logger.e("Could not read InstallChannel meta-data from AndroidManifest.xml");
            }
        }
        catch (Exception exception) {
            logger.e("Could not read InstallChannel meta-data from AndroidManifest.xml");
        }
        return null;
    }

    public static String getActivityName(Context context) {
        if (null == context) {
            return null;
        }
        return context.getClass().getName();
    }

    public static String getDeviceID(Context context) {
        if (StatCommonHelper.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            String string = "";
            if (StatCommonHelper.checkPhoneState(context)) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                string = telephonyManager.getDeviceId();
            }
            if (string != null) {
                return string;
            }
            logger.error("deviceId is null");
            return null;
        }
        logger.e("Could not get permission of android.permission.READ_PHONE_STATE");
        return null;
    }

    public static String getSimOperator(Context context) {
        String string = null;
        if (StatCommonHelper.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            if (StatCommonHelper.checkPhoneState(context)) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                try {
                    string = telephonyManager.getSimOperator();
                }
                catch (Exception exception) {
                    logger.e(exception);
                }
            }
        } else {
            logger.e("Could not get permission of android.permission.READ_PHONE_STATE");
        }
        return string;
    }

    public static String getCurAppVersion(Context context) {
        String string = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            string = packageInfo.versionName;
            if (string == null) {
                return "";
            }
        }
        catch (Exception exception) {
            logger.e(exception);
        }
        return string;
    }

    public static boolean checkPhoneState(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission("android.permission.READ_PHONE_STATE", context.getPackageName()) == 0;
    }

    public static String getLinkedWay(Context context) {
        String string = null;
        if (StatCommonHelper.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                String string2 = networkInfo.getTypeName();
                String string3 = networkInfo.getExtraInfo();
                if (string2 != null) {
                    string = string2.equalsIgnoreCase("WIFI") ? "WIFI" : (string2.equalsIgnoreCase("MOBILE") ? (string3 != null ? string3 : "MOBILE") : (string3 != null ? string3 : string2));
                }
            }
        } else {
            logger.e("can not get the permission of android.permission.ACCESS_WIFI_STATE");
        }
        return string;
    }

    public static Integer getTelephonyNetworkType(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getNetworkType();
        }
        return null;
    }

    public static String getAppVersion(Context context) {
        String string = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            string = packageInfo.versionName;
            if (string == null || string.length() == 0) {
                return "unknown";
            }
        }
        catch (Exception exception) {
            logger.e(exception);
        }
        return string;
    }

    public static void jsonPut(JSONObject jSONObject, String string, String string2) throws JSONException {
        if (string2 != null && string2.length() > 0) {
            jSONObject.put(string, (Object)string2);
        }
    }

    public static int hasRootAccess(Context context) {
        if (RootCmd.isRootSystem()) {
            return 1;
        }
        return 0;
    }

    public static StatLogger getLogger() {
        if (logger == null) {
            logger = new StatLogger("MtaSDK");
            logger.setDebugEnable(false);
        }
        return logger;
    }

    public static long getTomorrowStartMilliseconds() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return 86400000L + calendar.getTimeInMillis();
    }

    public static Long convertStringToLong(String string, String string2, int n, int n2, Long l) {
        String[] stringArray;
        if (string == null || string2 == null) {
            return l;
        }
        if (string2.equalsIgnoreCase(".") || string2.equalsIgnoreCase("|")) {
            string2 = "\\" + string2;
        }
        if ((stringArray = string.split(string2)).length == n2) {
            try {
                Long l2 = 0L;
                for (int i = 0; i < stringArray.length; ++i) {
                    l2 = (long)n * (l2 + Long.valueOf(stringArray[i]));
                }
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }
        return l;
    }

    public static long getSDKLongVersion(String string) {
        return StatCommonHelper.convertStringToLong(string, ".", 100, 3, 0L);
    }

    public static String getExternalStorageInfo(Context context) {
        block5: {
            try {
                if (StatCommonHelper.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    if (Environment.getExternalStorageState().equals("mounted")) {
                        String string = Environment.getExternalStorageDirectory().getPath();
                        if (string == null) {
                            return null;
                        }
                        StatFs statFs = new StatFs(string);
                        long l = (long)statFs.getBlockCount() * (long)statFs.getBlockSize() / 1000000L;
                        long l2 = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize() / 1000000L;
                        return String.valueOf(l2) + "/" + String.valueOf(l);
                    }
                    break block5;
                }
                logger.warn("can not get the permission of android.permission.WRITE_EXTERNAL_STORAGE");
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getDateFormat(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return simpleDateFormat.format(new Date(l));
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = RC4.encrypt(string.getBytes("UTF-8"));
            byte[] byArray2 = StatBase64.encode(byArray, 0);
            return new String(byArray2, "UTF-8");
        }
        catch (Throwable throwable) {
            logger.e(throwable);
            return string;
        }
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = StatBase64.decode(byArray, 0);
            byArray2 = RC4.decrypt(byArray2);
            return new String(byArray2, "UTF-8");
        }
        catch (Throwable throwable) {
            logger.e(throwable);
            return string;
        }
    }

    static class RootCmd {
        private static int systemRootState = -1;

        public static boolean isRootSystem() {
            if (systemRootState == 1) {
                return true;
            }
            if (systemRootState == 0) {
                return false;
            }
            File file = null;
            String[] stringArray = new String[]{"/bin", "/system/bin/", "/system/xbin/", "/system/sbin/", "/sbin/", "/vendor/bin/"};
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    file = new File(stringArray[i] + "su");
                    if (file == null || !file.exists()) continue;
                    systemRootState = 1;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            systemRootState = 0;
            return false;
        }
    }
}

