/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.common;

import android.util.Log;
import com.tencent.stat.StatConfig;

public final class StatLogger {
    private String tag = "default";
    private boolean debugEnable = true;
    private int logLevel = 2;

    public boolean isDebugEnable() {
        return this.debugEnable;
    }

    public void setDebugEnable(boolean bl) {
        this.debugEnable = bl;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public StatLogger() {
    }

    public StatLogger(String string) {
        this.tag = string;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    private String getLoggerClassInfo() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray == null) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (stackTraceElement.isNativeMethod() || stackTraceElement.getClassName().equals(Thread.class.getName()) || stackTraceElement.getClassName().equals(this.getClass().getName())) continue;
            return "[" + Thread.currentThread().getName() + "(" + Thread.currentThread().getId() + "): " + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + "]";
        }
        return null;
    }

    public void info(Object object) {
        if (this.logLevel <= 4) {
            String string = this.getLoggerClassInfo();
            String string2 = string == null ? object.toString() : string + " - " + object;
            Log.i((String)this.tag, (String)string2);
        }
    }

    public void i(Object object) {
        if (this.isDebugEnable()) {
            this.info(object);
        }
    }

    public void verbose(Object object) {
        if (this.logLevel <= 2) {
            String string = this.getLoggerClassInfo();
            String string2 = string == null ? object.toString() : string + " - " + object;
            Log.v((String)this.tag, (String)string2);
        }
    }

    public void v(Object object) {
        if (this.isDebugEnable()) {
            this.verbose(object);
        }
    }

    public void warn(Object object) {
        if (this.logLevel <= 5) {
            String string = this.getLoggerClassInfo();
            String string2 = string == null ? object.toString() : string + " - " + object;
            Log.w((String)this.tag, (String)string2);
        }
    }

    public void w(Object object) {
        if (this.isDebugEnable()) {
            this.warn(object);
        }
    }

    public void error(Object object) {
        if (this.logLevel <= 6) {
            String string = this.getLoggerClassInfo();
            String string2 = string == null ? object.toString() : string + " - " + object;
            Log.e((String)this.tag, (String)string2);
        }
    }

    public void error(Exception exception) {
        if (this.logLevel <= 6) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getLoggerClassInfo();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            if (string != null) {
                stringBuffer.append(string + " - " + exception + "\r\n");
            } else {
                stringBuffer.append(exception + "\r\n");
            }
            if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    if (stackTraceElement == null) continue;
                    stringBuffer.append("[ " + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + " ]\r\n");
                }
            }
            Log.e((String)this.tag, (String)stringBuffer.toString());
        }
    }

    public void e(Object object) {
        if (this.isDebugEnable()) {
            this.error(object);
        }
    }

    public void e(Exception exception) {
        if (StatConfig.isDebugEnable()) {
            this.error(exception);
        }
    }

    public void debug(Object object) {
        if (this.logLevel <= 3) {
            String string = this.getLoggerClassInfo();
            String string2 = string == null ? object.toString() : string + " - " + object;
            Log.d((String)this.tag, (String)string2);
        }
    }

    public void d(Object object) {
        if (this.isDebugEnable()) {
            this.debug(object);
        }
    }
}

