/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.event;

import android.content.Context;
import com.tencent.stat.StatAppMonitor;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.event.Event;
import com.tencent.stat.event.EventType;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitorStatEvent
extends Event {
    private StatAppMonitor monitor = null;
    private static String simOperator = null;
    private static String appVersion = null;

    public MonitorStatEvent(Context context, int n, StatAppMonitor statAppMonitor) {
        super(context, n);
        this.monitor = statAppMonitor;
    }

    @Override
    public EventType getType() {
        return EventType.MONITOR_STAT;
    }

    @Override
    public boolean onEncode(JSONObject jSONObject) throws JSONException {
        if (this.monitor == null) {
            return false;
        }
        jSONObject.put("na", (Object)this.monitor.getInterfaceName());
        jSONObject.put("rq", this.monitor.getReqSize());
        jSONObject.put("rp", this.monitor.getRespSize());
        jSONObject.put("rt", this.monitor.getResultType());
        jSONObject.put("tm", this.monitor.getMillisecondsConsume());
        jSONObject.put("rc", this.monitor.getReturnCode());
        jSONObject.put("sp", this.monitor.getSampling());
        if (appVersion == null) {
            appVersion = StatCommonHelper.getAppVersion(this.ctx);
        }
        StatCommonHelper.jsonPut(jSONObject, "av", appVersion);
        if (simOperator == null) {
            simOperator = StatCommonHelper.getSimOperator(this.ctx);
        }
        StatCommonHelper.jsonPut(jSONObject, "op", simOperator);
        jSONObject.put("cn", (Object)StatCommonHelper.getLinkedWay(this.ctx));
        return true;
    }
}

