/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class MemoryCacheUtils {
    private static final String URI_AND_SIZE_SEPARATOR = "_";
    private static final String WIDTH_AND_HEIGHT_SEPARATOR = "x";

    private MemoryCacheUtils() {
    }

    public static String generateKey(String imageUri, ImageSize targetSize) {
        return imageUri + URI_AND_SIZE_SEPARATOR + targetSize.getWidth() + WIDTH_AND_HEIGHT_SEPARATOR + targetSize.getHeight();
    }

    public static Comparator<String> createFuzzyKeyComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                String imageUri1 = key1.substring(0, key1.lastIndexOf(MemoryCacheUtils.URI_AND_SIZE_SEPARATOR));
                String imageUri2 = key2.substring(0, key2.lastIndexOf(MemoryCacheUtils.URI_AND_SIZE_SEPARATOR));
                return imageUri1.compareTo(imageUri2);
            }
        };
    }

    public static List<Bitmap> findCachedBitmapsForImageUri(String imageUri, MemoryCache memoryCache) {
        ArrayList<Bitmap> values = new ArrayList<Bitmap>();
        for (String key : memoryCache.keys()) {
            if (!key.startsWith(imageUri)) continue;
            values.add((Bitmap)memoryCache.get(key));
        }
        return values;
    }

    public static List<String> findCacheKeysForImageUri(String imageUri, MemoryCache memoryCache) {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : memoryCache.keys()) {
            if (!key.startsWith(imageUri)) continue;
            values.add(key);
        }
        return values;
    }

    public static void removeFromCache(String imageUri, MemoryCache memoryCache) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : memoryCache.keys()) {
            if (!key.startsWith(imageUri)) continue;
            keysToRemove.add(key);
        }
        for (String keyToRemove : keysToRemove) {
            memoryCache.remove(keyToRemove);
        }
    }
}

