/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tauth;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;
import com.tencent.b.a.g;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.avatar.QQAvatar;
import com.tencent.connect.share.QQShare;
import com.tencent.connect.share.QzoneShare;
import com.tencent.open.SocialApi;
import com.tencent.open.TaskGuide;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.LocationApi;
import com.tencent.utils.HttpUtils;
import com.tencent.utils.SystemUtils;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class Tencent {
    private QQAuth mQQAuth;
    private Context mContext;
    private LocationApi mLocationApi;

    private Tencent(String string, Context context) {
        this.mContext = context;
        this.mQQAuth = QQAuth.createInstance(string, context);
    }

    public static Tencent createInstance(String string, Context context) {
        Tencent tencent = new Tencent(string, context);
        if (!Tencent.checkManifestConfig(context, string)) {
            return null;
        }
        g.a("openSDK_LOG", "createInstance()  --end");
        return tencent;
    }

    private static boolean checkManifestConfig(Context context, String string) {
        Object object;
        ComponentName componentName;
        try {
            componentName = new ComponentName(context.getPackageName(), "com.tencent.tauth.AuthActivity");
            object = context.getPackageManager();
            object.getActivityInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = "\u6ca1\u6709\u5728AndroidManifest.xml\u4e2d\u68c0\u6d4b\u5230com.tencent.tauth.AuthActivity,\u8bf7\u52a0\u4e0acom.tencent.open.AuthActivity,\u5e76\u914d\u7f6e<data android:scheme=\"tencent" + string + "\" />,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5b98\u7f51\u6587\u6863.";
            string2 = string2 + "\n\u914d\u7f6e\u793a\u4f8b\u5982\u4e0b: \n<activity\n     android:name=\"com.tencent.connect.util.AuthActivity\"\n     android:noHistory=\"true\"\n     android:launchMode=\"singleTask\">\n<intent-filter>\n    <action android:name=\"android.intent.action.VIEW\" />\n     <category android:name=\"android.intent.category.DEFAULT\" />\n    <category android:name=\"android.intent.category.BROWSABLE\" />\n    <data android:scheme=\"tencent" + string + "\" />\n" + "</intent-filter>\n" + "</activity>";
            g.a();
            g.d("AndroidManifest.xml \u6ca1\u6709\u68c0\u6d4b\u5230com.tencent.tauth.AuthActivity", string2);
            return false;
        }
        try {
            componentName = new ComponentName(context.getPackageName(), "com.tencent.connect.common.AssistActivity");
            object = context.getPackageManager();
            object.getActivityInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "\u6ca1\u6709\u5728AndroidManifest.xml\u4e2d\u68c0\u6d4b\u5230com.tencent.connect.common.AssistActivity,\u8bf7\u52a0\u4e0acom.tencent.connect.common.AssistActivity,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5b98\u7f51\u6587\u6863.";
            object = (String)object + "\n\u914d\u7f6e\u793a\u4f8b\u5982\u4e0b: \n<activity\n     android:name=\"com.tencent.connect.common.AssistActivity\"\n     android:screenOrientation=\"portrait\"\n     android:theme=\"@android:style/Theme.Translucent.NoTitleBar\"\n     android:configChanges=\"orientation|keyboardHidden\">\n</activity>";
            g.a();
            g.d("AndroidManifest.xml \u6ca1\u6709\u68c0\u6d4b\u5230com.tencent.connect.common.AssistActivity", (String)object);
            return false;
        }
        return true;
    }

    public int login(Activity activity, String string, IUiListener iUiListener) {
        return this.mQQAuth.login(activity, string, iUiListener);
    }

    public int loginWithOEM(Activity activity, String string, IUiListener iUiListener, String string2, String string3, String string4) {
        return this.mQQAuth.loginWithOEM(activity, string, iUiListener, string2, string3, string4);
    }

    public void logout(Context context) {
        this.mQQAuth.getQQToken().setAccessToken(null, "0");
        this.mQQAuth.getQQToken().setOpenId(null);
    }

    public int reAuth(Activity activity, String string, IUiListener iUiListener) {
        return this.mQQAuth.reAuth(activity, string, iUiListener);
    }

    public int ask(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.ask(activity, bundle, iUiListener);
        return 0;
    }

    public int reactive(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.reactive(activity, bundle, iUiListener);
        return 0;
    }

    public int searchNearby(Activity activity, Bundle bundle, IUiListener iUiListener) {
        if (this.mLocationApi == null) {
            this.mLocationApi = new LocationApi((Context)activity, this.mQQAuth.getQQToken());
        }
        this.mLocationApi.searchNearby(activity, bundle, iUiListener);
        return 0;
    }

    public int deleteLocation(Activity activity, Bundle bundle, IUiListener iUiListener) {
        if (this.mLocationApi == null) {
            this.mLocationApi = new LocationApi((Context)activity, this.mQQAuth.getQQToken());
        }
        this.mLocationApi.deleteLocation(activity, bundle, iUiListener);
        return 0;
    }

    public int brag(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.brag(activity, bundle, iUiListener);
        return 0;
    }

    public int challenge(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.challenge(activity, bundle, iUiListener);
        return 0;
    }

    public int gift(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.gift(activity, bundle, iUiListener);
        return 0;
    }

    public int invite(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.invite(activity, bundle, iUiListener);
        return 0;
    }

    public int story(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.story(activity, bundle, iUiListener);
        return 0;
    }

    public void setAvatar(Activity activity, Bundle bundle, IUiListener iUiListener) {
        String string = bundle.getString("picture");
        int n2 = bundle.getInt("exitAnim");
        QQAvatar qQAvatar = new QQAvatar(this.mContext, this.mQQAuth.getQQToken());
        qQAvatar.setAvatar(activity, Uri.parse((String)string), iUiListener, n2);
    }

    public void setAvatar(Activity activity, Bundle bundle, IUiListener iUiListener, int n2, int n3) {
        bundle.putInt("exitAnim", n3);
        activity.overridePendingTransition(n2, 0);
        this.setAvatar(activity, bundle, iUiListener);
    }

    public void requestAsync(String string, Bundle bundle, String string2, IRequestListener iRequestListener, Object object) {
        HttpUtils.requestAsync(this.mQQAuth.getQQToken(), this.mContext, string, bundle, string2, iRequestListener);
    }

    public JSONObject request(String string, Bundle bundle, String string2) throws IOException, JSONException, HttpUtils.NetworkUnavailableException, HttpUtils.HttpStatusException {
        return HttpUtils.request(this.mQQAuth.getQQToken(), this.mContext, string, bundle, string2);
    }

    public void shareToQQ(Activity activity, Bundle bundle, IUiListener iUiListener) {
        QQShare qQShare = new QQShare((Context)activity, this.mQQAuth.getQQToken());
        qQShare.shareToQQ(activity, bundle, iUiListener);
    }

    public void shareToQzone(Activity activity, Bundle bundle, IUiListener iUiListener) {
        QzoneShare qzoneShare = new QzoneShare((Context)activity, this.mQQAuth.getQQToken());
        qzoneShare.shareToQzone(activity, bundle, iUiListener);
    }

    public void grade(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.grade(activity, bundle, iUiListener);
    }

    public void voice(Activity activity, Bundle bundle, IUiListener iUiListener) {
        SocialApi socialApi = new SocialApi((Context)activity, this.mQQAuth.getQQToken());
        socialApi.voice(activity, bundle, iUiListener);
    }

    public void showTaskGuideWindow(Activity activity, Bundle bundle, IUiListener iUiListener) {
        TaskGuide taskGuide = new TaskGuide((Context)activity, this.mQQAuth.getQQToken());
        taskGuide.showTaskGuideWindow(activity, bundle, iUiListener);
    }

    public boolean onActivityResult(int n2, int n3, Intent intent) {
        return false;
    }

    public boolean isSessionValid() {
        return this.mQQAuth.isSessionValid();
    }

    public String getAppId() {
        return this.mQQAuth.getQQToken().getAppId();
    }

    public String getAccessToken() {
        return this.mQQAuth.getQQToken().getAccessToken();
    }

    public long getExpiresIn() {
        return this.mQQAuth.getQQToken().getExpireTimeInSecond();
    }

    public String getOpenId() {
        return this.mQQAuth.getQQToken().getOpenId();
    }

    public void setAccessToken(String string, String string2) {
        g.a("openSDK_LOG", "setAccessToken(), expiresIn = " + string2 + "");
        this.mQQAuth.setAccessToken(string, string2);
    }

    public void setOpenId(String string) {
        g.a("openSDK_LOG", "setOpenId() --start");
        this.mQQAuth.setOpenId(this.mContext, string);
        g.a("openSDK_LOG", "setOpenId() --end");
    }

    public boolean isReady() {
        boolean bl = this.isSessionValid() && this.getOpenId() != null;
        return bl;
    }

    public QQToken getQQToken() {
        return this.mQQAuth.getQQToken();
    }

    public boolean isSupportSSOLogin(Activity activity) {
        String string = SystemUtils.getAppVersionName((Context)activity, "com.tencent.mobileqq");
        if (string == null) {
            Toast.makeText((Context)activity, (CharSequence)"\u6ca1\u6709\u5b89\u88c5\u624bQ", (int)0).show();
            return false;
        }
        if (SystemUtils.checkMobileQQ((Context)activity)) {
            Toast.makeText((Context)activity, (CharSequence)"\u5df2\u5b89\u88c5\u7684\u624bQ\u7248\u672c\u652f\u6301SSO\u767b\u9646", (int)0).show();
            return true;
        }
        Toast.makeText((Context)activity, (CharSequence)"\u5df2\u5b89\u88c5\u7684\u624bQ\u7248\u672c\u4e0d\u652f\u6301SSO\u767b\u9646", (int)0).show();
        return false;
    }
}

